---
component:
  id: components/form/form-group
---

## Basic Usage

```jsx
<FormGroup
  label="Title"
  labelOptional="Optional"
  hint="Make it good."
>
  <Input
    type={InputType.Text}
    placeholder="Video Title"
  />
</FormGroup>
```

## Example: Horizontal Labels

```jsx
<Layout margin={{ y: 3 }}>
  <FormGroup label="Name" hint="Tell us who to deliver pizza to" orientation={FormGroupOrientation.Horizontal}>
    <Input type={InputType.Text} />
  </FormGroup>
</Layout>

<Layout margin={{ y: 3 }}>
  <FormGroup label="Pizza Type" orientation={FormGroupOrientation.Horizontal}>
    <Layout margin={{ bottom: 1 }}>
      <Radio name="settings-pizza" label="Vegetarian" />
    </Layout>
    <Layout margin={{ bottom: 1 }}>
      <Radio name="settings-pizza" label="Pepperoni delux" />
    </Layout>
    <Layout margin={{ bottom: 1 }}>
      <Radio name="settings-pizza" label="Pineapple and ham supreme" />
    </Layout>
  </FormGroup>
</Layout>

<Layout margin={{ y: 3 }}>
  <FormGroup label="How many toppings?" hint="Drag to adjust the quantity of toppings" orientation={FormGroupOrientation.Horizontal}>
    <Range />
  </FormGroup>
</Layout>

<Layout margin={{ y: 3 }}>
  <FormGroup errorMessage="Wrong" label="Notes" labelOptional="Optional" hint="Any special instructions for pizza prep?" orientation={FormGroupOrientation.Horizontal}>
    <TextArea></TextArea>
  </FormGroup>
</Layout>

<Layout display={Display.Flex} justifyContent={JustifyContent.End}>
  <Layout margin={{ right: 1}}>
    <Button type={ButtonType.Hollow}>Cancel</Button>
  </Layout>
  <Layout>
    <Button>Order My Pizza</Button>
  </Layout>
</Layout>

```

## Example: Error message display

```jsx
<Layout margin={{ y: 3 }}>
  <FormGroup error errorMessage="Sorry, your name was not found in our system." label="Name" hint="Tell us who to deliver pizza to">
    <Input type={InputType.Text} value="Ben Cole" />
  </FormGroup>
</Layout>

<Layout margin={{ y: 3 }}>
  <FormGroup  error errorMessage="Sorry, we are sold out of that type of pizza." label="Pizza Type">
    <Layout margin={{ bottom: 1 }}>
      <Radio name="settings-pizza" label="Vegetarian" />
    </Layout>
    <Layout margin={{ bottom: 1 }}>
      <Radio name="settings-pizza" label="Pepperoni delux" />
    </Layout>
    <Layout margin={{ bottom: 1 }}>
      <Radio name="settings-pizza" label="Pineapple and ham supreme" checked />
    </Layout>
  </FormGroup>
</Layout>
```
