Modal views are self-contained views or user flows that force the users attention. They typically reside as a layer above the rest of the content of the page and restrict the user’s attention to the modal view.

## Pattern Usage
Modals restrict the users attention: they should only be used in cases where the experience requires the user to complete a critical task or workflow, confirm a change or notify the user about critical information.

Instances when a modal should be used include:
- The user should confirm the action they’re about to take (e.g. “Are you sure you want to Delete this video?”).
- You want to keep the user at their current context, but have a workflow that requires their undivided attention (i.e. payment flows).

Do not use a modal view for something that could be better handled more passively as a Toast Notification or in an in-page flow.

## Design and Usability

### Types

#### Interrupt Alert

Interrupt modals are typically utilized in cases where you need the user to confirm an action or warn the user about a potential catastrophic event.

They should be presented using the small modal size and the “Default” style with a right aligned button pair or single button (although single button modals should be avoided and are usually better served as a Toast Style Notification).

![Small interrupt alert](https://s3-us-west-2.amazonaws.com/web-design-int-production/assets/ui/images/pattern-modal-small.png)

#### Modal Workflow

Modal workflows are recommended in cases where you need the user to complete a complex series of steps outside of their current context.

They should use the medium or large modal sizes. If the workflow contains multiple steps or screens, consider using the “Split” type with left and right aligned buttons.

If you have a flow where you need the user to have a feeling of temporary or less interruption, consider using the Task Sheet pattern instead of a Modal Workflow.

![Default split modal](https://s3-us-west-2.amazonaws.com/web-design-int-production/assets/ui/images/pattern-modal-default-split.png)


#### Default Modal

Consider using the default modal for any other use case you may have. The default modal is also capable of being modified with different header and footer treatments.

![Default modal](https://s3-us-west-2.amazonaws.com/web-design-int-production/assets/ui/images/pattern-modal-default.png)

It’s important to note that you should not use an in-page modal when you can instead use a native browser dialog such as confirm or alert. One example of when you should use the native dialog is to prompt the user that they may lose unsaved changes. The native prompt can warn you if you are closing a tab that you might lose changes, but an in-page custom modal will not be able to do anything in this scenario.

### Visual Design

There are 3 different modal sizes and 2 types of action footers.

#### Sizes
- Small (300 px wide)
- Medium (600 px wide)
- Large (800 px wide)

#### Headers
- Default (plain text)

#### Footers
- Default (1 or 2 CTAs aligned on the right)
- Split (2 CTA split on the left and right)
- Progress indicator

Each modal pattern is required to have:
- A title
- At least 1 primary CTA
- A close button-icon in the top right

Each modal pattern can optionally have:
- A second button in the footer
- A step counter in the footer
- A progress bar underneath the header

Upon implementation of the pattern, you’ll find that the sizing and spacing has been taken care of for you. Here is the outlined spec of modal spacing:

#### Modal Header

- padding: Title = 2rem = 20px, Icon = 1rem = 10px
- margin: None
- font-size: Size 4 = 16px
- icon size: Default = 20px

#### Modal Body

- padding: 2rem = 20 px
- margin: None
- font-size: Size 6 = 20px

#### Modal Footer

- padding: 1rem = 10 px
- margin: None
- button size: Default

![Modal header](https://s3-us-west-2.amazonaws.com/web-design-int-production/assets/ui/images/pattern-modal-header.png)

![Modal body](https://s3-us-west-2.amazonaws.com/web-design-int-production/assets/ui/images/pattern-modal-body.png)

![Modal footers](https://s3-us-west-2.amazonaws.com/web-design-int-production/assets/ui/images/pattern-modal-footer.png)


### Branding Opportunities

The modal pattern offers branding opportunities for those who want to include additional visual elements to the UI. By default, the background color of the header is white. If you’re interested in jazzing up your modal, you have the option to include a background image to add texture to the header.

Here is an example of a modal header with a background image:

![Branded modal header](https://s3-us-west-2.amazonaws.com/web-design-int-production/assets/ui/images/pattern-modal-header-branded.png)

If you plan to add a background image to your modal header, we recommend you size the image at a ratio of 300 x 52 (small modal), 400 x 52 (medium modal), and 600 x 52 (large modal) so the image scales correctly.

### Interaction Design

Aside from interacting with the dialog window itself, the user is still able to interact with the rest of the window. Some points of interaction design with modal windows to consider include:
- When the user clicks on the dark background around the modal, the modal should not close. However, the user can press the escape key to close the modal, as well as click on the ‘x’ button icon located on the top-right of the modal.
- The page content behind the modal should lock and not be able to scroll while the modal is overlaid on top of it.
- The modal should appear vertically and horizontally centered on the screen.
- Closing the modal with the [x] does not always have to be linked to the secondary CTA of the modal. For example, consider the case of asking the user if they “Accept” or “Deny” something, with “Accept” being the primary CTA and “Deny” the secondary CTA. If the user clicks the x button-icon in the top right corner of the modal to dismiss the modal window, it does not have to map to “Deny.”

### Language

Modal views include a title and 1 or 2 calls to action. When writing copy for the title, describe the purpose of the modal in a concise manner. Do not use generic title text such as “Alert” or “Attention!”. Give the modal title a description that simply describes the model content.

For the actions inside the modal, always provide only one clear primary CTA in the Default, Success or Alert button style, all secondary actions inside modals should use either the hollow or text button types.

Use verbs for your buttons that describe the action that will happen when clicked. *Never use generic Yes/No button labels.*

For more on button labels, read the button documentation.
