---
component:
  id: components/form/image-selector
---

## Basic Usage

Image selectors are either checkboxes or radio buttons that are visually enhanced. Use image selectors when you need to use images as labels for your checkboxes or radio buttons.

All image selectors must be wrapped in a `<fieldset>` and must include a `<legend>` to describe what the image selectors are for. The `<fieldset>` should be used inside of your overall `<form>` element. Make sure that the images passed into `<ImageSelector>` are all the same size.

Our provided example shows how to align all of your image selectors using `<Grid>`, but we encourage you to use `<Layout>` or `<Tower>` as well.

## Design Best Practices

Because our layouts are responsive, when creating an image asset for the image selector, make sure the image is larger than the size of the container you intend to use it in. For example, if in your mockups the image selector is 100px wide on mobile, and 200px wide on desktop, try to make the image asset some size bigger than 200px to ensure that it scales down properly. Trying to make your image scale up, where the image goes from smaller and has to stretch to larger, is a bad responsive practice and generally leads to pixelation or other unwanted visual artifacts on the image. The image selector assumes that the provided image will occupy 100% of the image selector width.

## Use Image Selector in a Checkbox Group

```jsx
<fieldset>
  <InjectLayout margin={{bottom: 0.5}}>
    <legend>
      <CoreText bold>Choose an Item</CoreText>
    </legend>
  </InjectLayout>
  <Grid gutterSize={GridGutterSize.Small}>
    <Column cols={4}>
      <ImageSelector
        type={ImageSelectorType.Checkbox}
        label="Item 1"
        name="image-selector-checkbox"
        src="//placehold.jp/6441a4/ffffff/600x300.jpg?text=item1"
        alt="Item 1" />
    </Column>
    <Column cols={4}>
      <ImageSelector
        type={ImageSelectorType.Checkbox}
        label="Item 2"
        name="image-selector-checkbox"
        src="//placehold.jp/6441a4/ffffff/600x300.jpg?text=item2"
        alt="Item 2" />
    </Column>
    <Column cols={4}>
      <ImageSelector
        disabled
        type={ImageSelectorType.Checkbox}
        label="Item 3"
        name="image-selector-checkbox"
        src="//placehold.jp/6441a4/ffffff/600x300.jpg?text=item3"
        alt="Item 3" />
    </Column>
  </Grid>
</fieldset>
```

## Use Image Selector in a Radio Button Group

```jsx
<fieldset>
  <InjectLayout margin={{bottom: 0.5}}>
    <legend>
      <CoreText bold>Choose an Item</CoreText>
    </legend>
  </InjectLayout>
  <Grid gutterSize={GridGutterSize.Small}>
    <Column cols={4}>
      <ImageSelector
        type={ImageSelectorType.Radio}
        label="Item 1"
        name="image-selector-radio"
        src="//placehold.jp/6441a4/ffffff/600x300.jpg?text=item1"
        alt="Item 1" />
    </Column>
    <Column cols={4}>
      <ImageSelector
        type={ImageSelectorType.Radio}
        label="Item 2"
        name="image-selector-radio"
        src="//placehold.jp/6441a4/ffffff/600x300.jpg?text=item2"
        alt="Item 2" />
    </Column>
    <Column cols={4}>
      <ImageSelector
        error
        type={ImageSelectorType.Radio}
        label="Item 3"
        name="image-selector-radio"
        src="//placehold.jp/6441a4/ffffff/600x300.jpg?text=item3"
        alt="Item 3" />
    </Column>
  </Grid>
</fieldset>
```
