---
component:
  id: components/form/radio
---

## Basic Usage

```jsx
<Layout margin={{ y: 1 }}>
  <Radio name="settings-raid" label="Allow all incoming raids" />
</Layout>
<Layout margin={{ y: 1 }}>
  <Radio name="settings-raid" label="Allow only raids from friends, teammates and followed channels" />
</Layout>
<Layout margin={{ y: 1 }}>
  <Radio name="settings-raid" label="Disable incoming raids" />
</Layout>
```

## Example: FormGroup + Layout

```jsx
<Layout margin={{ y: 3 }}>
  <FormGroup label="Channel Raid Settings">
    <Layout margin={{ y: 1 }}>
      <Radio name="settings-raid" label="Allow all incoming raids" />
    </Layout>
    <Layout margin={{ y: 1 }}>
      <Radio name="settings-raid" label="Allow only raids from friends, teammates and followed channels" />
    </Layout>
    <Layout margin={{ y: 1 }}>
      <Radio name="settings-raid" label="Disable incoming raids" />
    </Layout>
  </FormGroup>
</Layout>

<Layout margin={{ y: 3 }}>
  <FormGroup label="Daily Pizza Preference">
    <Layout margin={{ y: 1 }}>
      <Radio name="settings-pizza" label="Vegetarian" />
    </Layout>
    <Layout margin={{ y: 1 }}>
      <Radio name="settings-pizza" label="Pepperoni delux" />
    </Layout>
    <Layout margin={{ y: 1 }}>
      <Radio name="settings-pizza" label="Pineapple and ham supreme" />
    </Layout>
  </FormGroup>
</Layout>
```
