---
component:
  id: components/grid/grid
---

## Basic Usage

### Basic
```jsx
<Grid>
  <Column cols={4}>
    <StyledLayout background={Background.Accent} padding={2} />
  </Column>
  <Column cols={8}>
    <StyledLayout background={Background.Accent} padding={2} />
  </Column>
</Grid>
```

### Nested
```jsx
<Grid>
  <Column cols={3}>
    <StyledLayout background={Background.Accent} padding={2} margin={{ bottom: 1 }} />
    <Grid>
      <Column cols={6}>
        <StyledLayout background={Background.Accent} padding={2} />
      </Column>
      <Column cols={6}>
        <StyledLayout background={Background.Accent} padding={2} />
      </Column>
    </Grid>
  </Column>
  <Column cols={9}>
    <StyledLayout background={Background.Accent} padding={2} margin={{ bottom: 1 }} />
    <Grid>
      <Column cols={6}>
        <StyledLayout background={Background.Accent} padding={2} />
      </Column>
      <Column cols={6}>
        <StyledLayout background={Background.Accent} padding={2} />
      </Column>
    </Grid>
  </Column>
</Grid>
```

## Example: Responsive, equal sized columns

Column size can change based on responsive breakpoints. Example with equal columns:

<a href="https://s3-us-west-2.amazonaws.com/web-design-int-production/assets/ui/videos/2018-03-09_15-46-38.mp4" target="_blank">
  <video src="https://s3-us-west-2.amazonaws.com/web-design-int-production/assets/ui/videos/2018-03-09_15-46-38.mp4" autoplay="true" muted="true" loop="true" width="100%" />
</a>

Code shown below for the video above (resize your browser to see the live demo below re-arrange):

```jsx
<Grid>
  <Column cols={{ default: 12, sm: 6, md: 4, lg: 2 }}>
    <StyledLayout background={Background.Accent} color={Color.Overlay} padding={2} margin={{ bottom: 1 }} display={Display.Flex} justifyContent={JustifyContent.Center} alignItems={AlignItems.Center}>
      <CoreText fontSize={FontSize.Size2}>A</CoreText>
    </StyledLayout>
  </Column>
  <Column cols={{ default: 12, sm: 6, md: 4, lg: 2 }}>
    <StyledLayout background={Background.Accent} color={Color.Overlay} padding={2} margin={{ bottom: 1 }} display={Display.Flex} justifyContent={JustifyContent.Center} alignItems={AlignItems.Center}>
      <CoreText fontSize={FontSize.Size2}>B</CoreText>
    </StyledLayout>
  </Column>
  <Column cols={{ default: 12, sm: 6, md: 4, lg: 2 }}>
    <StyledLayout background={Background.Accent} color={Color.Overlay} padding={2} margin={{ bottom: 1 }} display={Display.Flex} justifyContent={JustifyContent.Center} alignItems={AlignItems.Center}>
      <CoreText fontSize={FontSize.Size2}>C</CoreText>
    </StyledLayout>
  </Column>
  <Column cols={{ default: 12, sm: 6, md: 4, lg: 2 }}>
    <StyledLayout background={Background.Accent} color={Color.Overlay} padding={2} margin={{ bottom: 1 }} display={Display.Flex} justifyContent={JustifyContent.Center} alignItems={AlignItems.Center}>
      <CoreText fontSize={FontSize.Size2}>D</CoreText>
    </StyledLayout>
  </Column>
  <Column cols={{ default: 12, sm: 6, md: 4, lg: 2 }}>
    <StyledLayout background={Background.Accent} color={Color.Overlay} padding={2} margin={{ bottom: 1 }} display={Display.Flex} justifyContent={JustifyContent.Center} alignItems={AlignItems.Center}>
      <CoreText fontSize={FontSize.Size2}>E</CoreText>
    </StyledLayout>
  </Column>
  <Column cols={{ default: 12, sm: 6, md: 4, lg: 2 }}>
    <StyledLayout background={Background.Accent} color={Color.Overlay} padding={2} margin={{ bottom: 1 }} display={Display.Flex} justifyContent={JustifyContent.Center} alignItems={AlignItems.Center}>
      <CoreText fontSize={FontSize.Size2}>F</CoreText>
    </StyledLayout>
  </Column>
</Grid>
```


## Example: Responsive column layout

An example with different sized regions at different viewport sizes:

<a href="https://s3-us-west-2.amazonaws.com/web-design-int-production/assets/ui/videos/2018-03-15_14-18-27.mp4" target="_blank">
  <video src="https://s3-us-west-2.amazonaws.com/web-design-int-production/assets/ui/videos/2018-03-15_14-18-27.mp4" autoplay="true" muted="true" loop="true" width="100%" />
</a>

Code shown below for the video above (resize your browser to see the live demo below re-arrange):

```jsx
<Grid>
  <Column cols={{ default: 12, xs: 6, md: 4 }}>
    <StyledLayout background={Background.Accent} color={Color.Overlay} padding={2} margin={{ bottom: 1 }} display={Display.Flex} justifyContent={JustifyContent.Center} alignItems={AlignItems.Center}>
      <CoreText fontSize={FontSize.Size2}>A</CoreText>
    </StyledLayout>
  </Column>
  <Column cols={{ default: 12, xs: 6, md: 8 }}>
    <StyledLayout background={Background.Accent} color={Color.Overlay} padding={2} margin={{ bottom: 1 }} display={Display.Flex} justifyContent={JustifyContent.Center} alignItems={AlignItems.Center}>
      <CoreText fontSize={FontSize.Size2}>B</CoreText>
    </StyledLayout>
  </Column>
  <Column cols={{ default: 12, xs: 12, md: 8 }} offset={{ default: 0, xs: 0, md: 4 }}>
    <StyledLayout background={Background.Accent} color={Color.Overlay} padding={2} margin={{ bottom: 1 }} display={Display.Flex} justifyContent={JustifyContent.Center} alignItems={AlignItems.Center}>
      <CoreText fontSize={FontSize.Size4}>Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum</CoreText>
    </StyledLayout>
  </Column>
  <Column cols={{ default: 12 }}>
    <StyledLayout background={Background.Accent} color={Color.Overlay} padding={2} margin={{ bottom: 1 }} display={Display.Flex} justifyContent={JustifyContent.Center} alignItems={AlignItems.Center}>
      <CoreText fontSize={FontSize.Size2}>D</CoreText>
    </StyledLayout>
  </Column>
</Grid>
```

## Example: Grid + Flexbox for vertical centering

```jsx
<Grid>

  <Column cols={6}>
    <StyledLayout
      background={Background.AccentAlt2}
      color={Color.Overlay}
      padding={2}
    >
      <CoreText bold>This is very tall content:</CoreText>
      <br />
      <CoreText>Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum.</CoreText>
    </StyledLayout>
  </Column>

  <Column cols={6}>
    <StyledLayout
      display={Display.Flex}
      fullHeight
      fullWidth
      background={Background.AccentAlt}
      color={Color.Overlay}
      padding={2}
    >
      <Layout alignSelf={AlignSelf.Center}>
        <CoreText bold>This is short content:</CoreText>
        <br />
        <CoreText>It is also vertically centered.</CoreText>
      </Layout>
    </StyledLayout>
  </Column>

</Grid>
```
