---
component:
  id: components/grid/column
---
## Basic Usage

### Offsets
```jsx
<Grid>
  <Column cols={{ default: 8, lg: 6 }} offset={{ default: 4, lg: 0 }} >
    <StyledLayout background={Background.Accent} color={Color.Overlay} padding={2}>
      This column has a default offset of 4, but at a large breakpoint that offset is 0.
    </StyledLayout>
  </Column>
</Grid>
```

### Basic Ordering

Using the `order` property, a `Column` can be defined to appear first or last at various breakpoints or by default, regardless of order in the source code. (This is a simplified example to demonstrate how this works; you would normally use this when combined with media queries to create a responsive layout)

```jsx
<Grid>
  <Column cols={4}>
    <StyledLayout background={Background.Accent} color={Color.Overlay} padding={2} margin={{ bottom: 1 }} display={Display.Flex} justifyContent={JustifyContent.Center} alignItems={AlignItems.Center}>
      <CoreText fontSize={FontSize.Size2}>A</CoreText>
    </StyledLayout>
  </Column>
  <Column cols={4} order={ColumnOrder.Last}>
    <StyledLayout background={Background.Accent} color={Color.Overlay} padding={2} margin={{ bottom: 1 }} display={Display.Flex} justifyContent={JustifyContent.Center} alignItems={AlignItems.Center}>
      <CoreText fontSize={FontSize.Size2}>B</CoreText>
    </StyledLayout>
  </Column>
  <Column cols={4} order={ColumnOrder.First}>
    <StyledLayout background={Background.Accent} color={Color.Overlay} padding={2} margin={{ bottom: 1 }} display={Display.Flex} justifyContent={JustifyContent.Center} alignItems={AlignItems.Center}>
      <CoreText fontSize={FontSize.Size2}>C</CoreText>
    </StyledLayout>
  </Column>
</Grid>
```

## Responsive Ordering

Ordering allows us to change the display order of columns at various breakpoints; in this example, the "B" column is re-ordered to appear on the left side at larger viewports and retains source order at smaller viewports.

```jsx
<Grid>
  <Column cols={{ default: 12, md: 6 }}>
    <StyledLayout background={Background.Accent} color={Color.Overlay} padding={2} margin={{ bottom: 1 }} display={Display.Flex} justifyContent={JustifyContent.Center} alignItems={AlignItems.Center}>
      <CoreText fontSize={FontSize.Size2}>A</CoreText>
    </StyledLayout>
  </Column>
  <Column cols={{ default: 12, md: 6 }} order={{ md: ColumnOrder.First }}>
    <StyledLayout background={Background.Accent} color={Color.Overlay} padding={2} margin={{ bottom: 1 }} display={Display.Flex} justifyContent={JustifyContent.Center} alignItems={AlignItems.Center}>
      <CoreText fontSize={FontSize.Size2}>B</CoreText>
    </StyledLayout>
  </Column>
  <Column cols={12}>
    <StyledLayout background={Background.Accent} color={Color.Overlay} padding={2} margin={{ bottom: 1 }} display={Display.Flex} justifyContent={JustifyContent.Center} alignItems={AlignItems.Center}>
      <CoreText fontSize={FontSize.Size2}>C</CoreText>
    </StyledLayout>
  </Column>
</Grid>
```
