---
component:
  id: 'components/core-image'
---

## Basic Usage

```jsx
<CoreImage src="https://s3-us-west-2.amazonaws.com/web-design-int-production/assets/brand/images/Photography--1.jpg" alt="Required alternative text." />
```

## Responsive Image by Density

```jsx
<CoreImage
  src="https://placehold.jp/6441a4/ffffff/200x100.jpg?text=1x"
  alt="user-readable description of the image"
  srcSet={{
    '1x': 'https://placehold.jp/6441a4/ffffff/200x100.jpg?text=1x',
    '1.5x': 'https://placehold.jp/6441a4/ffffff/300x150.jpg?text=1.5x',
    '2x': 'https://placehold.jp/6441a4/ffffff/400x200.jpg?text=2x',
    '3x': 'https://placehold.jp/6441a4/ffffff/600x300.jpg?text=3x',
    '4x': 'https://placehold.jp/6441a4/ffffff/800x400.jpg?text=4x',
  }}
/>
```

## Responsive Image by Target Width

```jsx
<CoreImage
  src="https://placehold.jp/6441a4/ffffff/200x100.jpg?text=800w"
  alt="user-readable description of the image"
  srcSet={{
    '800w': 'https://placehold.jp/6441a4/ffffff/200x100.jpg?text=800w',
    '1200w': 'https://placehold.jp/6441a4/ffffff/300x150.jpg?text=1200w',
    '1600w': 'https://placehold.jp/6441a4/ffffff/400x200.jpg?text=1600w',
  }}
  sizes={[
    { size: '400px', mediaCondition: '(min-width: 400px)' },
    { size: '100vw' },
  ]}
/>
```
