---
component:
  id: components/styled-layout
  disablePlayground: true
---

# Basic Usage
```jsx
<StyledLayout background={Background.Base} elevation={3} padding={5} />
```

# Accent
Some elements are designed to draw attention to an important action or message. To implement this, the accent background color palette can be used on `StyledLayout` along with `overlay`-ready elements.

```jsx
<StyledLayout background={Background.Accent} color={Color.Overlay} elevation={3} padding={2}>
  <Layout margin={{ bottom: 1}}>
    <CoreText>
      All your favorite communities, friends, and games, all in one place.
    </CoreText>
  </Layout>
  <Button type={ButtonType.Hollow} overlay>Download the Desktop App</Button>
</StyledLayout>
```
