---
component:
  id: 'components/layout'
  disablePlayground: true
---

`InjectLayout` works just like `Layout`, except it injects class names onto the first child node which allows you to avoid the addition of a DOM node. This will only work when wrapped around components which accept a `className` prop; most Core UI components do not accept `className`.

## When (not) to use InjectLayout

In general, it is recommended to choose `<Layout>` unless you specifically need to avoid the creation of an additional DOM node. The reason for this is to assist with human understandability of the code, as it can be confusing to follow what InjectLayout is doing as code becomes complex.

### ✅ Recommended:

Easy to understand: the padding is inside the click target.

```html
<a href="twitch.tv">
  <Layout padding={3}> Visit Twitch </Layout>
</a>
```

### ❌ Not Recommended:

More difficult to understand because two JSX elements render to one DOM node.

```html
<InjectLayout padding={3}>
  <a href="twitch.tv"> Visit Twitch </a>
</InjectLayout>
```

## When to use InjectLayout

We must use `InjectLayout` because `<Layout fullWidth>` would not affect the width of the image:

```html
<InjectLayout fullWidth>
  <img src="kappa.jpg" />
</InjectLayout>
```

These tags must not have additional DOM nodes inserted between the `ul` and the `li`:

```html
<InjectLayout display={Display.Flex}>
  <ul>
    <InjectLayout flexGrow={1}>
      <li>Foo</li>
    </InjectLayout>
    <InjectLayout flexGrow={1}>
      <li>Bar</li>
    </InjectLayout>
  </ul>
</InjectLayout>
```
