---
component:
  id: components/core-link
---

# Basic Usage

```jsx
<CoreLink to="https://www.twitch.tv/">Twitch</CoreLink>
```

# Within an overlay

Using `<CoreLink>` instead of a plain `<a>` tag provides some control over the visual appearance of the link, such as to display it in an overlay:

```jsx
<StyledLayout color={Color.Overlay} background={Background.AccentAlt2} padding={2}>
  <CoreText>
    Please visit our website:
    <CoreLink
      type={CoreLinkType.Overlay}
      to="https://www.twitch.tv/"
    >
      www.twitch.tv
    </CoreLink>
  </CoreText>
</StyledLayout>
```
