---
component:
  id: components/responsive-wrapper
---

## Basic Usage

Children will be constrained to fit our shared breakpoint sizes.

This component applys a "max-width" property around contents so that on very large screens the main content area won't grow to be too large. It also provides smaller "max-width" values at breakpoints in order to create a more predictable "responsive collapse" to provide more control over the contents as the viewport gets smaller.

## Example: Wrapper + Grid + Responsive Columns

By combining `<ResponsiveWrapper>` with the structure of `<Grid>` and `<Column>` we can achieve a centered layout with a "maximum width" which works well for page content and collapses at predictable breakpoints to help ensure content looks good at every viewport size.

Here is a simple example that shows you how `<ResponsiveWrapper>` works.

<a href="https://s3-us-west-2.amazonaws.com/web-design-int-production/assets/ui/images/responsiveWrapper.mp4" target="_blank">
  <video src="https://s3-us-west-2.amazonaws.com/web-design-int-production/assets/ui/images/responsiveWrapper.mp4" autoplay="true" muted="true" loop="true" width="100%"></video>
</a>

The code for the example is below:

```jsx
<ResponsiveWrapper centered>
  <Grid justifyContent={JustifyContent.Center}>
    <Column cols={{ default: 12, sm: 10, md: 8, lg: 7, xl: 6 }}>
      {/* Page contents go here */}
    </Column>
  </Grid>
</ResponsiveWrapper>
```

Here is an example of `<ResponsiveWrapper>` in a more complex layout. This layout changes the size of form elements at different breakpoints in order to maintain an optimal user experience.

<a href="https://s3-us-west-2.amazonaws.com/web-design-int-production/assets/ui/images/responsivewrapper+demo+2.mp4" target="_blank">
  <video src="https://s3-us-west-2.amazonaws.com/web-design-int-production/assets/ui/images/responsivewrapper+demo+2.mp4" autoplay="true" muted="true" loop="true" width="100%"></video>
</a>

The code for the example is below:

```jsx
<ResponsiveWrapper centered>
  <CoreText type={TextType.H2}>Pick a topping:</CoreText>
  <StyledLayout border margin={{ top: 2 }}>
    <Grid justifyContent={JustifyContent.Center}>
      <Column cols={{ default: 6, xs: 6, sm: 4, md: 2, lg: 2, xl: 2 }}>
        <Layout padding={1} margin={{ bottom: 1 }} breakpointLarge={{ padding: 2 }}>
          <CheckBox label="Cheese" />
        </Layout>
      </Column>
      <Column cols={{ default: 6, xs: 6, sm: 4, md: 2, lg: 2, xl: 2 }}>
        <Layout padding={1} margin={{ bottom: 1 }} breakpointLarge={{ padding: 2 }}>
          <CheckBox label="Onions" />
        </Layout>
      </Column>
      <Column cols={{ default: 6, xs: 6, sm: 4, md: 2, lg: 2, xl: 2 }}>
        <Layout padding={1} margin={{ bottom: 1 }} breakpointLarge={{ padding: 2 }}>
          <CheckBox label="Pineapples" />
        </Layout>
      </Column>
      <Column cols={{ default: 6, xs: 6, sm: 4, md: 2, lg: 2, xl: 2 }}>
        <Layout padding={1} margin={{ bottom: 1 }} breakpointLarge={{ padding: 2 }}>
          <CheckBox label="Jalapenos" />
        </Layout>
      </Column>
      <Column cols={{ default: 6, xs: 6, sm: 4, md: 2, lg: 2, xl: 2 }}>
        <Layout padding={1} margin={{ bottom: 1 }} breakpointLarge={{ padding: 2 }}>
          <CheckBox label="Green Peppers" />
        </Layout>
      </Column>
      <Column cols={{ default: 6, xs: 6, sm: 4, md: 2, lg: 2, xl: 2 }}>
        <Layout padding={1} margin={{ bottom: 1 }} breakpointLarge={{ padding: 2 }}>
          <CheckBox label="HAM!" />
        </Layout>
      </Column>
      <Column cols={{ default: 6, xs: 6, sm: 4, md: 2, lg: 2, xl: 2 }}>
        <Layout padding={1} margin={{ bottom: 1 }} breakpointLarge={{ padding: 2 }}>
          <CheckBox label="Spicy Hot Cheetos" />
        </Layout>
      </Column>
      <Column cols={{ default: 6, xs: 6, sm: 4, md: 2, lg: 2, xl: 2 }}>
        <Layout padding={1} margin={{ bottom: 1 }} breakpointLarge={{ padding: 2 }}>
          <CheckBox label="Tomatos" />
        </Layout>
      </Column>
      <Column cols={{ default: 6, xs: 6, sm: 4, md: 2, lg: 2, xl: 2 }}>
        <Layout padding={1} margin={{ bottom: 1 }} breakpointLarge={{ padding: 2 }}>
          <CheckBox label="Arugula" />
        </Layout>
      </Column>
      <Column cols={{ default: 6, xs: 6, sm: 4, md: 2, lg: 2, xl: 2 }}>
        <Layout padding={1} margin={{ bottom: 1 }} breakpointLarge={{ padding: 2 }}>
          <CheckBox label="Chocolate" />
        </Layout>
      </Column>
      <Column cols={{ default: 6, xs: 6, sm: 4, md: 2, lg: 2, xl: 2 }}>
        <Layout padding={1} margin={{ bottom: 1 }} breakpointLarge={{ padding: 2 }}>
          <CheckBox label="Olives" />
        </Layout>
      </Column>
      <Column cols={{ default: 6, xs: 6, sm: 4, md: 2, lg: 2, xl: 2 }}>
        <Layout padding={1} margin={{ bottom: 1 }} breakpointLarge={{ padding: 2 }}>
          <CheckBox label="Mini Pizzas" />
        </Layout>
      </Column>
    </Grid>
  </StyledLayout>

  <Layout margin={{ top: 4 }}>
    <CoreText type={TextType.H2}>Complete the order form:</CoreText>
    <StyledLayout border margin={{ top: 2 }}>
      <Grid justifyContent={JustifyContent.Center}>
        <Column cols={{ default: 12, xs: 12, sm: 4, md: 5, lg: 5, xl: 5 }}>
          <Layout padding={1} margin={{ bottom: 1 }}>
            <FormGroup
              label="First Name"
            >
              <Input
                type={InputType.Text}
                placeholder="First Name"
              />
            </FormGroup>
          </Layout>
        </Column>
        <Column cols={{ default: 12, xs: 12, sm: 4, md: 2, lg: 2, xl: 2 }}>
          <Layout padding={1} margin={{ bottom: 1 }}>
            <FormGroup
              label="Middle Name"
            >
              <Input
                type={InputType.Text}
                placeholder="Middle Name"
              />
            </FormGroup>
          </Layout>
        </Column>
        <Column cols={{ default: 12, xs: 12, sm: 4, md: 5, lg: 5, xl: 5 }}>
          <Layout padding={1} margin={{ bottom: 1 }}>
            <FormGroup
              label="Last Name"
            >
              <Input
                type={InputType.Text}
                placeholder="Last Name"
              />
            </FormGroup>
          </Layout>
        </Column>
        <Column cols={{ default: 6, xs: 6, sm: 6, md: 6, lg: 6, xl: 6 }}>
          <Layout padding={1} margin={{ bottom: 1 }}>
            <FormGroup
              label="Credit Card #"
            >
              <Input
                type={InputType.Text}
                placeholder="Credit Card #"
              />
            </FormGroup>
          </Layout>
        </Column>
        <Column cols={{ default: 6, xs: 6, sm: 6, md: 6, lg: 6, xl: 6 }}>
          <Layout padding={1} margin={{ bottom: 1 }}>
            <FormGroup
              label="Name on Card"
            >
              <Input
                type={InputType.Text}
                placeholder="Name on Card"
              />
            </FormGroup>
          </Layout>
        </Column>
        <Column cols={{ default: 12 }}>
          <Layout padding={1} margin={{ bottom: 1 }} display={Display.Flex} justifyContent={JustifyContent.End}>
            <Button>Submit</Button>
          </Layout>
        </Column>
      </Grid>
    </StyledLayout>
  </Layout>
</ResponsiveWrapper>
```
