---
component:
  redirect: core-text
---

The `CoreText` component is used to apply functional CSS rules to text elements and should only be used in place of plain HTML text rendering tags when necessary.

# Basic Usage

## Text Type
```jsx
<CoreText type={TextType.H1}>Heading</CoreText><br />
<CoreText fontSize={FontSize.Size5}>
  <CoreText type={TextType.Span} bold>Developer Day will be held on October 19 in Long Beach, CA</CoreText>, one day prior to TwitchCon. Game creators and stream tools developers of all levels, from hobbyists to AAA studios, are invited to learn more about the Twitch Developer Platform, hear directly from the people behind the products, and share experiences with each other.
</CoreText>
```

## Ellipsis + Flexbox

Text content of arbitrary length inside a container of a flexible size is a common layout need. It is sometimes necessary to add both the **ellipsis attribute** to `<CoreText>` AND the **overflow hidden** property to its container to achieve the correct behavior.

```jsx
<StyledLayout
  display={Display.Flex}
  alignItems={AlignItems.Center}
  background={Background.Base}
  padding={1}
  elevation={1}
>
  <Layout flexGrow={0} flexShrink={0} margin={{ right: 1 }}>
    <CoreImage      src="https://static-cdn.jtvnw.net/community-images/ec04cef0-0e81-4fa9-a037-d11ac87051b6/35b1347b-31a8-4bb2-bb98-bfa4ec010926-40x53.png" />
  </Layout>
  {/* THE NEXT LINE IS IMPORTANT! The following props:
    *     flexGrow={1}
    *     flexShrink={1}
    *     overflow={Overflow.Hidden}
    * make this container flexible AND hides the overflowing content
    **/}
  <Layout flexGrow={1} flexShrink={1} overflow={Overflow.Hidden}>
    {/* Ellipsis works here because the container has overflow hidden */}
    <CoreText ellipsis>
      Monstercat Radio - 24/7 Music Stream - live.monstercat.com - Always live 24/7, follow today to join the party and never miss out!
    </CoreText>
    <CoreText>
      <CoreLink>Monstercat</CoreLink> &bull; <CoreLink>Variety Streaming</CoreLink>
    </CoreText>
  </Layout>
  <Layout flexGrow={0} flexShrink={0} margin={{ x: 1 }}>
    <Stat
      label="Viewers"
      value="123,456,789"
      icon={SVGAsset.GlyphViews}
    />
  </Layout>
  <Layout flexGrow={0} flexShrink={0}>
    <Button type={ButtonType.Hollow}>Share</Button>
    <Layout margin={{ left: 1 }} display={Display.InlineBlock}>
      <ButtonIcon type={ButtonIconType.Hollow} icon={SVGAsset.More} />
    </Layout>
  </Layout>
</StyledLayout>
```

## Ellipsis

For user-generated text or text of an arbitrary length, apply ellipsis in order to prevent layout breakage.

```jsx
<Grid>
  <Column cols={6}>
    <StyledLayout padding={1} fullHeight border>
      <CoreText bold>One Line</CoreText>
      <CoreText ellipsis>Night of the Day of the Dawn of the Son of the Bride of the Return of the Revenge of the Terror of the Attack of the Evil, Mutant, Alien, Flesh Eating, Hellbound, Zombified Living Dead Part 2</CoreText>
    </StyledLayout>
  </Column>
  <Column cols={6}>
    <StyledLayout padding={1} fullHeight border>
      <CoreText bold>Two Lines</CoreText>
      <CoreText ellipsis lines={2}>Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum.</CoreText>
    </StyledLayout>
  </Column>
</Grid>
```

## Font Size

```jsx
<CoreText fontSize={FontSize.Size1}>Heading</CoreText><br />
<CoreText fontSize={FontSize.Size2}>Heading</CoreText><br />
<CoreText fontSize={FontSize.Size3}>Heading</CoreText><br />
<CoreText fontSize={FontSize.Size4}>Heading</CoreText><br />
<CoreText fontSize={FontSize.Size5}>Heading</CoreText><br />
<CoreText fontSize={FontSize.Size6}>Heading</CoreText><br />
<CoreText fontSize={FontSize.Size7}>Heading</CoreText>
```
