webpackJsonp([47234056399709],{873:function(a,s){a.exports={data:{page:{modifiedTime:"2018-04-03T23:09:30.000Z",fields:{title:"Image Selector",slug:"image-selector",path:"/user-interface/components/form/image-selector",segments:[{title:"User Interface",slug:"user-interface"},{title:"Components",slug:"components"},{title:"Form",slug:"form"},{title:"Image Selector",slug:"image-selector"}]},childMarkdownRemark:{html:'<h2 id="basic-usage"><a href="#basic-usage" aria-hidden="true" class="anchor"><svg aria-hidden="true" height="16" version="1.1" viewBox="0 0 16 16" width="16"><path fill-rule="evenodd" d="M4 9h1v1H4c-1.5 0-3-1.69-3-3.5S2.55 3 4 3h4c1.45 0 3 1.69 3 3.5 0 1.41-.91 2.72-2 3.25V8.59c.58-.45 1-1.27 1-2.09C10 5.22 8.98 4 8 4H4c-.98 0-2 1.22-2 2.5S3 9 4 9zm9-3h-1v1h1c1 0 2 1.22 2 2.5S13.98 12 13 12H9c-.98 0-2-1.22-2-2.5 0-.83.42-1.64 1-2.09V6.25c-1.09.53-2 1.84-2 3.25C6 11.31 7.55 13 9 13h4c1.45 0 3-1.69 3-3.5S14.5 6 13 6z"></path></svg></a>Basic Usage</h2>\n<p>Image selectors are either checkboxes or radio buttons that are visually enhanced. Use image selectors when you need to use images as labels for your checkboxes or radio buttons.</p>\n<p>All image selectors must be wrapped in a <code>&#x3C;fieldset></code> and must include a <code>&#x3C;legend></code> to describe what the image selectors are for. The <code>&#x3C;fieldset></code> should be used inside of your overall <code>&#x3C;form></code> element. Make sure that the images passed into <code>&#x3C;ImageSelector></code> are all the same size.</p>\n<p>Our provided example shows how to align all of your image selectors using <code>&#x3C;Grid></code>, but we encourage you to use <code>&#x3C;Layout></code> or <code>&#x3C;Tower></code> as well.</p>\n<h2 id="use-image-selector-in-a-checkbox-group"><a href="#use-image-selector-in-a-checkbox-group" aria-hidden="true" class="anchor"><svg aria-hidden="true" height="16" version="1.1" viewBox="0 0 16 16" width="16"><path fill-rule="evenodd" d="M4 9h1v1H4c-1.5 0-3-1.69-3-3.5S2.55 3 4 3h4c1.45 0 3 1.69 3 3.5 0 1.41-.91 2.72-2 3.25V8.59c.58-.45 1-1.27 1-2.09C10 5.22 8.98 4 8 4H4c-.98 0-2 1.22-2 2.5S3 9 4 9zm9-3h-1v1h1c1 0 2 1.22 2 2.5S13.98 12 13 12H9c-.98 0-2-1.22-2-2.5 0-.83.42-1.64 1-2.09V6.25c-1.09.53-2 1.84-2 3.25C6 11.31 7.55 13 9 13h4c1.45 0 3-1.69 3-3.5S14.5 6 13 6z"></path></svg></a>Use Image Selector in a Checkbox Group</h2>\n<div class="gatsby-highlight">\n      <pre class="language-jsx"><code><span class="token tag"><span class="token tag"><span class="token punctuation">&lt;</span>fieldset</span><span class="token punctuation">></span></span>\n  <span class="token tag"><span class="token tag"><span class="token punctuation">&lt;</span>InjectLayout</span> <span class="token attr-name">margin</span><span class="token script language-javascript"><span class="token punctuation">=</span><span class="token punctuation">{</span><span class="token punctuation">{</span>bottom<span class="token punctuation">:</span> <span class="token number">0.5</span><span class="token punctuation">}</span><span class="token punctuation">}</span></span><span class="token punctuation">></span></span>\n    <span class="token tag"><span class="token tag"><span class="token punctuation">&lt;</span>legend</span><span class="token punctuation">></span></span>\n      <span class="token tag"><span class="token tag"><span class="token punctuation">&lt;</span>CoreText</span> <span class="token attr-name">bold</span><span class="token punctuation">></span></span>Choose an Item<span class="token tag"><span class="token tag"><span class="token punctuation">&lt;/</span>CoreText</span><span class="token punctuation">></span></span>\n    <span class="token tag"><span class="token tag"><span class="token punctuation">&lt;/</span>legend</span><span class="token punctuation">></span></span>\n  <span class="token tag"><span class="token tag"><span class="token punctuation">&lt;/</span>InjectLayout</span><span class="token punctuation">></span></span>\n  <span class="token tag"><span class="token tag"><span class="token punctuation">&lt;</span>Grid</span> <span class="token attr-name">gutterSize</span><span class="token script language-javascript"><span class="token punctuation">=</span><span class="token punctuation">{</span>GridGutterSize<span class="token punctuation">.</span>Small<span class="token punctuation">}</span></span><span class="token punctuation">></span></span>\n    <span class="token tag"><span class="token tag"><span class="token punctuation">&lt;</span>Column</span> <span class="token attr-name">cols</span><span class="token script language-javascript"><span class="token punctuation">=</span><span class="token punctuation">{</span><span class="token number">4</span><span class="token punctuation">}</span></span><span class="token punctuation">></span></span>\n      <span class="token operator">&lt;</span>ImageSelector\n        type<span class="token operator">=</span><span class="token punctuation">{</span>ImageSelectorType<span class="token punctuation">.</span>Checkbox<span class="token punctuation">}</span>\n        label<span class="token operator">=</span><span class="token string">"Item 1"</span>\n        name<span class="token operator">=</span><span class="token string">"image-selector-checkbox"</span>\n        src<span class="token operator">=</span><span class="token string">"//placehold.jp/6441a4/ffffff/200x100.jpg?text=item1"</span>\n        alt<span class="token operator">=</span><span class="token string">"Item 1"</span> <span class="token operator">/</span><span class="token operator">></span>\n    <span class="token tag"><span class="token tag"><span class="token punctuation">&lt;/</span>Column</span><span class="token punctuation">></span></span>\n    <span class="token tag"><span class="token tag"><span class="token punctuation">&lt;</span>Column</span> <span class="token attr-name">cols</span><span class="token script language-javascript"><span class="token punctuation">=</span><span class="token punctuation">{</span><span class="token number">4</span><span class="token punctuation">}</span></span><span class="token punctuation">></span></span>\n      <span class="token operator">&lt;</span>ImageSelector\n        type<span class="token operator">=</span><span class="token punctuation">{</span>ImageSelectorType<span class="token punctuation">.</span>Checkbox<span class="token punctuation">}</span>\n        label<span class="token operator">=</span><span class="token string">"Item 2"</span>\n        name<span class="token operator">=</span><span class="token string">"image-selector-checkbox"</span>\n        src<span class="token operator">=</span><span class="token string">"//placehold.jp/6441a4/ffffff/200x100.jpg?text=item2"</span>\n        alt<span class="token operator">=</span><span class="token string">"Item 2"</span> <span class="token operator">/</span><span class="token operator">></span>\n    <span class="token tag"><span class="token tag"><span class="token punctuation">&lt;/</span>Column</span><span class="token punctuation">></span></span>\n    <span class="token tag"><span class="token tag"><span class="token punctuation">&lt;</span>Column</span> <span class="token attr-name">cols</span><span class="token script language-javascript"><span class="token punctuation">=</span><span class="token punctuation">{</span><span class="token number">4</span><span class="token punctuation">}</span></span><span class="token punctuation">></span></span>\n      <span class="token operator">&lt;</span>ImageSelector\n        disabled\n        type<span class="token operator">=</span><span class="token punctuation">{</span>ImageSelectorType<span class="token punctuation">.</span>Checkbox<span class="token punctuation">}</span>\n        label<span class="token operator">=</span><span class="token string">"Item 3"</span>\n        name<span class="token operator">=</span><span class="token string">"image-selector-checkbox"</span>\n        src<span class="token operator">=</span><span class="token string">"//placehold.jp/6441a4/ffffff/200x100.jpg?text=item3"</span>\n        alt<span class="token operator">=</span><span class="token string">"Item 3"</span> <span class="token operator">/</span><span class="token operator">></span>\n    <span class="token tag"><span class="token tag"><span class="token punctuation">&lt;/</span>Column</span><span class="token punctuation">></span></span>\n  <span class="token tag"><span class="token tag"><span class="token punctuation">&lt;/</span>Grid</span><span class="token punctuation">></span></span>\n<span class="token tag"><span class="token tag"><span class="token punctuation">&lt;/</span>fieldset</span><span class="token punctuation">></span></span>\n</code></pre>\n      </div>\n<h2 id="use-image-selector-in-a-radio-button-group"><a href="#use-image-selector-in-a-radio-button-group" aria-hidden="true" class="anchor"><svg aria-hidden="true" height="16" version="1.1" viewBox="0 0 16 16" width="16"><path fill-rule="evenodd" d="M4 9h1v1H4c-1.5 0-3-1.69-3-3.5S2.55 3 4 3h4c1.45 0 3 1.69 3 3.5 0 1.41-.91 2.72-2 3.25V8.59c.58-.45 1-1.27 1-2.09C10 5.22 8.98 4 8 4H4c-.98 0-2 1.22-2 2.5S3 9 4 9zm9-3h-1v1h1c1 0 2 1.22 2 2.5S13.98 12 13 12H9c-.98 0-2-1.22-2-2.5 0-.83.42-1.64 1-2.09V6.25c-1.09.53-2 1.84-2 3.25C6 11.31 7.55 13 9 13h4c1.45 0 3-1.69 3-3.5S14.5 6 13 6z"></path></svg></a>Use Image Selector in a Radio Button Group</h2>\n<div class="gatsby-highlight">\n      <pre class="language-jsx"><code><span class="token tag"><span class="token tag"><span class="token punctuation">&lt;</span>fieldset</span><span class="token punctuation">></span></span>\n  <span class="token tag"><span class="token tag"><span class="token punctuation">&lt;</span>InjectLayout</span> <span class="token attr-name">margin</span><span class="token script language-javascript"><span class="token punctuation">=</span><span class="token punctuation">{</span><span class="token punctuation">{</span>bottom<span class="token punctuation">:</span> <span class="token number">0.5</span><span class="token punctuation">}</span><span class="token punctuation">}</span></span><span class="token punctuation">></span></span>\n    <span class="token tag"><span class="token tag"><span class="token punctuation">&lt;</span>legend</span><span class="token punctuation">></span></span>\n      <span class="token tag"><span class="token tag"><span class="token punctuation">&lt;</span>CoreText</span> <span class="token attr-name">bold</span><span class="token punctuation">></span></span>Choose an Item<span class="token tag"><span class="token tag"><span class="token punctuation">&lt;/</span>CoreText</span><span class="token punctuation">></span></span>\n    <span class="token tag"><span class="token tag"><span class="token punctuation">&lt;/</span>legend</span><span class="token punctuation">></span></span>\n  <span class="token tag"><span class="token tag"><span class="token punctuation">&lt;/</span>InjectLayout</span><span class="token punctuation">></span></span>\n  <span class="token tag"><span class="token tag"><span class="token punctuation">&lt;</span>Grid</span> <span class="token attr-name">gutterSize</span><span class="token script language-javascript"><span class="token punctuation">=</span><span class="token punctuation">{</span>GridGutterSize<span class="token punctuation">.</span>Small<span class="token punctuation">}</span></span><span class="token punctuation">></span></span>\n    <span class="token tag"><span class="token tag"><span class="token punctuation">&lt;</span>Column</span> <span class="token attr-name">cols</span><span class="token script language-javascript"><span class="token punctuation">=</span><span class="token punctuation">{</span><span class="token number">4</span><span class="token punctuation">}</span></span><span class="token punctuation">></span></span>\n      <span class="token operator">&lt;</span>ImageSelector\n        type<span class="token operator">=</span><span class="token punctuation">{</span>ImageSelectorType<span class="token punctuation">.</span>Radio<span class="token punctuation">}</span>\n        label<span class="token operator">=</span><span class="token string">"Item 1"</span>\n        name<span class="token operator">=</span><span class="token string">"image-selector-radio"</span>\n        src<span class="token operator">=</span><span class="token string">"//placehold.jp/6441a4/ffffff/200x100.jpg?text=item1"</span>\n        alt<span class="token operator">=</span><span class="token string">"Item 1"</span> <span class="token operator">/</span><span class="token operator">></span>\n    <span class="token tag"><span class="token tag"><span class="token punctuation">&lt;/</span>Column</span><span class="token punctuation">></span></span>\n    <span class="token tag"><span class="token tag"><span class="token punctuation">&lt;</span>Column</span> <span class="token attr-name">cols</span><span class="token script language-javascript"><span class="token punctuation">=</span><span class="token punctuation">{</span><span class="token number">4</span><span class="token punctuation">}</span></span><span class="token punctuation">></span></span>\n      <span class="token operator">&lt;</span>ImageSelector\n        type<span class="token operator">=</span><span class="token punctuation">{</span>ImageSelectorType<span class="token punctuation">.</span>Radio<span class="token punctuation">}</span>\n        label<span class="token operator">=</span><span class="token string">"Item 2"</span>\n        name<span class="token operator">=</span><span class="token string">"image-selector-radio"</span>\n        src<span class="token operator">=</span><span class="token string">"//placehold.jp/6441a4/ffffff/200x100.jpg?text=item2"</span>\n        alt<span class="token operator">=</span><span class="token string">"Item 2"</span> <span class="token operator">/</span><span class="token operator">></span>\n    <span class="token tag"><span class="token tag"><span class="token punctuation">&lt;/</span>Column</span><span class="token punctuation">></span></span>\n    <span class="token tag"><span class="token tag"><span class="token punctuation">&lt;</span>Column</span> <span class="token attr-name">cols</span><span class="token script language-javascript"><span class="token punctuation">=</span><span class="token punctuation">{</span><span class="token number">4</span><span class="token punctuation">}</span></span><span class="token punctuation">></span></span>\n      <span class="token operator">&lt;</span>ImageSelector\n        error\n        type<span class="token operator">=</span><span class="token punctuation">{</span>ImageSelectorType<span class="token punctuation">.</span>Radio<span class="token punctuation">}</span>\n        label<span class="token operator">=</span><span class="token string">"Item 3"</span>\n        name<span class="token operator">=</span><span class="token string">"image-selector-radio"</span>\n        src<span class="token operator">=</span><span class="token string">"//placehold.jp/6441a4/ffffff/200x100.jpg?text=item3"</span>\n        alt<span class="token operator">=</span><span class="token string">"Item 3"</span> <span class="token operator">/</span><span class="token operator">></span>\n    <span class="token tag"><span class="token tag"><span class="token punctuation">&lt;/</span>Column</span><span class="token punctuation">></span></span>\n  <span class="token tag"><span class="token tag"><span class="token punctuation">&lt;/</span>Grid</span><span class="token punctuation">></span></span>\n<span class="token tag"><span class="token tag"><span class="token punctuation">&lt;/</span>fieldset</span><span class="token punctuation">></span></span>\n</code></pre>\n      </div>',frontmatter:{component:{id:"components/form/image-selector",disablePlayground:null},title:""},headings:[{value:"Basic Usage",depth:2},{value:"Use Image Selector in a Checkbox Group",depth:2},{value:"Use Image Selector in a Radio Button Group",depth:2}]}},github:{items:[{sha:"b1501103aa74913ccd4b20070f9336e6ac82dbb4",htmlUrl:"https://git-aws.internal.justin.tv/web/core-ui/commit/b1501103aa74913ccd4b20070f9336e6ac82dbb4",commit:{message:"change image selector labels to block elements",committer:{date:"2018-03-22T17:05:34Z"}},author:{login:"shusterm",avatarUrl:"https://git-aws.internal.justin.tv/avatars/u/406?",htmlUrl:"https://git-aws.internal.justin.tv/shusterm"}},{sha:"a63c5cd83a5946388c4189d1e7d7b522245fd25e",htmlUrl:"https://git-aws.internal.justin.tv/web/core-ui/commit/a63c5cd83a5946388c4189d1e7d7b522245fd25e",commit:{message:"added disabled and error states for image selector",committer:{date:"2018-03-07T18:37:40Z"}},author:{login:"shusterm",avatarUrl:"https://git-aws.internal.justin.tv/avatars/u/406?",htmlUrl:"https://git-aws.internal.justin.tv/shusterm"}},{sha:"745764769f6d9acb4f051853255b9e65e8e56ce0",htmlUrl:"https://git-aws.internal.justin.tv/web/core-ui/commit/745764769f6d9acb4f051853255b9e65e8e56ce0",commit:{message:"properly extend form checkbox, radio, and image selector interfaces for docs",committer:{date:"2018-03-06T21:25:26Z"}},author:{login:"shusterm",avatarUrl:"https://git-aws.internal.justin.tv/avatars/u/406?",htmlUrl:"https://git-aws.internal.justin.tv/shusterm"}},{sha:"2390806c0a5de0f8afa343e58cea176adf0ef48a",htmlUrl:"https://git-aws.internal.justin.tv/web/core-ui/commit/2390806c0a5de0f8afa343e58cea176adf0ef48a",commit:{message:"move some sass rules to layout",committer:{date:"2018-03-06T19:05:08Z"}},author:{login:"shusterm",avatarUrl:"https://git-aws.internal.justin.tv/avatars/u/406?",htmlUrl:"https://git-aws.internal.justin.tv/shusterm"}},{sha:"d8efe6a5be6bd5f6a8e35288f991ed0c93efd572",htmlUrl:"https://git-aws.internal.justin.tv/web/core-ui/commit/d8efe6a5be6bd5f6a8e35288f991ed0c93efd572",commit:{message:"fix element selector, radio example",committer:{date:"2018-03-06T18:59:49Z"}},author:{login:"shusterm",avatarUrl:"https://git-aws.internal.justin.tv/avatars/u/406?",htmlUrl:"https://git-aws.internal.justin.tv/shusterm"}},{sha:"7981f66a63923c1d507433529e8610f4891170dc",htmlUrl:"https://git-aws.internal.justin.tv/web/core-ui/commit/7981f66a63923c1d507433529e8610f4891170dc",commit:{message:"apply all CoreImage attrs; use legends for examples; change selected border size",committer:{date:"2018-03-06T00:29:49Z"}},author:{login:"shusterm",avatarUrl:"https://git-aws.internal.justin.tv/avatars/u/406?",htmlUrl:"https://git-aws.internal.justin.tv/shusterm"}},{sha:"6800e39f8d852c1d4b9a4f06ae07086323d869d7",htmlUrl:"https://git-aws.internal.justin.tv/web/core-ui/commit/6800e39f8d852c1d4b9a4f06ae07086323d869d7",commit:{message:"basic implementation for image selector",committer:{date:"2018-03-05T22:44:40Z"}},author:{login:"shusterm",avatarUrl:"https://git-aws.internal.justin.tv/avatars/u/406?",htmlUrl:"https://git-aws.internal.justin.tv/shusterm"}}]},component:{name:"ImageSelector",comment:null,properties:[{name:"alt",flags:{isOptional:null},type:"string",comment:{shortText:"User-readable description of the image being displayed.",tags:[{tag:"example",text:"Required alternative text.\n"}]},availableValues:[],breakpointCompatible:!1},{name:"autoFocus",flags:{isOptional:!0},type:"boolean",comment:null,availableValues:[],breakpointCompatible:!1},{name:"checked",flags:{isOptional:!0},type:"boolean",comment:{shortText:"Programatically check the box.",tags:null},availableValues:[],breakpointCompatible:!1},{name:"className",flags:{isOptional:!0},type:"string",comment:null,availableValues:[],breakpointCompatible:!1},{name:"defaultChecked",flags:{isOptional:!0},type:"boolean",comment:null,availableValues:[],breakpointCompatible:!1},{name:"disabled",flags:{isOptional:!0},type:"boolean",comment:{shortText:"Display as disabled.",tags:null},availableValues:[],breakpointCompatible:!1},{name:"error",flags:{isOptional:!0},type:"boolean",comment:null,availableValues:[],breakpointCompatible:!1},{name:"id",flags:{isOptional:!0},type:"string",comment:null,availableValues:[],breakpointCompatible:!1},{name:"label",flags:{isOptional:null},type:"string",comment:{shortText:null,tags:[{tag:"example",text:"PlayStation 4\n"}]},availableValues:[],breakpointCompatible:!1},{name:"name",flags:{isOptional:!0},type:"string",comment:null,availableValues:[],breakpointCompatible:!1},{name:"onBlur",flags:{isOptional:!0},type:"React.FormEventHandler",comment:null,availableValues:[],breakpointCompatible:!1},{name:"onChange",flags:{isOptional:!0},type:"React.FormEventHandler",comment:null,availableValues:[],breakpointCompatible:!1},{name:"onError",flags:{isOptional:!0},type:"React.EventHandler",comment:{shortText:"Callback that fires when image fails to load.",tags:null},availableValues:[],breakpointCompatible:!1},{name:"onFocus",flags:{isOptional:!0},type:"React.FormEventHandler",comment:null,availableValues:[],breakpointCompatible:!1},{name:"onLoad",flags:{isOptional:!0},type:"React.EventHandler",comment:{shortText:"Callback that fires when image loads.",tags:null},availableValues:[],breakpointCompatible:!1},{name:"refDelegate",flags:{isOptional:!0},type:null,comment:null,availableValues:[],breakpointCompatible:!1},{name:"refHandler",flags:{isOptional:!0},type:null,comment:null,availableValues:[],breakpointCompatible:!1},{name:"required",flags:{isOptional:!0},type:"boolean",comment:null,availableValues:[],breakpointCompatible:!1},{name:"sizes",flags:{isOptional:!0},type:null,comment:{shortText:"The intended display size of the image at various breakpoints. Accepts an array of objects that contain a size, and optionally a mediaCondition.",tags:null},availableValues:[],breakpointCompatible:!1},{name:"src",flags:{isOptional:null},type:"string",comment:{shortText:"URL of the image resource.",tags:[{tag:"example",text:"https://s3-us-west-2.amazonaws.com/web-design-int-production/assets/brand/images/Photography--1.jpg\n"}]},availableValues:[],breakpointCompatible:!1},{name:"srcSet",flags:{isOptional:!0},type:"CoreSrcSet",comment:{shortText:"A configuration object for responsive image display. Accepts an object with valid descriptors for keys and image urls for values.",tags:null},availableValues:[],breakpointCompatible:!1},{name:"tabIndex",flags:{isOptional:!0},type:"number",comment:null,availableValues:[],breakpointCompatible:!1},{name:"type",flags:{isOptional:null},type:"ImageSelectorType",comment:{shortText:"ImageSelectors can behave a radio or checkbox controls.",tags:null},availableValues:["Checkbox","Radio"],breakpointCompatible:!1},{name:"value",flags:{isOptional:!0},type:"string",comment:null,availableValues:[],breakpointCompatible:!1}]}},pathContext:{componentPagePath:"/user-interface/components/form/image-selector",componentId:"components/form/image-selector"}}}});
//# sourceMappingURL=path---user-interface-components-form-image-selector-properties-8c4973808d26de088085.js.map