webpackJsonp([0xb0cdd3a7aac0],{908:function(n,a){n.exports={data:{page:{modifiedTime:"2018-04-03T23:09:30.000Z",fields:{title:"Grid",slug:"grid",path:"/user-interface/components/grid/grid",segments:[{title:"User Interface",slug:"user-interface"},{title:"Components",slug:"components"},{title:"Grid",slug:"grid"},{title:"Grid",slug:"grid"}]},childMarkdownRemark:{html:'<h2 id="basic-usage"><a href="#basic-usage" aria-hidden="true" class="anchor"><svg aria-hidden="true" height="16" version="1.1" viewBox="0 0 16 16" width="16"><path fill-rule="evenodd" d="M4 9h1v1H4c-1.5 0-3-1.69-3-3.5S2.55 3 4 3h4c1.45 0 3 1.69 3 3.5 0 1.41-.91 2.72-2 3.25V8.59c.58-.45 1-1.27 1-2.09C10 5.22 8.98 4 8 4H4c-.98 0-2 1.22-2 2.5S3 9 4 9zm9-3h-1v1h1c1 0 2 1.22 2 2.5S13.98 12 13 12H9c-.98 0-2-1.22-2-2.5 0-.83.42-1.64 1-2.09V6.25c-1.09.53-2 1.84-2 3.25C6 11.31 7.55 13 9 13h4c1.45 0 3-1.69 3-3.5S14.5 6 13 6z"></path></svg></a>Basic Usage</h2>\n<h3 id="basic"><a href="#basic" aria-hidden="true" class="anchor"><svg aria-hidden="true" height="16" version="1.1" viewBox="0 0 16 16" width="16"><path fill-rule="evenodd" d="M4 9h1v1H4c-1.5 0-3-1.69-3-3.5S2.55 3 4 3h4c1.45 0 3 1.69 3 3.5 0 1.41-.91 2.72-2 3.25V8.59c.58-.45 1-1.27 1-2.09C10 5.22 8.98 4 8 4H4c-.98 0-2 1.22-2 2.5S3 9 4 9zm9-3h-1v1h1c1 0 2 1.22 2 2.5S13.98 12 13 12H9c-.98 0-2-1.22-2-2.5 0-.83.42-1.64 1-2.09V6.25c-1.09.53-2 1.84-2 3.25C6 11.31 7.55 13 9 13h4c1.45 0 3-1.69 3-3.5S14.5 6 13 6z"></path></svg></a>Basic</h3>\n<div class="gatsby-highlight">\n      <pre class="language-jsx"><code><span class="token tag"><span class="token tag"><span class="token punctuation">&lt;</span>Grid</span><span class="token punctuation">></span></span>\n  <span class="token tag"><span class="token tag"><span class="token punctuation">&lt;</span>Column</span> <span class="token attr-name">cols</span><span class="token script language-javascript"><span class="token punctuation">=</span><span class="token punctuation">{</span><span class="token number">4</span><span class="token punctuation">}</span></span><span class="token punctuation">></span></span>\n    <span class="token tag"><span class="token tag"><span class="token punctuation">&lt;</span>StyledLayout</span> <span class="token attr-name">background</span><span class="token script language-javascript"><span class="token punctuation">=</span><span class="token punctuation">{</span>Background<span class="token punctuation">.</span>Accent<span class="token punctuation">}</span></span> <span class="token attr-name">padding</span><span class="token script language-javascript"><span class="token punctuation">=</span><span class="token punctuation">{</span><span class="token number">2</span><span class="token punctuation">}</span></span> <span class="token punctuation">/></span></span>\n  <span class="token tag"><span class="token tag"><span class="token punctuation">&lt;/</span>Column</span><span class="token punctuation">></span></span>\n  <span class="token tag"><span class="token tag"><span class="token punctuation">&lt;</span>Column</span> <span class="token attr-name">cols</span><span class="token script language-javascript"><span class="token punctuation">=</span><span class="token punctuation">{</span><span class="token number">8</span><span class="token punctuation">}</span></span><span class="token punctuation">></span></span>\n    <span class="token tag"><span class="token tag"><span class="token punctuation">&lt;</span>StyledLayout</span> <span class="token attr-name">background</span><span class="token script language-javascript"><span class="token punctuation">=</span><span class="token punctuation">{</span>Background<span class="token punctuation">.</span>Accent<span class="token punctuation">}</span></span> <span class="token attr-name">padding</span><span class="token script language-javascript"><span class="token punctuation">=</span><span class="token punctuation">{</span><span class="token number">2</span><span class="token punctuation">}</span></span> <span class="token punctuation">/></span></span>\n  <span class="token tag"><span class="token tag"><span class="token punctuation">&lt;/</span>Column</span><span class="token punctuation">></span></span>\n<span class="token tag"><span class="token tag"><span class="token punctuation">&lt;/</span>Grid</span><span class="token punctuation">></span></span>\n</code></pre>\n      </div>\n<h3 id="nested"><a href="#nested" aria-hidden="true" class="anchor"><svg aria-hidden="true" height="16" version="1.1" viewBox="0 0 16 16" width="16"><path fill-rule="evenodd" d="M4 9h1v1H4c-1.5 0-3-1.69-3-3.5S2.55 3 4 3h4c1.45 0 3 1.69 3 3.5 0 1.41-.91 2.72-2 3.25V8.59c.58-.45 1-1.27 1-2.09C10 5.22 8.98 4 8 4H4c-.98 0-2 1.22-2 2.5S3 9 4 9zm9-3h-1v1h1c1 0 2 1.22 2 2.5S13.98 12 13 12H9c-.98 0-2-1.22-2-2.5 0-.83.42-1.64 1-2.09V6.25c-1.09.53-2 1.84-2 3.25C6 11.31 7.55 13 9 13h4c1.45 0 3-1.69 3-3.5S14.5 6 13 6z"></path></svg></a>Nested</h3>\n<div class="gatsby-highlight">\n      <pre class="language-jsx"><code><span class="token tag"><span class="token tag"><span class="token punctuation">&lt;</span>Grid</span><span class="token punctuation">></span></span>\n  <span class="token tag"><span class="token tag"><span class="token punctuation">&lt;</span>Column</span> <span class="token attr-name">cols</span><span class="token script language-javascript"><span class="token punctuation">=</span><span class="token punctuation">{</span><span class="token number">3</span><span class="token punctuation">}</span></span><span class="token punctuation">></span></span>\n    <span class="token tag"><span class="token tag"><span class="token punctuation">&lt;</span>StyledLayout</span> <span class="token attr-name">background</span><span class="token script language-javascript"><span class="token punctuation">=</span><span class="token punctuation">{</span>Background<span class="token punctuation">.</span>Accent<span class="token punctuation">}</span></span> <span class="token attr-name">padding</span><span class="token script language-javascript"><span class="token punctuation">=</span><span class="token punctuation">{</span><span class="token number">2</span><span class="token punctuation">}</span></span> <span class="token attr-name">margin</span><span class="token script language-javascript"><span class="token punctuation">=</span><span class="token punctuation">{</span><span class="token punctuation">{</span> bottom<span class="token punctuation">:</span> <span class="token number">1</span> <span class="token punctuation">}</span><span class="token punctuation">}</span></span> <span class="token punctuation">/></span></span>\n    <span class="token tag"><span class="token tag"><span class="token punctuation">&lt;</span>Grid</span><span class="token punctuation">></span></span>\n      <span class="token tag"><span class="token tag"><span class="token punctuation">&lt;</span>Column</span> <span class="token attr-name">cols</span><span class="token script language-javascript"><span class="token punctuation">=</span><span class="token punctuation">{</span><span class="token number">6</span><span class="token punctuation">}</span></span><span class="token punctuation">></span></span>\n        <span class="token tag"><span class="token tag"><span class="token punctuation">&lt;</span>StyledLayout</span> <span class="token attr-name">background</span><span class="token script language-javascript"><span class="token punctuation">=</span><span class="token punctuation">{</span>Background<span class="token punctuation">.</span>Accent<span class="token punctuation">}</span></span> <span class="token attr-name">padding</span><span class="token script language-javascript"><span class="token punctuation">=</span><span class="token punctuation">{</span><span class="token number">2</span><span class="token punctuation">}</span></span> <span class="token punctuation">/></span></span>\n      <span class="token tag"><span class="token tag"><span class="token punctuation">&lt;/</span>Column</span><span class="token punctuation">></span></span>\n      <span class="token tag"><span class="token tag"><span class="token punctuation">&lt;</span>Column</span> <span class="token attr-name">cols</span><span class="token script language-javascript"><span class="token punctuation">=</span><span class="token punctuation">{</span><span class="token number">6</span><span class="token punctuation">}</span></span><span class="token punctuation">></span></span>\n        <span class="token tag"><span class="token tag"><span class="token punctuation">&lt;</span>StyledLayout</span> <span class="token attr-name">background</span><span class="token script language-javascript"><span class="token punctuation">=</span><span class="token punctuation">{</span>Background<span class="token punctuation">.</span>Accent<span class="token punctuation">}</span></span> <span class="token attr-name">padding</span><span class="token script language-javascript"><span class="token punctuation">=</span><span class="token punctuation">{</span><span class="token number">2</span><span class="token punctuation">}</span></span> <span class="token punctuation">/></span></span>\n      <span class="token tag"><span class="token tag"><span class="token punctuation">&lt;/</span>Column</span><span class="token punctuation">></span></span>\n    <span class="token tag"><span class="token tag"><span class="token punctuation">&lt;/</span>Grid</span><span class="token punctuation">></span></span>\n  <span class="token tag"><span class="token tag"><span class="token punctuation">&lt;/</span>Column</span><span class="token punctuation">></span></span>\n  <span class="token tag"><span class="token tag"><span class="token punctuation">&lt;</span>Column</span> <span class="token attr-name">cols</span><span class="token script language-javascript"><span class="token punctuation">=</span><span class="token punctuation">{</span><span class="token number">9</span><span class="token punctuation">}</span></span><span class="token punctuation">></span></span>\n    <span class="token tag"><span class="token tag"><span class="token punctuation">&lt;</span>StyledLayout</span> <span class="token attr-name">background</span><span class="token script language-javascript"><span class="token punctuation">=</span><span class="token punctuation">{</span>Background<span class="token punctuation">.</span>Accent<span class="token punctuation">}</span></span> <span class="token attr-name">padding</span><span class="token script language-javascript"><span class="token punctuation">=</span><span class="token punctuation">{</span><span class="token number">2</span><span class="token punctuation">}</span></span> <span class="token attr-name">margin</span><span class="token script language-javascript"><span class="token punctuation">=</span><span class="token punctuation">{</span><span class="token punctuation">{</span> bottom<span class="token punctuation">:</span> <span class="token number">1</span> <span class="token punctuation">}</span><span class="token punctuation">}</span></span> <span class="token punctuation">/></span></span>\n    <span class="token tag"><span class="token tag"><span class="token punctuation">&lt;</span>Grid</span><span class="token punctuation">></span></span>\n      <span class="token tag"><span class="token tag"><span class="token punctuation">&lt;</span>Column</span> <span class="token attr-name">cols</span><span class="token script language-javascript"><span class="token punctuation">=</span><span class="token punctuation">{</span><span class="token number">6</span><span class="token punctuation">}</span></span><span class="token punctuation">></span></span>\n        <span class="token tag"><span class="token tag"><span class="token punctuation">&lt;</span>StyledLayout</span> <span class="token attr-name">background</span><span class="token script language-javascript"><span class="token punctuation">=</span><span class="token punctuation">{</span>Background<span class="token punctuation">.</span>Accent<span class="token punctuation">}</span></span> <span class="token attr-name">padding</span><span class="token script language-javascript"><span class="token punctuation">=</span><span class="token punctuation">{</span><span class="token number">2</span><span class="token punctuation">}</span></span> <span class="token punctuation">/></span></span>\n      <span class="token tag"><span class="token tag"><span class="token punctuation">&lt;/</span>Column</span><span class="token punctuation">></span></span>\n      <span class="token tag"><span class="token tag"><span class="token punctuation">&lt;</span>Column</span> <span class="token attr-name">cols</span><span class="token script language-javascript"><span class="token punctuation">=</span><span class="token punctuation">{</span><span class="token number">6</span><span class="token punctuation">}</span></span><span class="token punctuation">></span></span>\n        <span class="token tag"><span class="token tag"><span class="token punctuation">&lt;</span>StyledLayout</span> <span class="token attr-name">background</span><span class="token script language-javascript"><span class="token punctuation">=</span><span class="token punctuation">{</span>Background<span class="token punctuation">.</span>Accent<span class="token punctuation">}</span></span> <span class="token attr-name">padding</span><span class="token script language-javascript"><span class="token punctuation">=</span><span class="token punctuation">{</span><span class="token number">2</span><span class="token punctuation">}</span></span> <span class="token punctuation">/></span></span>\n      <span class="token tag"><span class="token tag"><span class="token punctuation">&lt;/</span>Column</span><span class="token punctuation">></span></span>\n    <span class="token tag"><span class="token tag"><span class="token punctuation">&lt;/</span>Grid</span><span class="token punctuation">></span></span>\n  <span class="token tag"><span class="token tag"><span class="token punctuation">&lt;/</span>Column</span><span class="token punctuation">></span></span>\n<span class="token tag"><span class="token tag"><span class="token punctuation">&lt;/</span>Grid</span><span class="token punctuation">></span></span>\n</code></pre>\n      </div>\n<h2 id="example-responsive-equal-sized-columns"><a href="#example-responsive-equal-sized-columns" aria-hidden="true" class="anchor"><svg aria-hidden="true" height="16" version="1.1" viewBox="0 0 16 16" width="16"><path fill-rule="evenodd" d="M4 9h1v1H4c-1.5 0-3-1.69-3-3.5S2.55 3 4 3h4c1.45 0 3 1.69 3 3.5 0 1.41-.91 2.72-2 3.25V8.59c.58-.45 1-1.27 1-2.09C10 5.22 8.98 4 8 4H4c-.98 0-2 1.22-2 2.5S3 9 4 9zm9-3h-1v1h1c1 0 2 1.22 2 2.5S13.98 12 13 12H9c-.98 0-2-1.22-2-2.5 0-.83.42-1.64 1-2.09V6.25c-1.09.53-2 1.84-2 3.25C6 11.31 7.55 13 9 13h4c1.45 0 3-1.69 3-3.5S14.5 6 13 6z"></path></svg></a>Example: Responsive, equal sized columns</h2>\n<p>Column size can change based on responsive breakpoints. Example with equal columns:</p>\n<a href="https://s3-us-west-2.amazonaws.com/web-design-int-production/assets/ui/videos/2018-03-09_15-46-38.mp4" target="_blank">\n  <video src="https://s3-us-west-2.amazonaws.com/web-design-int-production/assets/ui/videos/2018-03-09_15-46-38.mp4" autoplay="true" muted="true" loop="true" width="100%" />\n</a>\n<p>Code shown below for the video above (resize your browser to see the live demo below re-arrange):</p>\n<div class="gatsby-highlight">\n      <pre class="language-jsx"><code><span class="token tag"><span class="token tag"><span class="token punctuation">&lt;</span>Grid</span><span class="token punctuation">></span></span>\n  <span class="token tag"><span class="token tag"><span class="token punctuation">&lt;</span>Column</span> <span class="token attr-name">cols</span><span class="token script language-javascript"><span class="token punctuation">=</span><span class="token punctuation">{</span><span class="token punctuation">{</span> <span class="token keyword">default</span><span class="token punctuation">:</span> <span class="token number">12</span><span class="token punctuation">,</span> sm<span class="token punctuation">:</span> <span class="token number">6</span><span class="token punctuation">,</span> md<span class="token punctuation">:</span> <span class="token number">4</span><span class="token punctuation">,</span> lg<span class="token punctuation">:</span> <span class="token number">2</span> <span class="token punctuation">}</span><span class="token punctuation">}</span></span><span class="token punctuation">></span></span>\n    <span class="token tag"><span class="token tag"><span class="token punctuation">&lt;</span>StyledLayout</span> <span class="token attr-name">background</span><span class="token script language-javascript"><span class="token punctuation">=</span><span class="token punctuation">{</span>Background<span class="token punctuation">.</span>Accent<span class="token punctuation">}</span></span> <span class="token attr-name">color</span><span class="token script language-javascript"><span class="token punctuation">=</span><span class="token punctuation">{</span>Color<span class="token punctuation">.</span>Overlay<span class="token punctuation">}</span></span> <span class="token attr-name">padding</span><span class="token script language-javascript"><span class="token punctuation">=</span><span class="token punctuation">{</span><span class="token number">2</span><span class="token punctuation">}</span></span> <span class="token attr-name">margin</span><span class="token script language-javascript"><span class="token punctuation">=</span><span class="token punctuation">{</span><span class="token punctuation">{</span> bottom<span class="token punctuation">:</span> <span class="token number">1</span> <span class="token punctuation">}</span><span class="token punctuation">}</span></span> <span class="token attr-name">display</span><span class="token script language-javascript"><span class="token punctuation">=</span><span class="token punctuation">{</span>Display<span class="token punctuation">.</span>Flex<span class="token punctuation">}</span></span> <span class="token attr-name">justifyContent</span><span class="token script language-javascript"><span class="token punctuation">=</span><span class="token punctuation">{</span>JustifyContent<span class="token punctuation">.</span>Center<span class="token punctuation">}</span></span> <span class="token attr-name">alignItems</span><span class="token script language-javascript"><span class="token punctuation">=</span><span class="token punctuation">{</span>AlignItems<span class="token punctuation">.</span>Center<span class="token punctuation">}</span></span><span class="token punctuation">></span></span>\n      <span class="token tag"><span class="token tag"><span class="token punctuation">&lt;</span>CoreText</span> <span class="token attr-name">fontSize</span><span class="token script language-javascript"><span class="token punctuation">=</span><span class="token punctuation">{</span>FontSize<span class="token punctuation">.</span>Size2<span class="token punctuation">}</span></span><span class="token punctuation">></span></span>A<span class="token tag"><span class="token tag"><span class="token punctuation">&lt;/</span>CoreText</span><span class="token punctuation">></span></span>\n    <span class="token tag"><span class="token tag"><span class="token punctuation">&lt;/</span>StyledLayout</span><span class="token punctuation">></span></span>\n  <span class="token tag"><span class="token tag"><span class="token punctuation">&lt;/</span>Column</span><span class="token punctuation">></span></span>\n  <span class="token tag"><span class="token tag"><span class="token punctuation">&lt;</span>Column</span> <span class="token attr-name">cols</span><span class="token script language-javascript"><span class="token punctuation">=</span><span class="token punctuation">{</span><span class="token punctuation">{</span> <span class="token keyword">default</span><span class="token punctuation">:</span> <span class="token number">12</span><span class="token punctuation">,</span> sm<span class="token punctuation">:</span> <span class="token number">6</span><span class="token punctuation">,</span> md<span class="token punctuation">:</span> <span class="token number">4</span><span class="token punctuation">,</span> lg<span class="token punctuation">:</span> <span class="token number">2</span> <span class="token punctuation">}</span><span class="token punctuation">}</span></span><span class="token punctuation">></span></span>\n    <span class="token tag"><span class="token tag"><span class="token punctuation">&lt;</span>StyledLayout</span> <span class="token attr-name">background</span><span class="token script language-javascript"><span class="token punctuation">=</span><span class="token punctuation">{</span>Background<span class="token punctuation">.</span>Accent<span class="token punctuation">}</span></span> <span class="token attr-name">color</span><span class="token script language-javascript"><span class="token punctuation">=</span><span class="token punctuation">{</span>Color<span class="token punctuation">.</span>Overlay<span class="token punctuation">}</span></span> <span class="token attr-name">padding</span><span class="token script language-javascript"><span class="token punctuation">=</span><span class="token punctuation">{</span><span class="token number">2</span><span class="token punctuation">}</span></span> <span class="token attr-name">margin</span><span class="token script language-javascript"><span class="token punctuation">=</span><span class="token punctuation">{</span><span class="token punctuation">{</span> bottom<span class="token punctuation">:</span> <span class="token number">1</span> <span class="token punctuation">}</span><span class="token punctuation">}</span></span> <span class="token attr-name">display</span><span class="token script language-javascript"><span class="token punctuation">=</span><span class="token punctuation">{</span>Display<span class="token punctuation">.</span>Flex<span class="token punctuation">}</span></span> <span class="token attr-name">justifyContent</span><span class="token script language-javascript"><span class="token punctuation">=</span><span class="token punctuation">{</span>JustifyContent<span class="token punctuation">.</span>Center<span class="token punctuation">}</span></span> <span class="token attr-name">alignItems</span><span class="token script language-javascript"><span class="token punctuation">=</span><span class="token punctuation">{</span>AlignItems<span class="token punctuation">.</span>Center<span class="token punctuation">}</span></span><span class="token punctuation">></span></span>\n      <span class="token tag"><span class="token tag"><span class="token punctuation">&lt;</span>CoreText</span> <span class="token attr-name">fontSize</span><span class="token script language-javascript"><span class="token punctuation">=</span><span class="token punctuation">{</span>FontSize<span class="token punctuation">.</span>Size2<span class="token punctuation">}</span></span><span class="token punctuation">></span></span>B<span class="token tag"><span class="token tag"><span class="token punctuation">&lt;/</span>CoreText</span><span class="token punctuation">></span></span>\n    <span class="token tag"><span class="token tag"><span class="token punctuation">&lt;/</span>StyledLayout</span><span class="token punctuation">></span></span>\n  <span class="token tag"><span class="token tag"><span class="token punctuation">&lt;/</span>Column</span><span class="token punctuation">></span></span>\n  <span class="token tag"><span class="token tag"><span class="token punctuation">&lt;</span>Column</span> <span class="token attr-name">cols</span><span class="token script language-javascript"><span class="token punctuation">=</span><span class="token punctuation">{</span><span class="token punctuation">{</span> <span class="token keyword">default</span><span class="token punctuation">:</span> <span class="token number">12</span><span class="token punctuation">,</span> sm<span class="token punctuation">:</span> <span class="token number">6</span><span class="token punctuation">,</span> md<span class="token punctuation">:</span> <span class="token number">4</span><span class="token punctuation">,</span> lg<span class="token punctuation">:</span> <span class="token number">2</span> <span class="token punctuation">}</span><span class="token punctuation">}</span></span><span class="token punctuation">></span></span>\n    <span class="token tag"><span class="token tag"><span class="token punctuation">&lt;</span>StyledLayout</span> <span class="token attr-name">background</span><span class="token script language-javascript"><span class="token punctuation">=</span><span class="token punctuation">{</span>Background<span class="token punctuation">.</span>Accent<span class="token punctuation">}</span></span> <span class="token attr-name">color</span><span class="token script language-javascript"><span class="token punctuation">=</span><span class="token punctuation">{</span>Color<span class="token punctuation">.</span>Overlay<span class="token punctuation">}</span></span> <span class="token attr-name">padding</span><span class="token script language-javascript"><span class="token punctuation">=</span><span class="token punctuation">{</span><span class="token number">2</span><span class="token punctuation">}</span></span> <span class="token attr-name">margin</span><span class="token script language-javascript"><span class="token punctuation">=</span><span class="token punctuation">{</span><span class="token punctuation">{</span> bottom<span class="token punctuation">:</span> <span class="token number">1</span> <span class="token punctuation">}</span><span class="token punctuation">}</span></span> <span class="token attr-name">display</span><span class="token script language-javascript"><span class="token punctuation">=</span><span class="token punctuation">{</span>Display<span class="token punctuation">.</span>Flex<span class="token punctuation">}</span></span> <span class="token attr-name">justifyContent</span><span class="token script language-javascript"><span class="token punctuation">=</span><span class="token punctuation">{</span>JustifyContent<span class="token punctuation">.</span>Center<span class="token punctuation">}</span></span> <span class="token attr-name">alignItems</span><span class="token script language-javascript"><span class="token punctuation">=</span><span class="token punctuation">{</span>AlignItems<span class="token punctuation">.</span>Center<span class="token punctuation">}</span></span><span class="token punctuation">></span></span>\n      <span class="token tag"><span class="token tag"><span class="token punctuation">&lt;</span>CoreText</span> <span class="token attr-name">fontSize</span><span class="token script language-javascript"><span class="token punctuation">=</span><span class="token punctuation">{</span>FontSize<span class="token punctuation">.</span>Size2<span class="token punctuation">}</span></span><span class="token punctuation">></span></span>C<span class="token tag"><span class="token tag"><span class="token punctuation">&lt;/</span>CoreText</span><span class="token punctuation">></span></span>\n    <span class="token tag"><span class="token tag"><span class="token punctuation">&lt;/</span>StyledLayout</span><span class="token punctuation">></span></span>\n  <span class="token tag"><span class="token tag"><span class="token punctuation">&lt;/</span>Column</span><span class="token punctuation">></span></span>\n  <span class="token tag"><span class="token tag"><span class="token punctuation">&lt;</span>Column</span> <span class="token attr-name">cols</span><span class="token script language-javascript"><span class="token punctuation">=</span><span class="token punctuation">{</span><span class="token punctuation">{</span> <span class="token keyword">default</span><span class="token punctuation">:</span> <span class="token number">12</span><span class="token punctuation">,</span> sm<span class="token punctuation">:</span> <span class="token number">6</span><span class="token punctuation">,</span> md<span class="token punctuation">:</span> <span class="token number">4</span><span class="token punctuation">,</span> lg<span class="token punctuation">:</span> <span class="token number">2</span> <span class="token punctuation">}</span><span class="token punctuation">}</span></span><span class="token punctuation">></span></span>\n    <span class="token tag"><span class="token tag"><span class="token punctuation">&lt;</span>StyledLayout</span> <span class="token attr-name">background</span><span class="token script language-javascript"><span class="token punctuation">=</span><span class="token punctuation">{</span>Background<span class="token punctuation">.</span>Accent<span class="token punctuation">}</span></span> <span class="token attr-name">color</span><span class="token script language-javascript"><span class="token punctuation">=</span><span class="token punctuation">{</span>Color<span class="token punctuation">.</span>Overlay<span class="token punctuation">}</span></span> <span class="token attr-name">padding</span><span class="token script language-javascript"><span class="token punctuation">=</span><span class="token punctuation">{</span><span class="token number">2</span><span class="token punctuation">}</span></span> <span class="token attr-name">margin</span><span class="token script language-javascript"><span class="token punctuation">=</span><span class="token punctuation">{</span><span class="token punctuation">{</span> bottom<span class="token punctuation">:</span> <span class="token number">1</span> <span class="token punctuation">}</span><span class="token punctuation">}</span></span> <span class="token attr-name">display</span><span class="token script language-javascript"><span class="token punctuation">=</span><span class="token punctuation">{</span>Display<span class="token punctuation">.</span>Flex<span class="token punctuation">}</span></span> <span class="token attr-name">justifyContent</span><span class="token script language-javascript"><span class="token punctuation">=</span><span class="token punctuation">{</span>JustifyContent<span class="token punctuation">.</span>Center<span class="token punctuation">}</span></span> <span class="token attr-name">alignItems</span><span class="token script language-javascript"><span class="token punctuation">=</span><span class="token punctuation">{</span>AlignItems<span class="token punctuation">.</span>Center<span class="token punctuation">}</span></span><span class="token punctuation">></span></span>\n      <span class="token tag"><span class="token tag"><span class="token punctuation">&lt;</span>CoreText</span> <span class="token attr-name">fontSize</span><span class="token script language-javascript"><span class="token punctuation">=</span><span class="token punctuation">{</span>FontSize<span class="token punctuation">.</span>Size2<span class="token punctuation">}</span></span><span class="token punctuation">></span></span>D<span class="token tag"><span class="token tag"><span class="token punctuation">&lt;/</span>CoreText</span><span class="token punctuation">></span></span>\n    <span class="token tag"><span class="token tag"><span class="token punctuation">&lt;/</span>StyledLayout</span><span class="token punctuation">></span></span>\n  <span class="token tag"><span class="token tag"><span class="token punctuation">&lt;/</span>Column</span><span class="token punctuation">></span></span>\n  <span class="token tag"><span class="token tag"><span class="token punctuation">&lt;</span>Column</span> <span class="token attr-name">cols</span><span class="token script language-javascript"><span class="token punctuation">=</span><span class="token punctuation">{</span><span class="token punctuation">{</span> <span class="token keyword">default</span><span class="token punctuation">:</span> <span class="token number">12</span><span class="token punctuation">,</span> sm<span class="token punctuation">:</span> <span class="token number">6</span><span class="token punctuation">,</span> md<span class="token punctuation">:</span> <span class="token number">4</span><span class="token punctuation">,</span> lg<span class="token punctuation">:</span> <span class="token number">2</span> <span class="token punctuation">}</span><span class="token punctuation">}</span></span><span class="token punctuation">></span></span>\n    <span class="token tag"><span class="token tag"><span class="token punctuation">&lt;</span>StyledLayout</span> <span class="token attr-name">background</span><span class="token script language-javascript"><span class="token punctuation">=</span><span class="token punctuation">{</span>Background<span class="token punctuation">.</span>Accent<span class="token punctuation">}</span></span> <span class="token attr-name">color</span><span class="token script language-javascript"><span class="token punctuation">=</span><span class="token punctuation">{</span>Color<span class="token punctuation">.</span>Overlay<span class="token punctuation">}</span></span> <span class="token attr-name">padding</span><span class="token script language-javascript"><span class="token punctuation">=</span><span class="token punctuation">{</span><span class="token number">2</span><span class="token punctuation">}</span></span> <span class="token attr-name">margin</span><span class="token script language-javascript"><span class="token punctuation">=</span><span class="token punctuation">{</span><span class="token punctuation">{</span> bottom<span class="token punctuation">:</span> <span class="token number">1</span> <span class="token punctuation">}</span><span class="token punctuation">}</span></span> <span class="token attr-name">display</span><span class="token script language-javascript"><span class="token punctuation">=</span><span class="token punctuation">{</span>Display<span class="token punctuation">.</span>Flex<span class="token punctuation">}</span></span> <span class="token attr-name">justifyContent</span><span class="token script language-javascript"><span class="token punctuation">=</span><span class="token punctuation">{</span>JustifyContent<span class="token punctuation">.</span>Center<span class="token punctuation">}</span></span> <span class="token attr-name">alignItems</span><span class="token script language-javascript"><span class="token punctuation">=</span><span class="token punctuation">{</span>AlignItems<span class="token punctuation">.</span>Center<span class="token punctuation">}</span></span><span class="token punctuation">></span></span>\n      <span class="token tag"><span class="token tag"><span class="token punctuation">&lt;</span>CoreText</span> <span class="token attr-name">fontSize</span><span class="token script language-javascript"><span class="token punctuation">=</span><span class="token punctuation">{</span>FontSize<span class="token punctuation">.</span>Size2<span class="token punctuation">}</span></span><span class="token punctuation">></span></span>E<span class="token tag"><span class="token tag"><span class="token punctuation">&lt;/</span>CoreText</span><span class="token punctuation">></span></span>\n    <span class="token tag"><span class="token tag"><span class="token punctuation">&lt;/</span>StyledLayout</span><span class="token punctuation">></span></span>\n  <span class="token tag"><span class="token tag"><span class="token punctuation">&lt;/</span>Column</span><span class="token punctuation">></span></span>\n  <span class="token tag"><span class="token tag"><span class="token punctuation">&lt;</span>Column</span> <span class="token attr-name">cols</span><span class="token script language-javascript"><span class="token punctuation">=</span><span class="token punctuation">{</span><span class="token punctuation">{</span> <span class="token keyword">default</span><span class="token punctuation">:</span> <span class="token number">12</span><span class="token punctuation">,</span> sm<span class="token punctuation">:</span> <span class="token number">6</span><span class="token punctuation">,</span> md<span class="token punctuation">:</span> <span class="token number">4</span><span class="token punctuation">,</span> lg<span class="token punctuation">:</span> <span class="token number">2</span> <span class="token punctuation">}</span><span class="token punctuation">}</span></span><span class="token punctuation">></span></span>\n    <span class="token tag"><span class="token tag"><span class="token punctuation">&lt;</span>StyledLayout</span> <span class="token attr-name">background</span><span class="token script language-javascript"><span class="token punctuation">=</span><span class="token punctuation">{</span>Background<span class="token punctuation">.</span>Accent<span class="token punctuation">}</span></span> <span class="token attr-name">color</span><span class="token script language-javascript"><span class="token punctuation">=</span><span class="token punctuation">{</span>Color<span class="token punctuation">.</span>Overlay<span class="token punctuation">}</span></span> <span class="token attr-name">padding</span><span class="token script language-javascript"><span class="token punctuation">=</span><span class="token punctuation">{</span><span class="token number">2</span><span class="token punctuation">}</span></span> <span class="token attr-name">margin</span><span class="token script language-javascript"><span class="token punctuation">=</span><span class="token punctuation">{</span><span class="token punctuation">{</span> bottom<span class="token punctuation">:</span> <span class="token number">1</span> <span class="token punctuation">}</span><span class="token punctuation">}</span></span> <span class="token attr-name">display</span><span class="token script language-javascript"><span class="token punctuation">=</span><span class="token punctuation">{</span>Display<span class="token punctuation">.</span>Flex<span class="token punctuation">}</span></span> <span class="token attr-name">justifyContent</span><span class="token script language-javascript"><span class="token punctuation">=</span><span class="token punctuation">{</span>JustifyContent<span class="token punctuation">.</span>Center<span class="token punctuation">}</span></span> <span class="token attr-name">alignItems</span><span class="token script language-javascript"><span class="token punctuation">=</span><span class="token punctuation">{</span>AlignItems<span class="token punctuation">.</span>Center<span class="token punctuation">}</span></span><span class="token punctuation">></span></span>\n      <span class="token tag"><span class="token tag"><span class="token punctuation">&lt;</span>CoreText</span> <span class="token attr-name">fontSize</span><span class="token script language-javascript"><span class="token punctuation">=</span><span class="token punctuation">{</span>FontSize<span class="token punctuation">.</span>Size2<span class="token punctuation">}</span></span><span class="token punctuation">></span></span>F<span class="token tag"><span class="token tag"><span class="token punctuation">&lt;/</span>CoreText</span><span class="token punctuation">></span></span>\n    <span class="token tag"><span class="token tag"><span class="token punctuation">&lt;/</span>StyledLayout</span><span class="token punctuation">></span></span>\n  <span class="token tag"><span class="token tag"><span class="token punctuation">&lt;/</span>Column</span><span class="token punctuation">></span></span>\n<span class="token tag"><span class="token tag"><span class="token punctuation">&lt;/</span>Grid</span><span class="token punctuation">></span></span>\n</code></pre>\n      </div>\n<h2 id="example-responsive-column-layout"><a href="#example-responsive-column-layout" aria-hidden="true" class="anchor"><svg aria-hidden="true" height="16" version="1.1" viewBox="0 0 16 16" width="16"><path fill-rule="evenodd" d="M4 9h1v1H4c-1.5 0-3-1.69-3-3.5S2.55 3 4 3h4c1.45 0 3 1.69 3 3.5 0 1.41-.91 2.72-2 3.25V8.59c.58-.45 1-1.27 1-2.09C10 5.22 8.98 4 8 4H4c-.98 0-2 1.22-2 2.5S3 9 4 9zm9-3h-1v1h1c1 0 2 1.22 2 2.5S13.98 12 13 12H9c-.98 0-2-1.22-2-2.5 0-.83.42-1.64 1-2.09V6.25c-1.09.53-2 1.84-2 3.25C6 11.31 7.55 13 9 13h4c1.45 0 3-1.69 3-3.5S14.5 6 13 6z"></path></svg></a>Example: Responsive column layout</h2>\n<p>An example with different sized regions at different viewport sizes:</p>\n<a href="https://s3-us-west-2.amazonaws.com/web-design-int-production/assets/ui/videos/2018-03-15_14-18-27.mp4" target="_blank">\n  <video src="https://s3-us-west-2.amazonaws.com/web-design-int-production/assets/ui/videos/2018-03-15_14-18-27.mp4" autoplay="true" muted="true" loop="true" width="100%" />\n</a>\n<p>Code shown below for the video above (resize your browser to see the live demo below re-arrange):</p>\n<div class="gatsby-highlight">\n      <pre class="language-jsx"><code><span class="token tag"><span class="token tag"><span class="token punctuation">&lt;</span>Grid</span><span class="token punctuation">></span></span>\n  <span class="token tag"><span class="token tag"><span class="token punctuation">&lt;</span>Column</span> <span class="token attr-name">cols</span><span class="token script language-javascript"><span class="token punctuation">=</span><span class="token punctuation">{</span><span class="token punctuation">{</span> <span class="token keyword">default</span><span class="token punctuation">:</span> <span class="token number">12</span><span class="token punctuation">,</span> xs<span class="token punctuation">:</span> <span class="token number">6</span><span class="token punctuation">,</span> md<span class="token punctuation">:</span> <span class="token number">4</span> <span class="token punctuation">}</span><span class="token punctuation">}</span></span><span class="token punctuation">></span></span>\n    <span class="token tag"><span class="token tag"><span class="token punctuation">&lt;</span>StyledLayout</span> <span class="token attr-name">background</span><span class="token script language-javascript"><span class="token punctuation">=</span><span class="token punctuation">{</span>Background<span class="token punctuation">.</span>Accent<span class="token punctuation">}</span></span> <span class="token attr-name">color</span><span class="token script language-javascript"><span class="token punctuation">=</span><span class="token punctuation">{</span>Color<span class="token punctuation">.</span>Overlay<span class="token punctuation">}</span></span> <span class="token attr-name">padding</span><span class="token script language-javascript"><span class="token punctuation">=</span><span class="token punctuation">{</span><span class="token number">2</span><span class="token punctuation">}</span></span> <span class="token attr-name">margin</span><span class="token script language-javascript"><span class="token punctuation">=</span><span class="token punctuation">{</span><span class="token punctuation">{</span> bottom<span class="token punctuation">:</span> <span class="token number">1</span> <span class="token punctuation">}</span><span class="token punctuation">}</span></span> <span class="token attr-name">display</span><span class="token script language-javascript"><span class="token punctuation">=</span><span class="token punctuation">{</span>Display<span class="token punctuation">.</span>Flex<span class="token punctuation">}</span></span> <span class="token attr-name">justifyContent</span><span class="token script language-javascript"><span class="token punctuation">=</span><span class="token punctuation">{</span>JustifyContent<span class="token punctuation">.</span>Center<span class="token punctuation">}</span></span> <span class="token attr-name">alignItems</span><span class="token script language-javascript"><span class="token punctuation">=</span><span class="token punctuation">{</span>AlignItems<span class="token punctuation">.</span>Center<span class="token punctuation">}</span></span><span class="token punctuation">></span></span>\n      <span class="token tag"><span class="token tag"><span class="token punctuation">&lt;</span>CoreText</span> <span class="token attr-name">fontSize</span><span class="token script language-javascript"><span class="token punctuation">=</span><span class="token punctuation">{</span>FontSize<span class="token punctuation">.</span>Size2<span class="token punctuation">}</span></span><span class="token punctuation">></span></span>A<span class="token tag"><span class="token tag"><span class="token punctuation">&lt;/</span>CoreText</span><span class="token punctuation">></span></span>\n    <span class="token tag"><span class="token tag"><span class="token punctuation">&lt;/</span>StyledLayout</span><span class="token punctuation">></span></span>\n  <span class="token tag"><span class="token tag"><span class="token punctuation">&lt;/</span>Column</span><span class="token punctuation">></span></span>\n  <span class="token tag"><span class="token tag"><span class="token punctuation">&lt;</span>Column</span> <span class="token attr-name">cols</span><span class="token script language-javascript"><span class="token punctuation">=</span><span class="token punctuation">{</span><span class="token punctuation">{</span> <span class="token keyword">default</span><span class="token punctuation">:</span> <span class="token number">12</span><span class="token punctuation">,</span> xs<span class="token punctuation">:</span> <span class="token number">6</span><span class="token punctuation">,</span> md<span class="token punctuation">:</span> <span class="token number">8</span> <span class="token punctuation">}</span><span class="token punctuation">}</span></span><span class="token punctuation">></span></span>\n    <span class="token tag"><span class="token tag"><span class="token punctuation">&lt;</span>StyledLayout</span> <span class="token attr-name">background</span><span class="token script language-javascript"><span class="token punctuation">=</span><span class="token punctuation">{</span>Background<span class="token punctuation">.</span>Accent<span class="token punctuation">}</span></span> <span class="token attr-name">color</span><span class="token script language-javascript"><span class="token punctuation">=</span><span class="token punctuation">{</span>Color<span class="token punctuation">.</span>Overlay<span class="token punctuation">}</span></span> <span class="token attr-name">padding</span><span class="token script language-javascript"><span class="token punctuation">=</span><span class="token punctuation">{</span><span class="token number">2</span><span class="token punctuation">}</span></span> <span class="token attr-name">margin</span><span class="token script language-javascript"><span class="token punctuation">=</span><span class="token punctuation">{</span><span class="token punctuation">{</span> bottom<span class="token punctuation">:</span> <span class="token number">1</span> <span class="token punctuation">}</span><span class="token punctuation">}</span></span> <span class="token attr-name">display</span><span class="token script language-javascript"><span class="token punctuation">=</span><span class="token punctuation">{</span>Display<span class="token punctuation">.</span>Flex<span class="token punctuation">}</span></span> <span class="token attr-name">justifyContent</span><span class="token script language-javascript"><span class="token punctuation">=</span><span class="token punctuation">{</span>JustifyContent<span class="token punctuation">.</span>Center<span class="token punctuation">}</span></span> <span class="token attr-name">alignItems</span><span class="token script language-javascript"><span class="token punctuation">=</span><span class="token punctuation">{</span>AlignItems<span class="token punctuation">.</span>Center<span class="token punctuation">}</span></span><span class="token punctuation">></span></span>\n      <span class="token tag"><span class="token tag"><span class="token punctuation">&lt;</span>CoreText</span> <span class="token attr-name">fontSize</span><span class="token script language-javascript"><span class="token punctuation">=</span><span class="token punctuation">{</span>FontSize<span class="token punctuation">.</span>Size2<span class="token punctuation">}</span></span><span class="token punctuation">></span></span>B<span class="token tag"><span class="token tag"><span class="token punctuation">&lt;/</span>CoreText</span><span class="token punctuation">></span></span>\n    <span class="token tag"><span class="token tag"><span class="token punctuation">&lt;/</span>StyledLayout</span><span class="token punctuation">></span></span>\n  <span class="token tag"><span class="token tag"><span class="token punctuation">&lt;/</span>Column</span><span class="token punctuation">></span></span>\n  <span class="token tag"><span class="token tag"><span class="token punctuation">&lt;</span>Column</span> <span class="token attr-name">cols</span><span class="token script language-javascript"><span class="token punctuation">=</span><span class="token punctuation">{</span><span class="token punctuation">{</span> <span class="token keyword">default</span><span class="token punctuation">:</span> <span class="token number">12</span><span class="token punctuation">,</span> xs<span class="token punctuation">:</span> <span class="token number">12</span><span class="token punctuation">,</span> md<span class="token punctuation">:</span> <span class="token number">8</span> <span class="token punctuation">}</span><span class="token punctuation">}</span></span> <span class="token attr-name">offset</span><span class="token script language-javascript"><span class="token punctuation">=</span><span class="token punctuation">{</span><span class="token punctuation">{</span> <span class="token keyword">default</span><span class="token punctuation">:</span> <span class="token number">0</span><span class="token punctuation">,</span> xs<span class="token punctuation">:</span> <span class="token number">0</span><span class="token punctuation">,</span> md<span class="token punctuation">:</span> <span class="token number">4</span> <span class="token punctuation">}</span><span class="token punctuation">}</span></span><span class="token punctuation">></span></span>\n    <span class="token tag"><span class="token tag"><span class="token punctuation">&lt;</span>StyledLayout</span> <span class="token attr-name">background</span><span class="token script language-javascript"><span class="token punctuation">=</span><span class="token punctuation">{</span>Background<span class="token punctuation">.</span>Accent<span class="token punctuation">}</span></span> <span class="token attr-name">color</span><span class="token script language-javascript"><span class="token punctuation">=</span><span class="token punctuation">{</span>Color<span class="token punctuation">.</span>Overlay<span class="token punctuation">}</span></span> <span class="token attr-name">padding</span><span class="token script language-javascript"><span class="token punctuation">=</span><span class="token punctuation">{</span><span class="token number">2</span><span class="token punctuation">}</span></span> <span class="token attr-name">margin</span><span class="token script language-javascript"><span class="token punctuation">=</span><span class="token punctuation">{</span><span class="token punctuation">{</span> bottom<span class="token punctuation">:</span> <span class="token number">1</span> <span class="token punctuation">}</span><span class="token punctuation">}</span></span> <span class="token attr-name">display</span><span class="token script language-javascript"><span class="token punctuation">=</span><span class="token punctuation">{</span>Display<span class="token punctuation">.</span>Flex<span class="token punctuation">}</span></span> <span class="token attr-name">justifyContent</span><span class="token script language-javascript"><span class="token punctuation">=</span><span class="token punctuation">{</span>JustifyContent<span class="token punctuation">.</span>Center<span class="token punctuation">}</span></span> <span class="token attr-name">alignItems</span><span class="token script language-javascript"><span class="token punctuation">=</span><span class="token punctuation">{</span>AlignItems<span class="token punctuation">.</span>Center<span class="token punctuation">}</span></span><span class="token punctuation">></span></span>\n      <span class="token tag"><span class="token tag"><span class="token punctuation">&lt;</span>CoreText</span> <span class="token attr-name">fontSize</span><span class="token script language-javascript"><span class="token punctuation">=</span><span class="token punctuation">{</span>FontSize<span class="token punctuation">.</span>Size4<span class="token punctuation">}</span></span><span class="token punctuation">></span></span>Lorem ipsum dolor sit amet<span class="token punctuation">,</span> consectetur adipiscing elit<span class="token punctuation">,</span> sed <span class="token keyword">do</span> eiusmod tempor incididunt ut labore et dolore magna aliqua<span class="token punctuation">.</span> Ut enim ad minim veniam<span class="token punctuation">,</span> quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat<span class="token punctuation">.</span> Duis aute irure dolor <span class="token keyword">in</span> reprehenderit <span class="token keyword">in</span> voluptate velit esse cillum dolore eu fugiat nulla pariatur<span class="token punctuation">.</span> Excepteur sint occaecat cupidatat non proident<span class="token punctuation">,</span> sunt <span class="token keyword">in</span> culpa qui officia deserunt mollit anim id est laborum<span class="token tag"><span class="token tag"><span class="token punctuation">&lt;/</span>CoreText</span><span class="token punctuation">></span></span>\n    <span class="token tag"><span class="token tag"><span class="token punctuation">&lt;/</span>StyledLayout</span><span class="token punctuation">></span></span>\n  <span class="token tag"><span class="token tag"><span class="token punctuation">&lt;/</span>Column</span><span class="token punctuation">></span></span>\n  <span class="token tag"><span class="token tag"><span class="token punctuation">&lt;</span>Column</span> <span class="token attr-name">cols</span><span class="token script language-javascript"><span class="token punctuation">=</span><span class="token punctuation">{</span><span class="token punctuation">{</span> <span class="token keyword">default</span><span class="token punctuation">:</span> <span class="token number">12</span> <span class="token punctuation">}</span><span class="token punctuation">}</span></span><span class="token punctuation">></span></span>\n    <span class="token tag"><span class="token tag"><span class="token punctuation">&lt;</span>StyledLayout</span> <span class="token attr-name">background</span><span class="token script language-javascript"><span class="token punctuation">=</span><span class="token punctuation">{</span>Background<span class="token punctuation">.</span>Accent<span class="token punctuation">}</span></span> <span class="token attr-name">color</span><span class="token script language-javascript"><span class="token punctuation">=</span><span class="token punctuation">{</span>Color<span class="token punctuation">.</span>Overlay<span class="token punctuation">}</span></span> <span class="token attr-name">padding</span><span class="token script language-javascript"><span class="token punctuation">=</span><span class="token punctuation">{</span><span class="token number">2</span><span class="token punctuation">}</span></span> <span class="token attr-name">margin</span><span class="token script language-javascript"><span class="token punctuation">=</span><span class="token punctuation">{</span><span class="token punctuation">{</span> bottom<span class="token punctuation">:</span> <span class="token number">1</span> <span class="token punctuation">}</span><span class="token punctuation">}</span></span> <span class="token attr-name">display</span><span class="token script language-javascript"><span class="token punctuation">=</span><span class="token punctuation">{</span>Display<span class="token punctuation">.</span>Flex<span class="token punctuation">}</span></span> <span class="token attr-name">justifyContent</span><span class="token script language-javascript"><span class="token punctuation">=</span><span class="token punctuation">{</span>JustifyContent<span class="token punctuation">.</span>Center<span class="token punctuation">}</span></span> <span class="token attr-name">alignItems</span><span class="token script language-javascript"><span class="token punctuation">=</span><span class="token punctuation">{</span>AlignItems<span class="token punctuation">.</span>Center<span class="token punctuation">}</span></span><span class="token punctuation">></span></span>\n      <span class="token tag"><span class="token tag"><span class="token punctuation">&lt;</span>CoreText</span> <span class="token attr-name">fontSize</span><span class="token script language-javascript"><span class="token punctuation">=</span><span class="token punctuation">{</span>FontSize<span class="token punctuation">.</span>Size2<span class="token punctuation">}</span></span><span class="token punctuation">></span></span>D<span class="token tag"><span class="token tag"><span class="token punctuation">&lt;/</span>CoreText</span><span class="token punctuation">></span></span>\n    <span class="token tag"><span class="token tag"><span class="token punctuation">&lt;/</span>StyledLayout</span><span class="token punctuation">></span></span>\n  <span class="token tag"><span class="token tag"><span class="token punctuation">&lt;/</span>Column</span><span class="token punctuation">></span></span>\n<span class="token tag"><span class="token tag"><span class="token punctuation">&lt;/</span>Grid</span><span class="token punctuation">></span></span>\n</code></pre>\n      </div>\n<h2 id="example-grid--flexbox-for-vertical-centering"><a href="#example-grid--flexbox-for-vertical-centering" aria-hidden="true" class="anchor"><svg aria-hidden="true" height="16" version="1.1" viewBox="0 0 16 16" width="16"><path fill-rule="evenodd" d="M4 9h1v1H4c-1.5 0-3-1.69-3-3.5S2.55 3 4 3h4c1.45 0 3 1.69 3 3.5 0 1.41-.91 2.72-2 3.25V8.59c.58-.45 1-1.27 1-2.09C10 5.22 8.98 4 8 4H4c-.98 0-2 1.22-2 2.5S3 9 4 9zm9-3h-1v1h1c1 0 2 1.22 2 2.5S13.98 12 13 12H9c-.98 0-2-1.22-2-2.5 0-.83.42-1.64 1-2.09V6.25c-1.09.53-2 1.84-2 3.25C6 11.31 7.55 13 9 13h4c1.45 0 3-1.69 3-3.5S14.5 6 13 6z"></path></svg></a>Example: Grid + Flexbox for vertical centering</h2>\n<div class="gatsby-highlight">\n      <pre class="language-jsx"><code><span class="token tag"><span class="token tag"><span class="token punctuation">&lt;</span>Grid</span><span class="token punctuation">></span></span>\n\n  <span class="token tag"><span class="token tag"><span class="token punctuation">&lt;</span>Column</span> <span class="token attr-name">cols</span><span class="token script language-javascript"><span class="token punctuation">=</span><span class="token punctuation">{</span><span class="token number">6</span><span class="token punctuation">}</span></span><span class="token punctuation">></span></span>\n    <span class="token tag"><span class="token tag"><span class="token punctuation">&lt;</span>StyledLayout</span>\n      <span class="token attr-name">background</span><span class="token script language-javascript"><span class="token punctuation">=</span><span class="token punctuation">{</span>Background<span class="token punctuation">.</span>AccentAlt2<span class="token punctuation">}</span></span>\n      <span class="token attr-name">color</span><span class="token script language-javascript"><span class="token punctuation">=</span><span class="token punctuation">{</span>Color<span class="token punctuation">.</span>Overlay<span class="token punctuation">}</span></span>\n      <span class="token attr-name">padding</span><span class="token script language-javascript"><span class="token punctuation">=</span><span class="token punctuation">{</span><span class="token number">2</span><span class="token punctuation">}</span></span>\n    <span class="token punctuation">></span></span>\n      <span class="token tag"><span class="token tag"><span class="token punctuation">&lt;</span>CoreText</span> <span class="token attr-name">bold</span><span class="token punctuation">></span></span>This is very tall content<span class="token punctuation">:</span><span class="token tag"><span class="token tag"><span class="token punctuation">&lt;/</span>CoreText</span><span class="token punctuation">></span></span>\n      <span class="token tag"><span class="token tag"><span class="token punctuation">&lt;</span>br</span> <span class="token punctuation">/></span></span>\n      <span class="token tag"><span class="token tag"><span class="token punctuation">&lt;</span>CoreText</span><span class="token punctuation">></span></span>Lorem ipsum dolor sit amet<span class="token punctuation">,</span> consectetur adipiscing elit<span class="token punctuation">,</span> sed <span class="token keyword">do</span> eiusmod tempor incididunt ut labore et dolore magna aliqua<span class="token punctuation">.</span> Ut enim ad minim veniam<span class="token punctuation">,</span> quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat<span class="token punctuation">.</span> Duis aute irure dolor <span class="token keyword">in</span> reprehenderit <span class="token keyword">in</span> voluptate velit esse cillum dolore eu fugiat nulla pariatur<span class="token punctuation">.</span> Excepteur sint occaecat cupidatat non proident<span class="token punctuation">,</span> sunt <span class="token keyword">in</span> culpa qui officia deserunt mollit anim id est laborum<span class="token punctuation">.</span><span class="token tag"><span class="token tag"><span class="token punctuation">&lt;/</span>CoreText</span><span class="token punctuation">></span></span>\n    <span class="token tag"><span class="token tag"><span class="token punctuation">&lt;/</span>StyledLayout</span><span class="token punctuation">></span></span>\n  <span class="token tag"><span class="token tag"><span class="token punctuation">&lt;/</span>Column</span><span class="token punctuation">></span></span>\n\n  <span class="token tag"><span class="token tag"><span class="token punctuation">&lt;</span>Column</span> <span class="token attr-name">cols</span><span class="token script language-javascript"><span class="token punctuation">=</span><span class="token punctuation">{</span><span class="token number">6</span><span class="token punctuation">}</span></span><span class="token punctuation">></span></span>\n    <span class="token tag"><span class="token tag"><span class="token punctuation">&lt;</span>StyledLayout</span>\n      <span class="token attr-name">display</span><span class="token script language-javascript"><span class="token punctuation">=</span><span class="token punctuation">{</span>Display<span class="token punctuation">.</span>Flex<span class="token punctuation">}</span></span>\n      <span class="token attr-name">fullHeight</span>\n      <span class="token attr-name">fullWidth</span>\n      <span class="token attr-name">background</span><span class="token script language-javascript"><span class="token punctuation">=</span><span class="token punctuation">{</span>Background<span class="token punctuation">.</span>AccentAlt<span class="token punctuation">}</span></span>\n      <span class="token attr-name">color</span><span class="token script language-javascript"><span class="token punctuation">=</span><span class="token punctuation">{</span>Color<span class="token punctuation">.</span>Overlay<span class="token punctuation">}</span></span>\n      <span class="token attr-name">padding</span><span class="token script language-javascript"><span class="token punctuation">=</span><span class="token punctuation">{</span><span class="token number">2</span><span class="token punctuation">}</span></span>\n    <span class="token punctuation">></span></span>\n      <span class="token tag"><span class="token tag"><span class="token punctuation">&lt;</span>Layout</span> <span class="token attr-name">alignSelf</span><span class="token script language-javascript"><span class="token punctuation">=</span><span class="token punctuation">{</span>AlignSelf<span class="token punctuation">.</span>Center<span class="token punctuation">}</span></span><span class="token punctuation">></span></span>\n        <span class="token tag"><span class="token tag"><span class="token punctuation">&lt;</span>CoreText</span> <span class="token attr-name">bold</span><span class="token punctuation">></span></span>This is short content<span class="token punctuation">:</span><span class="token tag"><span class="token tag"><span class="token punctuation">&lt;/</span>CoreText</span><span class="token punctuation">></span></span>\n        <span class="token tag"><span class="token tag"><span class="token punctuation">&lt;</span>br</span> <span class="token punctuation">/></span></span>\n        <span class="token tag"><span class="token tag"><span class="token punctuation">&lt;</span>CoreText</span><span class="token punctuation">></span></span>It is also vertically centered<span class="token punctuation">.</span><span class="token tag"><span class="token tag"><span class="token punctuation">&lt;/</span>CoreText</span><span class="token punctuation">></span></span>\n      <span class="token tag"><span class="token tag"><span class="token punctuation">&lt;/</span>Layout</span><span class="token punctuation">></span></span>\n    <span class="token tag"><span class="token tag"><span class="token punctuation">&lt;/</span>StyledLayout</span><span class="token punctuation">></span></span>\n  <span class="token tag"><span class="token tag"><span class="token punctuation">&lt;/</span>Column</span><span class="token punctuation">></span></span>\n\n<span class="token tag"><span class="token tag"><span class="token punctuation">&lt;/</span>Grid</span><span class="token punctuation">></span></span>\n</code></pre>\n      </div>',
frontmatter:{component:{id:"components/grid/grid",disablePlayground:null},title:""},headings:[{value:"Basic Usage",depth:2},{value:"Basic",depth:3},{value:"Nested",depth:3},{value:"Example: Responsive, equal sized columns",depth:2},{value:"Example: Responsive column layout",depth:2},{value:"Example: Grid + Flexbox for vertical centering",depth:2}]}},github:{items:[{sha:"fa2a6eac9480afbb350f1f1c508d2a6edd81b91f",htmlUrl:"https://git-aws.internal.justin.tv/web/core-ui/commit/fa2a6eac9480afbb350f1f1c508d2a6edd81b91f",commit:{message:"Updated to string enums",committer:{date:"2018-02-28T21:15:18Z"}},author:{login:"jpanter",avatarUrl:"https://git-aws.internal.justin.tv/avatars/u/788?",htmlUrl:"https://git-aws.internal.justin.tv/jpanter"}},{sha:"378dd6d6c0f51a35c19fda3cfab7e55ae14e3a12",htmlUrl:"https://git-aws.internal.justin.tv/web/core-ui/commit/378dd6d6c0f51a35c19fda3cfab7e55ae14e3a12",commit:{message:"Merge branch 'master' into cg-auto-docs",committer:{date:"2018-01-31T23:42:34Z"}},author:{login:"cgrffit",avatarUrl:"https://git-aws.internal.justin.tv/avatars/u/707?",htmlUrl:"https://git-aws.internal.justin.tv/cgrffit"}},{sha:"18cd187ab0dd360dcc716b43d56683cfdf7d9df6",htmlUrl:"https://git-aws.internal.justin.tv/web/core-ui/commit/18cd187ab0dd360dcc716b43d56683cfdf7d9df6",commit:{message:"oops, extrasmall to small",committer:{date:"2018-01-29T18:42:10Z"}},author:{login:"shusterm",avatarUrl:"https://git-aws.internal.justin.tv/avatars/u/406?",htmlUrl:"https://git-aws.internal.justin.tv/shusterm"}},{sha:"b3bbf04436d20d43a852761751b6ac4c8ca432e1",htmlUrl:"https://git-aws.internal.justin.tv/web/core-ui/commit/b3bbf04436d20d43a852761751b6ac4c8ca432e1",commit:{message:"fix prop names",committer:{date:"2018-01-29T18:35:39Z"}},author:{login:"shusterm",avatarUrl:"https://git-aws.internal.justin.tv/avatars/u/406?",htmlUrl:"https://git-aws.internal.justin.tv/shusterm"}},{sha:"e244218a4a5739e406047efe89b39525faafaea6",htmlUrl:"https://git-aws.internal.justin.tv/web/core-ui/commit/e244218a4a5739e406047efe89b39525faafaea6",commit:{message:"add playground examples for grid alignment resolves #805",committer:{date:"2018-01-26T23:09:53Z"}},author:{login:"shusterm",avatarUrl:"https://git-aws.internal.justin.tv/avatars/u/406?",htmlUrl:"https://git-aws.internal.justin.tv/shusterm"}},{sha:"59207919ca42b86a1868b7380e6b8f0d579e7ec7",htmlUrl:"https://git-aws.internal.justin.tv/web/core-ui/commit/59207919ca42b86a1868b7380e6b8f0d579e7ec7",commit:{message:"add props to configure grid alignment",committer:{date:"2018-01-26T20:45:25Z"}},author:{login:"shusterm",avatarUrl:"https://git-aws.internal.justin.tv/avatars/u/406?",htmlUrl:"https://git-aws.internal.justin.tv/shusterm"}},{sha:"03a7cfd533b9ccef6f7f1e1c4dc01717be3c0bf3",htmlUrl:"https://git-aws.internal.justin.tv/web/core-ui/commit/03a7cfd533b9ccef6f7f1e1c4dc01717be3c0bf3",commit:{message:"Update content",committer:{date:"2018-01-26T00:19:22Z"}},author:{login:"cgrffit",avatarUrl:"https://git-aws.internal.justin.tv/avatars/u/707?",htmlUrl:"https://git-aws.internal.justin.tv/cgrffit"}},{sha:"410cb9df779e0e3702692a568e9c8344d5893b74",htmlUrl:"https://git-aws.internal.justin.tv/web/core-ui/commit/410cb9df779e0e3702692a568e9c8344d5893b74",commit:{message:"Content and fix markdown component",committer:{date:"2018-01-24T19:17:56Z"}},author:{login:"cgrffit",avatarUrl:"https://git-aws.internal.justin.tv/avatars/u/707?",htmlUrl:"https://git-aws.internal.justin.tv/cgrffit"}},{sha:"e16ccb433fc75c450e014c812d5c6249f6b6a94f",htmlUrl:"https://git-aws.internal.justin.tv/web/core-ui/commit/e16ccb433fc75c450e014c812d5c6249f6b6a94f",commit:{message:"Merge branch 'master' into cg-auto-docs",committer:{date:"2018-01-17T19:36:31Z"}},author:{login:"cgrffit",avatarUrl:"https://git-aws.internal.justin.tv/avatars/u/707?",htmlUrl:"https://git-aws.internal.justin.tv/cgrffit"}},{sha:"caa04a2ac5d52fd00c066ff88444ca0a3ae2f08b",htmlUrl:"https://git-aws.internal.justin.tv/web/core-ui/commit/caa04a2ac5d52fd00c066ff88444ca0a3ae2f08b",commit:{message:"Updating prefixes to follow convention",committer:{date:"2017-12-14T18:54:35Z"}},author:{login:"jpanter",avatarUrl:"https://git-aws.internal.justin.tv/avatars/u/788?",htmlUrl:"https://git-aws.internal.justin.tv/jpanter"}},{sha:"1c3aafee9294e64b5a8807a3e584619da1aef4ff",htmlUrl:"https://git-aws.internal.justin.tv/web/core-ui/commit/1c3aafee9294e64b5a8807a3e584619da1aef4ff",commit:{message:"Remove import statements from readme's so they can be automatically generated",committer:{date:"2017-11-30T18:53:33Z"}},author:{login:"cgrffit",avatarUrl:"https://git-aws.internal.justin.tv/avatars/u/707?",htmlUrl:"https://git-aws.internal.justin.tv/cgrffit"}},{sha:"c0a1af35825e9f1a58f93dc32e594cc3f9baaf2f",htmlUrl:"https://git-aws.internal.justin.tv/web/core-ui/commit/c0a1af35825e9f1a58f93dc32e594cc3f9baaf2f",commit:{message:"Add docs and remove remaining console errors",committer:{date:"2017-11-30T18:23:37Z"}},author:{login:"cgrffit",avatarUrl:"https://git-aws.internal.justin.tv/avatars/u/707?",htmlUrl:"https://git-aws.internal.justin.tv/cgrffit"}},{sha:"88ab1dd4880fac3a45cdf056734b3744bef5adba",htmlUrl:"https://git-aws.internal.justin.tv/web/core-ui/commit/88ab1dd4880fac3a45cdf056734b3744bef5adba",commit:{message:"Get the commits for each component file and display the latest",committer:{date:"2017-11-21T22:33:46Z"}},author:{login:"cgrffit",avatarUrl:"https://git-aws.internal.justin.tv/avatars/u/707?",htmlUrl:"https://git-aws.internal.justin.tv/cgrffit"}},{sha:"334e9bc30a18881a9f164fd648fabe5d26428932",htmlUrl:"https://git-aws.internal.justin.tv/web/core-ui/commit/334e9bc30a18881a9f164fd648fabe5d26428932",commit:{message:"Remove prop tables from readmes",committer:{date:"2017-11-18T01:48:25Z"}},author:{login:"cgrffit",avatarUrl:"https://git-aws.internal.justin.tv/avatars/u/707?",htmlUrl:"https://git-aws.internal.justin.tv/cgrffit"}},{sha:"30c6cb578a4b73947bc978a8a8fab1de7ba23d0e",htmlUrl:"https://git-aws.internal.justin.tv/web/core-ui/commit/30c6cb578a4b73947bc978a8a8fab1de7ba23d0e",commit:{message:"Format the docs",committer:{date:"2017-11-17T21:43:29Z"}},author:{login:"cgrffit",avatarUrl:"https://git-aws.internal.justin.tv/avatars/u/707?",htmlUrl:"https://git-aws.internal.justin.tv/cgrffit"}},{sha:"41c1a0d7743619e457309a3ae90c2d77aed6deaa",htmlUrl:"https://git-aws.internal.justin.tv/web/core-ui/commit/41c1a0d7743619e457309a3ae90c2d77aed6deaa",commit:{message:"add grid gutter size medium resolves #698",committer:{date:"2017-11-15T22:20:44Z"}},author:{login:"shusterm",avatarUrl:"https://git-aws.internal.justin.tv/avatars/u/406?",htmlUrl:"https://git-aws.internal.justin.tv/shusterm"}},{sha:"c3ba67465626c979db388d631cd66d1eafba63c7",htmlUrl:"https://git-aws.internal.justin.tv/web/core-ui/commit/c3ba67465626c979db388d631cd66d1eafba63c7",commit:{message:"Add grid, interactable, and layout prop docs",committer:{date:"2017-10-16T22:08:04Z"}},author:{login:"cgrffit",avatarUrl:"https://git-aws.internal.justin.tv/avatars/u/707?",htmlUrl:"https://git-aws.internal.justin.tv/cgrffit"}},{sha:"356869dfeb5d6a887a8b32b87b54e36c641536bb",htmlUrl:"https://git-aws.internal.justin.tv/web/core-ui/commit/356869dfeb5d6a887a8b32b87b54e36c641536bb",commit:{message:"Add remaining READMEs",committer:{date:"2017-10-16T21:28:19Z"}},author:{login:"cgrffit",avatarUrl:"https://git-aws.internal.justin.tv/avatars/u/707?",htmlUrl:"https://git-aws.internal.justin.tv/cgrffit"}},{sha:"7a58870807f375e723cf5f3944b20d41ba4a1671",htmlUrl:"https://git-aws.internal.justin.tv/web/core-ui/commit/7a58870807f375e723cf5f3944b20d41ba4a1671",commit:{message:"change Container to Grid",committer:{date:"2017-07-31T23:09:44Z"}},author:{login:"shusterm",avatarUrl:"https://git-aws.internal.justin.tv/avatars/u/406?",htmlUrl:"https://git-aws.internal.justin.tv/shusterm"}}]},component:{name:"Grid",comment:null,properties:[{name:"alignItems",flags:{isOptional:!0},type:"AlignItems",comment:null,availableValues:["Baseline","Center","End","Start","Stretch"],breakpointCompatible:!0},{name:"children",flags:{isOptional:!0},type:"React.ReactNode",comment:{shortText:null,tags:[{tag:"example",text:"\n  <Column cols={4}>\n    <StyledLayout background={Background.Accent} padding={2} />\n  </Column>\n  <Column cols={4}>\n    <StyledLayout background={Background.Accent} padding={2} />\n  </Column>\n  <Column cols={4}>\n    <StyledLayout background={Background.Accent} padding={2} />\n  </Column>\n"}]},availableValues:[],breakpointCompatible:!1},{name:"gutterSize",flags:{isOptional:!0},type:"GridGutterSize",comment:null,availableValues:["Default","Large","Medium","None","Small"],breakpointCompatible:!1},{name:"justifyContent",flags:{isOptional:!0},type:"JustifyContent",comment:null,availableValues:["Around","Between","Center","End","Start"],breakpointCompatible:!0}]}},pathContext:{componentPagePath:"/user-interface/components/grid/grid",componentId:"components/grid/grid"}}}});
//# sourceMappingURL=path---user-interface-components-grid-grid-7879258aba7bc14c6920.js.map