webpackJsonp([20557957722918],{913:function(a,n){a.exports={data:{page:{modifiedTime:"2018-04-03T17:55:28.000Z",fields:{title:"Layout",slug:"layout",path:"/user-interface/components/layout",segments:[{title:"User Interface",slug:"user-interface"},{title:"Components",slug:"components"},{title:"Layout",slug:"layout"}]},childMarkdownRemark:{html:'<p>Layout comes in three flavors: <code>&#x3C;Layout></code>, <code>&#x3C;StyledLayout></code>, and <code>&#x3C;InjectLayout></code> and you should reach for them in this order, with preference for the simplest component which solves the problem.</p>\n<p>These components provide a typed API to apply CSS properties (such as padding, margin, or FlexBox properties) to wrapper such as a <code>&#x3C;div></code> tag. <a href="./styled-layout">See docs on Styled Layout</a> for more info about visual layout styles, or <a href="https://css-tricks.com/snippets/css/a-guide-to-flexbox/">read up on CSS FlexBox</a> to learn more about the available properties.</p>\n<h2 id="example-flexbox-with-images-and-text"><a href="#example-flexbox-with-images-and-text" aria-hidden="true" class="anchor"><svg aria-hidden="true" height="16" version="1.1" viewBox="0 0 16 16" width="16"><path fill-rule="evenodd" d="M4 9h1v1H4c-1.5 0-3-1.69-3-3.5S2.55 3 4 3h4c1.45 0 3 1.69 3 3.5 0 1.41-.91 2.72-2 3.25V8.59c.58-.45 1-1.27 1-2.09C10 5.22 8.98 4 8 4H4c-.98 0-2 1.22-2 2.5S3 9 4 9zm9-3h-1v1h1c1 0 2 1.22 2 2.5S13.98 12 13 12H9c-.98 0-2-1.22-2-2.5 0-.83.42-1.64 1-2.09V6.25c-1.09.53-2 1.84-2 3.25C6 11.31 7.55 13 9 13h4c1.45 0 3-1.69 3-3.5S14.5 6 13 6z"></path></svg></a>Example: FlexBox with images and text</h2>\n<p>A common layout pattern which includes text, images, and CTA buttons within a rectangular area. Notice that the center region with the text is designated to grow and shrink as the available space resizes and the other two regions do not grow or shrink.</p>\n<div class="gatsby-highlight">\n      <pre class="language-jsx"><code><span class="token tag"><span class="token tag"><span class="token punctuation">&lt;</span>StyledLayout</span> <span class="token attr-name">display</span><span class="token script language-javascript"><span class="token punctuation">=</span><span class="token punctuation">{</span>Display<span class="token punctuation">.</span>Flex<span class="token punctuation">}</span></span> <span class="token attr-name">elevation</span><span class="token script language-javascript"><span class="token punctuation">=</span><span class="token punctuation">{</span><span class="token number">1</span><span class="token punctuation">}</span></span> <span class="token attr-name">background</span><span class="token script language-javascript"><span class="token punctuation">=</span><span class="token punctuation">{</span>Background<span class="token punctuation">.</span>Base<span class="token punctuation">}</span></span><span class="token punctuation">></span></span>\n\n  <span class="token tag"><span class="token tag"><span class="token punctuation">&lt;</span>Layout</span> <span class="token attr-name">flexGrow</span><span class="token script language-javascript"><span class="token punctuation">=</span><span class="token punctuation">{</span><span class="token number">0</span><span class="token punctuation">}</span></span> <span class="token attr-name">flexShrink</span><span class="token script language-javascript"><span class="token punctuation">=</span><span class="token punctuation">{</span><span class="token number">0</span><span class="token punctuation">}</span></span><span class="token punctuation">></span></span>\n    <span class="token tag"><span class="token tag"><span class="token punctuation">&lt;</span>img</span> <span class="token attr-name">src</span><span class="token attr-value"><span class="token punctuation">=</span><span class="token punctuation">"</span>https://static-cdn.jtvnw.net/ttv-boxart/StarCraft%20II-95x127.jpg<span class="token punctuation">"</span></span> <span class="token punctuation">/></span></span>\n  <span class="token tag"><span class="token tag"><span class="token punctuation">&lt;/</span>Layout</span><span class="token punctuation">></span></span>\n\n  <span class="token tag"><span class="token tag"><span class="token punctuation">&lt;</span>Layout</span> <span class="token attr-name">flexGrow</span><span class="token script language-javascript"><span class="token punctuation">=</span><span class="token punctuation">{</span><span class="token number">1</span><span class="token punctuation">}</span></span> <span class="token attr-name">flexShrink</span><span class="token script language-javascript"><span class="token punctuation">=</span><span class="token punctuation">{</span><span class="token number">1</span><span class="token punctuation">}</span></span> <span class="token attr-name">padding</span><span class="token script language-javascript"><span class="token punctuation">=</span><span class="token punctuation">{</span><span class="token number">2</span><span class="token punctuation">}</span></span><span class="token punctuation">></span></span>\n    <span class="token tag"><span class="token tag"><span class="token punctuation">&lt;</span>p</span><span class="token punctuation">></span></span>Starcraft <span class="token number">2</span> is the most awesome game ever<span class="token operator">!</span><span class="token tag"><span class="token tag"><span class="token punctuation">&lt;/</span>p</span><span class="token punctuation">></span></span>\n  <span class="token tag"><span class="token tag"><span class="token punctuation">&lt;/</span>Layout</span><span class="token punctuation">></span></span>\n\n  <span class="token tag"><span class="token tag"><span class="token punctuation">&lt;</span>Layout</span> <span class="token attr-name">flexGrow</span><span class="token script language-javascript"><span class="token punctuation">=</span><span class="token punctuation">{</span><span class="token number">0</span><span class="token punctuation">}</span></span> <span class="token attr-name">flexShrink</span><span class="token script language-javascript"><span class="token punctuation">=</span><span class="token punctuation">{</span><span class="token number">0</span><span class="token punctuation">}</span></span> <span class="token attr-name">padding</span><span class="token script language-javascript"><span class="token punctuation">=</span><span class="token punctuation">{</span><span class="token number">2</span><span class="token punctuation">}</span></span><span class="token punctuation">></span></span>\n    <span class="token tag"><span class="token tag"><span class="token punctuation">&lt;</span>Button</span><span class="token punctuation">></span></span>Buy Now<span class="token tag"><span class="token tag"><span class="token punctuation">&lt;/</span>Button</span><span class="token punctuation">></span></span>\n  <span class="token tag"><span class="token tag"><span class="token punctuation">&lt;/</span>Layout</span><span class="token punctuation">></span></span>\n\n<span class="token tag"><span class="token tag"><span class="token punctuation">&lt;/</span>StyledLayout</span><span class="token punctuation">></span></span>\n</code></pre>\n      </div>\n<h2 id="example-vertical-centering-elements-in-a-row"><a href="#example-vertical-centering-elements-in-a-row" aria-hidden="true" class="anchor"><svg aria-hidden="true" height="16" version="1.1" viewBox="0 0 16 16" width="16"><path fill-rule="evenodd" d="M4 9h1v1H4c-1.5 0-3-1.69-3-3.5S2.55 3 4 3h4c1.45 0 3 1.69 3 3.5 0 1.41-.91 2.72-2 3.25V8.59c.58-.45 1-1.27 1-2.09C10 5.22 8.98 4 8 4H4c-.98 0-2 1.22-2 2.5S3 9 4 9zm9-3h-1v1h1c1 0 2 1.22 2 2.5S13.98 12 13 12H9c-.98 0-2-1.22-2-2.5 0-.83.42-1.64 1-2.09V6.25c-1.09.53-2 1.84-2 3.25C6 11.31 7.55 13 9 13h4c1.45 0 3-1.69 3-3.5S14.5 6 13 6z"></path></svg></a>Example: Vertical centering elements in a row</h2>\n<p>By setting a flex-child to ALSO behave as a flex-parent, we can vertically center things:</p>\n<div class="gatsby-highlight">\n      <pre class="language-jsx"><code><span class="token tag"><span class="token tag"><span class="token punctuation">&lt;</span>StyledLayout</span> <span class="token attr-name">display</span><span class="token script language-javascript"><span class="token punctuation">=</span><span class="token punctuation">{</span>Display<span class="token punctuation">.</span>Flex<span class="token punctuation">}</span></span> <span class="token attr-name">border</span> <span class="token attr-name">padding</span><span class="token script language-javascript"><span class="token punctuation">=</span><span class="token punctuation">{</span><span class="token number">1</span><span class="token punctuation">}</span></span><span class="token punctuation">></span></span>\n  <span class="token tag"><span class="token tag"><span class="token punctuation">&lt;</span>Button</span><span class="token punctuation">></span></span>Click Me<span class="token tag"><span class="token tag"><span class="token punctuation">&lt;/</span>Button</span><span class="token punctuation">></span></span>\n  <span class="token tag"><span class="token tag"><span class="token punctuation">&lt;</span>Layout</span> <span class="token attr-name">display</span><span class="token script language-javascript"><span class="token punctuation">=</span><span class="token punctuation">{</span>Display<span class="token punctuation">.</span>Flex<span class="token punctuation">}</span></span> <span class="token attr-name">alignItems</span><span class="token script language-javascript"><span class="token punctuation">=</span><span class="token punctuation">{</span>AlignItems<span class="token punctuation">.</span>Center<span class="token punctuation">}</span></span> <span class="token attr-name">margin</span><span class="token script language-javascript"><span class="token punctuation">=</span><span class="token punctuation">{</span><span class="token punctuation">{</span> left<span class="token punctuation">:</span> <span class="token number">1</span> <span class="token punctuation">}</span><span class="token punctuation">}</span></span><span class="token punctuation">></span></span>\n    <span class="token tag"><span class="token tag"><span class="token punctuation">&lt;</span>p</span><span class="token punctuation">></span></span>This text is vertically centered<span class="token operator">!</span><span class="token tag"><span class="token tag"><span class="token punctuation">&lt;/</span>p</span><span class="token punctuation">></span></span>\n  <span class="token tag"><span class="token tag"><span class="token punctuation">&lt;/</span>Layout</span><span class="token punctuation">></span></span>\n<span class="token tag"><span class="token tag"><span class="token punctuation">&lt;/</span>StyledLayout</span><span class="token punctuation">></span></span>\n</code></pre>\n      </div>\n<h2 id="example-stacking-and-anchoring"><a href="#example-stacking-and-anchoring" aria-hidden="true" class="anchor"><svg aria-hidden="true" height="16" version="1.1" viewBox="0 0 16 16" width="16"><path fill-rule="evenodd" d="M4 9h1v1H4c-1.5 0-3-1.69-3-3.5S2.55 3 4 3h4c1.45 0 3 1.69 3 3.5 0 1.41-.91 2.72-2 3.25V8.59c.58-.45 1-1.27 1-2.09C10 5.22 8.98 4 8 4H4c-.98 0-2 1.22-2 2.5S3 9 4 9zm9-3h-1v1h1c1 0 2 1.22 2 2.5S13.98 12 13 12H9c-.98 0-2-1.22-2-2.5 0-.83.42-1.64 1-2.09V6.25c-1.09.53-2 1.84-2 3.25C6 11.31 7.55 13 9 13h4c1.45 0 3-1.69 3-3.5S14.5 6 13 6z"></path></svg></a>Example: Stacking and anchoring</h2>\n<div class="gatsby-highlight">\n      <pre class="language-jsx"><code><span class="token tag"><span class="token tag"><span class="token punctuation">&lt;</span>Layout</span> <span class="token attr-name">position</span><span class="token script language-javascript"><span class="token punctuation">=</span><span class="token punctuation">{</span>Position<span class="token punctuation">.</span>Relative<span class="token punctuation">}</span></span><span class="token punctuation">></span></span>\n  <span class="token tag"><span class="token tag"><span class="token punctuation">&lt;</span>img</span> <span class="token attr-name">src</span><span class="token attr-value"><span class="token punctuation">=</span><span class="token punctuation">"</span>https://s3-us-west-2.amazonaws.com/web-design-int-production/assets/brand/images/Photography--4.jpg<span class="token punctuation">"</span></span> <span class="token attr-name">width</span><span class="token script language-javascript"><span class="token punctuation">=</span><span class="token punctuation">{</span><span class="token number">720</span><span class="token punctuation">}</span></span> <span class="token attr-name">height</span><span class="token script language-javascript"><span class="token punctuation">=</span><span class="token punctuation">{</span><span class="token number">367</span><span class="token punctuation">}</span></span> <span class="token punctuation">/></span></span>\n  <span class="token tag"><span class="token tag"><span class="token punctuation">&lt;</span>StyledLayout</span>\n    <span class="token attr-name">position</span><span class="token script language-javascript"><span class="token punctuation">=</span><span class="token punctuation">{</span>Position<span class="token punctuation">.</span>Absolute<span class="token punctuation">}</span></span>\n    <span class="token attr-name">attachTop</span>\n    <span class="token attr-name">attachRight</span>\n    <span class="token attr-name">padding</span><span class="token script language-javascript"><span class="token punctuation">=</span><span class="token punctuation">{</span><span class="token number">2</span><span class="token punctuation">}</span></span>\n    <span class="token attr-name">margin</span><span class="token script language-javascript"><span class="token punctuation">=</span><span class="token punctuation">{</span><span class="token number">2</span><span class="token punctuation">}</span></span>\n    <span class="token attr-name">background</span><span class="token script language-javascript"><span class="token punctuation">=</span><span class="token punctuation">{</span>Background<span class="token punctuation">.</span>Base<span class="token punctuation">}</span></span>\n    <span class="token attr-name">elevation</span><span class="token script language-javascript"><span class="token punctuation">=</span><span class="token punctuation">{</span><span class="token number">3</span><span class="token punctuation">}</span></span>\n  <span class="token punctuation">></span></span>\n    <span class="token tag"><span class="token tag"><span class="token punctuation">&lt;</span>CoreText</span> <span class="token attr-name">bold</span><span class="token punctuation">></span></span>An element positioned <span class="token keyword">in</span> the top right<span class="token punctuation">.</span><span class="token tag"><span class="token tag"><span class="token punctuation">&lt;/</span>CoreText</span><span class="token punctuation">></span></span>\n  <span class="token tag"><span class="token tag"><span class="token punctuation">&lt;/</span>StyledLayout</span><span class="token punctuation">></span></span>\n<span class="token tag"><span class="token tag"><span class="token punctuation">&lt;/</span>Layout</span><span class="token punctuation">></span></span>\n</code></pre>\n      </div>\n<h2 id="example-stacking-and-centering"><a href="#example-stacking-and-centering" aria-hidden="true" class="anchor"><svg aria-hidden="true" height="16" version="1.1" viewBox="0 0 16 16" width="16"><path fill-rule="evenodd" d="M4 9h1v1H4c-1.5 0-3-1.69-3-3.5S2.55 3 4 3h4c1.45 0 3 1.69 3 3.5 0 1.41-.91 2.72-2 3.25V8.59c.58-.45 1-1.27 1-2.09C10 5.22 8.98 4 8 4H4c-.98 0-2 1.22-2 2.5S3 9 4 9zm9-3h-1v1h1c1 0 2 1.22 2 2.5S13.98 12 13 12H9c-.98 0-2-1.22-2-2.5 0-.83.42-1.64 1-2.09V6.25c-1.09.53-2 1.84-2 3.25C6 11.31 7.55 13 9 13h4c1.45 0 3-1.69 3-3.5S14.5 6 13 6z"></path></svg></a>Example: Stacking and centering</h2>\n<div class="gatsby-highlight">\n      <pre class="language-jsx"><code><span class="token tag"><span class="token tag"><span class="token punctuation">&lt;</span>Layout</span> <span class="token attr-name">position</span><span class="token script language-javascript"><span class="token punctuation">=</span><span class="token punctuation">{</span>Position<span class="token punctuation">.</span>Relative<span class="token punctuation">}</span></span><span class="token punctuation">></span></span>\n  <span class="token tag"><span class="token tag"><span class="token punctuation">&lt;</span>img</span> <span class="token attr-name">src</span><span class="token attr-value"><span class="token punctuation">=</span><span class="token punctuation">"</span>https://s3-us-west-2.amazonaws.com/web-design-int-production/assets/brand/images/Photography--4.jpg<span class="token punctuation">"</span></span> <span class="token attr-name">width</span><span class="token script language-javascript"><span class="token punctuation">=</span><span class="token punctuation">{</span><span class="token number">720</span><span class="token punctuation">}</span></span> <span class="token attr-name">height</span><span class="token script language-javascript"><span class="token punctuation">=</span><span class="token punctuation">{</span><span class="token number">367</span><span class="token punctuation">}</span></span> <span class="token punctuation">/></span></span>\n  <span class="token tag"><span class="token tag"><span class="token punctuation">&lt;</span>Layout</span>\n    <span class="token attr-name">position</span><span class="token script language-javascript"><span class="token punctuation">=</span><span class="token punctuation">{</span>Position<span class="token punctuation">.</span>Absolute<span class="token punctuation">}</span></span>\n    <span class="token attr-name">attachTop</span>\n    <span class="token attr-name">attachLeft</span>\n    <span class="token attr-name">fullWidth</span>\n    <span class="token attr-name">fullHeight</span>\n    <span class="token attr-name">display</span><span class="token script language-javascript"><span class="token punctuation">=</span><span class="token punctuation">{</span>Display<span class="token punctuation">.</span>Flex<span class="token punctuation">}</span></span>\n    <span class="token attr-name">alignItems</span><span class="token script language-javascript"><span class="token punctuation">=</span><span class="token punctuation">{</span>AlignItems<span class="token punctuation">.</span>Center<span class="token punctuation">}</span></span>\n    <span class="token attr-name">justifyContent</span><span class="token script language-javascript"><span class="token punctuation">=</span><span class="token punctuation">{</span>JustifyContent<span class="token punctuation">.</span>Center<span class="token punctuation">}</span></span>\n  <span class="token punctuation">></span></span>\n    <span class="token tag"><span class="token tag"><span class="token punctuation">&lt;</span>StyledLayout</span>\n      <span class="token attr-name">padding</span><span class="token script language-javascript"><span class="token punctuation">=</span><span class="token punctuation">{</span><span class="token number">2</span><span class="token punctuation">}</span></span>\n      <span class="token attr-name">background</span><span class="token script language-javascript"><span class="token punctuation">=</span><span class="token punctuation">{</span>Background<span class="token punctuation">.</span>Base<span class="token punctuation">}</span></span>\n      <span class="token attr-name">elevation</span><span class="token script language-javascript"><span class="token punctuation">=</span><span class="token punctuation">{</span><span class="token number">3</span><span class="token punctuation">}</span></span>\n    <span class="token punctuation">></span></span>\n      <span class="token tag"><span class="token tag"><span class="token punctuation">&lt;</span>CoreText</span> <span class="token attr-name">bold</span><span class="token punctuation">></span></span>An element positioned <span class="token keyword">in</span> the center<span class="token punctuation">.</span><span class="token tag"><span class="token tag"><span class="token punctuation">&lt;/</span>CoreText</span><span class="token punctuation">></span></span>\n    <span class="token tag"><span class="token tag"><span class="token punctuation">&lt;/</span>StyledLayout</span><span class="token punctuation">></span></span>\n  <span class="token tag"><span class="token tag"><span class="token punctuation">&lt;/</span>Layout</span><span class="token punctuation">></span></span>\n<span class="token tag"><span class="token tag"><span class="token punctuation">&lt;/</span>Layout</span><span class="token punctuation">></span></span>\n</code></pre>\n      </div>\n<h2 id="example-flex-columns-all-viewport-sizes"><a href="#example-flex-columns-all-viewport-sizes" aria-hidden="true" class="anchor"><svg aria-hidden="true" height="16" version="1.1" viewBox="0 0 16 16" width="16"><path fill-rule="evenodd" d="M4 9h1v1H4c-1.5 0-3-1.69-3-3.5S2.55 3 4 3h4c1.45 0 3 1.69 3 3.5 0 1.41-.91 2.72-2 3.25V8.59c.58-.45 1-1.27 1-2.09C10 5.22 8.98 4 8 4H4c-.98 0-2 1.22-2 2.5S3 9 4 9zm9-3h-1v1h1c1 0 2 1.22 2 2.5S13.98 12 13 12H9c-.98 0-2-1.22-2-2.5 0-.83.42-1.64 1-2.09V6.25c-1.09.53-2 1.84-2 3.25C6 11.31 7.55 13 9 13h4c1.45 0 3-1.69 3-3.5S14.5 6 13 6z"></path></svg></a>Example: Flex Columns (All Viewport Sizes)</h2>\n<div class="gatsby-highlight">\n      <pre class="language-jsx"><code><span class="token tag"><span class="token tag"><span class="token punctuation">&lt;</span>Layout</span>\n  <span class="token attr-name">display</span><span class="token script language-javascript"><span class="token punctuation">=</span><span class="token punctuation">{</span>Display<span class="token punctuation">.</span>Flex<span class="token punctuation">}</span></span>\n  <span class="token attr-name">flexDirection</span><span class="token script language-javascript"><span class="token punctuation">=</span><span class="token punctuation">{</span>FlexDirection<span class="token punctuation">.</span>Column<span class="token punctuation">}</span></span>\n<span class="token punctuation">></span></span>\n  <span class="token tag"><span class="token tag"><span class="token punctuation">&lt;</span>Layout</span> <span class="token attr-name">margin</span><span class="token script language-javascript"><span class="token punctuation">=</span><span class="token punctuation">{</span><span class="token number">0.5</span><span class="token punctuation">}</span></span><span class="token punctuation">></span></span><span class="token tag"><span class="token tag"><span class="token punctuation">&lt;</span>Stat</span> <span class="token attr-name">label</span><span class="token attr-value"><span class="token punctuation">=</span><span class="token punctuation">"</span>My Cool Label<span class="token punctuation">"</span></span> <span class="token attr-name">value</span><span class="token attr-value"><span class="token punctuation">=</span><span class="token punctuation">"</span>1234<span class="token punctuation">"</span></span> <span class="token attr-name">icon</span><span class="token script language-javascript"><span class="token punctuation">=</span><span class="token punctuation">{</span>SVGAsset<span class="token punctuation">.</span>NavDashboard<span class="token punctuation">}</span></span> <span class="token punctuation">/></span></span><span class="token tag"><span class="token tag"><span class="token punctuation">&lt;/</span>Layout</span><span class="token punctuation">></span></span>\n  <span class="token tag"><span class="token tag"><span class="token punctuation">&lt;</span>Layout</span> <span class="token attr-name">margin</span><span class="token script language-javascript"><span class="token punctuation">=</span><span class="token punctuation">{</span><span class="token number">0.5</span><span class="token punctuation">}</span></span><span class="token punctuation">></span></span><span class="token tag"><span class="token tag"><span class="token punctuation">&lt;</span>Stat</span> <span class="token attr-name">label</span><span class="token attr-value"><span class="token punctuation">=</span><span class="token punctuation">"</span>My Cool Label<span class="token punctuation">"</span></span> <span class="token attr-name">value</span><span class="token attr-value"><span class="token punctuation">=</span><span class="token punctuation">"</span>4567<span class="token punctuation">"</span></span> <span class="token attr-name">icon</span><span class="token script language-javascript"><span class="token punctuation">=</span><span class="token punctuation">{</span>SVGAsset<span class="token punctuation">.</span>DeadGlitch<span class="token punctuation">}</span></span> <span class="token punctuation">/></span></span><span class="token tag"><span class="token tag"><span class="token punctuation">&lt;/</span>Layout</span><span class="token punctuation">></span></span>\n  <span class="token tag"><span class="token tag"><span class="token punctuation">&lt;</span>Layout</span> <span class="token attr-name">margin</span><span class="token script language-javascript"><span class="token punctuation">=</span><span class="token punctuation">{</span><span class="token number">0.5</span><span class="token punctuation">}</span></span><span class="token punctuation">></span></span><span class="token tag"><span class="token tag"><span class="token punctuation">&lt;</span>Stat</span> <span class="token attr-name">label</span><span class="token attr-value"><span class="token punctuation">=</span><span class="token punctuation">"</span>My Cool Label<span class="token punctuation">"</span></span> <span class="token attr-name">value</span><span class="token attr-value"><span class="token punctuation">=</span><span class="token punctuation">"</span>8910<span class="token punctuation">"</span></span> <span class="token attr-name">icon</span><span class="token script language-javascript"><span class="token punctuation">=</span><span class="token punctuation">{</span>SVGAsset<span class="token punctuation">.</span>Bits<span class="token punctuation">}</span></span> <span class="token punctuation">/></span></span><span class="token tag"><span class="token tag"><span class="token punctuation">&lt;/</span>Layout</span><span class="token punctuation">></span></span>\n<span class="token tag"><span class="token tag"><span class="token punctuation">&lt;/</span>Layout</span><span class="token punctuation">></span></span>\n</code></pre>\n      </div>\n<h2 id="example-responsive-flex-columns-and-rows"><a href="#example-responsive-flex-columns-and-rows" aria-hidden="true" class="anchor"><svg aria-hidden="true" height="16" version="1.1" viewBox="0 0 16 16" width="16"><path fill-rule="evenodd" d="M4 9h1v1H4c-1.5 0-3-1.69-3-3.5S2.55 3 4 3h4c1.45 0 3 1.69 3 3.5 0 1.41-.91 2.72-2 3.25V8.59c.58-.45 1-1.27 1-2.09C10 5.22 8.98 4 8 4H4c-.98 0-2 1.22-2 2.5S3 9 4 9zm9-3h-1v1h1c1 0 2 1.22 2 2.5S13.98 12 13 12H9c-.98 0-2-1.22-2-2.5 0-.83.42-1.64 1-2.09V6.25c-1.09.53-2 1.84-2 3.25C6 11.31 7.55 13 9 13h4c1.45 0 3-1.69 3-3.5S14.5 6 13 6z"></path></svg></a>Example: Responsive Flex Columns and Rows</h2>\n<p>This will create <strong>rows at large viewports</strong> and <strong>columns at small viewports</strong>. You can re-size your browser viewport to see this example switch between Rows and Colummns.</p>\n<div class="gatsby-highlight">\n      <pre class="language-jsx"><code><span class="token tag"><span class="token tag"><span class="token punctuation">&lt;</span>Layout</span>\n  <span class="token attr-name">display</span><span class="token script language-javascript"><span class="token punctuation">=</span><span class="token punctuation">{</span>Display<span class="token punctuation">.</span>Flex<span class="token punctuation">}</span></span>\n  <span class="token attr-name">flexDirection</span><span class="token script language-javascript"><span class="token punctuation">=</span><span class="token punctuation">{</span>FlexDirection<span class="token punctuation">.</span>Column<span class="token punctuation">}</span></span>\n  <span class="token attr-name">breakpointMedium</span><span class="token script language-javascript"><span class="token punctuation">=</span><span class="token punctuation">{</span><span class="token punctuation">{</span>\n    flexDirection<span class="token punctuation">:</span> FlexDirection<span class="token punctuation">.</span>Row\n  <span class="token punctuation">}</span><span class="token punctuation">}</span></span>\n<span class="token punctuation">></span></span>\n  <span class="token tag"><span class="token tag"><span class="token punctuation">&lt;</span>Layout</span> <span class="token attr-name">margin</span><span class="token script language-javascript"><span class="token punctuation">=</span><span class="token punctuation">{</span><span class="token number">0.5</span><span class="token punctuation">}</span></span><span class="token punctuation">></span></span><span class="token tag"><span class="token tag"><span class="token punctuation">&lt;</span>Stat</span> <span class="token attr-name">label</span><span class="token attr-value"><span class="token punctuation">=</span><span class="token punctuation">"</span>My Cool Label<span class="token punctuation">"</span></span> <span class="token attr-name">value</span><span class="token attr-value"><span class="token punctuation">=</span><span class="token punctuation">"</span>1234<span class="token punctuation">"</span></span> <span class="token attr-name">icon</span><span class="token script language-javascript"><span class="token punctuation">=</span><span class="token punctuation">{</span>SVGAsset<span class="token punctuation">.</span>NavDashboard<span class="token punctuation">}</span></span> <span class="token punctuation">/></span></span><span class="token tag"><span class="token tag"><span class="token punctuation">&lt;/</span>Layout</span><span class="token punctuation">></span></span>\n  <span class="token tag"><span class="token tag"><span class="token punctuation">&lt;</span>Layout</span> <span class="token attr-name">margin</span><span class="token script language-javascript"><span class="token punctuation">=</span><span class="token punctuation">{</span><span class="token number">0.5</span><span class="token punctuation">}</span></span><span class="token punctuation">></span></span><span class="token tag"><span class="token tag"><span class="token punctuation">&lt;</span>Stat</span> <span class="token attr-name">label</span><span class="token attr-value"><span class="token punctuation">=</span><span class="token punctuation">"</span>My Cool Label<span class="token punctuation">"</span></span> <span class="token attr-name">value</span><span class="token attr-value"><span class="token punctuation">=</span><span class="token punctuation">"</span>5678<span class="token punctuation">"</span></span> <span class="token attr-name">icon</span><span class="token script language-javascript"><span class="token punctuation">=</span><span class="token punctuation">{</span>SVGAsset<span class="token punctuation">.</span>DeadGlitch<span class="token punctuation">}</span></span> <span class="token punctuation">/></span></span><span class="token tag"><span class="token tag"><span class="token punctuation">&lt;/</span>Layout</span><span class="token punctuation">></span></span>\n  <span class="token tag"><span class="token tag"><span class="token punctuation">&lt;</span>Layout</span> <span class="token attr-name">margin</span><span class="token script language-javascript"><span class="token punctuation">=</span><span class="token punctuation">{</span><span class="token number">0.5</span><span class="token punctuation">}</span></span><span class="token punctuation">></span></span><span class="token tag"><span class="token tag"><span class="token punctuation">&lt;</span>Stat</span> <span class="token attr-name">label</span><span class="token attr-value"><span class="token punctuation">=</span><span class="token punctuation">"</span>My Cool Label<span class="token punctuation">"</span></span> <span class="token attr-name">value</span><span class="token attr-value"><span class="token punctuation">=</span><span class="token punctuation">"</span>8910<span class="token punctuation">"</span></span> <span class="token attr-name">icon</span><span class="token script language-javascript"><span class="token punctuation">=</span><span class="token punctuation">{</span>SVGAsset<span class="token punctuation">.</span>Bits<span class="token punctuation">}</span></span> <span class="token punctuation">/></span></span><span class="token tag"><span class="token tag"><span class="token punctuation">&lt;/</span>Layout</span><span class="token punctuation">></span></span>\n<span class="token tag"><span class="token tag"><span class="token punctuation">&lt;/</span>Layout</span><span class="token punctuation">></span></span>\n</code></pre>\n      </div>\n<h2 id="padding"><a href="#padding" aria-hidden="true" class="anchor"><svg aria-hidden="true" height="16" version="1.1" viewBox="0 0 16 16" width="16"><path fill-rule="evenodd" d="M4 9h1v1H4c-1.5 0-3-1.69-3-3.5S2.55 3 4 3h4c1.45 0 3 1.69 3 3.5 0 1.41-.91 2.72-2 3.25V8.59c.58-.45 1-1.27 1-2.09C10 5.22 8.98 4 8 4H4c-.98 0-2 1.22-2 2.5S3 9 4 9zm9-3h-1v1h1c1 0 2 1.22 2 2.5S13.98 12 13 12H9c-.98 0-2-1.22-2-2.5 0-.83.42-1.64 1-2.09V6.25c-1.09.53-2 1.84-2 3.25C6 11.31 7.55 13 9 13h4c1.45 0 3-1.69 3-3.5S14.5 6 13 6z"></path></svg></a>Padding</h2>\n<h3 id="all-sides"><a href="#all-sides" aria-hidden="true" class="anchor"><svg aria-hidden="true" height="16" version="1.1" viewBox="0 0 16 16" width="16"><path fill-rule="evenodd" d="M4 9h1v1H4c-1.5 0-3-1.69-3-3.5S2.55 3 4 3h4c1.45 0 3 1.69 3 3.5 0 1.41-.91 2.72-2 3.25V8.59c.58-.45 1-1.27 1-2.09C10 5.22 8.98 4 8 4H4c-.98 0-2 1.22-2 2.5S3 9 4 9zm9-3h-1v1h1c1 0 2 1.22 2 2.5S13.98 12 13 12H9c-.98 0-2-1.22-2-2.5 0-.83.42-1.64 1-2.09V6.25c-1.09.53-2 1.84-2 3.25C6 11.31 7.55 13 9 13h4c1.45 0 3-1.69 3-3.5S14.5 6 13 6z"></path></svg></a>All Sides</h3>\n<div class="gatsby-highlight">\n      <pre class="language-jsx"><code><span class="token tag"><span class="token tag"><span class="token punctuation">&lt;</span>div</span><span class="token punctuation">></span></span>\n<span class="token tag"><span class="token tag"><span class="token punctuation">&lt;</span>StyledLayout</span> <span class="token attr-name">padding</span><span class="token script language-javascript"><span class="token punctuation">=</span><span class="token punctuation">{</span><span class="token number">1</span><span class="token punctuation">}</span></span> <span class="token attr-name">margin</span><span class="token script language-javascript"><span class="token punctuation">=</span><span class="token punctuation">{</span><span class="token number">1</span><span class="token punctuation">}</span></span> <span class="token attr-name">display</span><span class="token script language-javascript"><span class="token punctuation">=</span><span class="token punctuation">{</span>Display<span class="token punctuation">.</span>InlineBlock<span class="token punctuation">}</span></span> <span class="token attr-name">background</span><span class="token script language-javascript"><span class="token punctuation">=</span><span class="token punctuation">{</span>Background<span class="token punctuation">.</span>Accent<span class="token punctuation">}</span></span> <span class="token punctuation">/></span></span>\n<span class="token tag"><span class="token tag"><span class="token punctuation">&lt;</span>StyledLayout</span> <span class="token attr-name">padding</span><span class="token script language-javascript"><span class="token punctuation">=</span><span class="token punctuation">{</span><span class="token number">2</span><span class="token punctuation">}</span></span> <span class="token attr-name">margin</span><span class="token script language-javascript"><span class="token punctuation">=</span><span class="token punctuation">{</span><span class="token number">1</span><span class="token punctuation">}</span></span> <span class="token attr-name">display</span><span class="token script language-javascript"><span class="token punctuation">=</span><span class="token punctuation">{</span>Display<span class="token punctuation">.</span>InlineBlock<span class="token punctuation">}</span></span> <span class="token attr-name">background</span><span class="token script language-javascript"><span class="token punctuation">=</span><span class="token punctuation">{</span>Background<span class="token punctuation">.</span>Accent<span class="token punctuation">}</span></span> <span class="token punctuation">/></span></span>\n<span class="token tag"><span class="token tag"><span class="token punctuation">&lt;</span>StyledLayout</span> <span class="token attr-name">padding</span><span class="token script language-javascript"><span class="token punctuation">=</span><span class="token punctuation">{</span><span class="token number">3</span><span class="token punctuation">}</span></span> <span class="token attr-name">margin</span><span class="token script language-javascript"><span class="token punctuation">=</span><span class="token punctuation">{</span><span class="token number">1</span><span class="token punctuation">}</span></span> <span class="token attr-name">display</span><span class="token script language-javascript"><span class="token punctuation">=</span><span class="token punctuation">{</span>Display<span class="token punctuation">.</span>InlineBlock<span class="token punctuation">}</span></span> <span class="token attr-name">background</span><span class="token script language-javascript"><span class="token punctuation">=</span><span class="token punctuation">{</span>Background<span class="token punctuation">.</span>Accent<span class="token punctuation">}</span></span> <span class="token punctuation">/></span></span>\n<span class="token tag"><span class="token tag"><span class="token punctuation">&lt;</span>StyledLayout</span> <span class="token attr-name">padding</span><span class="token script language-javascript"><span class="token punctuation">=</span><span class="token punctuation">{</span><span class="token number">4</span><span class="token punctuation">}</span></span> <span class="token attr-name">margin</span><span class="token script language-javascript"><span class="token punctuation">=</span><span class="token punctuation">{</span><span class="token number">1</span><span class="token punctuation">}</span></span> <span class="token attr-name">display</span><span class="token script language-javascript"><span class="token punctuation">=</span><span class="token punctuation">{</span>Display<span class="token punctuation">.</span>InlineBlock<span class="token punctuation">}</span></span> <span class="token attr-name">background</span><span class="token script language-javascript"><span class="token punctuation">=</span><span class="token punctuation">{</span>Background<span class="token punctuation">.</span>Accent<span class="token punctuation">}</span></span> <span class="token punctuation">/></span></span>\n<span class="token tag"><span class="token tag"><span class="token punctuation">&lt;</span>StyledLayout</span> <span class="token attr-name">padding</span><span class="token script language-javascript"><span class="token punctuation">=</span><span class="token punctuation">{</span><span class="token number">5</span><span class="token punctuation">}</span></span> <span class="token attr-name">margin</span><span class="token script language-javascript"><span class="token punctuation">=</span><span class="token punctuation">{</span><span class="token number">1</span><span class="token punctuation">}</span></span> <span class="token attr-name">display</span><span class="token script language-javascript"><span class="token punctuation">=</span><span class="token punctuation">{</span>Display<span class="token punctuation">.</span>InlineBlock<span class="token punctuation">}</span></span> <span class="token attr-name">background</span><span class="token script language-javascript"><span class="token punctuation">=</span><span class="token punctuation">{</span>Background<span class="token punctuation">.</span>Accent<span class="token punctuation">}</span></span> <span class="token punctuation">/></span></span>\n<span class="token tag"><span class="token tag"><span class="token punctuation">&lt;/</span>div</span><span class="token punctuation">></span></span>\n</code></pre>\n      </div>\n<h3 id="by-side"><a href="#by-side" aria-hidden="true" class="anchor"><svg aria-hidden="true" height="16" version="1.1" viewBox="0 0 16 16" width="16"><path fill-rule="evenodd" d="M4 9h1v1H4c-1.5 0-3-1.69-3-3.5S2.55 3 4 3h4c1.45 0 3 1.69 3 3.5 0 1.41-.91 2.72-2 3.25V8.59c.58-.45 1-1.27 1-2.09C10 5.22 8.98 4 8 4H4c-.98 0-2 1.22-2 2.5S3 9 4 9zm9-3h-1v1h1c1 0 2 1.22 2 2.5S13.98 12 13 12H9c-.98 0-2-1.22-2-2.5 0-.83.42-1.64 1-2.09V6.25c-1.09.53-2 1.84-2 3.25C6 11.31 7.55 13 9 13h4c1.45 0 3-1.69 3-3.5S14.5 6 13 6z"></path></svg></a>By Side</h3>\n<div class="gatsby-highlight">\n      <pre class="language-jsx"><code><span class="token tag"><span class="token tag"><span class="token punctuation">&lt;</span>div</span><span class="token punctuation">></span></span>\n<span class="token tag"><span class="token tag"><span class="token punctuation">&lt;</span>StyledLayout</span> <span class="token attr-name">padding</span><span class="token script language-javascript"><span class="token punctuation">=</span><span class="token punctuation">{</span><span class="token punctuation">{</span> x<span class="token punctuation">:</span> <span class="token number">1</span><span class="token punctuation">,</span> y<span class="token punctuation">:</span> <span class="token number">2</span> <span class="token punctuation">}</span><span class="token punctuation">}</span></span> <span class="token attr-name">margin</span><span class="token script language-javascript"><span class="token punctuation">=</span><span class="token punctuation">{</span><span class="token number">1</span><span class="token punctuation">}</span></span> <span class="token attr-name">display</span><span class="token script language-javascript"><span class="token punctuation">=</span><span class="token punctuation">{</span>Display<span class="token punctuation">.</span>InlineBlock<span class="token punctuation">}</span></span> <span class="token attr-name">background</span><span class="token script language-javascript"><span class="token punctuation">=</span><span class="token punctuation">{</span>Background<span class="token punctuation">.</span>Accent<span class="token punctuation">}</span></span><span class="token punctuation">></span></span>\n  <span class="token tag"><span class="token tag"><span class="token punctuation">&lt;</span>CoreText</span> <span class="token attr-name">color</span><span class="token script language-javascript"><span class="token punctuation">=</span><span class="token punctuation">{</span>Color<span class="token punctuation">.</span>Overlay<span class="token punctuation">}</span></span><span class="token punctuation">></span></span>•<span class="token tag"><span class="token tag"><span class="token punctuation">&lt;/</span>CoreText</span><span class="token punctuation">></span></span>\n<span class="token tag"><span class="token tag"><span class="token punctuation">&lt;/</span>StyledLayout</span><span class="token punctuation">></span></span>\n<span class="token tag"><span class="token tag"><span class="token punctuation">&lt;</span>StyledLayout</span> <span class="token attr-name">padding</span><span class="token script language-javascript"><span class="token punctuation">=</span><span class="token punctuation">{</span><span class="token punctuation">{</span> x<span class="token punctuation">:</span> <span class="token number">4</span><span class="token punctuation">,</span> y<span class="token punctuation">:</span> <span class="token number">2</span> <span class="token punctuation">}</span><span class="token punctuation">}</span></span> <span class="token attr-name">margin</span><span class="token script language-javascript"><span class="token punctuation">=</span><span class="token punctuation">{</span><span class="token number">1</span><span class="token punctuation">}</span></span> <span class="token attr-name">display</span><span class="token script language-javascript"><span class="token punctuation">=</span><span class="token punctuation">{</span>Display<span class="token punctuation">.</span>InlineBlock<span class="token punctuation">}</span></span> <span class="token attr-name">background</span><span class="token script language-javascript"><span class="token punctuation">=</span><span class="token punctuation">{</span>Background<span class="token punctuation">.</span>Accent<span class="token punctuation">}</span></span><span class="token punctuation">></span></span>\n  <span class="token tag"><span class="token tag"><span class="token punctuation">&lt;</span>CoreText</span> <span class="token attr-name">color</span><span class="token script language-javascript"><span class="token punctuation">=</span><span class="token punctuation">{</span>Color<span class="token punctuation">.</span>Overlay<span class="token punctuation">}</span></span><span class="token punctuation">></span></span>•<span class="token tag"><span class="token tag"><span class="token punctuation">&lt;/</span>CoreText</span><span class="token punctuation">></span></span>\n<span class="token tag"><span class="token tag"><span class="token punctuation">&lt;/</span>StyledLayout</span><span class="token punctuation">></span></span>\n<span class="token tag"><span class="token tag"><span class="token punctuation">&lt;</span>StyledLayout</span> <span class="token attr-name">padding</span><span class="token script language-javascript"><span class="token punctuation">=</span><span class="token punctuation">{</span><span class="token punctuation">{</span> left<span class="token punctuation">:</span> <span class="token number">5</span><span class="token punctuation">,</span> right<span class="token punctuation">:</span> <span class="token number">3</span><span class="token punctuation">,</span> y<span class="token punctuation">:</span> <span class="token number">2</span> <span class="token punctuation">}</span><span class="token punctuation">}</span></span> <span class="token attr-name">margin</span><span class="token script language-javascript"><span class="token punctuation">=</span><span class="token punctuation">{</span><span class="token number">1</span><span class="token punctuation">}</span></span> <span class="token attr-name">display</span><span class="token script language-javascript"><span class="token punctuation">=</span><span class="token punctuation">{</span>Display<span class="token punctuation">.</span>InlineBlock<span class="token punctuation">}</span></span> <span class="token attr-name">background</span><span class="token script language-javascript"><span class="token punctuation">=</span><span class="token punctuation">{</span>Background<span class="token punctuation">.</span>Accent<span class="token punctuation">}</span></span><span class="token punctuation">></span></span>\n  <span class="token tag"><span class="token tag"><span class="token punctuation">&lt;</span>CoreText</span> <span class="token attr-name">color</span><span class="token script language-javascript"><span class="token punctuation">=</span><span class="token punctuation">{</span>Color<span class="token punctuation">.</span>Overlay<span class="token punctuation">}</span></span><span class="token punctuation">></span></span>•<span class="token tag"><span class="token tag"><span class="token punctuation">&lt;/</span>CoreText</span><span class="token punctuation">></span></span>\n<span class="token tag"><span class="token tag"><span class="token punctuation">&lt;/</span>StyledLayout</span><span class="token punctuation">></span></span>\n<span class="token tag"><span class="token tag"><span class="token punctuation">&lt;/</span>div</span><span class="token punctuation">></span></span>\n</code></pre>\n      </div>\n<h2 id="injecting-layout"><a href="#injecting-layout" aria-hidden="true" class="anchor"><svg aria-hidden="true" height="16" version="1.1" viewBox="0 0 16 16" width="16"><path fill-rule="evenodd" d="M4 9h1v1H4c-1.5 0-3-1.69-3-3.5S2.55 3 4 3h4c1.45 0 3 1.69 3 3.5 0 1.41-.91 2.72-2 3.25V8.59c.58-.45 1-1.27 1-2.09C10 5.22 8.98 4 8 4H4c-.98 0-2 1.22-2 2.5S3 9 4 9zm9-3h-1v1h1c1 0 2 1.22 2 2.5S13.98 12 13 12H9c-.98 0-2-1.22-2-2.5 0-.83.42-1.64 1-2.09V6.25c-1.09.53-2 1.84-2 3.25C6 11.31 7.55 13 9 13h4c1.45 0 3-1.69 3-3.5S14.5 6 13 6z"></path></svg></a>Injecting Layout</h2>\n<p>In some cases, it may be necessary to not wrap an element with a <code>Layout</code> but instead, pass those properties onto the element itself. <code>InjectLayout</code> can be used to <em>inject</em> these properties into any elements that accept classnames (<code>core-ui</code> elements <em>do not</em> accept classnames).</p>\n<h3 id="element-with-event-handlers"><a href="#element-with-event-handlers" aria-hidden="true" class="anchor"><svg aria-hidden="true" height="16" version="1.1" viewBox="0 0 16 16" width="16"><path fill-rule="evenodd" d="M4 9h1v1H4c-1.5 0-3-1.69-3-3.5S2.55 3 4 3h4c1.45 0 3 1.69 3 3.5 0 1.41-.91 2.72-2 3.25V8.59c.58-.45 1-1.27 1-2.09C10 5.22 8.98 4 8 4H4c-.98 0-2 1.22-2 2.5S3 9 4 9zm9-3h-1v1h1c1 0 2 1.22 2 2.5S13.98 12 13 12H9c-.98 0-2-1.22-2-2.5 0-.83.42-1.64 1-2.09V6.25c-1.09.53-2 1.84-2 3.25C6 11.31 7.55 13 9 13h4c1.45 0 3-1.69 3-3.5S14.5 6 13 6z"></path></svg></a>Element with Event Handlers</h3>\n<p>Because <code>Layout</code> is designed to be used specifically for laying out elements, it does not accept event handlers. To modify the layout of an interactable element or component, wrap it in an <code>InjectLayout</code> with the desired <code>Layout</code> properties.</p>\n<div class="gatsby-highlight">\n      <pre class="language-jsx"><code><span class="token tag"><span class="token tag"><span class="token punctuation">&lt;</span>InjectLayout</span> <span class="token attr-name">padding</span><span class="token script language-javascript"><span class="token punctuation">=</span><span class="token punctuation">{</span><span class="token number">2</span><span class="token punctuation">}</span></span><span class="token punctuation">></span></span>\n  <span class="token tag"><span class="token tag"><span class="token punctuation">&lt;</span>button</span> <span class="token attr-name">onClick</span><span class="token script language-javascript"><span class="token punctuation">=</span><span class="token punctuation">{</span><span class="token punctuation">(</span><span class="token punctuation">)</span><span class="token operator">=></span><span class="token punctuation">{</span> <span class="token function">alert</span><span class="token punctuation">(</span><span class="token string">\'Clicked\'</span><span class="token punctuation">)</span> <span class="token punctuation">}</span><span class="token punctuation">}</span></span><span class="token punctuation">></span></span>\n    Clickable Element\n  <span class="token tag"><span class="token tag"><span class="token punctuation">&lt;/</span>button</span><span class="token punctuation">></span></span>\n<span class="token tag"><span class="token tag"><span class="token punctuation">&lt;/</span>InjectLayout</span><span class="token punctuation">></span></span>\n</code></pre>\n      </div>',
frontmatter:{component:{id:"components/layout",disablePlayground:!0},title:""},headings:[{value:"Example: FlexBox with images and text",depth:2},{value:"Example: Vertical centering elements in a row",depth:2},{value:"Example: Stacking and anchoring",depth:2},{value:"Example: Stacking and centering",depth:2},{value:"Example: Flex Columns (All Viewport Sizes)",depth:2},{value:"Example: Responsive Flex Columns and Rows",depth:2},{value:"Padding",depth:2},{value:"All Sides",depth:3},{value:"By Side",depth:3},{value:"Injecting Layout",depth:2},{value:"Element with Event Handlers",depth:3}]}},github:{items:[{sha:"fa2a6eac9480afbb350f1f1c508d2a6edd81b91f",htmlUrl:"https://git-aws.internal.justin.tv/web/core-ui/commit/fa2a6eac9480afbb350f1f1c508d2a6edd81b91f",commit:{message:"Updated to string enums",committer:{date:"2018-02-28T21:15:18Z"}},author:{login:"jpanter",avatarUrl:"https://git-aws.internal.justin.tv/avatars/u/788?",htmlUrl:"https://git-aws.internal.justin.tv/jpanter"}},{sha:"bfe5b09cbee257d888959a6dd92c968e90388f6d",htmlUrl:"https://git-aws.internal.justin.tv/web/core-ui/commit/bfe5b09cbee257d888959a6dd92c968e90388f6d",commit:{message:"Merge branch 'master' into cg-auto-docs",committer:{date:"2018-02-20T22:44:23Z"}},author:{login:"cgrffit",avatarUrl:"https://git-aws.internal.justin.tv/avatars/u/707?",htmlUrl:"https://git-aws.internal.justin.tv/cgrffit"}},{sha:"b99df674700f093fd34ad96a6809c3bbd3678cb2",htmlUrl:"https://git-aws.internal.justin.tv/web/core-ui/commit/b99df674700f093fd34ad96a6809c3bbd3678cb2",commit:{message:"Add verticalAlign prop to Layout and update how Text can take that property",committer:{date:"2018-02-16T22:55:03Z"}},author:{login:"cgrffit",avatarUrl:"https://git-aws.internal.justin.tv/avatars/u/707?",htmlUrl:"https://git-aws.internal.justin.tv/cgrffit"}},{sha:"0b0f7ec37cdd6203789d5789da78d1f810dfea16",htmlUrl:"https://git-aws.internal.justin.tv/web/core-ui/commit/0b0f7ec37cdd6203789d5789da78d1f810dfea16",commit:{message:"Add documentation",committer:{date:"2018-02-12T19:46:16Z"}},author:{login:"cgrffit",avatarUrl:"https://git-aws.internal.justin.tv/avatars/u/707?",htmlUrl:"https://git-aws.internal.justin.tv/cgrffit"}},{sha:"af0a1a78218edf9c0720197153022b37f38be4c6",htmlUrl:"https://git-aws.internal.justin.tv/web/core-ui/commit/af0a1a78218edf9c0720197153022b37f38be4c6",commit:{message:"Add breakpoint compatible flag",committer:{date:"2018-02-05T23:29:05Z"}},author:{login:"cgrffit",avatarUrl:"https://git-aws.internal.justin.tv/avatars/u/707?",htmlUrl:"https://git-aws.internal.justin.tv/cgrffit"}},{sha:"534a12da823f18285e2526ea5c9fbd355aca5397",htmlUrl:"https://git-aws.internal.justin.tv/web/core-ui/commit/534a12da823f18285e2526ea5c9fbd355aca5397",commit:{message:"Add ability to disable playground links for components that ready for it yet",committer:{date:"2018-01-27T00:15:29Z"}},author:{login:"cgrffit",avatarUrl:"https://git-aws.internal.justin.tv/avatars/u/707?",htmlUrl:"https://git-aws.internal.justin.tv/cgrffit"}},{sha:"e16ccb433fc75c450e014c812d5c6249f6b6a94f",htmlUrl:"https://git-aws.internal.justin.tv/web/core-ui/commit/e16ccb433fc75c450e014c812d5c6249f6b6a94f",commit:{message:"Merge branch 'master' into cg-auto-docs",committer:{date:"2018-01-17T19:36:31Z"}},author:{login:"cgrffit",avatarUrl:"https://git-aws.internal.justin.tv/avatars/u/707?",htmlUrl:"https://git-aws.internal.justin.tv/cgrffit"}},{sha:"b6c9858cf06e1d52b1a511c4bf4698de187d10b2",htmlUrl:"https://git-aws.internal.justin.tv/web/core-ui/commit/b6c9858cf06e1d52b1a511c4bf4698de187d10b2",commit:{message:"Better redirects and move content to docs/data",committer:{date:"2018-01-17T01:42:29Z"}},author:{login:"cgrffit",avatarUrl:"https://git-aws.internal.justin.tv/avatars/u/707?",htmlUrl:"https://git-aws.internal.justin.tv/cgrffit"}},{sha:"f2f4b87fbd0a72a104fbf807a1243073a5fe0f00",htmlUrl:"https://git-aws.internal.justin.tv/web/core-ui/commit/f2f4b87fbd0a72a104fbf807a1243073a5fe0f00",commit:{message:"Updated docs for visibility utility classes",committer:{date:"2018-01-04T19:11:33Z"}},author:null},{sha:"dbb57f53689a8f54233ee1cccd00926e148ce587",htmlUrl:"https://git-aws.internal.justin.tv/web/core-ui/commit/dbb57f53689a8f54233ee1cccd00926e148ce587",commit:{message:"Prefixing helpers",committer:{date:"2017-12-06T23:11:27Z"}},author:{login:"jpanter",avatarUrl:"https://git-aws.internal.justin.tv/avatars/u/788?",htmlUrl:"https://git-aws.internal.justin.tv/jpanter"}},{sha:"1c3aafee9294e64b5a8807a3e584619da1aef4ff",htmlUrl:"https://git-aws.internal.justin.tv/web/core-ui/commit/1c3aafee9294e64b5a8807a3e584619da1aef4ff",commit:{message:"Remove import statements from readme's so they can be automatically generated",committer:{date:"2017-11-30T18:53:33Z"}},author:{login:"cgrffit",avatarUrl:"https://git-aws.internal.justin.tv/avatars/u/707?",htmlUrl:"https://git-aws.internal.justin.tv/cgrffit"}},{sha:"c0a1af35825e9f1a58f93dc32e594cc3f9baaf2f",htmlUrl:"https://git-aws.internal.justin.tv/web/core-ui/commit/c0a1af35825e9f1a58f93dc32e594cc3f9baaf2f",commit:{message:"Add docs and remove remaining console errors",committer:{date:"2017-11-30T18:23:37Z"}},author:{login:"cgrffit",avatarUrl:"https://git-aws.internal.justin.tv/avatars/u/707?",htmlUrl:"https://git-aws.internal.justin.tv/cgrffit"}},{sha:"df6040c70cd5c6366b403069ed3789f4b060e048",htmlUrl:"https://git-aws.internal.justin.tv/web/core-ui/commit/df6040c70cd5c6366b403069ed3789f4b060e048",commit:{message:"Update markdown styles and readme content",committer:{date:"2017-11-21T02:37:20Z"}},author:{login:"cgrffit",avatarUrl:"https://git-aws.internal.justin.tv/avatars/u/707?",htmlUrl:"https://git-aws.internal.justin.tv/cgrffit"}},{sha:"097be7d5616a7291222371061fbd6cd46eae0b90",htmlUrl:"https://git-aws.internal.justin.tv/web/core-ui/commit/097be7d5616a7291222371061fbd6cd46eae0b90",commit:{message:"Get reference values for aliases and enums",committer:{date:"2017-11-20T23:17:39Z"}},author:{login:"cgrffit",avatarUrl:"https://git-aws.internal.justin.tv/avatars/u/707?",htmlUrl:"https://git-aws.internal.justin.tv/cgrffit"}},{sha:"334e9bc30a18881a9f164fd648fabe5d26428932",htmlUrl:"https://git-aws.internal.justin.tv/web/core-ui/commit/334e9bc30a18881a9f164fd648fabe5d26428932",commit:{message:"Remove prop tables from readmes",committer:{date:"2017-11-18T01:48:25Z"}},author:{login:"cgrffit",avatarUrl:"https://git-aws.internal.justin.tv/avatars/u/707?",htmlUrl:"https://git-aws.internal.justin.tv/cgrffit"}},{sha:"23bb5275bc7b535e278aee6b548fbc83919f9212",htmlUrl:"https://git-aws.internal.justin.tv/web/core-ui/commit/23bb5275bc7b535e278aee6b548fbc83919f9212",commit:{message:"More content updates",committer:{date:"2017-11-17T01:05:40Z"}},author:{login:"cgrffit",avatarUrl:"https://git-aws.internal.justin.tv/avatars/u/707?",htmlUrl:"https://git-aws.internal.justin.tv/cgrffit"}},{sha:"0d45cebd45c3c595ac19735af42ac700f1f9649b",htmlUrl:"https://git-aws.internal.justin.tv/web/core-ui/commit/0d45cebd45c3c595ac19735af42ac700f1f9649b",commit:{message:"Merge pull request #622 from web/cg-docs-update\n\nUpdate README, CONTRIBUTING, and component docs",committer:{date:"2017-10-25T21:56:43Z"}},author:{login:"shusterm",avatarUrl:"https://git-aws.internal.justin.tv/avatars/u/406?",htmlUrl:"https://git-aws.internal.justin.tv/shusterm"}},{sha:"f73c31784e1238734d07d3b78c7066c092b3fb29",htmlUrl:"https://git-aws.internal.justin.tv/web/core-ui/commit/f73c31784e1238734d07d3b78c7066c092b3fb29",commit:{message:"Add wrap-reverse class and enum. Resolves #656.",committer:{date:"2017-10-25T17:47:13Z"}},author:{login:"cgrffit",avatarUrl:"https://git-aws.internal.justin.tv/avatars/u/707?",htmlUrl:"https://git-aws.internal.justin.tv/cgrffit"}},{sha:"ec0d8a1a4a38a98fd76994dd25f6333392df1ffc",htmlUrl:"https://git-aws.internal.justin.tv/web/core-ui/commit/ec0d8a1a4a38a98fd76994dd25f6333392df1ffc",commit:{message:"Add tab prop docs",committer:{date:"2017-10-17T23:38:34Z"}},author:{login:"cgrffit",avatarUrl:"https://git-aws.internal.justin.tv/avatars/u/707?",htmlUrl:"https://git-aws.internal.justin.tv/cgrffit"}},{sha:"88695671a79480195a8bea8ee0a86d68dc61ce07",htmlUrl:"https://git-aws.internal.justin.tv/web/core-ui/commit/88695671a79480195a8bea8ee0a86d68dc61ce07",commit:{message:"Add stat, styledlayout, and svg prop docs",committer:{date:"2017-10-17T23:18:13Z"}},author:{login:"cgrffit",avatarUrl:"https://git-aws.internal.justin.tv/avatars/u/707?",htmlUrl:"https://git-aws.internal.justin.tv/cgrffit"}},{sha:"f3d684bcdbebbc9f8e3e3b87460b01c8ca3d9502",htmlUrl:"https://git-aws.internal.justin.tv/web/core-ui/commit/f3d684bcdbebbc9f8e3e3b87460b01c8ca3d9502",commit:{message:"Merge branch 'master' into cg-docs-update",committer:{date:"2017-10-17T21:30:15Z"}},author:{login:"cgrffit",avatarUrl:"https://git-aws.internal.justin.tv/avatars/u/707?",htmlUrl:"https://git-aws.internal.justin.tv/cgrffit"}},{sha:"975bb85e72a8005d30a60a9fd4f0a5ebcee7aa1b",htmlUrl:"https://git-aws.internal.justin.tv/web/core-ui/commit/975bb85e72a8005d30a60a9fd4f0a5ebcee7aa1b",commit:{message:"Add live indicator and loading spinner docs",committer:{date:"2017-10-17T21:23:10Z"}},author:{login:"cgrffit",avatarUrl:"https://git-aws.internal.justin.tv/avatars/u/707?",htmlUrl:"https://git-aws.internal.justin.tv/cgrffit"}},{sha:"aa13ead05b3b783b0945a960f0cfa69aa427b460",htmlUrl:"https://git-aws.internal.justin.tv/web/core-ui/commit/aa13ead05b3b783b0945a960f0cfa69aa427b460",commit:{message:"Finish layout docs",committer:{date:"2017-10-17T21:18:07Z"}},author:{login:"cgrffit",avatarUrl:"https://git-aws.internal.justin.tv/avatars/u/707?",htmlUrl:"https://git-aws.internal.justin.tv/cgrffit"}},{sha:"390a5ca0361e7d40729f3a1aacda0bf488e8c7b0",htmlUrl:"https://git-aws.internal.justin.tv/web/core-ui/commit/390a5ca0361e7d40729f3a1aacda0bf488e8c7b0",commit:{message:"Finish layout docs",committer:{date:"2017-10-17T21:14:31Z"}},author:{login:"cgrffit",avatarUrl:"https://git-aws.internal.justin.tv/avatars/u/707?",htmlUrl:"https://git-aws.internal.justin.tv/cgrffit"}},{sha:"8a1e8b23e3474001162870d54ce59baf4f9f55cd",htmlUrl:"https://git-aws.internal.justin.tv/web/core-ui/commit/8a1e8b23e3474001162870d54ce59baf4f9f55cd",commit:{message:"Moving `fullHeight` & `fullWidth` to default props out of breakpoint props for clarification of what they are actually used for",committer:{date:"2017-10-17T20:08:30Z"}},author:{login:"jpanter",avatarUrl:"https://git-aws.internal.justin.tv/avatars/u/788?",htmlUrl:"https://git-aws.internal.justin.tv/jpanter"}},{sha:"c3ba67465626c979db388d631cd66d1eafba63c7",htmlUrl:"https://git-aws.internal.justin.tv/web/core-ui/commit/c3ba67465626c979db388d631cd66d1eafba63c7",commit:{message:"Add grid, interactable, and layout prop docs",committer:{date:"2017-10-16T22:08:04Z"}},author:{login:"cgrffit",avatarUrl:"https://git-aws.internal.justin.tv/avatars/u/707?",htmlUrl:"https://git-aws.internal.justin.tv/cgrffit"}},{sha:"356869dfeb5d6a887a8b32b87b54e36c641536bb",htmlUrl:"https://git-aws.internal.justin.tv/web/core-ui/commit/356869dfeb5d6a887a8b32b87b54e36c641536bb",commit:{message:"Add remaining READMEs",committer:{date:"2017-10-16T21:28:19Z"}},author:{login:"cgrffit",avatarUrl:"https://git-aws.internal.justin.tv/avatars/u/707?",htmlUrl:"https://git-aws.internal.justin.tv/cgrffit"}},{sha:"39f8b7454f445335d66494b2231a1a126168ed40",htmlUrl:"https://git-aws.internal.justin.tv/web/core-ui/commit/39f8b7454f445335d66494b2231a1a126168ed40",commit:{message:"simplified className calls",committer:{date:"2017-08-16T17:02:56Z"}},author:{login:"jpanter",avatarUrl:"https://git-aws.internal.justin.tv/avatars/u/788?",htmlUrl:"https://git-aws.internal.justin.tv/jpanter"}},{sha:"02d70d5a3c5f5076422709243e3027eaa68d3f47",htmlUrl:"https://git-aws.internal.justin.tv/web/core-ui/commit/02d70d5a3c5f5076422709243e3027eaa68d3f47",commit:{message:"Created intractable component",committer:{date:"2017-08-09T02:02:00Z"}},author:{login:"jpanter",avatarUrl:"https://git-aws.internal.justin.tv/avatars/u/788?",htmlUrl:"https://git-aws.internal.justin.tv/jpanter"}},{sha:"b89376151dee6809ad48c1fdc7f277828d388b01",htmlUrl:"https://git-aws.internal.justin.tv/web/core-ui/commit/b89376151dee6809ad48c1fdc7f277828d388b01",commit:{message:"functional tools for z-index",committer:{date:"2017-08-04T00:30:58Z"}},author:{login:"shusterm",avatarUrl:"https://git-aws.internal.justin.tv/avatars/u/406?",htmlUrl:"https://git-aws.internal.justin.tv/shusterm"}}]},component:{name:"InjectLayout",comment:null,properties:[{name:"alignContent",flags:{isOptional:!0},type:"AlignContent",comment:null,availableValues:["Baseline","Center","End","Start","Stretch"],breakpointCompatible:!0},{name:"alignItems",flags:{isOptional:!0},type:"AlignItems",comment:null,availableValues:["Baseline","Center","End","Start","Stretch"],breakpointCompatible:!0},{name:"alignSelf",flags:{isOptional:!0},type:"AlignSelf",comment:null,availableValues:["Baseline","Center","End","Start","Stretch"],breakpointCompatible:!0},{name:"attachBottom",flags:{isOptional:!0},type:"boolean",comment:null,availableValues:[],breakpointCompatible:!1},{name:"attachLeft",flags:{isOptional:!0},type:"boolean",comment:null,availableValues:[],breakpointCompatible:!1},{name:"attachRight",flags:{isOptional:!0},type:"boolean",comment:null,availableValues:[],breakpointCompatible:!1},{name:"attachTop",flags:{isOptional:!0},type:"boolean",comment:null,availableValues:[],breakpointCompatible:!1},{name:"children",flags:{isOptional:!0},type:"React.ReactNode",comment:null,availableValues:[],breakpointCompatible:!1},{name:"className",flags:{isOptional:!0},type:"string",comment:null,availableValues:[],breakpointCompatible:!1},{name:"display",flags:{isOptional:!0},type:"Display",comment:null,availableValues:["Block","Flex","Hide","HideAccessible","Inline","InlineBlock","InlineFlex"],breakpointCompatible:!0},{name:"ellipsis",flags:{isOptional:!0},type:"boolean",comment:null,availableValues:[],breakpointCompatible:!1},{name:"flexDirection",flags:{isOptional:!0},type:"FlexDirection",comment:null,availableValues:["Column","ColumnReverse","Row","RowReverse"],breakpointCompatible:!0},{name:"flexGrow",flags:{isOptional:!0},type:"FlexValue",comment:null,availableValues:["0","1","2","3","4"],breakpointCompatible:!0},{name:"flexOrder",flags:{isOptional:!0},type:"FlexValue",comment:null,availableValues:["0","1","2","3","4"],breakpointCompatible:!0},{name:"flexShrink",flags:{isOptional:!0},type:"FlexValue",comment:null,availableValues:["0","1","2","3","4"],breakpointCompatible:!0},{name:"flexWrap",flags:{isOptional:!0},type:"FlexWrap",comment:null,availableValues:["NoWrap","Wrap","WrapReverse"],breakpointCompatible:!0},{name:"fullHeight",flags:{isOptional:!0},type:"boolean",comment:null,availableValues:[],breakpointCompatible:!1},{name:"fullWidth",flags:{isOptional:!0},type:"boolean",comment:null,availableValues:[],breakpointCompatible:!1},{name:"justifyContent",flags:{isOptional:!0},type:"JustifyContent",comment:null,availableValues:["Around","Between","Center","End","Start"],breakpointCompatible:!0},{name:"margin",flags:{isOptional:!0},type:"Margin",comment:null,availableValues:["MarginValue","MarginValues"],breakpointCompatible:!0},{name:"overflow",flags:{isOptional:!0},type:"Overflow",comment:null,availableValues:["Auto","Hidden","Scroll","Visible"],breakpointCompatible:!1},{name:"padding",flags:{isOptional:!0},type:"Padding",comment:null,availableValues:["PaddingValue","PaddingValues"],breakpointCompatible:!0},{name:"position",flags:{isOptional:!0},type:"Position",comment:null,availableValues:["Absolute","Fixed","Relative"],breakpointCompatible:!0},{name:"refDelegate",flags:{isOptional:!0},type:null,comment:null,availableValues:[],breakpointCompatible:!1},{name:"resize",flags:{isOptional:!0},type:"Resize",comment:null,availableValues:["None","X","Y"],breakpointCompatible:!1},{name:"textAlign",flags:{isOptional:!0},type:"TextAlign",comment:null,availableValues:["Center","Left","Right"],breakpointCompatible:!0},{name:"verticalAlign",flags:{isOptional:!0},type:"VerticalAlign",comment:null,availableValues:["Baseline","Bottom","Middle","TextBottom","TextTop","Top"],breakpointCompatible:!1},{name:"visibility",flags:{isOptional:!0},type:"Visibility",comment:null,availableValues:["Hidden","Visible"],breakpointCompatible:!0},{name:"zIndex",flags:{isOptional:!0},type:"ZIndex",comment:null,availableValues:["Above","Below","Default"],breakpointCompatible:!1}]}},pathContext:{componentPagePath:"/user-interface/components/layout",componentId:"components/layout"}}}});
//# sourceMappingURL=path---user-interface-components-layout-b5ffcfd8904f9e020d74.js.map