webpackJsonp([63227969863842],{969:function(a,n){a.exports={data:{page:{modifiedTime:"2018-04-03T17:55:28.000Z",fields:{title:"Tower",slug:"tower",path:"/user-interface/components/tower",segments:[{title:"User Interface",slug:"user-interface"},{title:"Components",slug:"components"},{title:"Tower",slug:"tower"}]},childMarkdownRemark:{html:'<h2 id="when-to-use-tower"><a href="#when-to-use-tower" aria-hidden="true" class="anchor"><svg aria-hidden="true" height="16" version="1.1" viewBox="0 0 16 16" width="16"><path fill-rule="evenodd" d="M4 9h1v1H4c-1.5 0-3-1.69-3-3.5S2.55 3 4 3h4c1.45 0 3 1.69 3 3.5 0 1.41-.91 2.72-2 3.25V8.59c.58-.45 1-1.27 1-2.09C10 5.22 8.98 4 8 4H4c-.98 0-2 1.22-2 2.5S3 9 4 9zm9-3h-1v1h1c1 0 2 1.22 2 2.5S13.98 12 13 12H9c-.98 0-2-1.22-2-2.5 0-.83.42-1.64 1-2.09V6.25c-1.09.53-2 1.84-2 3.25C6 11.31 7.55 13 9 13h4c1.45 0 3-1.69 3-3.5S14.5 6 13 6z"></path></svg></a>When to Use Tower</h2>\n<p>Use <code>Tower</code> to lay out items of the same size while maintaining consistently fixed size gutters and the ability to have edge-to-edge coverage – for example, on the <a href="https://www.twitch.tv/directory">Browse</a> page. This approach is especially usefully where the width of the wrapping layout can scale to infinity and the number of items in a row is variable as it will ensure that enough items always fill their container\'s width.</p>\n<h2 id="basic-usage"><a href="#basic-usage" aria-hidden="true" class="anchor"><svg aria-hidden="true" height="16" version="1.1" viewBox="0 0 16 16" width="16"><path fill-rule="evenodd" d="M4 9h1v1H4c-1.5 0-3-1.69-3-3.5S2.55 3 4 3h4c1.45 0 3 1.69 3 3.5 0 1.41-.91 2.72-2 3.25V8.59c.58-.45 1-1.27 1-2.09C10 5.22 8.98 4 8 4H4c-.98 0-2 1.22-2 2.5S3 9 4 9zm9-3h-1v1h1c1 0 2 1.22 2 2.5S13.98 12 13 12H9c-.98 0-2-1.22-2-2.5 0-.83.42-1.64 1-2.09V6.25c-1.09.53-2 1.84-2 3.25C6 11.31 7.55 13 9 13h4c1.45 0 3-1.69 3-3.5S14.5 6 13 6z"></path></svg></a>Basic Usage</h2>\n<div class="gatsby-highlight">\n      <pre class="language-jsx"><code><span class="token tag"><span class="token tag"><span class="token punctuation">&lt;</span>Tower</span>\n  <span class="token attr-name">childWidth</span><span class="token script language-javascript"><span class="token punctuation">=</span><span class="token punctuation">{</span>TowerChildWidth<span class="token punctuation">.</span>Small<span class="token punctuation">}</span></span>\n  <span class="token attr-name">gutterSize</span><span class="token script language-javascript"><span class="token punctuation">=</span><span class="token punctuation">{</span>TowerGutter<span class="token punctuation">.</span>Small<span class="token punctuation">}</span></span>\n  <span class="token attr-name">placeholderItems</span><span class="token script language-javascript"><span class="token punctuation">=</span><span class="token punctuation">{</span><span class="token number">20</span><span class="token punctuation">}</span></span>\n<span class="token punctuation">></span></span>\n  <span class="token tag"><span class="token tag"><span class="token punctuation">&lt;</span>div</span><span class="token punctuation">></span></span>\n    <span class="token tag"><span class="token tag"><span class="token punctuation">&lt;</span>StyledLayout</span> <span class="token attr-name">background</span><span class="token script language-javascript"><span class="token punctuation">=</span><span class="token punctuation">{</span>Background<span class="token punctuation">.</span>Accent<span class="token punctuation">}</span></span> <span class="token attr-name">color</span><span class="token script language-javascript"><span class="token punctuation">=</span><span class="token punctuation">{</span>Color<span class="token punctuation">.</span>Overlay<span class="token punctuation">}</span></span> <span class="token attr-name">padding</span><span class="token script language-javascript"><span class="token punctuation">=</span><span class="token punctuation">{</span><span class="token number">2</span><span class="token punctuation">}</span></span> <span class="token attr-name">margin</span><span class="token script language-javascript"><span class="token punctuation">=</span><span class="token punctuation">{</span><span class="token punctuation">{</span> bottom<span class="token punctuation">:</span> <span class="token number">1</span> <span class="token punctuation">}</span><span class="token punctuation">}</span></span> <span class="token attr-name">display</span><span class="token script language-javascript"><span class="token punctuation">=</span><span class="token punctuation">{</span>Display<span class="token punctuation">.</span>Flex<span class="token punctuation">}</span></span> <span class="token attr-name">justifyContent</span><span class="token script language-javascript"><span class="token punctuation">=</span><span class="token punctuation">{</span>JustifyContent<span class="token punctuation">.</span>Center<span class="token punctuation">}</span></span> <span class="token attr-name">alignItems</span><span class="token script language-javascript"><span class="token punctuation">=</span><span class="token punctuation">{</span>AlignItems<span class="token punctuation">.</span>Center<span class="token punctuation">}</span></span><span class="token punctuation">></span></span>\n      <span class="token tag"><span class="token tag"><span class="token punctuation">&lt;</span>CoreText</span> <span class="token attr-name">fontSize</span><span class="token script language-javascript"><span class="token punctuation">=</span><span class="token punctuation">{</span>FontSize<span class="token punctuation">.</span>Size2<span class="token punctuation">}</span></span><span class="token punctuation">></span></span>A<span class="token tag"><span class="token tag"><span class="token punctuation">&lt;/</span>CoreText</span><span class="token punctuation">></span></span>\n    <span class="token tag"><span class="token tag"><span class="token punctuation">&lt;/</span>StyledLayout</span><span class="token punctuation">></span></span>\n  <span class="token tag"><span class="token tag"><span class="token punctuation">&lt;/</span>div</span><span class="token punctuation">></span></span>\n  <span class="token tag"><span class="token tag"><span class="token punctuation">&lt;</span>div</span><span class="token punctuation">></span></span>\n    <span class="token tag"><span class="token tag"><span class="token punctuation">&lt;</span>StyledLayout</span> <span class="token attr-name">background</span><span class="token script language-javascript"><span class="token punctuation">=</span><span class="token punctuation">{</span>Background<span class="token punctuation">.</span>Accent<span class="token punctuation">}</span></span> <span class="token attr-name">color</span><span class="token script language-javascript"><span class="token punctuation">=</span><span class="token punctuation">{</span>Color<span class="token punctuation">.</span>Overlay<span class="token punctuation">}</span></span> <span class="token attr-name">padding</span><span class="token script language-javascript"><span class="token punctuation">=</span><span class="token punctuation">{</span><span class="token number">2</span><span class="token punctuation">}</span></span> <span class="token attr-name">margin</span><span class="token script language-javascript"><span class="token punctuation">=</span><span class="token punctuation">{</span><span class="token punctuation">{</span> bottom<span class="token punctuation">:</span> <span class="token number">1</span> <span class="token punctuation">}</span><span class="token punctuation">}</span></span> <span class="token attr-name">display</span><span class="token script language-javascript"><span class="token punctuation">=</span><span class="token punctuation">{</span>Display<span class="token punctuation">.</span>Flex<span class="token punctuation">}</span></span> <span class="token attr-name">justifyContent</span><span class="token script language-javascript"><span class="token punctuation">=</span><span class="token punctuation">{</span>JustifyContent<span class="token punctuation">.</span>Center<span class="token punctuation">}</span></span> <span class="token attr-name">alignItems</span><span class="token script language-javascript"><span class="token punctuation">=</span><span class="token punctuation">{</span>AlignItems<span class="token punctuation">.</span>Center<span class="token punctuation">}</span></span><span class="token punctuation">></span></span>\n      <span class="token tag"><span class="token tag"><span class="token punctuation">&lt;</span>CoreText</span> <span class="token attr-name">fontSize</span><span class="token script language-javascript"><span class="token punctuation">=</span><span class="token punctuation">{</span>FontSize<span class="token punctuation">.</span>Size2<span class="token punctuation">}</span></span><span class="token punctuation">></span></span>B<span class="token tag"><span class="token tag"><span class="token punctuation">&lt;/</span>CoreText</span><span class="token punctuation">></span></span>\n    <span class="token tag"><span class="token tag"><span class="token punctuation">&lt;/</span>StyledLayout</span><span class="token punctuation">></span></span>\n  <span class="token tag"><span class="token tag"><span class="token punctuation">&lt;/</span>div</span><span class="token punctuation">></span></span>\n  <span class="token tag"><span class="token tag"><span class="token punctuation">&lt;</span>div</span><span class="token punctuation">></span></span>\n    <span class="token tag"><span class="token tag"><span class="token punctuation">&lt;</span>StyledLayout</span> <span class="token attr-name">background</span><span class="token script language-javascript"><span class="token punctuation">=</span><span class="token punctuation">{</span>Background<span class="token punctuation">.</span>Accent<span class="token punctuation">}</span></span> <span class="token attr-name">color</span><span class="token script language-javascript"><span class="token punctuation">=</span><span class="token punctuation">{</span>Color<span class="token punctuation">.</span>Overlay<span class="token punctuation">}</span></span> <span class="token attr-name">padding</span><span class="token script language-javascript"><span class="token punctuation">=</span><span class="token punctuation">{</span><span class="token number">2</span><span class="token punctuation">}</span></span> <span class="token attr-name">margin</span><span class="token script language-javascript"><span class="token punctuation">=</span><span class="token punctuation">{</span><span class="token punctuation">{</span> bottom<span class="token punctuation">:</span> <span class="token number">1</span> <span class="token punctuation">}</span><span class="token punctuation">}</span></span> <span class="token attr-name">display</span><span class="token script language-javascript"><span class="token punctuation">=</span><span class="token punctuation">{</span>Display<span class="token punctuation">.</span>Flex<span class="token punctuation">}</span></span> <span class="token attr-name">justifyContent</span><span class="token script language-javascript"><span class="token punctuation">=</span><span class="token punctuation">{</span>JustifyContent<span class="token punctuation">.</span>Center<span class="token punctuation">}</span></span> <span class="token attr-name">alignItems</span><span class="token script language-javascript"><span class="token punctuation">=</span><span class="token punctuation">{</span>AlignItems<span class="token punctuation">.</span>Center<span class="token punctuation">}</span></span><span class="token punctuation">></span></span>\n      <span class="token tag"><span class="token tag"><span class="token punctuation">&lt;</span>CoreText</span> <span class="token attr-name">fontSize</span><span class="token script language-javascript"><span class="token punctuation">=</span><span class="token punctuation">{</span>FontSize<span class="token punctuation">.</span>Size2<span class="token punctuation">}</span></span><span class="token punctuation">></span></span>C<span class="token tag"><span class="token tag"><span class="token punctuation">&lt;/</span>CoreText</span><span class="token punctuation">></span></span>\n    <span class="token tag"><span class="token tag"><span class="token punctuation">&lt;/</span>StyledLayout</span><span class="token punctuation">></span></span>\n  <span class="token tag"><span class="token tag"><span class="token punctuation">&lt;/</span>div</span><span class="token punctuation">></span></span>\n  <span class="token tag"><span class="token tag"><span class="token punctuation">&lt;</span>div</span><span class="token punctuation">></span></span>\n    <span class="token tag"><span class="token tag"><span class="token punctuation">&lt;</span>StyledLayout</span> <span class="token attr-name">background</span><span class="token script language-javascript"><span class="token punctuation">=</span><span class="token punctuation">{</span>Background<span class="token punctuation">.</span>Accent<span class="token punctuation">}</span></span> <span class="token attr-name">color</span><span class="token script language-javascript"><span class="token punctuation">=</span><span class="token punctuation">{</span>Color<span class="token punctuation">.</span>Overlay<span class="token punctuation">}</span></span> <span class="token attr-name">padding</span><span class="token script language-javascript"><span class="token punctuation">=</span><span class="token punctuation">{</span><span class="token number">2</span><span class="token punctuation">}</span></span> <span class="token attr-name">margin</span><span class="token script language-javascript"><span class="token punctuation">=</span><span class="token punctuation">{</span><span class="token punctuation">{</span> bottom<span class="token punctuation">:</span> <span class="token number">1</span> <span class="token punctuation">}</span><span class="token punctuation">}</span></span> <span class="token attr-name">display</span><span class="token script language-javascript"><span class="token punctuation">=</span><span class="token punctuation">{</span>Display<span class="token punctuation">.</span>Flex<span class="token punctuation">}</span></span> <span class="token attr-name">justifyContent</span><span class="token script language-javascript"><span class="token punctuation">=</span><span class="token punctuation">{</span>JustifyContent<span class="token punctuation">.</span>Center<span class="token punctuation">}</span></span> <span class="token attr-name">alignItems</span><span class="token script language-javascript"><span class="token punctuation">=</span><span class="token punctuation">{</span>AlignItems<span class="token punctuation">.</span>Center<span class="token punctuation">}</span></span><span class="token punctuation">></span></span>\n      <span class="token tag"><span class="token tag"><span class="token punctuation">&lt;</span>CoreText</span> <span class="token attr-name">fontSize</span><span class="token script language-javascript"><span class="token punctuation">=</span><span class="token punctuation">{</span>FontSize<span class="token punctuation">.</span>Size2<span class="token punctuation">}</span></span><span class="token punctuation">></span></span>D<span class="token tag"><span class="token tag"><span class="token punctuation">&lt;/</span>CoreText</span><span class="token punctuation">></span></span>\n    <span class="token tag"><span class="token tag"><span class="token punctuation">&lt;/</span>StyledLayout</span><span class="token punctuation">></span></span>\n  <span class="token tag"><span class="token tag"><span class="token punctuation">&lt;/</span>div</span><span class="token punctuation">></span></span>\n  <span class="token tag"><span class="token tag"><span class="token punctuation">&lt;</span>div</span><span class="token punctuation">></span></span>\n    <span class="token tag"><span class="token tag"><span class="token punctuation">&lt;</span>StyledLayout</span> <span class="token attr-name">background</span><span class="token script language-javascript"><span class="token punctuation">=</span><span class="token punctuation">{</span>Background<span class="token punctuation">.</span>Accent<span class="token punctuation">}</span></span> <span class="token attr-name">color</span><span class="token script language-javascript"><span class="token punctuation">=</span><span class="token punctuation">{</span>Color<span class="token punctuation">.</span>Overlay<span class="token punctuation">}</span></span> <span class="token attr-name">padding</span><span class="token script language-javascript"><span class="token punctuation">=</span><span class="token punctuation">{</span><span class="token number">2</span><span class="token punctuation">}</span></span> <span class="token attr-name">margin</span><span class="token script language-javascript"><span class="token punctuation">=</span><span class="token punctuation">{</span><span class="token punctuation">{</span> bottom<span class="token punctuation">:</span> <span class="token number">1</span> <span class="token punctuation">}</span><span class="token punctuation">}</span></span> <span class="token attr-name">display</span><span class="token script language-javascript"><span class="token punctuation">=</span><span class="token punctuation">{</span>Display<span class="token punctuation">.</span>Flex<span class="token punctuation">}</span></span> <span class="token attr-name">justifyContent</span><span class="token script language-javascript"><span class="token punctuation">=</span><span class="token punctuation">{</span>JustifyContent<span class="token punctuation">.</span>Center<span class="token punctuation">}</span></span> <span class="token attr-name">alignItems</span><span class="token script language-javascript"><span class="token punctuation">=</span><span class="token punctuation">{</span>AlignItems<span class="token punctuation">.</span>Center<span class="token punctuation">}</span></span><span class="token punctuation">></span></span>\n      <span class="token tag"><span class="token tag"><span class="token punctuation">&lt;</span>CoreText</span> <span class="token attr-name">fontSize</span><span class="token script language-javascript"><span class="token punctuation">=</span><span class="token punctuation">{</span>FontSize<span class="token punctuation">.</span>Size2<span class="token punctuation">}</span></span><span class="token punctuation">></span></span>E<span class="token tag"><span class="token tag"><span class="token punctuation">&lt;/</span>CoreText</span><span class="token punctuation">></span></span>\n    <span class="token tag"><span class="token tag"><span class="token punctuation">&lt;/</span>StyledLayout</span><span class="token punctuation">></span></span>\n  <span class="token tag"><span class="token tag"><span class="token punctuation">&lt;/</span>div</span><span class="token punctuation">></span></span>\n  <span class="token tag"><span class="token tag"><span class="token punctuation">&lt;</span>div</span><span class="token punctuation">></span></span>\n    <span class="token tag"><span class="token tag"><span class="token punctuation">&lt;</span>StyledLayout</span> <span class="token attr-name">background</span><span class="token script language-javascript"><span class="token punctuation">=</span><span class="token punctuation">{</span>Background<span class="token punctuation">.</span>Accent<span class="token punctuation">}</span></span> <span class="token attr-name">color</span><span class="token script language-javascript"><span class="token punctuation">=</span><span class="token punctuation">{</span>Color<span class="token punctuation">.</span>Overlay<span class="token punctuation">}</span></span> <span class="token attr-name">padding</span><span class="token script language-javascript"><span class="token punctuation">=</span><span class="token punctuation">{</span><span class="token number">2</span><span class="token punctuation">}</span></span> <span class="token attr-name">margin</span><span class="token script language-javascript"><span class="token punctuation">=</span><span class="token punctuation">{</span><span class="token punctuation">{</span> bottom<span class="token punctuation">:</span> <span class="token number">1</span> <span class="token punctuation">}</span><span class="token punctuation">}</span></span> <span class="token attr-name">display</span><span class="token script language-javascript"><span class="token punctuation">=</span><span class="token punctuation">{</span>Display<span class="token punctuation">.</span>Flex<span class="token punctuation">}</span></span> <span class="token attr-name">justifyContent</span><span class="token script language-javascript"><span class="token punctuation">=</span><span class="token punctuation">{</span>JustifyContent<span class="token punctuation">.</span>Center<span class="token punctuation">}</span></span> <span class="token attr-name">alignItems</span><span class="token script language-javascript"><span class="token punctuation">=</span><span class="token punctuation">{</span>AlignItems<span class="token punctuation">.</span>Center<span class="token punctuation">}</span></span><span class="token punctuation">></span></span>\n      <span class="token tag"><span class="token tag"><span class="token punctuation">&lt;</span>CoreText</span> <span class="token attr-name">fontSize</span><span class="token script language-javascript"><span class="token punctuation">=</span><span class="token punctuation">{</span>FontSize<span class="token punctuation">.</span>Size2<span class="token punctuation">}</span></span><span class="token punctuation">></span></span>F<span class="token tag"><span class="token tag"><span class="token punctuation">&lt;/</span>CoreText</span><span class="token punctuation">></span></span>\n    <span class="token tag"><span class="token tag"><span class="token punctuation">&lt;/</span>StyledLayout</span><span class="token punctuation">></span></span>\n  <span class="token tag"><span class="token tag"><span class="token punctuation">&lt;/</span>div</span><span class="token punctuation">></span></span>\n  <span class="token tag"><span class="token tag"><span class="token punctuation">&lt;</span>div</span><span class="token punctuation">></span></span>\n    <span class="token tag"><span class="token tag"><span class="token punctuation">&lt;</span>StyledLayout</span> <span class="token attr-name">background</span><span class="token script language-javascript"><span class="token punctuation">=</span><span class="token punctuation">{</span>Background<span class="token punctuation">.</span>Accent<span class="token punctuation">}</span></span> <span class="token attr-name">color</span><span class="token script language-javascript"><span class="token punctuation">=</span><span class="token punctuation">{</span>Color<span class="token punctuation">.</span>Overlay<span class="token punctuation">}</span></span> <span class="token attr-name">padding</span><span class="token script language-javascript"><span class="token punctuation">=</span><span class="token punctuation">{</span><span class="token number">2</span><span class="token punctuation">}</span></span> <span class="token attr-name">margin</span><span class="token script language-javascript"><span class="token punctuation">=</span><span class="token punctuation">{</span><span class="token punctuation">{</span> bottom<span class="token punctuation">:</span> <span class="token number">1</span> <span class="token punctuation">}</span><span class="token punctuation">}</span></span> <span class="token attr-name">display</span><span class="token script language-javascript"><span class="token punctuation">=</span><span class="token punctuation">{</span>Display<span class="token punctuation">.</span>Flex<span class="token punctuation">}</span></span> <span class="token attr-name">justifyContent</span><span class="token script language-javascript"><span class="token punctuation">=</span><span class="token punctuation">{</span>JustifyContent<span class="token punctuation">.</span>Center<span class="token punctuation">}</span></span> <span class="token attr-name">alignItems</span><span class="token script language-javascript"><span class="token punctuation">=</span><span class="token punctuation">{</span>AlignItems<span class="token punctuation">.</span>Center<span class="token punctuation">}</span></span><span class="token punctuation">></span></span>\n      <span class="token tag"><span class="token tag"><span class="token punctuation">&lt;</span>CoreText</span> <span class="token attr-name">fontSize</span><span class="token script language-javascript"><span class="token punctuation">=</span><span class="token punctuation">{</span>FontSize<span class="token punctuation">.</span>Size2<span class="token punctuation">}</span></span><span class="token punctuation">></span></span>G<span class="token tag"><span class="token tag"><span class="token punctuation">&lt;/</span>CoreText</span><span class="token punctuation">></span></span>\n    <span class="token tag"><span class="token tag"><span class="token punctuation">&lt;/</span>StyledLayout</span><span class="token punctuation">></span></span>\n  <span class="token tag"><span class="token tag"><span class="token punctuation">&lt;/</span>div</span><span class="token punctuation">></span></span>\n  <span class="token tag"><span class="token tag"><span class="token punctuation">&lt;</span>div</span><span class="token punctuation">></span></span>\n    <span class="token tag"><span class="token tag"><span class="token punctuation">&lt;</span>StyledLayout</span> <span class="token attr-name">background</span><span class="token script language-javascript"><span class="token punctuation">=</span><span class="token punctuation">{</span>Background<span class="token punctuation">.</span>Accent<span class="token punctuation">}</span></span> <span class="token attr-name">color</span><span class="token script language-javascript"><span class="token punctuation">=</span><span class="token punctuation">{</span>Color<span class="token punctuation">.</span>Overlay<span class="token punctuation">}</span></span> <span class="token attr-name">padding</span><span class="token script language-javascript"><span class="token punctuation">=</span><span class="token punctuation">{</span><span class="token number">2</span><span class="token punctuation">}</span></span> <span class="token attr-name">margin</span><span class="token script language-javascript"><span class="token punctuation">=</span><span class="token punctuation">{</span><span class="token punctuation">{</span> bottom<span class="token punctuation">:</span> <span class="token number">1</span> <span class="token punctuation">}</span><span class="token punctuation">}</span></span> <span class="token attr-name">display</span><span class="token script language-javascript"><span class="token punctuation">=</span><span class="token punctuation">{</span>Display<span class="token punctuation">.</span>Flex<span class="token punctuation">}</span></span> <span class="token attr-name">justifyContent</span><span class="token script language-javascript"><span class="token punctuation">=</span><span class="token punctuation">{</span>JustifyContent<span class="token punctuation">.</span>Center<span class="token punctuation">}</span></span> <span class="token attr-name">alignItems</span><span class="token script language-javascript"><span class="token punctuation">=</span><span class="token punctuation">{</span>AlignItems<span class="token punctuation">.</span>Center<span class="token punctuation">}</span></span><span class="token punctuation">></span></span>\n      <span class="token tag"><span class="token tag"><span class="token punctuation">&lt;</span>CoreText</span> <span class="token attr-name">fontSize</span><span class="token script language-javascript"><span class="token punctuation">=</span><span class="token punctuation">{</span>FontSize<span class="token punctuation">.</span>Size2<span class="token punctuation">}</span></span><span class="token punctuation">></span></span>H<span class="token tag"><span class="token tag"><span class="token punctuation">&lt;/</span>CoreText</span><span class="token punctuation">></span></span>\n    <span class="token tag"><span class="token tag"><span class="token punctuation">&lt;/</span>StyledLayout</span><span class="token punctuation">></span></span>\n  <span class="token tag"><span class="token tag"><span class="token punctuation">&lt;/</span>div</span><span class="token punctuation">></span></span>\n  <span class="token tag"><span class="token tag"><span class="token punctuation">&lt;</span>div</span><span class="token punctuation">></span></span>\n    <span class="token tag"><span class="token tag"><span class="token punctuation">&lt;</span>StyledLayout</span> <span class="token attr-name">background</span><span class="token script language-javascript"><span class="token punctuation">=</span><span class="token punctuation">{</span>Background<span class="token punctuation">.</span>Accent<span class="token punctuation">}</span></span> <span class="token attr-name">color</span><span class="token script language-javascript"><span class="token punctuation">=</span><span class="token punctuation">{</span>Color<span class="token punctuation">.</span>Overlay<span class="token punctuation">}</span></span> <span class="token attr-name">padding</span><span class="token script language-javascript"><span class="token punctuation">=</span><span class="token punctuation">{</span><span class="token number">2</span><span class="token punctuation">}</span></span> <span class="token attr-name">margin</span><span class="token script language-javascript"><span class="token punctuation">=</span><span class="token punctuation">{</span><span class="token punctuation">{</span> bottom<span class="token punctuation">:</span> <span class="token number">1</span> <span class="token punctuation">}</span><span class="token punctuation">}</span></span> <span class="token attr-name">display</span><span class="token script language-javascript"><span class="token punctuation">=</span><span class="token punctuation">{</span>Display<span class="token punctuation">.</span>Flex<span class="token punctuation">}</span></span> <span class="token attr-name">justifyContent</span><span class="token script language-javascript"><span class="token punctuation">=</span><span class="token punctuation">{</span>JustifyContent<span class="token punctuation">.</span>Center<span class="token punctuation">}</span></span> <span class="token attr-name">alignItems</span><span class="token script language-javascript"><span class="token punctuation">=</span><span class="token punctuation">{</span>AlignItems<span class="token punctuation">.</span>Center<span class="token punctuation">}</span></span><span class="token punctuation">></span></span>\n      <span class="token tag"><span class="token tag"><span class="token punctuation">&lt;</span>CoreText</span> <span class="token attr-name">fontSize</span><span class="token script language-javascript"><span class="token punctuation">=</span><span class="token punctuation">{</span>FontSize<span class="token punctuation">.</span>Size2<span class="token punctuation">}</span></span><span class="token punctuation">></span></span>I<span class="token tag"><span class="token tag"><span class="token punctuation">&lt;/</span>CoreText</span><span class="token punctuation">></span></span>\n    <span class="token tag"><span class="token tag"><span class="token punctuation">&lt;/</span>StyledLayout</span><span class="token punctuation">></span></span>\n  <span class="token tag"><span class="token tag"><span class="token punctuation">&lt;/</span>div</span><span class="token punctuation">></span></span>\n<span class="token tag"><span class="token tag"><span class="token punctuation">&lt;/</span>Tower</span><span class="token punctuation">></span></span>\n</code></pre>\n      </div>\n<h2 id="using-placeholder-items"><a href="#using-placeholder-items" aria-hidden="true" class="anchor"><svg aria-hidden="true" height="16" version="1.1" viewBox="0 0 16 16" width="16"><path fill-rule="evenodd" d="M4 9h1v1H4c-1.5 0-3-1.69-3-3.5S2.55 3 4 3h4c1.45 0 3 1.69 3 3.5 0 1.41-.91 2.72-2 3.25V8.59c.58-.45 1-1.27 1-2.09C10 5.22 8.98 4 8 4H4c-.98 0-2 1.22-2 2.5S3 9 4 9zm9-3h-1v1h1c1 0 2 1.22 2 2.5S13.98 12 13 12H9c-.98 0-2-1.22-2-2.5 0-.83.42-1.64 1-2.09V6.25c-1.09.53-2 1.84-2 3.25C6 11.31 7.55 13 9 13h4c1.45 0 3-1.69 3-3.5S14.5 6 13 6z"></path></svg></a>Using Placeholder Items</h2>\n<p>When creating a Tower-based layout, use the <code>placeholderItems</code> property to render empty containers to the end of your Tower. This will prevent overflowing items from expanding beyond their desired size. Below is an example of where placeholders would prevent undesirable growing behavior.</p>\n<div class="gatsby-highlight">\n      <pre class="language-jsx"><code><span class="token tag"><span class="token tag"><span class="token punctuation">&lt;</span>Tower</span> <span class="token attr-name">childWidth</span><span class="token script language-javascript"><span class="token punctuation">=</span><span class="token punctuation">{</span>TowerChildWidth<span class="token punctuation">.</span>Small<span class="token punctuation">}</span></span><span class="token punctuation">></span></span>\n  <span class="token tag"><span class="token tag"><span class="token punctuation">&lt;</span>div</span><span class="token punctuation">></span></span>\n    <span class="token tag"><span class="token tag"><span class="token punctuation">&lt;</span>StyledLayout</span> <span class="token attr-name">background</span><span class="token script language-javascript"><span class="token punctuation">=</span><span class="token punctuation">{</span>Background<span class="token punctuation">.</span>Accent<span class="token punctuation">}</span></span> <span class="token attr-name">color</span><span class="token script language-javascript"><span class="token punctuation">=</span><span class="token punctuation">{</span>Color<span class="token punctuation">.</span>Overlay<span class="token punctuation">}</span></span> <span class="token attr-name">padding</span><span class="token script language-javascript"><span class="token punctuation">=</span><span class="token punctuation">{</span><span class="token number">2</span><span class="token punctuation">}</span></span> <span class="token attr-name">margin</span><span class="token script language-javascript"><span class="token punctuation">=</span><span class="token punctuation">{</span><span class="token punctuation">{</span> bottom<span class="token punctuation">:</span> <span class="token number">1</span> <span class="token punctuation">}</span><span class="token punctuation">}</span></span> <span class="token attr-name">display</span><span class="token script language-javascript"><span class="token punctuation">=</span><span class="token punctuation">{</span>Display<span class="token punctuation">.</span>Flex<span class="token punctuation">}</span></span> <span class="token attr-name">justifyContent</span><span class="token script language-javascript"><span class="token punctuation">=</span><span class="token punctuation">{</span>JustifyContent<span class="token punctuation">.</span>Center<span class="token punctuation">}</span></span> <span class="token attr-name">alignItems</span><span class="token script language-javascript"><span class="token punctuation">=</span><span class="token punctuation">{</span>AlignItems<span class="token punctuation">.</span>Center<span class="token punctuation">}</span></span><span class="token punctuation">></span></span>\n      <span class="token tag"><span class="token tag"><span class="token punctuation">&lt;</span>CoreText</span> <span class="token attr-name">fontSize</span><span class="token script language-javascript"><span class="token punctuation">=</span><span class="token punctuation">{</span>FontSize<span class="token punctuation">.</span>Size2<span class="token punctuation">}</span></span><span class="token punctuation">></span></span>A<span class="token tag"><span class="token tag"><span class="token punctuation">&lt;/</span>CoreText</span><span class="token punctuation">></span></span>\n    <span class="token tag"><span class="token tag"><span class="token punctuation">&lt;/</span>StyledLayout</span><span class="token punctuation">></span></span>\n  <span class="token tag"><span class="token tag"><span class="token punctuation">&lt;/</span>div</span><span class="token punctuation">></span></span>\n  <span class="token tag"><span class="token tag"><span class="token punctuation">&lt;</span>div</span><span class="token punctuation">></span></span>\n    <span class="token tag"><span class="token tag"><span class="token punctuation">&lt;</span>StyledLayout</span> <span class="token attr-name">background</span><span class="token script language-javascript"><span class="token punctuation">=</span><span class="token punctuation">{</span>Background<span class="token punctuation">.</span>Accent<span class="token punctuation">}</span></span> <span class="token attr-name">color</span><span class="token script language-javascript"><span class="token punctuation">=</span><span class="token punctuation">{</span>Color<span class="token punctuation">.</span>Overlay<span class="token punctuation">}</span></span> <span class="token attr-name">padding</span><span class="token script language-javascript"><span class="token punctuation">=</span><span class="token punctuation">{</span><span class="token number">2</span><span class="token punctuation">}</span></span> <span class="token attr-name">margin</span><span class="token script language-javascript"><span class="token punctuation">=</span><span class="token punctuation">{</span><span class="token punctuation">{</span> bottom<span class="token punctuation">:</span> <span class="token number">1</span> <span class="token punctuation">}</span><span class="token punctuation">}</span></span> <span class="token attr-name">display</span><span class="token script language-javascript"><span class="token punctuation">=</span><span class="token punctuation">{</span>Display<span class="token punctuation">.</span>Flex<span class="token punctuation">}</span></span> <span class="token attr-name">justifyContent</span><span class="token script language-javascript"><span class="token punctuation">=</span><span class="token punctuation">{</span>JustifyContent<span class="token punctuation">.</span>Center<span class="token punctuation">}</span></span> <span class="token attr-name">alignItems</span><span class="token script language-javascript"><span class="token punctuation">=</span><span class="token punctuation">{</span>AlignItems<span class="token punctuation">.</span>Center<span class="token punctuation">}</span></span><span class="token punctuation">></span></span>\n      <span class="token tag"><span class="token tag"><span class="token punctuation">&lt;</span>CoreText</span> <span class="token attr-name">fontSize</span><span class="token script language-javascript"><span class="token punctuation">=</span><span class="token punctuation">{</span>FontSize<span class="token punctuation">.</span>Size2<span class="token punctuation">}</span></span><span class="token punctuation">></span></span>B<span class="token tag"><span class="token tag"><span class="token punctuation">&lt;/</span>CoreText</span><span class="token punctuation">></span></span>\n    <span class="token tag"><span class="token tag"><span class="token punctuation">&lt;/</span>StyledLayout</span><span class="token punctuation">></span></span>\n  <span class="token tag"><span class="token tag"><span class="token punctuation">&lt;/</span>div</span><span class="token punctuation">></span></span>\n  <span class="token tag"><span class="token tag"><span class="token punctuation">&lt;</span>div</span><span class="token punctuation">></span></span>\n    <span class="token tag"><span class="token tag"><span class="token punctuation">&lt;</span>StyledLayout</span> <span class="token attr-name">background</span><span class="token script language-javascript"><span class="token punctuation">=</span><span class="token punctuation">{</span>Background<span class="token punctuation">.</span>Accent<span class="token punctuation">}</span></span> <span class="token attr-name">color</span><span class="token script language-javascript"><span class="token punctuation">=</span><span class="token punctuation">{</span>Color<span class="token punctuation">.</span>Overlay<span class="token punctuation">}</span></span> <span class="token attr-name">padding</span><span class="token script language-javascript"><span class="token punctuation">=</span><span class="token punctuation">{</span><span class="token number">2</span><span class="token punctuation">}</span></span> <span class="token attr-name">margin</span><span class="token script language-javascript"><span class="token punctuation">=</span><span class="token punctuation">{</span><span class="token punctuation">{</span> bottom<span class="token punctuation">:</span> <span class="token number">1</span> <span class="token punctuation">}</span><span class="token punctuation">}</span></span> <span class="token attr-name">display</span><span class="token script language-javascript"><span class="token punctuation">=</span><span class="token punctuation">{</span>Display<span class="token punctuation">.</span>Flex<span class="token punctuation">}</span></span> <span class="token attr-name">justifyContent</span><span class="token script language-javascript"><span class="token punctuation">=</span><span class="token punctuation">{</span>JustifyContent<span class="token punctuation">.</span>Center<span class="token punctuation">}</span></span> <span class="token attr-name">alignItems</span><span class="token script language-javascript"><span class="token punctuation">=</span><span class="token punctuation">{</span>AlignItems<span class="token punctuation">.</span>Center<span class="token punctuation">}</span></span><span class="token punctuation">></span></span>\n      <span class="token tag"><span class="token tag"><span class="token punctuation">&lt;</span>CoreText</span> <span class="token attr-name">fontSize</span><span class="token script language-javascript"><span class="token punctuation">=</span><span class="token punctuation">{</span>FontSize<span class="token punctuation">.</span>Size2<span class="token punctuation">}</span></span><span class="token punctuation">></span></span>C<span class="token tag"><span class="token tag"><span class="token punctuation">&lt;/</span>CoreText</span><span class="token punctuation">></span></span>\n    <span class="token tag"><span class="token tag"><span class="token punctuation">&lt;/</span>StyledLayout</span><span class="token punctuation">></span></span>\n  <span class="token tag"><span class="token tag"><span class="token punctuation">&lt;/</span>div</span><span class="token punctuation">></span></span>\n  <span class="token tag"><span class="token tag"><span class="token punctuation">&lt;</span>div</span><span class="token punctuation">></span></span>\n    <span class="token tag"><span class="token tag"><span class="token punctuation">&lt;</span>StyledLayout</span> <span class="token attr-name">background</span><span class="token script language-javascript"><span class="token punctuation">=</span><span class="token punctuation">{</span>Background<span class="token punctuation">.</span>Accent<span class="token punctuation">}</span></span> <span class="token attr-name">color</span><span class="token script language-javascript"><span class="token punctuation">=</span><span class="token punctuation">{</span>Color<span class="token punctuation">.</span>Overlay<span class="token punctuation">}</span></span> <span class="token attr-name">padding</span><span class="token script language-javascript"><span class="token punctuation">=</span><span class="token punctuation">{</span><span class="token number">2</span><span class="token punctuation">}</span></span> <span class="token attr-name">margin</span><span class="token script language-javascript"><span class="token punctuation">=</span><span class="token punctuation">{</span><span class="token punctuation">{</span> bottom<span class="token punctuation">:</span> <span class="token number">1</span> <span class="token punctuation">}</span><span class="token punctuation">}</span></span> <span class="token attr-name">display</span><span class="token script language-javascript"><span class="token punctuation">=</span><span class="token punctuation">{</span>Display<span class="token punctuation">.</span>Flex<span class="token punctuation">}</span></span> <span class="token attr-name">justifyContent</span><span class="token script language-javascript"><span class="token punctuation">=</span><span class="token punctuation">{</span>JustifyContent<span class="token punctuation">.</span>Center<span class="token punctuation">}</span></span> <span class="token attr-name">alignItems</span><span class="token script language-javascript"><span class="token punctuation">=</span><span class="token punctuation">{</span>AlignItems<span class="token punctuation">.</span>Center<span class="token punctuation">}</span></span><span class="token punctuation">></span></span>\n      <span class="token tag"><span class="token tag"><span class="token punctuation">&lt;</span>CoreText</span> <span class="token attr-name">fontSize</span><span class="token script language-javascript"><span class="token punctuation">=</span><span class="token punctuation">{</span>FontSize<span class="token punctuation">.</span>Size2<span class="token punctuation">}</span></span><span class="token punctuation">></span></span>D<span class="token tag"><span class="token tag"><span class="token punctuation">&lt;/</span>CoreText</span><span class="token punctuation">></span></span>\n    <span class="token tag"><span class="token tag"><span class="token punctuation">&lt;/</span>StyledLayout</span><span class="token punctuation">></span></span>\n  <span class="token tag"><span class="token tag"><span class="token punctuation">&lt;/</span>div</span><span class="token punctuation">></span></span>\n  <span class="token tag"><span class="token tag"><span class="token punctuation">&lt;</span>div</span><span class="token punctuation">></span></span>\n    <span class="token tag"><span class="token tag"><span class="token punctuation">&lt;</span>StyledLayout</span> <span class="token attr-name">background</span><span class="token script language-javascript"><span class="token punctuation">=</span><span class="token punctuation">{</span>Background<span class="token punctuation">.</span>Accent<span class="token punctuation">}</span></span> <span class="token attr-name">color</span><span class="token script language-javascript"><span class="token punctuation">=</span><span class="token punctuation">{</span>Color<span class="token punctuation">.</span>Overlay<span class="token punctuation">}</span></span> <span class="token attr-name">padding</span><span class="token script language-javascript"><span class="token punctuation">=</span><span class="token punctuation">{</span><span class="token number">2</span><span class="token punctuation">}</span></span> <span class="token attr-name">margin</span><span class="token script language-javascript"><span class="token punctuation">=</span><span class="token punctuation">{</span><span class="token punctuation">{</span> bottom<span class="token punctuation">:</span> <span class="token number">1</span> <span class="token punctuation">}</span><span class="token punctuation">}</span></span> <span class="token attr-name">display</span><span class="token script language-javascript"><span class="token punctuation">=</span><span class="token punctuation">{</span>Display<span class="token punctuation">.</span>Flex<span class="token punctuation">}</span></span> <span class="token attr-name">justifyContent</span><span class="token script language-javascript"><span class="token punctuation">=</span><span class="token punctuation">{</span>JustifyContent<span class="token punctuation">.</span>Center<span class="token punctuation">}</span></span> <span class="token attr-name">alignItems</span><span class="token script language-javascript"><span class="token punctuation">=</span><span class="token punctuation">{</span>AlignItems<span class="token punctuation">.</span>Center<span class="token punctuation">}</span></span><span class="token punctuation">></span></span>\n      <span class="token tag"><span class="token tag"><span class="token punctuation">&lt;</span>CoreText</span> <span class="token attr-name">fontSize</span><span class="token script language-javascript"><span class="token punctuation">=</span><span class="token punctuation">{</span>FontSize<span class="token punctuation">.</span>Size2<span class="token punctuation">}</span></span><span class="token punctuation">></span></span>E<span class="token tag"><span class="token tag"><span class="token punctuation">&lt;/</span>CoreText</span><span class="token punctuation">></span></span>\n    <span class="token tag"><span class="token tag"><span class="token punctuation">&lt;/</span>StyledLayout</span><span class="token punctuation">></span></span>\n  <span class="token tag"><span class="token tag"><span class="token punctuation">&lt;/</span>div</span><span class="token punctuation">></span></span>\n<span class="token tag"><span class="token tag"><span class="token punctuation">&lt;/</span>Tower</span><span class="token punctuation">></span></span>\n</code></pre>\n      </div>',
frontmatter:{component:{id:"components/tower",disablePlayground:null},title:""},headings:[{value:"When to Use Tower",depth:2},{value:"Basic Usage",depth:2},{value:"Using Placeholder Items",depth:2}]}},github:{items:[{sha:"ae537fe4a40f3eca6003f8a8657bef346ce671b4",htmlUrl:"https://git-aws.internal.justin.tv/web/core-ui/commit/ae537fe4a40f3eca6003f8a8657bef346ce671b4",commit:{message:"updates tower copy with better examples and explanations COREUI-136",committer:{date:"2018-03-28T21:48:44Z"}},author:{login:"shusterm",avatarUrl:"https://git-aws.internal.justin.tv/avatars/u/406?",htmlUrl:"https://git-aws.internal.justin.tv/shusterm"}},{sha:"fa2a6eac9480afbb350f1f1c508d2a6edd81b91f",htmlUrl:"https://git-aws.internal.justin.tv/web/core-ui/commit/fa2a6eac9480afbb350f1f1c508d2a6edd81b91f",commit:{message:"Updated to string enums",committer:{date:"2018-02-28T21:15:18Z"}},author:{login:"jpanter",avatarUrl:"https://git-aws.internal.justin.tv/avatars/u/788?",htmlUrl:"https://git-aws.internal.justin.tv/jpanter"}},{sha:"73c43d9301c781332e066d453d4532fa306958c6",htmlUrl:"https://git-aws.internal.justin.tv/web/core-ui/commit/73c43d9301c781332e066d453d4532fa306958c6",commit:{message:"Add property descriptions",committer:{date:"2018-02-09T01:13:13Z"}},author:{login:"cgrffit",avatarUrl:"https://git-aws.internal.justin.tv/avatars/u/707?",htmlUrl:"https://git-aws.internal.justin.tv/cgrffit"}},{sha:"e16ccb433fc75c450e014c812d5c6249f6b6a94f",htmlUrl:"https://git-aws.internal.justin.tv/web/core-ui/commit/e16ccb433fc75c450e014c812d5c6249f6b6a94f",commit:{message:"Merge branch 'master' into cg-auto-docs",committer:{date:"2018-01-17T19:36:31Z"}},author:{login:"cgrffit",avatarUrl:"https://git-aws.internal.justin.tv/avatars/u/707?",htmlUrl:"https://git-aws.internal.justin.tv/cgrffit"}},{sha:"b6c9858cf06e1d52b1a511c4bf4698de187d10b2",htmlUrl:"https://git-aws.internal.justin.tv/web/core-ui/commit/b6c9858cf06e1d52b1a511c4bf4698de187d10b2",commit:{message:"Better redirects and move content to docs/data",committer:{date:"2018-01-17T01:42:29Z"}},author:{login:"cgrffit",avatarUrl:"https://git-aws.internal.justin.tv/avatars/u/707?",htmlUrl:"https://git-aws.internal.justin.tv/cgrffit"}},{sha:"ca7278acf2043e94bb15fb585570b460686ec61b",htmlUrl:"https://git-aws.internal.justin.tv/web/core-ui/commit/ca7278acf2043e94bb15fb585570b460686ec61b",commit:{message:"remove redundant injectlayout",committer:{date:"2017-12-12T01:45:08Z"}},author:{login:"shusterm",avatarUrl:"https://git-aws.internal.justin.tv/avatars/u/406?",htmlUrl:"https://git-aws.internal.justin.tv/shusterm"}},{sha:"be54fdfadca11a38c4f220354bb7dcc699729d5c",htmlUrl:"https://git-aws.internal.justin.tv/web/core-ui/commit/be54fdfadca11a38c4f220354bb7dcc699729d5c",commit:{message:"refactor hardcoded core-ui values out of tower and button",committer:{date:"2017-12-12T01:42:45Z"}},author:{login:"shusterm",avatarUrl:"https://git-aws.internal.justin.tv/avatars/u/406?",htmlUrl:"https://git-aws.internal.justin.tv/shusterm"}},{sha:"1c3aafee9294e64b5a8807a3e584619da1aef4ff",htmlUrl:"https://git-aws.internal.justin.tv/web/core-ui/commit/1c3aafee9294e64b5a8807a3e584619da1aef4ff",commit:{message:"Remove import statements from readme's so they can be automatically generated",committer:{date:"2017-11-30T18:53:33Z"}},author:{login:"cgrffit",avatarUrl:"https://git-aws.internal.justin.tv/avatars/u/707?",htmlUrl:"https://git-aws.internal.justin.tv/cgrffit"}},{sha:"f51a4a60851be042e6407b22f97601378fe36c32",htmlUrl:"https://git-aws.internal.justin.tv/web/core-ui/commit/f51a4a60851be042e6407b22f97601378fe36c32",commit:{message:"Move frontmatter descriptions to the component files",committer:{date:"2017-11-21T01:02:44Z"}},author:{login:"cgrffit",avatarUrl:"https://git-aws.internal.justin.tv/avatars/u/707?",htmlUrl:"https://git-aws.internal.justin.tv/cgrffit"}},{sha:"26f2d07058a1a82e2715749c3adb26dfd5514c30",htmlUrl:"https://git-aws.internal.justin.tv/web/core-ui/commit/26f2d07058a1a82e2715749c3adb26dfd5514c30",commit:{message:"Even more docs",committer:{date:"2017-11-18T02:02:05Z"}},author:{login:"cgrffit",avatarUrl:"https://git-aws.internal.justin.tv/avatars/u/707?",htmlUrl:"https://git-aws.internal.justin.tv/cgrffit"}},{sha:"334e9bc30a18881a9f164fd648fabe5d26428932",htmlUrl:"https://git-aws.internal.justin.tv/web/core-ui/commit/334e9bc30a18881a9f164fd648fabe5d26428932",commit:{message:"Remove prop tables from readmes",committer:{date:"2017-11-18T01:48:25Z"}},author:{login:"cgrffit",avatarUrl:"https://git-aws.internal.justin.tv/avatars/u/707?",htmlUrl:"https://git-aws.internal.justin.tv/cgrffit"}},{sha:"30c6cb578a4b73947bc978a8a8fab1de7ba23d0e",htmlUrl:"https://git-aws.internal.justin.tv/web/core-ui/commit/30c6cb578a4b73947bc978a8a8fab1de7ba23d0e",commit:{message:"Format the docs",committer:{date:"2017-11-17T21:43:29Z"}},author:{login:"cgrffit",avatarUrl:"https://git-aws.internal.justin.tv/avatars/u/707?",htmlUrl:"https://git-aws.internal.justin.tv/cgrffit"}},{sha:"c29e261189b06ac516761a1adffee591cd5458d1",htmlUrl:"https://git-aws.internal.justin.tv/web/core-ui/commit/c29e261189b06ac516761a1adffee591cd5458d1",commit:{message:"added tower readme",committer:{date:"2017-10-17T23:00:06Z"}},author:{login:"tayho",avatarUrl:"https://git-aws.internal.justin.tv/avatars/u/781?",htmlUrl:"https://git-aws.internal.justin.tv/tayho"}},{sha:"356869dfeb5d6a887a8b32b87b54e36c641536bb",htmlUrl:"https://git-aws.internal.justin.tv/web/core-ui/commit/356869dfeb5d6a887a8b32b87b54e36c641536bb",commit:{message:"Add remaining READMEs",committer:{date:"2017-10-16T21:28:19Z"}},author:{login:"cgrffit",avatarUrl:"https://git-aws.internal.justin.tv/avatars/u/707?",htmlUrl:"https://git-aws.internal.justin.tv/cgrffit"}},{sha:"5fd3ac36187482de020cb653d02b18266e74800e",htmlUrl:"https://git-aws.internal.justin.tv/web/core-ui/commit/5fd3ac36187482de020cb653d02b18266e74800e",commit:{message:"Merge branch 'master' into ms-responsive-grid",committer:{date:"2017-08-09T15:01:24Z"}},author:{login:"shusterm",avatarUrl:"https://git-aws.internal.justin.tv/avatars/u/406?",htmlUrl:"https://git-aws.internal.justin.tv/shusterm"}},{sha:"21e6a4123c881790b7351e7da4b0a1f8469ff570",htmlUrl:"https://git-aws.internal.justin.tv/web/core-ui/commit/21e6a4123c881790b7351e7da4b0a1f8469ff570",commit:{message:"Updated placholder order to be max integer",committer:{date:"2017-08-04T20:45:08Z"}},author:{login:"jpanter",avatarUrl:"https://git-aws.internal.justin.tv/avatars/u/788?",htmlUrl:"https://git-aws.internal.justin.tv/jpanter"}},{sha:"849e1219e719a2a264e1f140845457ec15abde91",htmlUrl:"https://git-aws.internal.justin.tv/web/core-ui/commit/849e1219e719a2a264e1f140845457ec15abde91",commit:{message:"added examples to the playground",committer:{date:"2017-08-04T20:32:16Z"}},author:{login:"jpanter",avatarUrl:"https://git-aws.internal.justin.tv/avatars/u/788?",htmlUrl:"https://git-aws.internal.justin.tv/jpanter"}},{sha:"246f1d4169ed64d5f60d39b9176232431c66bb25",htmlUrl:"https://git-aws.internal.justin.tv/web/core-ui/commit/246f1d4169ed64d5f60d39b9176232431c66bb25",commit:{message:"responsive grid components",committer:{date:"2017-07-28T23:07:37Z"}},author:{login:"shusterm",avatarUrl:"https://git-aws.internal.justin.tv/avatars/u/406?",htmlUrl:"https://git-aws.internal.justin.tv/shusterm"}},{sha:"ca0558b197582edb7c010e25f4a827cdf26b510a",htmlUrl:"https://git-aws.internal.justin.tv/web/core-ui/commit/ca0558b197582edb7c010e25f4a827cdf26b510a",commit:{message:"added comment",committer:{date:"2017-07-28T22:28:58Z"}},author:{login:"jpanter",avatarUrl:"https://git-aws.internal.justin.tv/avatars/u/788?",htmlUrl:"https://git-aws.internal.justin.tv/jpanter"}},{sha:"645c1fabf4cdda9785f0d6edc8fc4ab36ebb01e5",htmlUrl:"https://git-aws.internal.justin.tv/web/core-ui/commit/645c1fabf4cdda9785f0d6edc8fc4ab36ebb01e5",commit:{message:"added placeholder order to tower",committer:{date:"2017-07-28T22:27:04Z"}},author:{login:"jpanter",avatarUrl:"https://git-aws.internal.justin.tv/avatars/u/788?",htmlUrl:"https://git-aws.internal.justin.tv/jpanter"}},{sha:"39620cce6718d87cad8596c600167103d540662a",htmlUrl:"https://git-aws.internal.justin.tv/web/core-ui/commit/39620cce6718d87cad8596c600167103d540662a",commit:{message:"Update with latest master",committer:{date:"2017-07-07T23:30:35Z"}},author:{login:"cgrffit",avatarUrl:"https://git-aws.internal.justin.tv/avatars/u/707?",htmlUrl:"https://git-aws.internal.justin.tv/cgrffit"}},{sha:"505bdbf739d4b10a278d3480842897064183717d",htmlUrl:"https://git-aws.internal.justin.tv/web/core-ui/commit/505bdbf739d4b10a278d3480842897064183717d",commit:{message:"Clean up linting",committer:{date:"2017-07-07T23:18:20Z"}},author:{login:"cgrffit",avatarUrl:"https://git-aws.internal.justin.tv/avatars/u/707?",htmlUrl:"https://git-aws.internal.justin.tv/cgrffit"}},{sha:"f82dc790f0e963bff701f37dc10301b1b017797c",htmlUrl:"https://git-aws.internal.justin.tv/web/core-ui/commit/f82dc790f0e963bff701f37dc10301b1b017797c",commit:{message:"Add remaining prefixes and clean up comments",committer:{date:"2017-06-26T21:45:30Z"}},author:{login:"cgrffit",avatarUrl:"https://git-aws.internal.justin.tv/avatars/u/707?",htmlUrl:"https://git-aws.internal.justin.tv/cgrffit"}},{sha:"4e16392f3ef56042466869d9527730e68d81c192",htmlUrl:"https://git-aws.internal.justin.tv/web/core-ui/commit/4e16392f3ef56042466869d9527730e68d81c192",commit:{message:"Prefix tower",committer:{date:"2017-06-26T20:48:48Z"}},author:{login:"cgrffit",avatarUrl:"https://git-aws.internal.justin.tv/avatars/u/707?",htmlUrl:"https://git-aws.internal.justin.tv/cgrffit"}},{sha:"4098e836648fa5675794887d9d0cd3c7c0f3004b",htmlUrl:"https://git-aws.internal.justin.tv/web/core-ui/commit/4098e836648fa5675794887d9d0cd3c7c0f3004b",commit:{message:"Changed tower breakpoint from LR to LG",committer:{date:"2017-06-22T22:14:18Z"}},author:{login:"jpanter",avatarUrl:"https://git-aws.internal.justin.tv/avatars/u/788?",htmlUrl:"https://git-aws.internal.justin.tv/jpanter"}},{sha:"d1bfd38bbe55733602c5064b4c852b6cb57cf20a",htmlUrl:"https://git-aws.internal.justin.tv/web/core-ui/commit/d1bfd38bbe55733602c5064b4c852b6cb57cf20a",commit:{message:"cleaning up the core ui components",committer:{date:"2017-06-09T18:29:17Z"}},author:{login:"jpanter",avatarUrl:"https://git-aws.internal.justin.tv/avatars/u/788?",htmlUrl:"https://git-aws.internal.justin.tv/jpanter"}},{sha:"fa1372fde22ef17fac60280ad04fe4b450b4b2e6",htmlUrl:"https://git-aws.internal.justin.tv/web/core-ui/commit/fa1372fde22ef17fac60280ad04fe4b450b4b2e6",commit:{message:"updated props namimg",committer:{date:"2017-06-06T00:12:50Z"}},author:{login:"jpanter",avatarUrl:"https://git-aws.internal.justin.tv/avatars/u/788?",htmlUrl:"https://git-aws.internal.justin.tv/jpanter"}},{sha:"d3c0c0490e4d79fcb4fa27e747de4ba70a6173e5",htmlUrl:"https://git-aws.internal.justin.tv/web/core-ui/commit/d3c0c0490e4d79fcb4fa27e747de4ba70a6173e5",commit:{message:"Merge branch 'master' of git-aws.internal.justin.tv:web/core-ui into twilight",committer:{date:"2017-06-01T20:34:09Z"}},author:{login:"jpanter",avatarUrl:"https://git-aws.internal.justin.tv/avatars/u/788?",htmlUrl:"https://git-aws.internal.justin.tv/jpanter"}},{sha:"1ca43c9d42effefd8c33b4b790fc5f2ecf5e96a9",htmlUrl:"https://git-aws.internal.justin.tv/web/core-ui/commit/1ca43c9d42effefd8c33b4b790fc5f2ecf5e96a9",commit:{message:"added placeholder items to tower",committer:{date:"2017-05-22T20:24:01Z"}},author:{login:"jpanter",avatarUrl:"https://git-aws.internal.justin.tv/avatars/u/788?",htmlUrl:"https://git-aws.internal.justin.tv/jpanter"}},{sha:"a6a7ad53e720b4ea85572cea10ae2be5a244cc5b",htmlUrl:"https://git-aws.internal.justin.tv/web/core-ui/commit/a6a7ad53e720b4ea85572cea10ae2be5a244cc5b",commit:{message:"added data attributes to not use props",committer:{date:"2017-05-18T21:44:46Z"}},author:{login:"jpanter",avatarUrl:"https://git-aws.internal.justin.tv/avatars/u/788?",htmlUrl:"https://git-aws.internal.justin.tv/jpanter"}}]},component:{name:"Tower",comment:{shortText:"Tower helps to lay out items of the same width while forcing a desired width on those children via flexbox."},properties:[{name:"center",flags:{isOptional:!0},type:"boolean",comment:{shortText:"Center the children.",tags:null},availableValues:[],breakpointCompatible:!1},{name:"childWidth",flags:{isOptional:!0},type:"TowerChildWidth",comment:{shortText:"Sets the width of the children.",tags:null},availableValues:["ExtraSmall","Large","Medium","Small"],breakpointCompatible:!1},{name:"children",flags:{isOptional:!0},type:"React.ReactNode",comment:{shortText:"The items to be laid out by tower.",tags:[{tag:"example",text:"\n <div>\n   <StyledLayout background={Background.Accent} padding={4} margin={{bottom: 1}} fullWidth />\n </div>\n <div>\n   <StyledLayout background={Background.Accent} padding={4} margin={{bottom: 1}} fullWidth />\n </div>\n <div>\n   <StyledLayout background={Background.Accent} padding={4} margin={{bottom: 1}} fullWidth />\n </div>\n   <div>\n   <StyledLayout background={Background.Accent} padding={4} margin={{bottom: 1}} fullWidth />\n </div>\n <div>\n   <StyledLayout background={Background.Accent} padding={4} margin={{bottom: 1}} fullWidth />\n </div>\n <div>\n   <StyledLayout background={Background.Accent} padding={4} margin={{bottom: 1}} fullWidth />\n </div>\n   <div>\n   <StyledLayout background={Background.Accent} padding={4} margin={{bottom: 1}} fullWidth />\n </div>\n <div>\n   <StyledLayout background={Background.Accent} padding={4} margin={{bottom: 1}} fullWidth />\n </div>\n <div>\n   <StyledLayout background={Background.Accent} padding={4} margin={{bottom: 1}} fullWidth />\n </div>\n"}]},availableValues:[],breakpointCompatible:!1},{name:"gutterSize",flags:{isOptional:!0},type:"TowerGutter",comment:{shortText:"Sets the size of gutter between the children.",tags:null},availableValues:["Default","ExtraSmall","Large","None","Small"],breakpointCompatible:!1},{name:"noGrow",flags:{isOptional:!0},type:"boolean",comment:null,availableValues:[],breakpointCompatible:!1},{name:"noWrap",flags:{isOptional:!0},type:"boolean",comment:null,availableValues:[],breakpointCompatible:!1},{name:"placeholderItems",flags:{isOptional:!0},type:"number",comment:null,availableValues:[],breakpointCompatible:!1}]}},pathContext:{componentPagePath:"/user-interface/components/tower",componentId:"components/tower"}}}});
//# sourceMappingURL=path---user-interface-components-tower-893b49fc613c9ef31624.js.map