webpackJsonp([0x8028ed3a04d7],{976:function(e,n){e.exports={data:{page:{modifiedTime:"2018-04-03T17:55:28.000Z",fields:{title:"Writing Sass",path:"/user-interface/guidelines/writing-sass"},childMarkdownRemark:{frontmatter:{title:"",description:null},html:'<h1 id="variables"><a href="#variables" aria-hidden="true" class="anchor"><svg aria-hidden="true" height="16" version="1.1" viewBox="0 0 16 16" width="16"><path fill-rule="evenodd" d="M4 9h1v1H4c-1.5 0-3-1.69-3-3.5S2.55 3 4 3h4c1.45 0 3 1.69 3 3.5 0 1.41-.91 2.72-2 3.25V8.59c.58-.45 1-1.27 1-2.09C10 5.22 8.98 4 8 4H4c-.98 0-2 1.22-2 2.5S3 9 4 9zm9-3h-1v1h1c1 0 2 1.22 2 2.5S13.98 12 13 12H9c-.98 0-2-1.22-2-2.5 0-.83.42-1.64 1-2.09V6.25c-1.09.53-2 1.84-2 3.25C6 11.31 7.55 13 9 13h4c1.45 0 3-1.69 3-3.5S14.5 6 13 6z"></path></svg></a>Variables</h1>\n<p>Use variables for the following delcarations:</p>\n<ul>\n<li><code>font-size</code></li>\n<li><code>font-weight</code></li>\n<li><code>font-family</code></li>\n<li><code>margin</code></li>\n<li><code>padding</code></li>\n<li><code>z-index</code></li>\n</ul>\n<h2 id="typography"><a href="#typography" aria-hidden="true" class="anchor"><svg aria-hidden="true" height="16" version="1.1" viewBox="0 0 16 16" width="16"><path fill-rule="evenodd" d="M4 9h1v1H4c-1.5 0-3-1.69-3-3.5S2.55 3 4 3h4c1.45 0 3 1.69 3 3.5 0 1.41-.91 2.72-2 3.25V8.59c.58-.45 1-1.27 1-2.09C10 5.22 8.98 4 8 4H4c-.98 0-2 1.22-2 2.5S3 9 4 9zm9-3h-1v1h1c1 0 2 1.22 2 2.5S13.98 12 13 12H9c-.98 0-2-1.22-2-2.5 0-.83.42-1.64 1-2.09V6.25c-1.09.53-2 1.84-2 3.25C6 11.31 7.55 13 9 13h4c1.45 0 3-1.69 3-3.5S14.5 6 13 6z"></path></svg></a>Typography</h2>\n<h3 id="font-sizes"><a href="#font-sizes" aria-hidden="true" class="anchor"><svg aria-hidden="true" height="16" version="1.1" viewBox="0 0 16 16" width="16"><path fill-rule="evenodd" d="M4 9h1v1H4c-1.5 0-3-1.69-3-3.5S2.55 3 4 3h4c1.45 0 3 1.69 3 3.5 0 1.41-.91 2.72-2 3.25V8.59c.58-.45 1-1.27 1-2.09C10 5.22 8.98 4 8 4H4c-.98 0-2 1.22-2 2.5S3 9 4 9zm9-3h-1v1h1c1 0 2 1.22 2 2.5S13.98 12 13 12H9c-.98 0-2-1.22-2-2.5 0-.83.42-1.64 1-2.09V6.25c-1.09.53-2 1.84-2 3.25C6 11.31 7.55 13 9 13h4c1.45 0 3-1.69 3-3.5S14.5 6 13 6z"></path></svg></a>Font Sizes</h3>\n<table>\n<thead>\n<tr>\n<th>Name</th>\n<th>Default Value</th>\n</tr>\n</thead>\n<tbody>\n<tr>\n<td><code>$font-size-1</code></td>\n<td><code>4rem</code></td>\n</tr>\n<tr>\n<td><code>$font-size-2</code></td>\n<td><code>2.8rem</code></td>\n</tr>\n<tr>\n<td><code>$font-size-3</code></td>\n<td><code>2.4rem</code></td>\n</tr>\n<tr>\n<td><code>$font-size-4</code></td>\n<td><code>1.6rem</code></td>\n</tr>\n<tr>\n<td><code>$font-size-5</code></td>\n<td><code>1.4rem</code></td>\n</tr>\n<tr>\n<td><code>$font-size-6</code></td>\n<td><code>1.2rem</code></td>\n</tr>\n</tbody>\n</table>\n<h3 id="font-weight"><a href="#font-weight" aria-hidden="true" class="anchor"><svg aria-hidden="true" height="16" version="1.1" viewBox="0 0 16 16" width="16"><path fill-rule="evenodd" d="M4 9h1v1H4c-1.5 0-3-1.69-3-3.5S2.55 3 4 3h4c1.45 0 3 1.69 3 3.5 0 1.41-.91 2.72-2 3.25V8.59c.58-.45 1-1.27 1-2.09C10 5.22 8.98 4 8 4H4c-.98 0-2 1.22-2 2.5S3 9 4 9zm9-3h-1v1h1c1 0 2 1.22 2 2.5S13.98 12 13 12H9c-.98 0-2-1.22-2-2.5 0-.83.42-1.64 1-2.09V6.25c-1.09.53-2 1.84-2 3.25C6 11.31 7.55 13 9 13h4c1.45 0 3-1.69 3-3.5S14.5 6 13 6z"></path></svg></a>Font Weight</h3>\n<table>\n<thead>\n<tr>\n<th>Name</th>\n<th>Default Value</th>\n</tr>\n</thead>\n<tbody>\n<tr>\n<td><code>$font-weight-bold</code></td>\n<td><code>600</code></td>\n</tr>\n<tr>\n<td><code>$font-weight-normal</code></td>\n<td><code>400</code></td>\n</tr>\n</tbody>\n</table>\n<h3 id="font-families"><a href="#font-families" aria-hidden="true" class="anchor"><svg aria-hidden="true" height="16" version="1.1" viewBox="0 0 16 16" width="16"><path fill-rule="evenodd" d="M4 9h1v1H4c-1.5 0-3-1.69-3-3.5S2.55 3 4 3h4c1.45 0 3 1.69 3 3.5 0 1.41-.91 2.72-2 3.25V8.59c.58-.45 1-1.27 1-2.09C10 5.22 8.98 4 8 4H4c-.98 0-2 1.22-2 2.5S3 9 4 9zm9-3h-1v1h1c1 0 2 1.22 2 2.5S13.98 12 13 12H9c-.98 0-2-1.22-2-2.5 0-.83.42-1.64 1-2.09V6.25c-1.09.53-2 1.84-2 3.25C6 11.31 7.55 13 9 13h4c1.45 0 3-1.69 3-3.5S14.5 6 13 6z"></path></svg></a>Font Families</h3>\n<table>\n<thead>\n<tr>\n<th>Name</th>\n<th>Default Value</th>\n</tr>\n</thead>\n<tbody>\n<tr>\n<td><code>$font-base</code></td>\n<td><code>\'Helvetica Neue\', Helvetica, Arial, sans-serif</code></td>\n</tr>\n</tbody>\n</table>\n<h3 id="line-heights"><a href="#line-heights" aria-hidden="true" class="anchor"><svg aria-hidden="true" height="16" version="1.1" viewBox="0 0 16 16" width="16"><path fill-rule="evenodd" d="M4 9h1v1H4c-1.5 0-3-1.69-3-3.5S2.55 3 4 3h4c1.45 0 3 1.69 3 3.5 0 1.41-.91 2.72-2 3.25V8.59c.58-.45 1-1.27 1-2.09C10 5.22 8.98 4 8 4H4c-.98 0-2 1.22-2 2.5S3 9 4 9zm9-3h-1v1h1c1 0 2 1.22 2 2.5S13.98 12 13 12H9c-.98 0-2-1.22-2-2.5 0-.83.42-1.64 1-2.09V6.25c-1.09.53-2 1.84-2 3.25C6 11.31 7.55 13 9 13h4c1.45 0 3-1.69 3-3.5S14.5 6 13 6z"></path></svg></a>Line Heights</h3>\n<table>\n<thead>\n<tr>\n<th>Name</th>\n<th>Default Value</th>\n</tr>\n</thead>\n<tbody>\n<tr>\n<td><code>$line-height-heading</code></td>\n<td><code>1.2</code></td>\n</tr>\n<tr>\n<td><code>$line-height-body</code></td>\n<td><code>1.5</code></td>\n</tr>\n</tbody>\n</table>\n<h2 id="spacing"><a href="#spacing" aria-hidden="true" class="anchor"><svg aria-hidden="true" height="16" version="1.1" viewBox="0 0 16 16" width="16"><path fill-rule="evenodd" d="M4 9h1v1H4c-1.5 0-3-1.69-3-3.5S2.55 3 4 3h4c1.45 0 3 1.69 3 3.5 0 1.41-.91 2.72-2 3.25V8.59c.58-.45 1-1.27 1-2.09C10 5.22 8.98 4 8 4H4c-.98 0-2 1.22-2 2.5S3 9 4 9zm9-3h-1v1h1c1 0 2 1.22 2 2.5S13.98 12 13 12H9c-.98 0-2-1.22-2-2.5 0-.83.42-1.64 1-2.09V6.25c-1.09.53-2 1.84-2 3.25C6 11.31 7.55 13 9 13h4c1.45 0 3-1.69 3-3.5S14.5 6 13 6z"></path></svg></a>Spacing</h2>\n<p>Use these variables on <code>margin</code> and <code>padding</code> declarations to ensure consistent spacing across the product.</p>\n<table>\n<thead>\n<tr>\n<th>Name</th>\n<th>Default Value</th>\n</tr>\n</thead>\n<tbody>\n<tr>\n<td><code>$space-0</code></td>\n<td><code>0</code></td>\n</tr>\n<tr>\n<td><code>$space-05</code></td>\n<td><code>0.5rem</code></td>\n</tr>\n<tr>\n<td><code>$space-1</code></td>\n<td><code>1rem</code></td>\n</tr>\n<tr>\n<td><code>$space-2</code></td>\n<td><code>2rem</code></td>\n</tr>\n<tr>\n<td><code>$space-3</code></td>\n<td><code>3rem</code></td>\n</tr>\n<tr>\n<td><code>$space-4</code></td>\n<td><code>4rem</code></td>\n</tr>\n<tr>\n<td><code>$space-5</code></td>\n<td><code>5rem</code></td>\n</tr>\n</tbody>\n</table>\n<h2 id="positioning"><a href="#positioning" aria-hidden="true" class="anchor"><svg aria-hidden="true" height="16" version="1.1" viewBox="0 0 16 16" width="16"><path fill-rule="evenodd" d="M4 9h1v1H4c-1.5 0-3-1.69-3-3.5S2.55 3 4 3h4c1.45 0 3 1.69 3 3.5 0 1.41-.91 2.72-2 3.25V8.59c.58-.45 1-1.27 1-2.09C10 5.22 8.98 4 8 4H4c-.98 0-2 1.22-2 2.5S3 9 4 9zm9-3h-1v1h1c1 0 2 1.22 2 2.5S13.98 12 13 12H9c-.98 0-2-1.22-2-2.5 0-.83.42-1.64 1-2.09V6.25c-1.09.53-2 1.84-2 3.25C6 11.31 7.55 13 9 13h4c1.45 0 3-1.69 3-3.5S14.5 6 13 6z"></path></svg></a>Positioning</h2>\n<h3 id="z-index"><a href="#z-index" aria-hidden="true" class="anchor"><svg aria-hidden="true" height="16" version="1.1" viewBox="0 0 16 16" width="16"><path fill-rule="evenodd" d="M4 9h1v1H4c-1.5 0-3-1.69-3-3.5S2.55 3 4 3h4c1.45 0 3 1.69 3 3.5 0 1.41-.91 2.72-2 3.25V8.59c.58-.45 1-1.27 1-2.09C10 5.22 8.98 4 8 4H4c-.98 0-2 1.22-2 2.5S3 9 4 9zm9-3h-1v1h1c1 0 2 1.22 2 2.5S13.98 12 13 12H9c-.98 0-2-1.22-2-2.5 0-.83.42-1.64 1-2.09V6.25c-1.09.53-2 1.84-2 3.25C6 11.31 7.55 13 9 13h4c1.45 0 3-1.69 3-3.5S14.5 6 13 6z"></path></svg></a>Z-Index</h3>\n<h4 id="relative"><a href="#relative" aria-hidden="true" class="anchor"><svg aria-hidden="true" height="16" version="1.1" viewBox="0 0 16 16" width="16"><path fill-rule="evenodd" d="M4 9h1v1H4c-1.5 0-3-1.69-3-3.5S2.55 3 4 3h4c1.45 0 3 1.69 3 3.5 0 1.41-.91 2.72-2 3.25V8.59c.58-.45 1-1.27 1-2.09C10 5.22 8.98 4 8 4H4c-.98 0-2 1.22-2 2.5S3 9 4 9zm9-3h-1v1h1c1 0 2 1.22 2 2.5S13.98 12 13 12H9c-.98 0-2-1.22-2-2.5 0-.83.42-1.64 1-2.09V6.25c-1.09.53-2 1.84-2 3.25C6 11.31 7.55 13 9 13h4c1.45 0 3-1.69 3-3.5S14.5 6 13 6z"></path></svg></a>Relative</h4>\n<p>Relative indices should be used to describe elements that are absolutely positioned within a containing element. For example, displaying an overlay "above."</p>\n<table>\n<thead>\n<tr>\n<th>Name</th>\n<th>Default Value</th>\n</tr>\n</thead>\n<tbody>\n<tr>\n<td><code>$z-index-above</code></td>\n<td><code>10</code></td>\n</tr>\n<tr>\n<td><code>$z-index-default</code></td>\n<td><code>1</code></td>\n</tr>\n<tr>\n<td><code>$z-index-below</code></td>\n<td><code>-1</code></td>\n</tr>\n</tbody>\n</table>\n<h4 id="absolute"><a href="#absolute" aria-hidden="true" class="anchor"><svg aria-hidden="true" height="16" version="1.1" viewBox="0 0 16 16" width="16"><path fill-rule="evenodd" d="M4 9h1v1H4c-1.5 0-3-1.69-3-3.5S2.55 3 4 3h4c1.45 0 3 1.69 3 3.5 0 1.41-.91 2.72-2 3.25V8.59c.58-.45 1-1.27 1-2.09C10 5.22 8.98 4 8 4H4c-.98 0-2 1.22-2 2.5S3 9 4 9zm9-3h-1v1h1c1 0 2 1.22 2 2.5S13.98 12 13 12H9c-.98 0-2-1.22-2-2.5 0-.83.42-1.64 1-2.09V6.25c-1.09.53-2 1.84-2 3.25C6 11.31 7.55 13 9 13h4c1.45 0 3-1.69 3-3.5S14.5 6 13 6z"></path></svg></a>Absolute</h4>\n<p>Absolute indinces should only be used for higher level elements on a page. These are elements that are positioned relatively to the viewport, as opposed to a containing element.</p>\n<table>\n<thead>\n<tr>\n<th>Name</th>\n<th>Default Value</th>\n</tr>\n</thead>\n<tbody>\n<tr>\n<td><code>$z-index-modal</code></td>\n<td><code>5000</code></td>\n</tr>\n<tr>\n<td><code>$z-index-notification</code></td>\n<td><code>4000</code></td>\n</tr>\n<tr>\n<td><code>$z-index-overlay</code></td>\n<td><code>3000</code></td>\n</tr>\n<tr>\n<td><code>$z-index-balloon</code></td>\n<td><code>2000</code></td>\n</tr>\n<tr>\n<td><code>$z-index-sticky</code></td>\n<td><code>1000</code></td>\n</tr>\n</tbody>\n</table>\n<h1 id="units"><a href="#units" aria-hidden="true" class="anchor"><svg aria-hidden="true" height="16" version="1.1" viewBox="0 0 16 16" width="16"><path fill-rule="evenodd" d="M4 9h1v1H4c-1.5 0-3-1.69-3-3.5S2.55 3 4 3h4c1.45 0 3 1.69 3 3.5 0 1.41-.91 2.72-2 3.25V8.59c.58-.45 1-1.27 1-2.09C10 5.22 8.98 4 8 4H4c-.98 0-2 1.22-2 2.5S3 9 4 9zm9-3h-1v1h1c1 0 2 1.22 2 2.5S13.98 12 13 12H9c-.98 0-2-1.22-2-2.5 0-.83.42-1.64 1-2.09V6.25c-1.09.53-2 1.84-2 3.25C6 11.31 7.55 13 9 13h4c1.45 0 3-1.69 3-3.5S14.5 6 13 6z"></path></svg></a>Units</h1>\n<p>For all properties that are not stylistic, we utilize rem units to allow for proper scaling between devices and resolution settings. rem\'s are based on\nthe font-size of the body. At Twitch, we have a base of 10px so that 1rem = 10px.</p>\n<h1 id="naming-selectors"><a href="#naming-selectors" aria-hidden="true" class="anchor"><svg aria-hidden="true" height="16" version="1.1" viewBox="0 0 16 16" width="16"><path fill-rule="evenodd" d="M4 9h1v1H4c-1.5 0-3-1.69-3-3.5S2.55 3 4 3h4c1.45 0 3 1.69 3 3.5 0 1.41-.91 2.72-2 3.25V8.59c.58-.45 1-1.27 1-2.09C10 5.22 8.98 4 8 4H4c-.98 0-2 1.22-2 2.5S3 9 4 9zm9-3h-1v1h1c1 0 2 1.22 2 2.5S13.98 12 13 12H9c-.98 0-2-1.22-2-2.5 0-.83.42-1.64 1-2.09V6.25c-1.09.53-2 1.84-2 3.25C6 11.31 7.55 13 9 13h4c1.45 0 3-1.69 3-3.5S14.5 6 13 6z"></path></svg></a>Naming Selectors</h1>\n<p>We utilize the BEM naming structure within our component styles to allow CSS to be used outside of React environments. The BEM methodology couples well with component-based thinking in that simpler, reusable components should be favored over a complex block. Using BEM selectors eliminates issues caused by inheritance that occurs when selecting elements through specificity.</p>\n<p>Tip: If you find yourself needing to write a second element, odds are that you should consider a new component all together.</p>\n<div class="gatsby-highlight">\n      <pre class="language-sass"><code><span class="token selector">.block</span>\n\n  <span class="token selector">&amp;__element</span>\n    <span class="token selector">&amp;--modifier</span>\n\n  <span class="token selector">&amp;--modifier</span>\n</code></pre>\n      </div>\n<h1 id="scope"><a href="#scope" aria-hidden="true" class="anchor"><svg aria-hidden="true" height="16" version="1.1" viewBox="0 0 16 16" width="16"><path fill-rule="evenodd" d="M4 9h1v1H4c-1.5 0-3-1.69-3-3.5S2.55 3 4 3h4c1.45 0 3 1.69 3 3.5 0 1.41-.91 2.72-2 3.25V8.59c.58-.45 1-1.27 1-2.09C10 5.22 8.98 4 8 4H4c-.98 0-2 1.22-2 2.5S3 9 4 9zm9-3h-1v1h1c1 0 2 1.22 2 2.5S13.98 12 13 12H9c-.98 0-2-1.22-2-2.5 0-.83.42-1.64 1-2.09V6.25c-1.09.53-2 1.84-2 3.25C6 11.31 7.55 13 9 13h4c1.45 0 3-1.69 3-3.5S14.5 6 13 6z"></path></svg></a>Scope</h1>\n<p>Component styles should only select elements that are in their corresponding component mark up. Selecting elements outside of this scope will not work in React and leads to inheritance issues that are hard to track outside of React environments.</p>\n<h1 id="media-queries"><a href="#media-queries" aria-hidden="true" class="anchor"><svg aria-hidden="true" height="16" version="1.1" viewBox="0 0 16 16" width="16"><path fill-rule="evenodd" d="M4 9h1v1H4c-1.5 0-3-1.69-3-3.5S2.55 3 4 3h4c1.45 0 3 1.69 3 3.5 0 1.41-.91 2.72-2 3.25V8.59c.58-.45 1-1.27 1-2.09C10 5.22 8.98 4 8 4H4c-.98 0-2 1.22-2 2.5S3 9 4 9zm9-3h-1v1h1c1 0 2 1.22 2 2.5S13.98 12 13 12H9c-.98 0-2-1.22-2-2.5 0-.83.42-1.64 1-2.09V6.25c-1.09.53-2 1.84-2 3.25C6 11.31 7.55 13 9 13h4c1.45 0 3-1.69 3-3.5S14.5 6 13 6z"></path></svg></a>Media Queries</h1>\n<p>In an effort to adopt mobile-first mindset, our media queries add styles progressively through <code>min-width</code>. Styles outside of media queries are always applied, and styles within media queries are applied from the width of the breakpoint and up.\nBreakpoints should only be accessed through the <code>mq</code> mixin that excepts the following keys: <code>xs</code>, <code>sm</code>, <code>md</code>, <code>lg</code>, <code>xl</code>, and <code>xxl</code>.</p>\n<div class="gatsby-highlight">\n      <pre class="language-sass"><code><span class="token atrule-line"><span class="token atrule">+</span>mq(\'sm\')</span>\n</code></pre>\n      </div>\n<h2 id="breakpoints"><a href="#breakpoints" aria-hidden="true" class="anchor"><svg aria-hidden="true" height="16" version="1.1" viewBox="0 0 16 16" width="16"><path fill-rule="evenodd" d="M4 9h1v1H4c-1.5 0-3-1.69-3-3.5S2.55 3 4 3h4c1.45 0 3 1.69 3 3.5 0 1.41-.91 2.72-2 3.25V8.59c.58-.45 1-1.27 1-2.09C10 5.22 8.98 4 8 4H4c-.98 0-2 1.22-2 2.5S3 9 4 9zm9-3h-1v1h1c1 0 2 1.22 2 2.5S13.98 12 13 12H9c-.98 0-2-1.22-2-2.5 0-.83.42-1.64 1-2.09V6.25c-1.09.53-2 1.84-2 3.25C6 11.31 7.55 13 9 13h4c1.45 0 3-1.69 3-3.5S14.5 6 13 6z"></path></svg></a>Breakpoints</h2>\n<div class="gatsby-highlight">\n      <pre class="language-sass"><code><span class="token variable-line"><span class="token variable">$breakpoints</span><span class="token punctuation">:</span> (</span>\n  <span class="token string">\'xs\'</span><span class="token selector">:  480px</span><span class="token selector">,</span>\n  <span class="token string">\'sm\'</span><span class="token selector">:  768px</span><span class="token selector">,</span>\n  <span class="token string">\'md\'</span><span class="token selector">:  1024px</span><span class="token selector">,</span>\n  <span class="token string">\'lg\'</span><span class="token selector">:  1200px</span><span class="token selector">,</span>\n  <span class="token string">\'xl\'</span><span class="token selector">:  1440px</span><span class="token selector">,</span>\n  <span class="token string">\'xxl\'</span><span class="token selector">: 1600px</span>\n<span class="token selector">) !default;</span>\n</code></pre>\n      </div>\n<h1 id="style-and-linting"><a href="#style-and-linting" aria-hidden="true" class="anchor"><svg aria-hidden="true" height="16" version="1.1" viewBox="0 0 16 16" width="16"><path fill-rule="evenodd" d="M4 9h1v1H4c-1.5 0-3-1.69-3-3.5S2.55 3 4 3h4c1.45 0 3 1.69 3 3.5 0 1.41-.91 2.72-2 3.25V8.59c.58-.45 1-1.27 1-2.09C10 5.22 8.98 4 8 4H4c-.98 0-2 1.22-2 2.5S3 9 4 9zm9-3h-1v1h1c1 0 2 1.22 2 2.5S13.98 12 13 12H9c-.98 0-2-1.22-2-2.5 0-.83.42-1.64 1-2.09V6.25c-1.09.53-2 1.84-2 3.25C6 11.31 7.55 13 9 13h4c1.45 0 3-1.69 3-3.5S14.5 6 13 6z"></path></svg></a>Style and Linting</h1>\n<h2 id="comments"><a href="#comments" aria-hidden="true" class="anchor"><svg aria-hidden="true" height="16" version="1.1" viewBox="0 0 16 16" width="16"><path fill-rule="evenodd" d="M4 9h1v1H4c-1.5 0-3-1.69-3-3.5S2.55 3 4 3h4c1.45 0 3 1.69 3 3.5 0 1.41-.91 2.72-2 3.25V8.59c.58-.45 1-1.27 1-2.09C10 5.22 8.98 4 8 4H4c-.98 0-2 1.22-2 2.5S3 9 4 9zm9-3h-1v1h1c1 0 2 1.22 2 2.5S13.98 12 13 12H9c-.98 0-2-1.22-2-2.5 0-.83.42-1.64 1-2.09V6.25c-1.09.53-2 1.84-2 3.25C6 11.31 7.55 13 9 13h4c1.45 0 3-1.69 3-3.5S14.5 6 13 6z"></path></svg></a>Comments</h2>\n<div class="gatsby-highlight">\n      <pre class="language-sass"><code><span class="token comment">// ------------------------------------------------------------------------</span>\n<span class="token comment">// Block Heading</span>\n<span class="token comment">// ------------------------------------------------------------------------</span>\n<span class="token comment">// Staghorn sculpin char sea catfish nibbler false trevally, rockfish.</span>\n<span class="token comment">// Bocaccio prickleback, anglerfish Billfish nurseryfish lanternfish hog</span>\n<span class="token comment">// sucker: tiger shark silver carp surfperch.</span>\n</code></pre>\n      </div>\n<div class="gatsby-highlight">\n      <pre class="language-sass"><code><span class="token comment">// Section Heading</span>\n<span class="token comment">// ------------------------------------------------------------------------</span>\n</code></pre>\n      </div>\n<h2 id="linting-rules"><a href="#linting-rules" aria-hidden="true" class="anchor"><svg aria-hidden="true" height="16" version="1.1" viewBox="0 0 16 16" width="16"><path fill-rule="evenodd" d="M4 9h1v1H4c-1.5 0-3-1.69-3-3.5S2.55 3 4 3h4c1.45 0 3 1.69 3 3.5 0 1.41-.91 2.72-2 3.25V8.59c.58-.45 1-1.27 1-2.09C10 5.22 8.98 4 8 4H4c-.98 0-2 1.22-2 2.5S3 9 4 9zm9-3h-1v1h1c1 0 2 1.22 2 2.5S13.98 12 13 12H9c-.98 0-2-1.22-2-2.5 0-.83.42-1.64 1-2.09V6.25c-1.09.53-2 1.84-2 3.25C6 11.31 7.55 13 9 13h4c1.45 0 3-1.69 3-3.5S14.5 6 13 6z"></path></svg></a>Linting Rules</h2>\n<h3 id="attribute-quotes"><a href="#attribute-quotes" aria-hidden="true" class="anchor"><svg aria-hidden="true" height="16" version="1.1" viewBox="0 0 16 16" width="16"><path fill-rule="evenodd" d="M4 9h1v1H4c-1.5 0-3-1.69-3-3.5S2.55 3 4 3h4c1.45 0 3 1.69 3 3.5 0 1.41-.91 2.72-2 3.25V8.59c.58-.45 1-1.27 1-2.09C10 5.22 8.98 4 8 4H4c-.98 0-2 1.22-2 2.5S3 9 4 9zm9-3h-1v1h1c1 0 2 1.22 2 2.5S13.98 12 13 12H9c-.98 0-2-1.22-2-2.5 0-.83.42-1.64 1-2.09V6.25c-1.09.53-2 1.84-2 3.25C6 11.31 7.55 13 9 13h4c1.45 0 3-1.69 3-3.5S14.5 6 13 6z"></path></svg></a>Attribute Quotes</h3>\n<p>Use single-quotes around attribute values in attribute selectors.</p>\n<div class="gatsby-highlight">\n      <pre class="language-sass"><code><span class="token selector">.selector</span>\n  <span class="token selector">&amp;[type=</span><span class="token string">\'text\'</span><span class="token selector">]</span>\n\n<span class="token comment">// The following is not allowed:</span>\n<span class="token comment">//</span>\n<span class="token comment">// .selector</span>\n<span class="token comment">//   &amp;[type="text"]</span>\n</code></pre>\n      </div>\n<h3 id="bem-depth"><a href="#bem-depth" aria-hidden="true" class="anchor"><svg aria-hidden="true" height="16" version="1.1" viewBox="0 0 16 16" width="16"><path fill-rule="evenodd" d="M4 9h1v1H4c-1.5 0-3-1.69-3-3.5S2.55 3 4 3h4c1.45 0 3 1.69 3 3.5 0 1.41-.91 2.72-2 3.25V8.59c.58-.45 1-1.27 1-2.09C10 5.22 8.98 4 8 4H4c-.98 0-2 1.22-2 2.5S3 9 4 9zm9-3h-1v1h1c1 0 2 1.22 2 2.5S13.98 12 13 12H9c-.98 0-2-1.22-2-2.5 0-.83.42-1.64 1-2.09V6.25c-1.09.53-2 1.84-2 3.25C6 11.31 7.55 13 9 13h4c1.45 0 3-1.69 3-3.5S14.5 6 13 6z"></path></svg></a>BEM Depth</h3>\n<p>Blocks should only have one level of elements.</p>\n<div class="gatsby-highlight">\n      <pre class="language-sass"><code><span class="token selector">.block</span>\n  <span class="token selector">&amp;__element</span>\n\n<span class="token comment">// The following is not allowed:</span>\n<span class="token comment">//</span>\n<span class="token comment">// .block</span>\n<span class="token comment">//   &amp;__element</span>\n<span class="token comment">//     &amp;__element</span>\n</code></pre>\n      </div>\n<h3 id="declarations-before-nesting"><a href="#declarations-before-nesting" aria-hidden="true" class="anchor"><svg aria-hidden="true" height="16" version="1.1" viewBox="0 0 16 16" width="16"><path fill-rule="evenodd" d="M4 9h1v1H4c-1.5 0-3-1.69-3-3.5S2.55 3 4 3h4c1.45 0 3 1.69 3 3.5 0 1.41-.91 2.72-2 3.25V8.59c.58-.45 1-1.27 1-2.09C10 5.22 8.98 4 8 4H4c-.98 0-2 1.22-2 2.5S3 9 4 9zm9-3h-1v1h1c1 0 2 1.22 2 2.5S13.98 12 13 12H9c-.98 0-2-1.22-2-2.5 0-.83.42-1.64 1-2.09V6.25c-1.09.53-2 1.84-2 3.25C6 11.31 7.55 13 9 13h4c1.45 0 3-1.69 3-3.5S14.5 6 13 6z"></path></svg></a>Declarations Before Nesting</h3>\n<p>Declarations within a selector should be written before nested selectors.</p>\n<div class="gatsby-highlight">\n      <pre class="language-sass"><code><span class="token selector">.block</span>\n<span class="token property-line">  <span class="token property">display</span><span class="token punctuation">:</span> block</span>\n\n  <span class="token selector">&amp;__element</span>\n\n<span class="token comment">// The following is not allowed:</span>\n<span class="token comment">//</span>\n<span class="token comment">// .block</span>\n<span class="token comment">//   &amp;__element</span>\n<span class="token comment">//     display: block</span>\n<span class="token comment">//</span>\n<span class="token comment">//   display: block</span>\n</code></pre>\n      </div>\n<h3 id="empty-arguments"><a href="#empty-arguments" aria-hidden="true" class="anchor"><svg aria-hidden="true" height="16" version="1.1" viewBox="0 0 16 16" width="16"><path fill-rule="evenodd" d="M4 9h1v1H4c-1.5 0-3-1.69-3-3.5S2.55 3 4 3h4c1.45 0 3 1.69 3 3.5 0 1.41-.91 2.72-2 3.25V8.59c.58-.45 1-1.27 1-2.09C10 5.22 8.98 4 8 4H4c-.98 0-2 1.22-2 2.5S3 9 4 9zm9-3h-1v1h1c1 0 2 1.22 2 2.5S13.98 12 13 12H9c-.98 0-2-1.22-2-2.5 0-.83.42-1.64 1-2.09V6.25c-1.09.53-2 1.84-2 3.25C6 11.31 7.55 13 9 13h4c1.45 0 3-1.69 3-3.5S14.5 6 13 6z"></path></svg></a>Empty Arguments</h3>\n<p>Write mixins without parentheses if no arguments are being supplied.</p>\n<div class="gatsby-highlight">\n      <pre class="language-sass"><code><span class="token selector">.block</span>\n<span class="token atrule-line">  <span class="token atrule">+</span>theme</span>\n\n<span class="token comment">// The following is/are not allowed:</span>\n<span class="token comment">//</span>\n<span class="token comment">// .block</span>\n<span class="token comment">//   +theme()</span>\n</code></pre>\n      </div>\n<h3 id="empty-line-between-blocks"><a href="#empty-line-between-blocks" aria-hidden="true" class="anchor"><svg aria-hidden="true" height="16" version="1.1" viewBox="0 0 16 16" width="16"><path fill-rule="evenodd" d="M4 9h1v1H4c-1.5 0-3-1.69-3-3.5S2.55 3 4 3h4c1.45 0 3 1.69 3 3.5 0 1.41-.91 2.72-2 3.25V8.59c.58-.45 1-1.27 1-2.09C10 5.22 8.98 4 8 4H4c-.98 0-2 1.22-2 2.5S3 9 4 9zm9-3h-1v1h1c1 0 2 1.22 2 2.5S13.98 12 13 12H9c-.98 0-2-1.22-2-2.5 0-.83.42-1.64 1-2.09V6.25c-1.09.53-2 1.84-2 3.25C6 11.31 7.55 13 9 13h4c1.45 0 3-1.69 3-3.5S14.5 6 13 6z"></path></svg></a>Empty Line Between Blocks</h3>\n<p>Leave a line between the declarations of the previous selector.</p>\n<div class="gatsby-highlight">\n      <pre class="language-sass"><code><span class="token selector">.block</span>\n<span class="token property-line">  <span class="token property">display</span><span class="token punctuation">:</span> block</span>\n\n<span class="token selector">.another-block</span>\n<span class="token property-line">  <span class="token property">display</span><span class="token punctuation">:</span> block</span>\n\n<span class="token comment">// This following is not allowed:</span>\n<span class="token comment">//</span>\n<span class="token comment">// .block</span>\n<span class="token comment">//  display: block</span>\n<span class="token comment">//</span>\n<span class="token comment">// .another-block</span>\n<span class="token comment">//  display: block</span>\n</code></pre>\n      </div>\n<h3 id="mixins-before-declarations"><a href="#mixins-before-declarations" aria-hidden="true" class="anchor"><svg aria-hidden="true" height="16" version="1.1" viewBox="0 0 16 16" width="16"><path fill-rule="evenodd" d="M4 9h1v1H4c-1.5 0-3-1.69-3-3.5S2.55 3 4 3h4c1.45 0 3 1.69 3 3.5 0 1.41-.91 2.72-2 3.25V8.59c.58-.45 1-1.27 1-2.09C10 5.22 8.98 4 8 4H4c-.98 0-2 1.22-2 2.5S3 9 4 9zm9-3h-1v1h1c1 0 2 1.22 2 2.5S13.98 12 13 12H9c-.98 0-2-1.22-2-2.5 0-.83.42-1.64 1-2.09V6.25c-1.09.53-2 1.84-2 3.25C6 11.31 7.55 13 9 13h4c1.45 0 3-1.69 3-3.5S14.5 6 13 6z"></path></svg></a>Mixins before Declarations</h3>\n<p>Call mixins at the top of each selector before other declarations. This concept is similar to importing files at the top of a file in React.</p>\n<div class="gatsby-highlight">\n      <pre class="language-sass"><code><span class="token selector">.block</span>\n<span class="token atrule-line">  <span class="token atrule">+</span>theme((color: \'color-text\'))</span>\n<span class="token property-line">  <span class="token property">display</span><span class="token punctuation">:</span> block</span>\n<span class="token property-line">  <span class="token property">padding</span><span class="token punctuation">:</span> <span class="token variable">$space-1</span></span>\n\n<span class="token comment">// The following is not allowed:</span>\n<span class="token comment">//</span>\n<span class="token comment">// .block</span>\n<span class="token comment">//   display: block</span>\n<span class="token comment">//   padding: $space-1</span>\n<span class="token comment">//   +theme((color: \'color-text\'))</span>\n</code></pre>\n      </div>\n<h3 id="force-nesting"><a href="#force-nesting" aria-hidden="true" class="anchor"><svg aria-hidden="true" height="16" version="1.1" viewBox="0 0 16 16" width="16"><path fill-rule="evenodd" d="M4 9h1v1H4c-1.5 0-3-1.69-3-3.5S2.55 3 4 3h4c1.45 0 3 1.69 3 3.5 0 1.41-.91 2.72-2 3.25V8.59c.58-.45 1-1.27 1-2.09C10 5.22 8.98 4 8 4H4c-.98 0-2 1.22-2 2.5S3 9 4 9zm9-3h-1v1h1c1 0 2 1.22 2 2.5S13.98 12 13 12H9c-.98 0-2-1.22-2-2.5 0-.83.42-1.64 1-2.09V6.25c-1.09.53-2 1.84-2 3.25C6 11.31 7.55 13 9 13h4c1.45 0 3-1.69 3-3.5S14.5 6 13 6z"></path></svg></a>Force Nesting</h3>\n<div class="gatsby-highlight">\n      <pre class="language-sass"><code><span class="token selector">.block</span>\n  <span class="token selector">&amp;__element</span>\n\n<span class="token selector">.block</span>\n  <span class="token selector">&amp;[type=</span><span class="token string">\'text\'</span><span class="token selector">]</span>\n\n<span class="token selector">.block</span>\n<span class="token property-line">  <span class="token property">&amp;</span><span class="token punctuation">:</span><span class="token punctuation">:</span><span class="token property">before</span></span>\n\n<span class="token comment">// The following are not allowed:</span>\n<span class="token comment">//</span>\n<span class="token comment">// .block__element</span>\n<span class="token comment">// .block[type=\'text\']</span>\n<span class="token comment">// .block::before</span>\n</code></pre>\n      </div>\n<h3 id="functionmixin-name-format"><a href="#functionmixin-name-format" aria-hidden="true" class="anchor"><svg aria-hidden="true" height="16" version="1.1" viewBox="0 0 16 16" width="16"><path fill-rule="evenodd" d="M4 9h1v1H4c-1.5 0-3-1.69-3-3.5S2.55 3 4 3h4c1.45 0 3 1.69 3 3.5 0 1.41-.91 2.72-2 3.25V8.59c.58-.45 1-1.27 1-2.09C10 5.22 8.98 4 8 4H4c-.98 0-2 1.22-2 2.5S3 9 4 9zm9-3h-1v1h1c1 0 2 1.22 2 2.5S13.98 12 13 12H9c-.98 0-2-1.22-2-2.5 0-.83.42-1.64 1-2.09V6.25c-1.09.53-2 1.84-2 3.25C6 11.31 7.55 13 9 13h4c1.45 0 3-1.69 3-3.5S14.5 6 13 6z"></path></svg></a>Function/Mixin Name Format</h3>\n<p>Functions and mixin names should be all lowercase and utilize hyphens to logically separate words.</p>\n<div class="gatsby-highlight">\n      <pre class="language-sass"><code><span class="token atrule-line"><span class="token atrule">@function</span> function-name($args)</span>\n\n<span class="token comment">// The following are not allowed:</span>\n<span class="token comment">//</span>\n<span class="token comment">// @function functionName($args)</span>\n<span class="token comment">// @function function_name($args)</span>\n</code></pre>\n      </div>\n<h3 id="leading-zero"><a href="#leading-zero" aria-hidden="true" class="anchor"><svg aria-hidden="true" height="16" version="1.1" viewBox="0 0 16 16" width="16"><path fill-rule="evenodd" d="M4 9h1v1H4c-1.5 0-3-1.69-3-3.5S2.55 3 4 3h4c1.45 0 3 1.69 3 3.5 0 1.41-.91 2.72-2 3.25V8.59c.58-.45 1-1.27 1-2.09C10 5.22 8.98 4 8 4H4c-.98 0-2 1.22-2 2.5S3 9 4 9zm9-3h-1v1h1c1 0 2 1.22 2 2.5S13.98 12 13 12H9c-.98 0-2-1.22-2-2.5 0-.83.42-1.64 1-2.09V6.25c-1.09.53-2 1.84-2 3.25C6 11.31 7.55 13 9 13h4c1.45 0 3-1.69 3-3.5S14.5 6 13 6z"></path></svg></a>Leading Zero</h3>\n<div class="gatsby-highlight">\n      <pre class="language-sass"><code><span class="token property-line"><span class="token property">top</span><span class="token punctuation">:</span> 0.5rem</span>\n\n<span class="token comment">// The following is not allowed:</span>\n<span class="token comment">//</span>\n<span class="token comment">// top: .5rem</span>\n</code></pre>\n      </div>\n<h3 id="color-keywordsliterals"><a href="#color-keywordsliterals" aria-hidden="true" class="anchor"><svg aria-hidden="true" height="16" version="1.1" viewBox="0 0 16 16" width="16"><path fill-rule="evenodd" d="M4 9h1v1H4c-1.5 0-3-1.69-3-3.5S2.55 3 4 3h4c1.45 0 3 1.69 3 3.5 0 1.41-.91 2.72-2 3.25V8.59c.58-.45 1-1.27 1-2.09C10 5.22 8.98 4 8 4H4c-.98 0-2 1.22-2 2.5S3 9 4 9zm9-3h-1v1h1c1 0 2 1.22 2 2.5S13.98 12 13 12H9c-.98 0-2-1.22-2-2.5 0-.83.42-1.64 1-2.09V6.25c-1.09.53-2 1.84-2 3.25C6 11.31 7.55 13 9 13h4c1.45 0 3-1.69 3-3.5S14.5 6 13 6z"></path></svg></a>Color Keywords/Literals</h3>\n<div class="gatsby-highlight">\n      <pre class="language-sass"><code><span class="token atrule-line"><span class="token atrule">+</span>theme</span>\n<span class="token property-line">  <span class="token property">color</span><span class="token punctuation">:</span> token(</span><span class="token string">\'color-text\'</span><span class="token selector">)</span>\n\n<span class="token comment">// The following are not allowed:</span>\n<span class="token comment">//</span>\n<span class="token comment">// color: #000</span>\n<span class="token comment">// color: rgb(255, 255, 255)</span>\n<span class="token comment">// color: black</span>\n</code></pre>\n      </div>\n<h3 id="nesting-depth"><a href="#nesting-depth" aria-hidden="true" class="anchor"><svg aria-hidden="true" height="16" version="1.1" viewBox="0 0 16 16" width="16"><path fill-rule="evenodd" d="M4 9h1v1H4c-1.5 0-3-1.69-3-3.5S2.55 3 4 3h4c1.45 0 3 1.69 3 3.5 0 1.41-.91 2.72-2 3.25V8.59c.58-.45 1-1.27 1-2.09C10 5.22 8.98 4 8 4H4c-.98 0-2 1.22-2 2.5S3 9 4 9zm9-3h-1v1h1c1 0 2 1.22 2 2.5S13.98 12 13 12H9c-.98 0-2-1.22-2-2.5 0-.83.42-1.64 1-2.09V6.25c-1.09.53-2 1.84-2 3.25C6 11.31 7.55 13 9 13h4c1.45 0 3-1.69 3-3.5S14.5 6 13 6z"></path></svg></a>Nesting Depth</h3>\n<p>Nesting depth should not exceed 3 levels.</p>\n<div class="gatsby-highlight">\n      <pre class="language-sass"><code><span class="token selector">.block</span>\n  <span class="token selector">&amp;__depth-1</span>\n    <span class="token selector">&amp;--depth-2</span>\n</code></pre>\n      </div>\n<h3 id="combinators"><a href="#combinators" aria-hidden="true" class="anchor"><svg aria-hidden="true" height="16" version="1.1" viewBox="0 0 16 16" width="16"><path fill-rule="evenodd" d="M4 9h1v1H4c-1.5 0-3-1.69-3-3.5S2.55 3 4 3h4c1.45 0 3 1.69 3 3.5 0 1.41-.91 2.72-2 3.25V8.59c.58-.45 1-1.27 1-2.09C10 5.22 8.98 4 8 4H4c-.98 0-2 1.22-2 2.5S3 9 4 9zm9-3h-1v1h1c1 0 2 1.22 2 2.5S13.98 12 13 12H9c-.98 0-2-1.22-2-2.5 0-.83.42-1.64 1-2.09V6.25c-1.09.53-2 1.84-2 3.25C6 11.31 7.55 13 9 13h4c1.45 0 3-1.69 3-3.5S14.5 6 13 6z"></path></svg></a>Combinators</h3>\n<div class="gatsby-highlight">\n      <pre class="language-sass"><code><span class="token selector">.card</span>\n  <span class="token selector">&amp;__title</span>\n\n<span class="token comment">// The following are not allowed:</span>\n<span class="token comment">//</span>\n<span class="token comment">// .card</span>\n<span class="token comment">//   &amp; > h1</span>\n<span class="token comment">//   &amp; > .title</span>\n<span class="token comment">//   &amp; + div</span>\n</code></pre>\n      </div>\n<h3 id="css-comments"><a href="#css-comments" aria-hidden="true" class="anchor"><svg aria-hidden="true" height="16" version="1.1" viewBox="0 0 16 16" width="16"><path fill-rule="evenodd" d="M4 9h1v1H4c-1.5 0-3-1.69-3-3.5S2.55 3 4 3h4c1.45 0 3 1.69 3 3.5 0 1.41-.91 2.72-2 3.25V8.59c.58-.45 1-1.27 1-2.09C10 5.22 8.98 4 8 4H4c-.98 0-2 1.22-2 2.5S3 9 4 9zm9-3h-1v1h1c1 0 2 1.22 2 2.5S13.98 12 13 12H9c-.98 0-2-1.22-2-2.5 0-.83.42-1.64 1-2.09V6.25c-1.09.53-2 1.84-2 3.25C6 11.31 7.55 13 9 13h4c1.45 0 3-1.69 3-3.5S14.5 6 13 6z"></path></svg></a>CSS Comments</h3>\n<p>CSS comments are not allowed, use SASS comments instead.</p>\n<div class="gatsby-highlight">\n      <pre class="language-sass"><code><span class="token comment">// Button</span>\n\n<span class="token comment">// The following is not allowed:</span>\n<span class="token comment">//</span>\n<span class="token comment">// /* Button */</span>\n</code></pre>\n      </div>\n<h3 id="duplicate-properties"><a href="#duplicate-properties" aria-hidden="true" class="anchor"><svg aria-hidden="true" height="16" version="1.1" viewBox="0 0 16 16" width="16"><path fill-rule="evenodd" d="M4 9h1v1H4c-1.5 0-3-1.69-3-3.5S2.55 3 4 3h4c1.45 0 3 1.69 3 3.5 0 1.41-.91 2.72-2 3.25V8.59c.58-.45 1-1.27 1-2.09C10 5.22 8.98 4 8 4H4c-.98 0-2 1.22-2 2.5S3 9 4 9zm9-3h-1v1h1c1 0 2 1.22 2 2.5S13.98 12 13 12H9c-.98 0-2-1.22-2-2.5 0-.83.42-1.64 1-2.09V6.25c-1.09.53-2 1.84-2 3.25C6 11.31 7.55 13 9 13h4c1.45 0 3-1.69 3-3.5S14.5 6 13 6z"></path></svg></a>Duplicate Properties</h3>\n<div class="gatsby-highlight">\n      <pre class="language-sass"><code><span class="token comment">// The following is not allowed</span>\n<span class="token comment">//</span>\n<span class="token comment">// .block</span>\n<span class="token comment">//   display: block</span>\n<span class="token comment">//   position: relative</span>\n<span class="token comment">//   display: inline-block</span>\n</code></pre>\n      </div>\n<h3 id="empty-rulesets"><a href="#empty-rulesets" aria-hidden="true" class="anchor"><svg aria-hidden="true" height="16" version="1.1" viewBox="0 0 16 16" width="16"><path fill-rule="evenodd" d="M4 9h1v1H4c-1.5 0-3-1.69-3-3.5S2.55 3 4 3h4c1.45 0 3 1.69 3 3.5 0 1.41-.91 2.72-2 3.25V8.59c.58-.45 1-1.27 1-2.09C10 5.22 8.98 4 8 4H4c-.98 0-2 1.22-2 2.5S3 9 4 9zm9-3h-1v1h1c1 0 2 1.22 2 2.5S13.98 12 13 12H9c-.98 0-2-1.22-2-2.5 0-.83.42-1.64 1-2.09V6.25c-1.09.53-2 1.84-2 3.25C6 11.31 7.55 13 9 13h4c1.45 0 3-1.69 3-3.5S14.5 6 13 6z"></path></svg></a>Empty Rulesets</h3>\n<p>All selectors must have declarations.</p>\n<h3 id="extends"><a href="#extends" aria-hidden="true" class="anchor"><svg aria-hidden="true" height="16" version="1.1" viewBox="0 0 16 16" width="16"><path fill-rule="evenodd" d="M4 9h1v1H4c-1.5 0-3-1.69-3-3.5S2.55 3 4 3h4c1.45 0 3 1.69 3 3.5 0 1.41-.91 2.72-2 3.25V8.59c.58-.45 1-1.27 1-2.09C10 5.22 8.98 4 8 4H4c-.98 0-2 1.22-2 2.5S3 9 4 9zm9-3h-1v1h1c1 0 2 1.22 2 2.5S13.98 12 13 12H9c-.98 0-2-1.22-2-2.5 0-.83.42-1.64 1-2.09V6.25c-1.09.53-2 1.84-2 3.25C6 11.31 7.55 13 9 13h4c1.45 0 3-1.69 3-3.5S14.5 6 13 6z"></path></svg></a>Extends</h3>\n<p>Extends are not allowed.</p>\n<h3 id="id-selectors"><a href="#id-selectors" aria-hidden="true" class="anchor"><svg aria-hidden="true" height="16" version="1.1" viewBox="0 0 16 16" width="16"><path fill-rule="evenodd" d="M4 9h1v1H4c-1.5 0-3-1.69-3-3.5S2.55 3 4 3h4c1.45 0 3 1.69 3 3.5 0 1.41-.91 2.72-2 3.25V8.59c.58-.45 1-1.27 1-2.09C10 5.22 8.98 4 8 4H4c-.98 0-2 1.22-2 2.5S3 9 4 9zm9-3h-1v1h1c1 0 2 1.22 2 2.5S13.98 12 13 12H9c-.98 0-2-1.22-2-2.5 0-.83.42-1.64 1-2.09V6.25c-1.09.53-2 1.84-2 3.25C6 11.31 7.55 13 9 13h4c1.45 0 3-1.69 3-3.5S14.5 6 13 6z"></path></svg></a>ID Selectors</h3>\n<div class="gatsby-highlight">\n      <pre class="language-sass"><code><span class="token selector">.selector</span>\n\n<span class="token comment">// The following is disallowed:</span>\n<span class="token comment">//</span>\n<span class="token comment">// #selector</span>\n</code></pre>\n      </div>\n<h3 id="important"><a href="#important" aria-hidden="true" class="anchor"><svg aria-hidden="true" height="16" version="1.1" viewBox="0 0 16 16" width="16"><path fill-rule="evenodd" d="M4 9h1v1H4c-1.5 0-3-1.69-3-3.5S2.55 3 4 3h4c1.45 0 3 1.69 3 3.5 0 1.41-.91 2.72-2 3.25V8.59c.58-.45 1-1.27 1-2.09C10 5.22 8.98 4 8 4H4c-.98 0-2 1.22-2 2.5S3 9 4 9zm9-3h-1v1h1c1 0 2 1.22 2 2.5S13.98 12 13 12H9c-.98 0-2-1.22-2-2.5 0-.83.42-1.64 1-2.09V6.25c-1.09.53-2 1.84-2 3.25C6 11.31 7.55 13 9 13h4c1.45 0 3-1.69 3-3.5S14.5 6 13 6z"></path></svg></a>Important</h3>\n<p>The <code>!important</code> tag is not allowed.</p>\n<h3 id="mergeable-selectors"><a href="#mergeable-selectors" aria-hidden="true" class="anchor"><svg aria-hidden="true" height="16" version="1.1" viewBox="0 0 16 16" width="16"><path fill-rule="evenodd" d="M4 9h1v1H4c-1.5 0-3-1.69-3-3.5S2.55 3 4 3h4c1.45 0 3 1.69 3 3.5 0 1.41-.91 2.72-2 3.25V8.59c.58-.45 1-1.27 1-2.09C10 5.22 8.98 4 8 4H4c-.98 0-2 1.22-2 2.5S3 9 4 9zm9-3h-1v1h1c1 0 2 1.22 2 2.5S13.98 12 13 12H9c-.98 0-2-1.22-2-2.5 0-.83.42-1.64 1-2.09V6.25c-1.09.53-2 1.84-2 3.25C6 11.31 7.55 13 9 13h4c1.45 0 3-1.69 3-3.5S14.5 6 13 6z"></path></svg></a>Mergeable Selectors</h3>\n<div class="gatsby-highlight">\n      <pre class="language-sass"><code><span class="token comment">// The following is/are not allowed:</span>\n<span class="token comment">//</span>\n<span class="token comment">// .selector</span>\n<span class="token comment">//   position: absolute</span>\n<span class="token comment">//</span>\n<span class="token comment">// .selector</span>\n<span class="token comment">//   top: 0</span>\n<span class="token comment">//   left: 0</span>\n</code></pre>\n      </div>\n<h3 id="qualifying-elements"><a href="#qualifying-elements" aria-hidden="true" class="anchor"><svg aria-hidden="true" height="16" version="1.1" viewBox="0 0 16 16" width="16"><path fill-rule="evenodd" d="M4 9h1v1H4c-1.5 0-3-1.69-3-3.5S2.55 3 4 3h4c1.45 0 3 1.69 3 3.5 0 1.41-.91 2.72-2 3.25V8.59c.58-.45 1-1.27 1-2.09C10 5.22 8.98 4 8 4H4c-.98 0-2 1.22-2 2.5S3 9 4 9zm9-3h-1v1h1c1 0 2 1.22 2 2.5S13.98 12 13 12H9c-.98 0-2-1.22-2-2.5 0-.83.42-1.64 1-2.09V6.25c-1.09.53-2 1.84-2 3.25C6 11.31 7.55 13 9 13h4c1.45 0 3-1.69 3-3.5S14.5 6 13 6z"></path></svg></a>Qualifying Elements</h3>\n<div class="gatsby-highlight">\n      <pre class="language-sass"><code><span class="token selector">.heading</span>\n<span class="token property-line">  <span class="token property">font-size</span><span class="token punctuation">:</span> <span class="token variable">$font-size-4</span></span>\n\n<span class="token comment">// The following is not allowed:</span>\n<span class="token comment">//</span>\n<span class="token comment">// h2</span>\n<span class="token comment">//   font-size: $font-size-4</span>\n</code></pre>\n      </div>\n<h3 id="transition-all"><a href="#transition-all" aria-hidden="true" class="anchor"><svg aria-hidden="true" height="16" version="1.1" viewBox="0 0 16 16" width="16"><path fill-rule="evenodd" d="M4 9h1v1H4c-1.5 0-3-1.69-3-3.5S2.55 3 4 3h4c1.45 0 3 1.69 3 3.5 0 1.41-.91 2.72-2 3.25V8.59c.58-.45 1-1.27 1-2.09C10 5.22 8.98 4 8 4H4c-.98 0-2 1.22-2 2.5S3 9 4 9zm9-3h-1v1h1c1 0 2 1.22 2 2.5S13.98 12 13 12H9c-.98 0-2-1.22-2-2.5 0-.83.42-1.64 1-2.09V6.25c-1.09.53-2 1.84-2 3.25C6 11.31 7.55 13 9 13h4c1.45 0 3-1.69 3-3.5S14.5 6 13 6z"></path></svg></a>Transition All</h3>\n<p>The use of <code>transition: all</code> is not allowed. Be sure to specify only the properties that are being transitioned.</p>\n<div class="gatsby-highlight">\n      <pre class="language-sass"><code><span class="token property-line"><span class="token property">transition</span><span class="token punctuation">:</span> background-color 0.2s ease-in</span>\n</code></pre>\n      </div>\n<h3 id="universal-selectors"><a href="#universal-selectors" aria-hidden="true" class="anchor"><svg aria-hidden="true" height="16" version="1.1" viewBox="0 0 16 16" width="16"><path fill-rule="evenodd" d="M4 9h1v1H4c-1.5 0-3-1.69-3-3.5S2.55 3 4 3h4c1.45 0 3 1.69 3 3.5 0 1.41-.91 2.72-2 3.25V8.59c.58-.45 1-1.27 1-2.09C10 5.22 8.98 4 8 4H4c-.98 0-2 1.22-2 2.5S3 9 4 9zm9-3h-1v1h1c1 0 2 1.22 2 2.5S13.98 12 13 12H9c-.98 0-2-1.22-2-2.5 0-.83.42-1.64 1-2.09V6.25c-1.09.53-2 1.84-2 3.25C6 11.31 7.55 13 9 13h4c1.45 0 3-1.69 3-3.5S14.5 6 13 6z"></path></svg></a>Universal Selectors</h3>\n<p>The use of the <code>*</code> selector is not allowed.</p>\n<h3 id="vendor-prefixes"><a href="#vendor-prefixes" aria-hidden="true" class="anchor"><svg aria-hidden="true" height="16" version="1.1" viewBox="0 0 16 16" width="16"><path fill-rule="evenodd" d="M4 9h1v1H4c-1.5 0-3-1.69-3-3.5S2.55 3 4 3h4c1.45 0 3 1.69 3 3.5 0 1.41-.91 2.72-2 3.25V8.59c.58-.45 1-1.27 1-2.09C10 5.22 8.98 4 8 4H4c-.98 0-2 1.22-2 2.5S3 9 4 9zm9-3h-1v1h1c1 0 2 1.22 2 2.5S13.98 12 13 12H9c-.98 0-2-1.22-2-2.5 0-.83.42-1.64 1-2.09V6.25c-1.09.53-2 1.84-2 3.25C6 11.31 7.55 13 9 13h4c1.45 0 3-1.69 3-3.5S14.5 6 13 6z"></path></svg></a>Vendor Prefixes</h3>\n<p>We use <code>autoprefixer</code> as part of our build process, so vendor prefix tags (<code>-moz</code>, <code>-webkit</code>, etc.) are not needed.</p>\n<h3 id="property-sort-order"><a href="#property-sort-order" aria-hidden="true" class="anchor"><svg aria-hidden="true" height="16" version="1.1" viewBox="0 0 16 16" width="16"><path fill-rule="evenodd" d="M4 9h1v1H4c-1.5 0-3-1.69-3-3.5S2.55 3 4 3h4c1.45 0 3 1.69 3 3.5 0 1.41-.91 2.72-2 3.25V8.59c.58-.45 1-1.27 1-2.09C10 5.22 8.98 4 8 4H4c-.98 0-2 1.22-2 2.5S3 9 4 9zm9-3h-1v1h1c1 0 2 1.22 2 2.5S13.98 12 13 12H9c-.98 0-2-1.22-2-2.5 0-.83.42-1.64 1-2.09V6.25c-1.09.53-2 1.84-2 3.25C6 11.31 7.55 13 9 13h4c1.45 0 3-1.69 3-3.5S14.5 6 13 6z"></path></svg></a>Property Sort Order</h3>\n<p>Writing CSS declarations in a consistent order allows for easy scanning and prevents writing duplicate properties. Our linter is set to the <a href="https://github.com/sasstools/sass-lint/blob/develop/lib/config/property-sort-orders/smacss.yml">SMACSS Sort Order</a>.</p>\n<div class="gatsby-highlight">\n      <pre class="language-sass"><code><span class="token selector">.selector</span>\n<span class="token property-line">  <span class="token property">display</span><span class="token punctuation">:</span> block</span>\n<span class="token property-line">  <span class="token property">position</span><span class="token punctuation">:</span> absolute</span>\n<span class="token property-line">  <span class="token property">top</span><span class="token punctuation">:</span> 0</span>\n<span class="token property-line">  <span class="token property">left</span><span class="token punctuation">:</span> 0</span>\n<span class="token property-line">  <span class="token property">margin</span><span class="token punctuation">:</span> 0</span>\n<span class="token property-line">  <span class="token property">padding</span><span class="token punctuation">:</span> 0</span>\n<span class="token property-line">  <span class="token property">font-size</span><span class="token punctuation">:</span> <span class="token variable">$font-size-4</span></span>\n</code></pre>\n      </div>\n<h3 id="pseudo-element-selectors"><a href="#pseudo-element-selectors" aria-hidden="true" class="anchor"><svg aria-hidden="true" height="16" version="1.1" viewBox="0 0 16 16" width="16"><path fill-rule="evenodd" d="M4 9h1v1H4c-1.5 0-3-1.69-3-3.5S2.55 3 4 3h4c1.45 0 3 1.69 3 3.5 0 1.41-.91 2.72-2 3.25V8.59c.58-.45 1-1.27 1-2.09C10 5.22 8.98 4 8 4H4c-.98 0-2 1.22-2 2.5S3 9 4 9zm9-3h-1v1h1c1 0 2 1.22 2 2.5S13.98 12 13 12H9c-.98 0-2-1.22-2-2.5 0-.83.42-1.64 1-2.09V6.25c-1.09.53-2 1.84-2 3.25C6 11.31 7.55 13 9 13h4c1.45 0 3-1.69 3-3.5S14.5 6 13 6z"></path></svg></a>Pseudo Element Selectors</h3>\n<div class="gatsby-highlight">\n      <pre class="language-sass"><code><span class="token selector">.selector</span>\n<span class="token property-line">  <span class="token property">&amp;</span><span class="token punctuation">:</span><span class="token punctuation">:</span><span class="token property">before</span></span>\n\n<span class="token comment">// The following is not allowed:</span>\n<span class="token comment">//</span>\n<span class="token comment">// .selector</span>\n<span class="token comment">//   &amp;:before</span>\n</code></pre>\n      </div>\n<h3 id="single-quotes"><a href="#single-quotes" aria-hidden="true" class="anchor"><svg aria-hidden="true" height="16" version="1.1" viewBox="0 0 16 16" width="16"><path fill-rule="evenodd" d="M4 9h1v1H4c-1.5 0-3-1.69-3-3.5S2.55 3 4 3h4c1.45 0 3 1.69 3 3.5 0 1.41-.91 2.72-2 3.25V8.59c.58-.45 1-1.27 1-2.09C10 5.22 8.98 4 8 4H4c-.98 0-2 1.22-2 2.5S3 9 4 9zm9-3h-1v1h1c1 0 2 1.22 2 2.5S13.98 12 13 12H9c-.98 0-2-1.22-2-2.5 0-.83.42-1.64 1-2.09V6.25c-1.09.53-2 1.84-2 3.25C6 11.31 7.55 13 9 13h4c1.45 0 3-1.69 3-3.5S14.5 6 13 6z"></path></svg></a>Single Quotes</h3>\n<p>Use single quotes for everything.</p>\n<div class="gatsby-highlight">\n      <pre class="language-sass"><code><span class="token selector">.selector</span>\n<span class="token property-line">  <span class="token property">&amp;</span><span class="token punctuation">:</span><span class="token punctuation">:</span><span class="token property">before</span></span>\n<span class="token property-line">    <span class="token property">content</span><span class="token punctuation">:</span> </span><span class="token string">\'\'</span>\n</code></pre>\n      </div>\n<h3 id="single-line-per-selector"><a href="#single-line-per-selector" aria-hidden="true" class="anchor"><svg aria-hidden="true" height="16" version="1.1" viewBox="0 0 16 16" width="16"><path fill-rule="evenodd" d="M4 9h1v1H4c-1.5 0-3-1.69-3-3.5S2.55 3 4 3h4c1.45 0 3 1.69 3 3.5 0 1.41-.91 2.72-2 3.25V8.59c.58-.45 1-1.27 1-2.09C10 5.22 8.98 4 8 4H4c-.98 0-2 1.22-2 2.5S3 9 4 9zm9-3h-1v1h1c1 0 2 1.22 2 2.5S13.98 12 13 12H9c-.98 0-2-1.22-2-2.5 0-.83.42-1.64 1-2.09V6.25c-1.09.53-2 1.84-2 3.25C6 11.31 7.55 13 9 13h4c1.45 0 3-1.69 3-3.5S14.5 6 13 6z"></path></svg></a>Single Line Per Selector</h3>\n<p>Each selector should appear on it\'s own line.</p>\n<div class="gatsby-highlight">\n      <pre class="language-sass"><code><span class="token selector">.selector</span><span class="token selector">,</span>\n<span class="token selector">.another</span>\n\n<span class="token comment">// The following is not allowed:</span>\n<span class="token comment">//</span>\n<span class="token comment">// .selector, .another</span>\n</code></pre>\n      </div>\n<h3 id="shorthand"><a href="#shorthand" aria-hidden="true" class="anchor"><svg aria-hidden="true" height="16" version="1.1" viewBox="0 0 16 16" width="16"><path fill-rule="evenodd" d="M4 9h1v1H4c-1.5 0-3-1.69-3-3.5S2.55 3 4 3h4c1.45 0 3 1.69 3 3.5 0 1.41-.91 2.72-2 3.25V8.59c.58-.45 1-1.27 1-2.09C10 5.22 8.98 4 8 4H4c-.98 0-2 1.22-2 2.5S3 9 4 9zm9-3h-1v1h1c1 0 2 1.22 2 2.5S13.98 12 13 12H9c-.98 0-2-1.22-2-2.5 0-.83.42-1.64 1-2.09V6.25c-1.09.53-2 1.84-2 3.25C6 11.31 7.55 13 9 13h4c1.45 0 3-1.69 3-3.5S14.5 6 13 6z"></path></svg></a>Shorthand</h3>\n<div class="gatsby-highlight">\n      <pre class="language-sass"><code><span class="token property-line"><span class="token property">padding</span><span class="token punctuation">:</span> <span class="token variable">$space-1</span> <span class="token variable">$space-2</span></span>\n\n<span class="token comment">// The following are not allowed:</span>\n<span class="token comment">//</span>\n<span class="token comment">// padding: $space-1 $space-2 $space-1 $space-2</span>\n<span class="token comment">//</span>\n<span class="token comment">// padding-top: $space-1</span>\n<span class="token comment">// padding-right: $space-2</span>\n<span class="token comment">// padding-bottom: $space-1</span>\n<span class="token comment">// padding-left: $space-1</span>\n</code></pre>\n      </div>\n<h3 id="spaces"><a href="#spaces" aria-hidden="true" class="anchor"><svg aria-hidden="true" height="16" version="1.1" viewBox="0 0 16 16" width="16"><path fill-rule="evenodd" d="M4 9h1v1H4c-1.5 0-3-1.69-3-3.5S2.55 3 4 3h4c1.45 0 3 1.69 3 3.5 0 1.41-.91 2.72-2 3.25V8.59c.58-.45 1-1.27 1-2.09C10 5.22 8.98 4 8 4H4c-.98 0-2 1.22-2 2.5S3 9 4 9zm9-3h-1v1h1c1 0 2 1.22 2 2.5S13.98 12 13 12H9c-.98 0-2-1.22-2-2.5 0-.83.42-1.64 1-2.09V6.25c-1.09.53-2 1.84-2 3.25C6 11.31 7.55 13 9 13h4c1.45 0 3-1.69 3-3.5S14.5 6 13 6z"></path></svg></a>Spaces</h3>\n<div class="gatsby-highlight">\n      <pre class="language-sass"><code><span class="token property-line"><span class="token property">display</span><span class="token punctuation">:</span> block</span>\n\n<span class="token comment">// The following is not allowed:</span>\n<span class="token comment">//</span>\n<span class="token comment">// display:block</span>\n</code></pre>\n      </div>\n<h3 id="url-quotes"><a href="#url-quotes" aria-hidden="true" class="anchor"><svg aria-hidden="true" height="16" version="1.1" viewBox="0 0 16 16" width="16"><path fill-rule="evenodd" d="M4 9h1v1H4c-1.5 0-3-1.69-3-3.5S2.55 3 4 3h4c1.45 0 3 1.69 3 3.5 0 1.41-.91 2.72-2 3.25V8.59c.58-.45 1-1.27 1-2.09C10 5.22 8.98 4 8 4H4c-.98 0-2 1.22-2 2.5S3 9 4 9zm9-3h-1v1h1c1 0 2 1.22 2 2.5S13.98 12 13 12H9c-.98 0-2-1.22-2-2.5 0-.83.42-1.64 1-2.09V6.25c-1.09.53-2 1.84-2 3.25C6 11.31 7.55 13 9 13h4c1.45 0 3-1.69 3-3.5S14.5 6 13 6z"></path></svg></a>URL Quotes</h3>\n<p>Wrap URL paths in single quotes.</p>\n<div class="gatsby-highlight">\n      <pre class="language-sass"><code><span class="token property-line"><span class="token property">background</span><span class="token punctuation">:</span></span>\n  <span class="token url">url(\'path/to/image\')</span>\n</code></pre>\n      </div>\n<h3 id="variable-name-format"><a href="#variable-name-format" aria-hidden="true" class="anchor"><svg aria-hidden="true" height="16" version="1.1" viewBox="0 0 16 16" width="16"><path fill-rule="evenodd" d="M4 9h1v1H4c-1.5 0-3-1.69-3-3.5S2.55 3 4 3h4c1.45 0 3 1.69 3 3.5 0 1.41-.91 2.72-2 3.25V8.59c.58-.45 1-1.27 1-2.09C10 5.22 8.98 4 8 4H4c-.98 0-2 1.22-2 2.5S3 9 4 9zm9-3h-1v1h1c1 0 2 1.22 2 2.5S13.98 12 13 12H9c-.98 0-2-1.22-2-2.5 0-.83.42-1.64 1-2.09V6.25c-1.09.53-2 1.84-2 3.25C6 11.31 7.55 13 9 13h4c1.45 0 3-1.69 3-3.5S14.5 6 13 6z"></path></svg></a>Variable Name Format</h3>\n<p>Variable names should be lowercase and use hyphens to separate words.</p>\n<div class="gatsby-highlight">\n      <pre class="language-sass"><code><span class="token variable-line"><span class="token variable">$variable-name-format</span><span class="token punctuation">:</span> 1rem</span>\n</code></pre>\n      </div>\n<h3 id="zero-unit"><a href="#zero-unit" aria-hidden="true" class="anchor"><svg aria-hidden="true" height="16" version="1.1" viewBox="0 0 16 16" width="16"><path fill-rule="evenodd" d="M4 9h1v1H4c-1.5 0-3-1.69-3-3.5S2.55 3 4 3h4c1.45 0 3 1.69 3 3.5 0 1.41-.91 2.72-2 3.25V8.59c.58-.45 1-1.27 1-2.09C10 5.22 8.98 4 8 4H4c-.98 0-2 1.22-2 2.5S3 9 4 9zm9-3h-1v1h1c1 0 2 1.22 2 2.5S13.98 12 13 12H9c-.98 0-2-1.22-2-2.5 0-.83.42-1.64 1-2.09V6.25c-1.09.53-2 1.84-2 3.25C6 11.31 7.55 13 9 13h4c1.45 0 3-1.69 3-3.5S14.5 6 13 6z"></path></svg></a>Zero Unit</h3>\n<p>If the value of a property is 0, omit the unit.</p>\n<div class="gatsby-highlight">\n      <pre class="language-sass"><code><span class="token property-line"><span class="token property">margin</span><span class="token punctuation">:</span> 0</span>\n\n<span class="token comment">// The following are not allowed:</span>\n<span class="token comment">//</span>\n<span class="token comment">// margin: 0rem</span>\n<span class="token comment">// margin: 0px</span>\n</code></pre>\n      </div>'
}}},pathContext:{}}}});
//# sourceMappingURL=path---user-interface-guidelines-writing-sass-21ade3a29ea1af9488ff.js.map