/**
 * Gatsby Configuration
 *
 * Resources:
 *   - https://www.gatsbyjs.org/docs/gatsby-config/
 */

require('dotenv').config();
const pathPrefix = process.env.GATSBY_PATH_PREFIX;

const pluginPath = `${__dirname}/compiled/src/plugins`;

module.exports = {
  pathPrefix,
  siteMetadata: {
    title: `Twitch Core Design System`,
  },
  plugins: [

    {
      resolve: `gatsby-plugin-google-analytics`,
      options: {
        trackingId: 'UA-119266098-1',
        head: false, // Puts tracking script in the head instead of the body
        anonymize: true, // optional
        respectDNT: true, // optional
      },
    },

    // Custom source plugin that fetches GitHub data for each component.
    {
      resolve: `${pluginPath}/gatsby-source-github-enterprise/gatsby-node.js`,
      options: {
        user: `carbon-components-prototype`,
        repository: `carbon-components-prototype`,
        token: process.env.GITHUB_ACCESS_TOKEN || ``,
        rootURL: `https://git-aws.internal.justin.tv/api/v3`,
        cwd: `${__dirname}/node_modules/carbon-components-prototype`,
        pattern: `src/components/**/`,
      },
    },

    // Custom source plugin that gets TypeDoc information from components.
    {
      resolve: `${pluginPath}/gatsby-source-components/gatsby-node.js`,
      options: {
        componentSrc: `${__dirname}/node_modules/carbon-components-prototype/src/`,
      },
    },

    // Custom source plugin that gets version information
    {
      resolve: `${pluginPath}/gatsby-version-data/gatsby-node.js`,
    },

    // Source the files needed to build the site. This includes all of the
    // markdown files from `data`.
    {
      resolve: `gatsby-source-filesystem`,
      options: {
        name: `data`,
        path: `${__dirname}/data`,
      },
    },

    // Parse all markdown files (each plugin add/parse some data into
    // graphQL layer).
    {
      resolve: `gatsby-transformer-remark`,
      options: {
        plugins: [
          {
            resolve: `${pluginPath}/gatsby-remark-code-classnames/index.js`,
          },
          {
            resolve: `gatsby-remark-images`,
            options: {
              maxWidth: 690,
              backgroundColor: `#f7f0eb`,
            },
          },
          `gatsby-remark-emoji`,
          `gatsby-remark-copy-linked-files`,
          `gatsby-remark-autolink-headers`,
        ],
      },
    },

    // Load SASS
    {
      resolve: `gatsby-plugin-postcss-sass`,
      options: {
        includePaths: [
          `${__dirname}/src/scss`,
          `${__dirname}/node_modules/carbon-components-prototype/src/scss`,
        ],
        sourceMaps: true,
        postCSSPlugins: [
          require('autoprefixer')(),
        ],
      },
    },

    // Parse JSON files
    `gatsby-transformer-json`,

    // Add typescript stack into webpack
    `gatsby-plugin-typescript`,
  ],
};
