import { Background, Color, CoreText, InjectLayout, StyledLayout } from 'carbon-components-prototype';
import * as React from 'react';

export interface CaptionProps {
  label: string;
  children?: React.ReactNode;
}

export function Caption(props: CaptionProps) {
  return (
    <InjectLayout fullWidth>
      <figcaption>
        {props.children}
        <StyledLayout background={Background.Alt} padding={1}>
          <CoreText color={Color.Alt2}>{props.label}</CoreText>
        </StyledLayout>
      </figcaption>
    </InjectLayout>
  );
}
