import {
  AlignItems,
  Background,
  BorderRadius,
  Color,
  Display,
  FlexDirection,
  JustifyContent,
  Layout,
  Position,
  StyledLayout,
  ZIndex,
} from 'carbon-components-prototype';
import * as core from 'carbon-components-prototype';
import * as classnames from 'classnames';
import * as React from 'react';
import {
  LiveError,
  LivePreview,
  LiveProvider,
} from 'react-live';
import { TabsParentExample } from '../../examples/tabs-parent';
import { trackPreviewThemeToggle } from '../../utils/analytics';
import { ThemeSwitcher } from '../theme-switcher';
import './styles.scss';

interface Props {
  children?: React.ReactNode;
  centerContent?: boolean;
  onLoad?: (isLoaded: boolean) => void;
  renderCode: string;
  showOverlay?: boolean;
  refDelegate?: (e: HTMLDivElement) => void;
  width?: number;
}

interface State {
}

export class CodePreview extends React.Component<Props, State> {
  public render () {
    const classes: ClassValue = {
      'code-preview': true,
      'code-preview--center-content': this.props.centerContent,
      'code-preview--show-overlay': this.props.showOverlay,
    };

    return (
      <Layout fullWidth fullHeight>
        <StyledLayout
          className={classnames(classes)}
          borderRadius={BorderRadius.Small}
          background={Background.Alt}
          color={Color.Base}
          display={Display.Flex}
          flexDirection={FlexDirection.Column}
          alignItems={AlignItems.Center}
          justifyContent={JustifyContent.Center}
          position={Position.Relative}
          padding={2}
          fullWidth
          fullHeight
        >
          <Layout
            display={Display.Flex}
            alignItems={AlignItems.Center}
            justifyContent={JustifyContent.Center}
            padding={2}
            fullWidth
          >
            <Layout position={Position.Absolute} zIndex={ZIndex.Above} attachTop attachRight padding={1}>
              <ThemeSwitcher onThemeSwitch={trackPreviewThemeToggle} />
            </Layout>
            <div
              onLoad={this.handleLoaded}
              ref={this.props.refDelegate}
              style={{ width: this.props.width }}
              className="code-preview__inner"
            >
              <LiveProvider
                code={this.props.renderCode}
                scope={{
                  ...core,
                  // TODO: Remove this in favor of inline code examples: https://jira.twitch.com/browse/COREUI-761
                  TabsParentExample,
                }}
              >
                <LiveError />
                <LivePreview />
              </LiveProvider>
            </div>
          </Layout>

          {this.props.children && (
            <Layout
              padding={{ top: 2 }}
              fullWidth
            >
              {this.props.children}
            </Layout>
          )}
        </StyledLayout>
      </Layout>
    );
  }

  private handleLoaded = () => {
    if (this.props.onLoad) {
      this.props.onLoad(true);
    }
  }
}
