import { Background, Button, ButtonType, CoreText, Display, Input, InputType, Layout, StyledLayout, TextType, Typeset } from 'carbon-components-prototype';
import { withPrefix } from 'gatsby-link';
import * as React from 'react';
import { trackContributeCalloutEdit, trackContributeCalloutFilePath, trackContributeCalloutGuidelines } from '../../utils/analytics';
import './styles.scss';

export interface Props {
  currentPageRelativePath: string;
}

export const ContributeCallout: React.StatelessComponent<Props> = (props: Props) => {

  const gitHubEditURL = `https://git-aws.internal.justin.tv/core-ui/core-ui-docs/edit/master/${props.currentPageRelativePath}`;

  return (
    <StyledLayout
      className="contribute-callout"
      background={Background.Alt}
      padding={3}
      margin={{ top: 2 }}
    >
      <CoreText type={TextType.H2}>
        Want to make this page better?
      </CoreText>
      <Layout margin={{ y: 1 }}>
        <Typeset>
          <p>You can help improve this documentation for everyone by submitting a pull request to:</p>
          <ul>
            <li>Edit text to clarify existing examples or properties</li>
            <li>Add new code examples of common and/or tricky use cases</li>
            <li>Fix bugs or typos</li>
          </ul>
        </Typeset>
      </Layout>
      <Layout margin={{ top: 3 }}>
        <Typeset>
          <p>This page is auto-magically generated from this Markdown file:</p>
        </Typeset>
        <Input
          type={InputType.Text}
          placeholder="Display Name"
          value={props.currentPageRelativePath}
          readOnly
          onFocus={trackContributeCalloutFilePath}
        />
      </Layout>
      <Layout margin={{ top: 2 }} display={Display.Flex}>
        <Layout margin={{ right: 1 }}>
          <Button linkTo={withPrefix('user-interface/contribute')} type={ButtonType.Hollow} onClick={trackContributeCalloutGuidelines}>
            Core UI Contribution Guidelines
          </Button>
        </Layout>
        <Layout margin={{ right: 1 }}>
          <Button linkTo={gitHubEditURL} targetBlank onClick={trackContributeCalloutEdit}>
            Edit on Github
          </Button>
        </Layout>
      </Layout>
    </StyledLayout>
  );
};
