import {
  Column,
  Grid,
  GridGutterSize,
} from 'carbon-components-prototype';
import { Columns } from 'carbon-components-prototype/src/components/grid/column';
import * as React from 'react';
import { parseMarkdownFromString } from '../../../../utils/parse-markdown-from-string';
import { Markdown } from '../../../markdown';

export interface BlockColumn {
  body?: string;
  cols?: Columns;
}

interface Props {
  data: BlockColumn[];
}

export class BlockColumns extends React.Component<Props, {}> {

  public render() {
    const { data } = this.props;

    return (
      <Grid gutterSize={GridGutterSize.Medium}>
        {data.map((column, index) => (
          <Column cols={{ default: 12, md: column.cols }} key={index}>
            <Markdown source={column.body ? parseMarkdownFromString(column.body) : ''} />
          </Column>
        ))}
      </Grid>
    );
  }
}
