import {
  BorderRadius,
  Column,
  CoreImage,
  Display,
  Grid,
  GridGutterSize,
  InjectLayout,
  Layout,
  StyledLayout,
  SVG,
  SVGAsset,
  SVGType,
} from 'carbon-components-prototype';
import * as React from 'react';
import { isVideo } from '../../../../utils/asset-helpers';
import { parseMarkdownFromString } from '../../../../utils/parse-markdown-from-string';
import { Caption } from '../../../caption';
import { Markdown } from '../../../markdown';
import './styles.scss';

export interface BlockGuideline {
  mediaSrc?: string;
  caption?: string;
  type?: string;
  body?: string;
}

interface Props {
  data: BlockGuideline[];
}

export const BlockGuidelines = (props: Props) => {
  const { data } = props;

  return (
    <Grid gutterSize={GridGutterSize.Medium}>
      {data.map((guideline, index) => (
        <Column cols={{ default: 12, md: data && data.length > 1 ? 6 : 12 }} key={index}>
          {guideline.type !== 'dont' ? (
            <SVG asset={SVGAsset.Check} type={SVGType.Success} />
          ) : (
            <SVG asset={SVGAsset.Close} type={SVGType.Warn} />
          )}
          <StyledLayout
            className={`block-guidelines__item--${guideline.type}`}
            borderRadius={BorderRadius.Medium}
            margin={{ bottom: 0.5 }}
          />
          <Layout padding={0.5}>
            {guideline.mediaSrc && !isVideo(guideline.mediaSrc) && (
              <>
                <CoreImage alt="" src={guideline.mediaSrc} />
                {guideline.caption && <Caption label={guideline.caption} />}
              </>
            )}
            {guideline.mediaSrc && isVideo(guideline.mediaSrc) && (
              <>
                <InjectLayout display={Display.Block} fullWidth>
                  <video src={guideline.mediaSrc} controls>
                    Sorry, your browser doesn't support embedded videos.
                  </video>
                </InjectLayout>
                {guideline.caption && <Caption label={guideline.caption} />}
              </>
            )}
            {guideline.body && (
              <Layout margin={{ top: 1 }}>
                <Markdown
                  source={parseMarkdownFromString(guideline.body)}
                  hideCopyCodeButton
                />
              </Layout>
            )}
          </Layout>
        </Column>
      ))}
    </Grid>
  );
};
