import { AlignItems, Background, BorderRadius, CoreImage, Display, FlexDirection, InjectLayout, InjectStyledLayout, JustifyContent, Layout, Position, ZIndex } from 'carbon-components-prototype';
import { Padding } from 'carbon-components-prototype/src/components/layout';
import * as React from 'react';
import { isVideo } from '../../../../utils/asset-helpers';
import { Caption } from '../../../caption';

interface Props {
  data: {
    mediaSrc: string,
    caption?: string,
  };
}

export const BlockMedia = (props: Props) => {
  let mediaElement: JSX.Element | null;

  if (isVideo(props.data.mediaSrc)) {
    mediaElement = (
      <InjectLayout display={Display.Block} fullWidth>
        <video src={props.data.mediaSrc} controls>
          Sorry, your browser doesn't support embedded videos.
        </video>
      </InjectLayout>
    );
  } else {
    mediaElement = (
      <CoreImage alt="" src={props.data.mediaSrc} />
    );
  }

  const wrapperPadding: Padding = props.data.caption ? { top: 3, bottom: 1, x: 3 } : 3;

  return (
    <Layout>
      <InjectStyledLayout
        display={Display.InlineFlex}
        justifyContent={JustifyContent.Center}
        alignItems={AlignItems.Center}
        flexDirection={FlexDirection.Column}
        borderRadius={BorderRadius.Medium}
        background={Background.Alt}
        padding={0}
        breakpointMedium={{
          padding: wrapperPadding,
        }}
      >
        <figure>
          <InjectStyledLayout position={Position.Relative} zIndex={ZIndex.Above} elevation={3}>
            {mediaElement}
          </InjectStyledLayout>
          {props.data.caption && (
            <Layout position={Position.Relative} zIndex={ZIndex.Default} fullWidth>
              <Caption label={props.data.caption} />
            </Layout>
          )}
        </figure>
      </InjectStyledLayout>
    </Layout>
  );
};
