import {
  Background,
  Color,
  Position,
  StyledLayout,
} from 'carbon-components-prototype';
import * as React from 'react';
import './styles.scss';

interface Props {
  children?: React.ReactNode;
}

export const Overlay = (props: Props) => {

  return (
    <StyledLayout
      className="overlay"
      background={Background.Overlay}
      color={Color.Base}
      position={Position.Fixed}
      attachTop
      attachLeft
      fullWidth
      fullHeight
      padding={3}
    >
      {props.children}
    </StyledLayout>
  );
};
