import {
  AlignItems,
  Column,
  Display,
  Grid,
  Layout,
} from 'carbon-components-prototype';
import * as React from 'react';
import { File, TypeDocFile } from '../../graphql-types';
import { getDisplayTitle } from '../../utils/display-titles';
import { parseMarkdownFromString } from '../../utils/parse-markdown-from-string';
import { BaseSize, Markdown } from '../markdown';
import './styles.scss';

interface Props {
  page: File;
  component?: TypeDocFile;
}

export const PageHeading = (props: Props) => {
  let description: string = props.component && props.component.comment && props.component.comment.shortText ? props.component.comment.shortText : '';

  let { childMarkdownRemark } = props.page;

  if (childMarkdownRemark && childMarkdownRemark.frontmatter && childMarkdownRemark.frontmatter.description) {
    description = childMarkdownRemark.frontmatter.description;
  }

  return (
    <div className="page-heading">
      <Layout
        display={Display.Flex}
        alignItems={AlignItems.Center}
        padding={{ bottom: 2 }}
      >
        <Layout flexGrow={1}>
          <h1 className="template__title">{getDisplayTitle(props.page)}</h1>
        </Layout>
      </Layout>
      <Grid>
        <Column cols={8}>
          <Markdown size={BaseSize.Larger} source={parseMarkdownFromString(description)} />
        </Column>
      </Grid>
    </div>
  );
};
