import {
  Layout,
  ResponsiveWrapper,
  StyledLayout,
} from 'carbon-components-prototype';
import * as React from 'react';
import { Helmet } from 'react-helmet';
import { File, FileConnection, SitePage, TypeDocFile } from '../../graphql-types';
import { PageHeading } from '../page-heading';
import { PageTabs } from '../page-tabs';

interface Props {
  children?: React.ReactNode;
  page: SitePage;
  file: File;
  tabs: FileConnection;
  component?: TypeDocFile;
}

export class PageWrapper extends React.Component<Props, {}> {

  public render() {
    return (
      <Layout padding={5}>
        {this.renderPageTitle()}
        <ResponsiveWrapper>
          <StyledLayout margin={{ bottom: 5 }}>
            <PageHeading page={this.props.file} component={this.props.component} />
            <PageTabs
              page={this.props.file}
              tabs={this.props.tabs}
              isComponent={!!this.props.component}
            />
          </StyledLayout>

          {this.props.children}

        </ResponsiveWrapper>
      </Layout>
    );
  }

  private renderPageTitle = () => {
    if (
      this.props.page.context &&
      this.props.page.context.title
    ) {
      return (
        <Helmet>
          <title>{this.props.page.context.title}</title>
        </Helmet>
      );
    }
  }
}

export const defaultPageQuery = graphql`
  fragment defaultPage on RootQueryType {
    indexPage: sitePage(
      path: { eq: $path }
    ) {
      id
      context {
        title
      }
    }
    indexFile: file(
      fields: {
        path: { eq: $pagePath }
        tab: {
          slug: { eq: "index" }
        }
      }
    ) {
      modifiedTime
      relativePath
      fields {
        title
        path
      }
      childMarkdownRemark {
        frontmatter {
          description
          component {
            disablePlayground
          }
        }
      }
    }
    tabs: allFile(
      filter: {
        fields: {
          path: { eq: $pagePath }
        }
      }
    ) {
      edges {
        node {
          relativePath
          fields {
            tabPath
            tab {
              title
              slug
            }
          }
        }
      }
    }
    component: typeDocFile(
      component: {eq: $componentId }
    ) {
      name
      comment {
        shortText
      }
      properties {
        name
        flags {
          isOptional
        }
        type
        sourceSrc
        comment {
          shortText
          tags {
            tag
            text
          }
        }
        availableValues {
          name
          sourceSrc
          values
          properties {
            name
            value
            isOptional
            sourceSrc
          }
        }
        breakpointCompatible
      }
    }
  }
`;
