import { buttonData } from '../../../tests/data/TypeDocFile_Button';
import { propsToRenderString, setupDefaultPropValues } from './property-helpers';

describe('setupDefaultPropValues', () => {

  it('matches the snapshot test', () => {
    const result = setupDefaultPropValues(buttonData.properties || []);
    expect(result).toMatchSnapshot();
  });

});

describe('propsToRenderString', () => {

  it('human readable mode matches the snapshot test', () => {
    const props = setupDefaultPropValues(buttonData.properties || []);

    // Set some props
    let sizeProp = props.find((prop) => (prop.name === 'size'));
    if (sizeProp) {
      sizeProp.currentValue = 'Large';
    }

    // Set another prop
    let ariaProp = props.find((prop) => (prop.name === 'ariaLabel'));
    if (ariaProp) {
      ariaProp.currentValue = 'Hello I am a button';
    }

    // Set another prop
    let blurProp = props.find((prop) => (prop.name === 'blurAfterClick'));
    if (blurProp) {
      blurProp.currentValue = true;
    }

    const result = propsToRenderString('Button', props, true);
    expect(result).toMatchSnapshot();
  });

  it('regular mode matches the snapshot test', () => {
    const props = setupDefaultPropValues(buttonData.properties || []);

    // Set some props
    let sizeProp = props.find((prop) => (prop.name === 'size'));
    if (sizeProp) {
      sizeProp.currentValue = 'Large';
    }

    // Set another prop
    let ariaProp = props.find((prop) => (prop.name === 'ariaLabel'));
    if (ariaProp) {
      ariaProp.currentValue = 'Hello I am a button';
    }

    // Set another prop
    let blurProp = props.find((prop) => (prop.name === 'blurAfterClick'));
    if (blurProp) {
      blurProp.currentValue = true;
    }

    const result = propsToRenderString('Button', props, false);
    expect(result).toMatchSnapshot();
  });

});
