import { Color, CoreLink, CoreLinkType, CoreText, Layout, StyledLayout, TextType } from 'carbon-components-prototype';
import * as React from 'react';
import './styles.scss';

export interface Props {}

export const NoResults: React.SFC<Props> = (_: Props) => (
  <StyledLayout
    className="no-results"
    color={Color.Overlay}
    padding={{ x: 2, y: 2 }}
  >
    <CoreText type={TextType.H2}>
      No Search Results
    </CoreText>
    <Layout margin={{ top: 1 }}>
      <CoreText>
        Need help finding something? Find us on Slack in <CoreLink to="slack://channel?team=T0266V6GF&id=C2BBMF55E" type={CoreLinkType.Overlay}>#core-ui-support</CoreLink>
      </CoreText>
    </Layout>
  </StyledLayout>
);
