import {
  BorderRadius,
  Color,
  CoreText,
  Interactable,
  InteractableType,
  Layout,
  Position,
  TextType,
} from 'carbon-components-prototype';
import { withPrefix } from 'gatsby-link';
import * as React from 'react';
import { FuseMatch } from '../utils/search-utils';
import './styles.scss';

interface Props {
  item: FuseMatch;
  index: number;
  isFocused?: boolean;
  onClick?: (index: number) => void;
}

class SearchResultComponent extends React.Component<Props, {}> {

  constructor(props: Props) {
    super(props);
  }

  public render() {

    return (
      <Interactable
        linkTo={withPrefix(this.props.item.item.path)}
        onClick={this.handleClick}
        type={this.props.isFocused ? InteractableType.Base : InteractableType.Overlay}
        borderRadius={BorderRadius.Medium}
      >
        <Layout
          className="search-result search-result--default"
          position={Position.Relative}
          padding={{ x: 2, y: 2 }}
        >
          <CoreText
            color={this.props.isFocused ? Color.Base : Color.Overlay}
            type={TextType.H2}
          >
            {this.props.item.item.title || '[NO TITLE]'}
          </CoreText>

          <Layout margin={{ top: 0.5 }}>
            <CoreText color={this.props.isFocused ? Color.Alt2 : Color.Overlay}>
              {this.props.item.item.path}
            </CoreText>
          </Layout>

          {this.props.item.item.excerpt && this.props.item.item.excerpt.length > 0 && (
            <Layout margin={{ top: 1 }}>
              <CoreText
                color={this.props.isFocused ? Color.Alt : Color.Overlay}
              >
                {this.truncateExcerpt(this.props.item.item.excerpt, 200)}
              </CoreText>
            </Layout>
          )}
        </Layout>
      </Interactable>
    );
  }

  private truncateExcerpt = (excerpt: string, maxCharLength: number) => {
    return excerpt.substring(0, maxCharLength) + '...';
  }

  private handleClick = () => {
    if (this.props.onClick) {
      this.props.onClick(this.props.index);
    }
  }
}

export const SearchResult = SearchResultComponent;
