import {
  AlignItems,
  AnimatedGlitchLogo,
  ButtonIcon,
  Color,
  Display,
  FlexDirection,
  InjectStyledLayout,
  JustifyContent,
  Layout,
  SVGAsset,
} from 'carbon-components-prototype';
import GatsbyLink, { withPrefix } from 'gatsby-link';
import * as React from 'react';
import { RouteComponentProps, withRouter } from 'react-router-dom';
import { trackSiteThemeToggle } from '../../utils/analytics';
import { VersionNumber } from '../sidebar/components/version-number';
import { ThemeSwitcher } from '../theme-switcher';
import './styles.scss';

interface PublicProps {
  currentProjectVersion: string;
}

type Props = PublicProps & RouteComponentProps<{}>;

class SidebarComponent extends React.Component<Props, {}> {
  constructor(props: Props) {
    super(props);
  }

  public render() {
    return (
      <Layout
        className="sidebar"
        display={Display.Flex}
        flexDirection={FlexDirection.Column}
        alignItems={AlignItems.Center}
        flexShrink={0}
        fullHeight
      >
        <Layout
          display={Display.Flex}
          alignItems={AlignItems.Start}
          justifyContent={JustifyContent.Center}
          flexGrow={0}
          padding={0.5}
          fullWidth
          className="sidebar__heading-bar"
        >
          <InjectStyledLayout
            display={Display.Flex}
            alignItems={AlignItems.Center}
            color={Color.Overlay}
            className="sidebar__brand"
          >
            <GatsbyLink to="/">
              <AnimatedGlitchLogo width={30} height={30} padding={{ x: 1, y: 0.5 }} />
            </GatsbyLink>
          </InjectStyledLayout>
        </Layout>
        <Layout flexGrow={1} flexShrink={1} padding={{ top: 0.5 }}>
          <ButtonIcon
            linkTo={withPrefix('/')}
            icon={SVGAsset.NavSearch}
            ariaLabel="Search"
            overlay
          />
        </Layout>
        <Layout padding={{ bottom: 0.5 }}>
          <ThemeSwitcher onThemeSwitch={trackSiteThemeToggle} />
        </Layout>
        <VersionNumber
          value={this.props.currentProjectVersion}
          linkTo={`https://git-aws.internal.justin.tv/core-ui/core-ui/releases/tag/v${this.props.currentProjectVersion}`}
        />
        <Layout padding={{ top: 0.5, bottom: 1 }}>
          <ButtonIcon
            linkTo="https://git-aws.internal.justin.tv/core-ui/core-ui"
            icon={SVGAsset.Github}
            ariaLabel="Link to Core UI Github Repo"
            overlay
          />
        </Layout>
      </Layout>
    );
  }
}

export const Sidebar: React.ComponentClass<PublicProps> = withRouter(SidebarComponent);
