// import { setupShallowTest } from 'src/tests/helpers';
import { CoreText, Interactable } from 'carbon-components-prototype';
import { setupShallowTest } from '../../../../tests/helpers';
import { Props, VersionNumber } from './component';

function getProps(): Props {
  return {
    value: '1.2.345',
    linkTo: 'https://www.twitch.tv',
  };
}

const setupShallow = setupShallowTest(VersionNumber, getProps);

describe('VersionNumber', () => {
  it('displays the version number as a string', () => {
    const { wrapper } = setupShallow();
    expect(wrapper.find(CoreText).children().text()).toBe('1.2.345');
  });

  it('links to the URL provided', () => {
    const { wrapper } = setupShallow();
    expect(wrapper.find(Interactable).prop('linkTo')).toBe('https://www.twitch.tv');
  });
});
