import {
  Background,
  BorderRadius,
  Color,
  CoreText,
  FontSize,
  Interactable,
  Layout,
  Overflow,
  StyledLayout,
} from 'carbon-components-prototype';
import { LocationDescriptor } from 'history';
import * as React from 'react';

export interface Props {
  value: string;
  linkTo: LocationDescriptor;
}

export const VersionNumber: React.StatelessComponent<Props> = (props: Props) => {
  return (
    <StyledLayout
      borderRadius={BorderRadius.Medium}
      background={Background.AccentAlt2}
      color={Color.Overlay}
      overflow={Overflow.Hidden}
    >
      <Interactable linkTo={props.linkTo}>
        <Layout padding={{ x: 0.5 }}>
          <CoreText fontSize={FontSize.Size7}>
            {props.value}
          </CoreText>
        </Layout>
      </Interactable>
    </StyledLayout>
  );
};
