import {
  BorderRadius,
  CoreText,
  FontSize,
  InjectLayout,
  Interactable,
  InteractableType,
  Layout,
} from 'carbon-components-prototype';
import * as GithubSlugger from 'github-slugger';
import * as React from 'react';
import { MarkdownHeading } from '../../graphql-types';
import { trackTableOfContentsClick } from '../../utils/analytics';

interface Props {
  headings: MarkdownHeading[];
}

export const TableOfContents = (props: Props) => {
  const slugger = new GithubSlugger();

  return (
    <ul>
      {
        props.headings.map((heading, index) => {
          if (heading.depth && heading.depth < 4) {
            return (
              <InjectLayout
                padding={{ left: heading.depth > 2 ? 1 : 0 }}
                margin={{ top: heading.depth < 3 ? 0.5 : 0 }}
                key={index}
              >
                <li>
                  <Interactable
                    linkTo={`#${slugger.slug(heading.value)}`}
                    onClick={trackTableOfContentsClick}
                    type={InteractableType.Alpha}
                    borderRadius={BorderRadius.Medium}
                    blurAfterClick
                  >
                    <Layout padding={{ x: 1, y: 0.5 }}>
                      <CoreText fontSize={FontSize.Size5}>{heading.value}</CoreText>
                    </Layout>
                  </Interactable>
                </li>
              </InjectLayout>
            );
          }
        })
      }
    </ul>
  );
};
