import { Button, ButtonSize, ButtonType, Display, Layout } from 'carbon-components-prototype';
import * as React from 'react';

interface Props {
  onThemeSwitch?: (theme: string) => void;
}

interface State {
  currentValue: string;
}

export class ThemeSwitcher extends React.Component<Props, State> {
  public state = {
    currentValue: '',
  };

  public render() {
    return (
      <Layout display={Display.Flex}>
        <Button ariaLabel="Switch Theme" type={ButtonType.Text} size={ButtonSize.Large} onClick={this.onButtonClick}>
          {this.state.currentValue === 'tw-root--theme-dark' ? '🌝' : '🌞'}
        </Button>
      </Layout>
    );
  }

  public componentDidMount() {
    const previousTheme = localStorage.getItem('currentThemeValue');

    if (previousTheme) {
      this.setCurrentTheme(previousTheme);
      return;
    }

    this.setCurrentTheme('tw-root--theme-light');
  }

  private onButtonClick = (_: React.MouseEvent<HTMLButtonElement>) => {
    const nextValue = this.state.currentValue === 'tw-root--theme-light' ? 'tw-root--theme-dark' : 'tw-root--theme-light';
    this.setCurrentTheme(nextValue);
    localStorage.setItem('currentThemeValue', nextValue);

    if (this.props.onThemeSwitch) {
      this.props.onThemeSwitch(nextValue);
    }
  }

  private setCurrentTheme = (name: string) => {
    const wrapper = document.querySelector('html');

    if (wrapper) {
      wrapper.classList.remove('tw-root--theme-light');
      wrapper.classList.remove('tw-root--theme-dark');
      wrapper.classList.add(name);
    }

    this.setState({
      currentValue: name,
    });
  }
}
