import {
  BorderRadius,
  Color,
  Display,
  Interactable,
  InteractableType,
  StyledLayout,
} from 'carbon-components-prototype';
import * as React from 'react';
import './styles.scss';

interface Props {
  children?: React.ReactNode;
  linkTo: string;
}

export const TileLink = (props: Props) => {
  return (
    <StyledLayout
      display={Display.Flex}
      elevation={3}
      className="tile-link"
    >
      <Interactable
        borderRadius={BorderRadius.Medium}
        linkTo={props.linkTo}
        type={InteractableType.Base}
      >
        <StyledLayout
          color={Color.Base}
          padding={2}
        >
          {props.children}
        </StyledLayout>
      </Interactable>
    </StyledLayout>
  );
};
