import { Layout, Tabs, TabSize, TabsProps } from 'carbon-components-prototype';
import * as React from 'react';

interface Props extends TabsProps {
  showActiveIndex?: boolean;
}

interface State {
  activeIndex: number;
}

export class TabsParentExample extends React.Component<Props, State> {
  public constructor(props: Props) {
    super(props);
    this.state = {
      activeIndex: props.activeTabIndex || 0,
    };
  }

  public render() {
    return (
      <>
        <Tabs
          {...this.props}
          size={this.props.size || TabSize.Large}
          activeTabIndex={this.state.activeIndex}
          tabs={this.props.tabs && this.props.tabs.map((a) => ({ ...a, onClick: this.onClick })) || [
            { onClick: this.onClick, label: 'Live Channels', linkTo: 'https://www.twitch.tv' },
            { onClick: this.onClick, label: 'Videos', linkTo: 'https://www.twitch.tv' },
            { onClick: this.onClick, label: 'Clips', linkTo: 'https://www.twitch.tv' },
          ]}
        />
        {this.props.showActiveIndex && (
          <Layout padding={2}>You are on tab {this.state.activeIndex}</Layout>
        )}
      </>
    );
  }

  private onClick = (e: React.MouseEvent<HTMLElement>, index: number) => {
    e.preventDefault();
    this.setState({
      activeIndex: index,
    });
  }
}
