/* tslint:disable */

export interface RootQueryType {
  allSitePage: SitePageConnection | null;
  allSitePlugin: SitePluginConnection | null;
  allGithubFile: GithubFileConnection | null;
  allTypeDocFile: TypeDocFileConnection | null;
  allConsumerProjectVersionsFile: consumerProjectVersionsFileConnection | null;
  allDirectory: DirectoryConnection | null;
  allFile: FileConnection | null;
  allMarkdownRemark: MarkdownRemarkConnection | null;
  sitePage: SitePage | null;
  sitePlugin: SitePlugin | null;
  site: Site | null;
  githubFile: GithubFile | null;
  typeDocFile: TypeDocFile | null;
  consumerProjectVersionsFile: consumerProjectVersionsFile | null;
  directory: Directory | null;
  file: File | null;
  markdownRemark: MarkdownRemark | null;
}

export interface AllSitePageRootQueryTypeArgs {
  skip: number | null;
  limit: number | null;
  sort: sitePageConnectionSort | null;
  filter: filterSitePage | null;
}

export interface AllSitePluginRootQueryTypeArgs {
  skip: number | null;
  limit: number | null;
  sort: sitePluginConnectionSort | null;
  filter: filterSitePlugin | null;
}

export interface AllGithubFileRootQueryTypeArgs {
  skip: number | null;
  limit: number | null;
  sort: githubFileConnectionSort | null;
  filter: filterGithubFile | null;
}

export interface AllTypeDocFileRootQueryTypeArgs {
  skip: number | null;
  limit: number | null;
  sort: typeDocFileConnectionSort | null;
  filter: filterTypeDocFile | null;
}

export interface AllConsumerProjectVersionsFileRootQueryTypeArgs {
  skip: number | null;
  limit: number | null;
  sort: consumerProjectVersionsFileConnectionSort | null;
  filter: filterConsumerProjectVersionsFile | null;
}

export interface AllDirectoryRootQueryTypeArgs {
  skip: number | null;
  limit: number | null;
  sort: directoryConnectionSort | null;
  filter: filterDirectory | null;
}

export interface AllFileRootQueryTypeArgs {
  skip: number | null;
  limit: number | null;
  sort: fileConnectionSort | null;
  filter: filterFile | null;
}

export interface AllMarkdownRemarkRootQueryTypeArgs {
  skip: number | null;
  limit: number | null;
  sort: markdownRemarkConnectionSort | null;
  filter: filterMarkdownRemark | null;
}

export interface SitePageRootQueryTypeArgs {
  layout: sitePageLayoutQueryString | null;
  jsonName: sitePageJsonNameQueryString | null;
  internalComponentName: sitePageInternalComponentNameQueryString | null;
  path: sitePagePathQueryString_2 | null;
  component: sitePageComponentQueryString | null;
  componentChunkName: sitePageComponentChunkNameQueryString | null;
  context: sitePageContextInputObject | null;
  pluginCreator: sitePagePluginCreatorInputObject | null;
  pluginCreatorId: sitePagePluginCreatorIdQueryString_2 | null;
  componentPath: sitePageComponentPathQueryString | null;
  id: sitePageIdQueryString_2 | null;
  internal: sitePageInternalInputObject_2 | null;
}

export interface SitePluginRootQueryTypeArgs {
  resolve: sitePluginResolveQueryString_2 | null;
  id: sitePluginIdQueryString_2 | null;
  name: sitePluginNameQueryString_2 | null;
  version: sitePluginVersionQueryString_2 | null;
  pluginOptions: sitePluginPluginOptionsInputObject_2 | null;
  nodeAPIs: sitePluginNodeApIsQueryList_2 | null;
  browserAPIs: sitePluginBrowserApIsQueryList_2 | null;
  ssrAPIs: sitePluginSsrApIsQueryList_2 | null;
  pluginFilepath: sitePluginPluginFilepathQueryString_2 | null;
  packageJson: sitePluginPackageJsonInputObject_2 | null;
  internal: sitePluginInternalInputObject_2 | null;
}

export interface SiteRootQueryTypeArgs {
  siteMetadata: siteSiteMetadataInputObject_2 | null;
  port: sitePortQueryString_2 | null;
  host: siteHostQueryString_2 | null;
  polyfill: sitePolyfillQueryBoolean_2 | null;
  buildTime: siteBuildTimeQueryString_2 | null;
  id: siteIdQueryString_2 | null;
  internal: siteInternalInputObject_2 | null;
}

export interface GithubFileRootQueryTypeArgs {
  items: githubFileItemsQueryList_2 | null;
  id: githubFileIdQueryString_2 | null;
  component: githubFileComponentQueryString_2 | null;
  internal: githubFileInternalInputObject_2 | null;
}

export interface TypeDocFileRootQueryTypeArgs {
  id: typeDocFileIdQueryString_2 | null;
  component: typeDocFileComponentQueryString_2 | null;
  name: typeDocFileNameQueryString_2 | null;
  comment: typeDocFileCommentInputObject_2 | null;
  properties: typeDocFilePropertiesQueryList_2 | null;
  internal: typeDocFileInternalInputObject_2 | null;
}

export interface ConsumerProjectVersionsFileRootQueryTypeArgs {
  id: consumerProjectVersionsFileIdQueryString_2 | null;
  currentProjectVersion: consumerProjectVersionsFileCurrentProjectVersionQueryString_2 | null;
  internal: consumerProjectVersionsFileInternalInputObject_2 | null;
}

export interface DirectoryRootQueryTypeArgs {
  id: directoryIdQueryString_2 | null;
  internal: directoryInternalInputObject_2 | null;
  sourceInstanceName: directorySourceInstanceNameQueryString_2 | null;
  absolutePath: directoryAbsolutePathQueryString_2 | null;
  relativePath: directoryRelativePathQueryString_2 | null;
  extension: directoryExtensionQueryString_2 | null;
  size: directorySizeQueryInteger_2 | null;
  prettySize: directoryPrettySizeQueryString_2 | null;
  modifiedTime: directoryModifiedTimeQueryString_2 | null;
  accessTime: directoryAccessTimeQueryString_2 | null;
  changeTime: directoryChangeTimeQueryString_2 | null;
  birthTime: directoryBirthTimeQueryString_2 | null;
  root: directoryRootQueryString_2 | null;
  dir: directoryDirQueryString_2 | null;
  base: directoryBaseQueryString_2 | null;
  ext: directoryExtQueryString_2 | null;
  name: directoryNameQueryString_2 | null;
  relativeDirectory: directoryRelativeDirectoryQueryString_2 | null;
  dev: directoryDevQueryInteger_2 | null;
  mode: directoryModeQueryInteger_2 | null;
  nlink: directoryNlinkQueryInteger_2 | null;
  uid: directoryUidQueryInteger_2 | null;
  gid: directoryGidQueryInteger_2 | null;
  rdev: directoryRdevQueryInteger_2 | null;
  blksize: directoryBlksizeQueryInteger_2 | null;
  ino: directoryInoQueryInteger_2 | null;
  blocks: directoryBlocksQueryInteger_2 | null;
  atimeMs: directoryAtimeMsQueryInteger_2 | null;
  mtimeMs: directoryMtimeMsQueryInteger_2 | null;
  ctimeMs: directoryCtimeMsQueryInteger_2 | null;
  birthtimeMs: directoryBirthtimeMsQueryInteger_2 | null;
  atime: directoryAtimeQueryString_2 | null;
  mtime: directoryMtimeQueryString_2 | null;
  ctime: directoryCtimeQueryString_2 | null;
  birthtime: directoryBirthtimeQueryString_2 | null;
}

export interface FileRootQueryTypeArgs {
  id: fileIdQueryString_2 | null;
  internal: fileInternalInputObject_2 | null;
  sourceInstanceName: fileSourceInstanceNameQueryString_2 | null;
  absolutePath: fileAbsolutePathQueryString_2 | null;
  relativePath: fileRelativePathQueryString_2 | null;
  extension: fileExtensionQueryString_2 | null;
  size: fileSizeQueryInteger_2 | null;
  prettySize: filePrettySizeQueryString_2 | null;
  modifiedTime: fileModifiedTimeQueryString_2 | null;
  accessTime: fileAccessTimeQueryString_2 | null;
  changeTime: fileChangeTimeQueryString_2 | null;
  birthTime: fileBirthTimeQueryString_2 | null;
  root: fileRootQueryString_2 | null;
  dir: fileDirQueryString_2 | null;
  base: fileBaseQueryString_2 | null;
  ext: fileExtQueryString_2 | null;
  name: fileNameQueryString_2 | null;
  relativeDirectory: fileRelativeDirectoryQueryString_2 | null;
  dev: fileDevQueryInteger_2 | null;
  mode: fileModeQueryInteger_2 | null;
  nlink: fileNlinkQueryInteger_2 | null;
  uid: fileUidQueryInteger_2 | null;
  gid: fileGidQueryInteger_2 | null;
  rdev: fileRdevQueryInteger_2 | null;
  blksize: fileBlksizeQueryInteger_2 | null;
  ino: fileInoQueryInteger_2 | null;
  blocks: fileBlocksQueryInteger_2 | null;
  atimeMs: fileAtimeMsQueryInteger_2 | null;
  mtimeMs: fileMtimeMsQueryInteger_2 | null;
  ctimeMs: fileCtimeMsQueryInteger_2 | null;
  birthtimeMs: fileBirthtimeMsQueryInteger_2 | null;
  atime: fileAtimeQueryString_2 | null;
  mtime: fileMtimeQueryString_2 | null;
  ctime: fileCtimeQueryString_2 | null;
  birthtime: fileBirthtimeQueryString_2 | null;
  fields: fileFieldsInputObject_2 | null;
  publicURL: publicUrlQueryString_3 | null;
}

export interface MarkdownRemarkRootQueryTypeArgs {
  id: markdownRemarkIdQueryString_2 | null;
  internal: markdownRemarkInternalInputObject_2 | null;
  frontmatter: markdownRemarkFrontmatterInputObject_2 | null;
  excerpt: excerptQueryString_3 | null;
  fileAbsolutePath: markdownRemarkFileAbsolutePathQueryString_2 | null;
  html: htmlQueryString_3 | null;
  headings: headingsQueryList_3 | null;
  timeToRead: timeToReadQueryInt_3 | null;
  tableOfContents: tableOfContentsQueryString_3 | null;
  wordCount: wordCountTypeName_3 | null;
}

export interface sitePageConnectionSort {
  fields: Array<SitePageConnectionSortByFieldsEnum>;
  order: sitePageConnectionSortOrderValues | null;
}

export type SitePageConnectionSortByFieldsEnum = "layout" | "jsonName" | "internalComponentName" | "path" | "matchPath" | "component" | "componentChunkName" | "context___pagePath" | "context___tab" | "context___componentId" | "context___title" | "pluginCreator___NODE" | "pluginCreatorId" | "componentPath" | "id" | "parent" | "children" | "internal___type" | "internal___contentDigest" | "internal___owner";

export type sitePageConnectionSortOrderValues = "ASC" | "DESC";

export interface filterSitePage {
  layout: sitePageConnectionLayoutQueryString | null;
  jsonName: sitePageConnectionJsonNameQueryString | null;
  internalComponentName: sitePageConnectionInternalComponentNameQueryString | null;
  path: sitePageConnectionPathQueryString_2 | null;
  component: sitePageConnectionComponentQueryString | null;
  componentChunkName: sitePageConnectionComponentChunkNameQueryString | null;
  context: sitePageConnectionContextInputObject | null;
  pluginCreator: sitePageConnectionPluginCreatorInputObject | null;
  pluginCreatorId: sitePageConnectionPluginCreatorIdQueryString_2 | null;
  componentPath: sitePageConnectionComponentPathQueryString | null;
  id: sitePageConnectionIdQueryString_2 | null;
  internal: sitePageConnectionInternalInputObject_2 | null;
}

export interface sitePageConnectionLayoutQueryString {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
}

export interface sitePageConnectionJsonNameQueryString {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
}

export interface sitePageConnectionInternalComponentNameQueryString {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
}

export interface sitePageConnectionPathQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
}

export interface sitePageConnectionComponentQueryString {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
}

export interface sitePageConnectionComponentChunkNameQueryString {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
}

export interface sitePageConnectionContextInputObject {
  pagePath: sitePageConnectionContextPagePathQueryString | null;
  tab: sitePageConnectionContextTabQueryString | null;
  componentId: sitePageConnectionContextComponentIdQueryString | null;
  title: sitePageConnectionContextTitleQueryString | null;
}

export interface sitePageConnectionContextPagePathQueryString {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
}

export interface sitePageConnectionContextTabQueryString {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
}

export interface sitePageConnectionContextComponentIdQueryString {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
}

export interface sitePageConnectionContextTitleQueryString {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
}

export interface sitePageConnectionPluginCreatorInputObject {
  resolve: sitePageConnectionPluginCreatorResolveQueryString | null;
  id: sitePageConnectionPluginCreatorIdQueryString | null;
  name: sitePageConnectionPluginCreatorNameQueryString | null;
  version: sitePageConnectionPluginCreatorVersionQueryString | null;
  pluginOptions: sitePageConnectionPluginCreatorPluginOptionsInputObject | null;
  nodeAPIs: sitePageConnectionPluginCreatorNodeApIsQueryList | null;
  browserAPIs: sitePageConnectionPluginCreatorBrowserApIsQueryList | null;
  ssrAPIs: sitePageConnectionPluginCreatorSsrApIsQueryList | null;
  pluginFilepath: sitePageConnectionPluginCreatorPluginFilepathQueryString | null;
  packageJson: sitePageConnectionPluginCreatorPackageJsonInputObject | null;
  parent: sitePageConnectionPluginCreatorParentQueryString | null;
  internal: sitePageConnectionPluginCreatorInternalInputObject | null;
}

export interface sitePageConnectionPluginCreatorResolveQueryString {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
}

export interface sitePageConnectionPluginCreatorIdQueryString {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
}

export interface sitePageConnectionPluginCreatorNameQueryString {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
}

export interface sitePageConnectionPluginCreatorVersionQueryString {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
}

export interface sitePageConnectionPluginCreatorPluginOptionsInputObject {
  plugins: sitePageConnectionPluginCreatorPluginOptionsPluginsQueryList | null;
  trackingId: sitePageConnectionPluginCreatorPluginOptionsTrackingIdQueryString | null;
  head: sitePageConnectionPluginCreatorPluginOptionsHeadQueryBoolean | null;
  anonymize: sitePageConnectionPluginCreatorPluginOptionsAnonymizeQueryBoolean | null;
  respectDNT: sitePageConnectionPluginCreatorPluginOptionsRespectDntQueryBoolean | null;
  user: sitePageConnectionPluginCreatorPluginOptionsUserQueryString | null;
  repository: sitePageConnectionPluginCreatorPluginOptionsRepositoryQueryString | null;
  token: sitePageConnectionPluginCreatorPluginOptionsTokenQueryString | null;
  rootURL: sitePageConnectionPluginCreatorPluginOptionsRootUrlQueryString | null;
  cwd: sitePageConnectionPluginCreatorPluginOptionsCwdQueryString | null;
  pattern: sitePageConnectionPluginCreatorPluginOptionsPatternQueryString | null;
  componentSrc: sitePageConnectionPluginCreatorPluginOptionsComponentSrcQueryString | null;
  name: sitePageConnectionPluginCreatorPluginOptionsNameQueryString | null;
  path: sitePageConnectionPluginCreatorPluginOptionsPathQueryString | null;
  maxWidth: sitePageConnectionPluginCreatorPluginOptionsMaxWidthQueryInteger | null;
  backgroundColor: sitePageConnectionPluginCreatorPluginOptionsBackgroundColorQueryString | null;
  includePaths: sitePageConnectionPluginCreatorPluginOptionsIncludePathsQueryList | null;
  sourceMaps: sitePageConnectionPluginCreatorPluginOptionsSourceMapsQueryBoolean | null;
  postCSSPlugins: sitePageConnectionPluginCreatorPluginOptionsPostCssPluginsQueryList | null;
}

export interface sitePageConnectionPluginCreatorPluginOptionsPluginsQueryList {
  in: Array<sitePageConnectionPluginCreatorPluginOptionsPluginsInputObject> | null;
}

export interface sitePageConnectionPluginCreatorPluginOptionsPluginsInputObject {
  resolve: sitePageConnectionPluginCreatorPluginOptionsPluginsResolveQueryString | null;
  id: sitePageConnectionPluginCreatorPluginOptionsPluginsIdQueryString | null;
  name: sitePageConnectionPluginCreatorPluginOptionsPluginsNameQueryString | null;
  version: sitePageConnectionPluginCreatorPluginOptionsPluginsVersionQueryString | null;
  pluginOptions: sitePageConnectionPluginCreatorPluginOptionsPluginsPluginOptionsInputObject | null;
  browserAPIs: sitePageConnectionPluginCreatorPluginOptionsPluginsBrowserApIsQueryList | null;
  ssrAPIs: sitePageConnectionPluginCreatorPluginOptionsPluginsSsrApIsQueryList | null;
  pluginFilepath: sitePageConnectionPluginCreatorPluginOptionsPluginsPluginFilepathQueryString | null;
}

export interface sitePageConnectionPluginCreatorPluginOptionsPluginsResolveQueryString {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
}

export interface sitePageConnectionPluginCreatorPluginOptionsPluginsIdQueryString {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
}

export interface sitePageConnectionPluginCreatorPluginOptionsPluginsNameQueryString {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
}

export interface sitePageConnectionPluginCreatorPluginOptionsPluginsVersionQueryString {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
}

export interface sitePageConnectionPluginCreatorPluginOptionsPluginsPluginOptionsInputObject {
  maxWidth: sitePageConnectionPluginCreatorPluginOptionsPluginsPluginOptionsMaxWidthQueryInteger | null;
  backgroundColor: sitePageConnectionPluginCreatorPluginOptionsPluginsPluginOptionsBackgroundColorQueryString | null;
}

export interface sitePageConnectionPluginCreatorPluginOptionsPluginsPluginOptionsMaxWidthQueryInteger {
  eq: number | null;
  ne: number | null;
}

export interface sitePageConnectionPluginCreatorPluginOptionsPluginsPluginOptionsBackgroundColorQueryString {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
}

export interface sitePageConnectionPluginCreatorPluginOptionsPluginsBrowserApIsQueryList {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
}

export interface sitePageConnectionPluginCreatorPluginOptionsPluginsSsrApIsQueryList {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
}

export interface sitePageConnectionPluginCreatorPluginOptionsPluginsPluginFilepathQueryString {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
}

export interface sitePageConnectionPluginCreatorPluginOptionsTrackingIdQueryString {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
}

export interface sitePageConnectionPluginCreatorPluginOptionsHeadQueryBoolean {
  eq: boolean | null;
  ne: boolean | null;
}

export interface sitePageConnectionPluginCreatorPluginOptionsAnonymizeQueryBoolean {
  eq: boolean | null;
  ne: boolean | null;
}

export interface sitePageConnectionPluginCreatorPluginOptionsRespectDntQueryBoolean {
  eq: boolean | null;
  ne: boolean | null;
}

export interface sitePageConnectionPluginCreatorPluginOptionsUserQueryString {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
}

export interface sitePageConnectionPluginCreatorPluginOptionsRepositoryQueryString {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
}

export interface sitePageConnectionPluginCreatorPluginOptionsTokenQueryString {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
}

export interface sitePageConnectionPluginCreatorPluginOptionsRootUrlQueryString {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
}

export interface sitePageConnectionPluginCreatorPluginOptionsCwdQueryString {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
}

export interface sitePageConnectionPluginCreatorPluginOptionsPatternQueryString {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
}

export interface sitePageConnectionPluginCreatorPluginOptionsComponentSrcQueryString {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
}

export interface sitePageConnectionPluginCreatorPluginOptionsNameQueryString {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
}

export interface sitePageConnectionPluginCreatorPluginOptionsPathQueryString {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
}

export interface sitePageConnectionPluginCreatorPluginOptionsMaxWidthQueryInteger {
  eq: number | null;
  ne: number | null;
}

export interface sitePageConnectionPluginCreatorPluginOptionsBackgroundColorQueryString {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
}

export interface sitePageConnectionPluginCreatorPluginOptionsIncludePathsQueryList {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
}

export interface sitePageConnectionPluginCreatorPluginOptionsSourceMapsQueryBoolean {
  eq: boolean | null;
  ne: boolean | null;
}

export interface sitePageConnectionPluginCreatorPluginOptionsPostCssPluginsQueryList {
  in: Array<sitePageConnectionPluginCreatorPluginOptionsPostCssPluginsInputObject> | null;
}

export interface sitePageConnectionPluginCreatorPluginOptionsPostCssPluginsInputObject {
  postcssPlugin: sitePageConnectionPluginCreatorPluginOptionsPostCssPluginsPostcssPluginQueryString | null;
  postcssVersion: sitePageConnectionPluginCreatorPluginOptionsPostCssPluginsPostcssVersionQueryString | null;
}

export interface sitePageConnectionPluginCreatorPluginOptionsPostCssPluginsPostcssPluginQueryString {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
}

export interface sitePageConnectionPluginCreatorPluginOptionsPostCssPluginsPostcssVersionQueryString {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
}

export interface sitePageConnectionPluginCreatorNodeApIsQueryList {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
}

export interface sitePageConnectionPluginCreatorBrowserApIsQueryList {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
}

export interface sitePageConnectionPluginCreatorSsrApIsQueryList {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
}

export interface sitePageConnectionPluginCreatorPluginFilepathQueryString {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
}

export interface sitePageConnectionPluginCreatorPackageJsonInputObject {
  name: sitePageConnectionPluginCreatorPackageJsonNameQueryString | null;
  description: sitePageConnectionPluginCreatorPackageJsonDescriptionQueryString | null;
  version: sitePageConnectionPluginCreatorPackageJsonVersionQueryString | null;
  main: sitePageConnectionPluginCreatorPackageJsonMainQueryString | null;
  author: sitePageConnectionPluginCreatorPackageJsonAuthorQueryString | null;
  license: sitePageConnectionPluginCreatorPackageJsonLicenseQueryString | null;
  dependencies: sitePageConnectionPluginCreatorPackageJsonDependenciesQueryList | null;
  devDependencies: sitePageConnectionPluginCreatorPackageJsonDevDependenciesQueryList | null;
  peerDependencies: sitePageConnectionPluginCreatorPackageJsonPeerDependenciesQueryList | null;
  keywords: sitePageConnectionPluginCreatorPackageJsonKeywordsQueryList | null;
}

export interface sitePageConnectionPluginCreatorPackageJsonNameQueryString {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
}

export interface sitePageConnectionPluginCreatorPackageJsonDescriptionQueryString {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
}

export interface sitePageConnectionPluginCreatorPackageJsonVersionQueryString {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
}

export interface sitePageConnectionPluginCreatorPackageJsonMainQueryString {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
}

export interface sitePageConnectionPluginCreatorPackageJsonAuthorQueryString {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
}

export interface sitePageConnectionPluginCreatorPackageJsonLicenseQueryString {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
}

export interface sitePageConnectionPluginCreatorPackageJsonDependenciesQueryList {
  in: Array<sitePageConnectionPluginCreatorPackageJsonDependenciesInputObject> | null;
}

export interface sitePageConnectionPluginCreatorPackageJsonDependenciesInputObject {
  name: sitePageConnectionPluginCreatorPackageJsonDependenciesNameQueryString | null;
  version: sitePageConnectionPluginCreatorPackageJsonDependenciesVersionQueryString | null;
}

export interface sitePageConnectionPluginCreatorPackageJsonDependenciesNameQueryString {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
}

export interface sitePageConnectionPluginCreatorPackageJsonDependenciesVersionQueryString {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
}

export interface sitePageConnectionPluginCreatorPackageJsonDevDependenciesQueryList {
  in: Array<sitePageConnectionPluginCreatorPackageJsonDevDependenciesInputObject> | null;
}

export interface sitePageConnectionPluginCreatorPackageJsonDevDependenciesInputObject {
  name: sitePageConnectionPluginCreatorPackageJsonDevDependenciesNameQueryString | null;
  version: sitePageConnectionPluginCreatorPackageJsonDevDependenciesVersionQueryString | null;
}

export interface sitePageConnectionPluginCreatorPackageJsonDevDependenciesNameQueryString {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
}

export interface sitePageConnectionPluginCreatorPackageJsonDevDependenciesVersionQueryString {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
}

export interface sitePageConnectionPluginCreatorPackageJsonPeerDependenciesQueryList {
  in: Array<sitePageConnectionPluginCreatorPackageJsonPeerDependenciesInputObject> | null;
}

export interface sitePageConnectionPluginCreatorPackageJsonPeerDependenciesInputObject {
  name: sitePageConnectionPluginCreatorPackageJsonPeerDependenciesNameQueryString | null;
  version: sitePageConnectionPluginCreatorPackageJsonPeerDependenciesVersionQueryString | null;
}

export interface sitePageConnectionPluginCreatorPackageJsonPeerDependenciesNameQueryString {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
}

export interface sitePageConnectionPluginCreatorPackageJsonPeerDependenciesVersionQueryString {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
}

export interface sitePageConnectionPluginCreatorPackageJsonKeywordsQueryList {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
}

export interface sitePageConnectionPluginCreatorParentQueryString {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
}

export interface sitePageConnectionPluginCreatorInternalInputObject {
  contentDigest: sitePageConnectionPluginCreatorInternalContentDigestQueryString | null;
  type: sitePageConnectionPluginCreatorInternalTypeQueryString | null;
  owner: sitePageConnectionPluginCreatorInternalOwnerQueryString | null;
}

export interface sitePageConnectionPluginCreatorInternalContentDigestQueryString {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
}

export interface sitePageConnectionPluginCreatorInternalTypeQueryString {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
}

export interface sitePageConnectionPluginCreatorInternalOwnerQueryString {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
}

export interface sitePageConnectionPluginCreatorIdQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
}

export interface sitePageConnectionComponentPathQueryString {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
}

export interface sitePageConnectionIdQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
}

export interface sitePageConnectionInternalInputObject_2 {
  type: sitePageConnectionInternalTypeQueryString_2 | null;
  contentDigest: sitePageConnectionInternalContentDigestQueryString_2 | null;
  owner: sitePageConnectionInternalOwnerQueryString_2 | null;
}

export interface sitePageConnectionInternalTypeQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
}

export interface sitePageConnectionInternalContentDigestQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
}

export interface sitePageConnectionInternalOwnerQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
}

export interface SitePageConnection {
  pageInfo: PageInfo;
  edges: Array<SitePageEdge> | null;
  totalCount: number | null;
  distinct: Array<string> | null;
  group: Array<sitePageGroupConnectionConnection> | null;
}

export interface DistinctSitePageConnectionArgs {
  field: sitePageDistinctEnum | null;
}

export interface GroupSitePageConnectionArgs {
  skip: number | null;
  limit: number | null;
  field: sitePageGroupEnum | null;
}

export interface PageInfo {
  hasNextPage: boolean;
}

export interface SitePageEdge {
  node: SitePage | null;
  next: SitePage | null;
  previous: SitePage | null;
}

export interface SitePage extends Node {
  id: string;
  parent: Node | null;
  children: Array<Node> | null;
  layout: string | null;
  jsonName: string | null;
  internalComponentName: string | null;
  path: string | null;
  component: string | null;
  componentChunkName: string | null;
  context: context | null;
  pluginCreator: SitePlugin | null;
  pluginCreatorId: string | null;
  componentPath: string | null;
  internal: internal_10 | null;
}

export interface Node {
  id: string;
  parent: Node | null;
  children: Array<Node> | null;
}

export interface context {
  pagePath: string | null;
  tab: string | null;
  componentId: string | null;
  title: string | null;
}

export interface SitePlugin extends Node {
  id: string;
  parent: Node | null;
  children: Array<Node> | null;
  resolve: string | null;
  name: string | null;
  version: string | null;
  pluginOptions: pluginOptions_3 | null;
  nodeAPIs: Array<string> | null;
  browserAPIs: Array<string> | null;
  ssrAPIs: Array<string> | null;
  pluginFilepath: string | null;
  packageJson: packageJson_2 | null;
  internal: internal_11 | null;
}

export interface pluginOptions_3 {
  plugins: Array<plugins_2> | null;
  trackingId: string | null;
  head: boolean | null;
  anonymize: boolean | null;
  respectDNT: boolean | null;
  user: string | null;
  repository: string | null;
  token: string | null;
  rootURL: string | null;
  cwd: string | null;
  pattern: string | null;
  componentSrc: string | null;
  name: string | null;
  path: string | null;
  maxWidth: number | null;
  backgroundColor: string | null;
  includePaths: Array<string> | null;
  sourceMaps: boolean | null;
  postCSSPlugins: Array<postCssPlugins_2> | null;
}

export interface plugins_2 {
  resolve: string | null;
  id: string | null;
  name: string | null;
  version: string | null;
  pluginOptions: pluginOptions_4 | null;
  browserAPIs: Array<string> | null;
  ssrAPIs: Array<string> | null;
  pluginFilepath: string | null;
}

export interface pluginOptions_4 {
  maxWidth: number | null;
  backgroundColor: string | null;
}

export interface postCssPlugins_2 {
  postcssPlugin: string | null;
  postcssVersion: string | null;
}

export interface packageJson_2 {
  name: string | null;
  description: string | null;
  version: string | null;
  main: string | null;
  author: string | null;
  license: string | null;
  dependencies: Array<dependencies_2> | null;
  devDependencies: Array<devDependencies_2> | null;
  peerDependencies: Array<peerDependencies_2> | null;
  keywords: Array<string> | null;
}

export interface dependencies_2 {
  name: string | null;
  version: string | null;
}

export interface devDependencies_2 {
  name: string | null;
  version: string | null;
}

export interface peerDependencies_2 {
  name: string | null;
  version: string | null;
}

export interface internal_11 {
  contentDigest: string | null;
  type: string | null;
  owner: string | null;
}

export interface internal_10 {
  type: string | null;
  contentDigest: string | null;
  owner: string | null;
}

export type sitePageDistinctEnum = "layout" | "jsonName" | "internalComponentName" | "path" | "component" | "componentChunkName" | "context___pagePath" | "context___tab" | "context___componentId" | "context___title" | "pluginCreator___NODE" | "pluginCreatorId" | "componentPath" | "id" | "parent" | "internal___type" | "internal___contentDigest" | "internal___owner";

export type sitePageGroupEnum = "layout" | "jsonName" | "internalComponentName" | "path" | "component" | "componentChunkName" | "context___pagePath" | "context___tab" | "context___componentId" | "context___title" | "pluginCreator___NODE" | "pluginCreatorId" | "componentPath" | "id" | "parent" | "internal___type" | "internal___contentDigest" | "internal___owner";

export interface sitePageGroupConnectionConnection {
  pageInfo: PageInfo;
  edges: Array<sitePageGroupConnectionEdge> | null;
  field: string | null;
  fieldValue: string | null;
  totalCount: number | null;
}

export interface sitePageGroupConnectionEdge {
  node: SitePage | null;
  next: SitePage | null;
  previous: SitePage | null;
}

export interface sitePluginConnectionSort {
  fields: Array<SitePluginConnectionSortByFieldsEnum>;
  order: sitePluginConnectionSortOrderValues | null;
}

export type SitePluginConnectionSortByFieldsEnum = "resolve" | "id" | "name" | "version" | "pluginOptions___plugins" | "pluginOptions___trackingId" | "pluginOptions___head" | "pluginOptions___anonymize" | "pluginOptions___respectDNT" | "pluginOptions___user" | "pluginOptions___repository" | "pluginOptions___token" | "pluginOptions___rootURL" | "pluginOptions___cwd" | "pluginOptions___pattern" | "pluginOptions___componentSrc" | "pluginOptions___name" | "pluginOptions___path" | "pluginOptions___maxWidth" | "pluginOptions___backgroundColor" | "pluginOptions___includePaths" | "pluginOptions___sourceMaps" | "pluginOptions___postCSSPlugins" | "nodeAPIs" | "browserAPIs" | "ssrAPIs" | "pluginFilepath" | "packageJson___name" | "packageJson___description" | "packageJson___version" | "packageJson___main" | "packageJson___author" | "packageJson___license" | "packageJson___dependencies" | "packageJson___devDependencies" | "packageJson___peerDependencies" | "packageJson___optionalDependecies" | "packageJson___bundledDependecies" | "packageJson___keywords" | "parent" | "children" | "internal___contentDigest" | "internal___type" | "internal___owner";

export type sitePluginConnectionSortOrderValues = "ASC" | "DESC";

export interface filterSitePlugin {
  resolve: sitePluginConnectionResolveQueryString_2 | null;
  id: sitePluginConnectionIdQueryString_2 | null;
  name: sitePluginConnectionNameQueryString_2 | null;
  version: sitePluginConnectionVersionQueryString_2 | null;
  pluginOptions: sitePluginConnectionPluginOptionsInputObject_2 | null;
  nodeAPIs: sitePluginConnectionNodeApIsQueryList_2 | null;
  browserAPIs: sitePluginConnectionBrowserApIsQueryList_2 | null;
  ssrAPIs: sitePluginConnectionSsrApIsQueryList_2 | null;
  pluginFilepath: sitePluginConnectionPluginFilepathQueryString_2 | null;
  packageJson: sitePluginConnectionPackageJsonInputObject_2 | null;
  internal: sitePluginConnectionInternalInputObject_2 | null;
}

export interface sitePluginConnectionResolveQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
}

export interface sitePluginConnectionIdQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
}

export interface sitePluginConnectionNameQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
}

export interface sitePluginConnectionVersionQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
}

export interface sitePluginConnectionPluginOptionsInputObject_2 {
  plugins: sitePluginConnectionPluginOptionsPluginsQueryList_2 | null;
  trackingId: sitePluginConnectionPluginOptionsTrackingIdQueryString_2 | null;
  head: sitePluginConnectionPluginOptionsHeadQueryBoolean_2 | null;
  anonymize: sitePluginConnectionPluginOptionsAnonymizeQueryBoolean_2 | null;
  respectDNT: sitePluginConnectionPluginOptionsRespectDntQueryBoolean_2 | null;
  user: sitePluginConnectionPluginOptionsUserQueryString_2 | null;
  repository: sitePluginConnectionPluginOptionsRepositoryQueryString_2 | null;
  token: sitePluginConnectionPluginOptionsTokenQueryString_2 | null;
  rootURL: sitePluginConnectionPluginOptionsRootUrlQueryString_2 | null;
  cwd: sitePluginConnectionPluginOptionsCwdQueryString_2 | null;
  pattern: sitePluginConnectionPluginOptionsPatternQueryString_2 | null;
  componentSrc: sitePluginConnectionPluginOptionsComponentSrcQueryString_2 | null;
  name: sitePluginConnectionPluginOptionsNameQueryString_2 | null;
  path: sitePluginConnectionPluginOptionsPathQueryString_2 | null;
  maxWidth: sitePluginConnectionPluginOptionsMaxWidthQueryInteger_2 | null;
  backgroundColor: sitePluginConnectionPluginOptionsBackgroundColorQueryString_2 | null;
  includePaths: sitePluginConnectionPluginOptionsIncludePathsQueryList_2 | null;
  sourceMaps: sitePluginConnectionPluginOptionsSourceMapsQueryBoolean_2 | null;
  postCSSPlugins: sitePluginConnectionPluginOptionsPostCssPluginsQueryList_2 | null;
}

export interface sitePluginConnectionPluginOptionsPluginsQueryList_2 {
  in: Array<sitePluginConnectionPluginOptionsPluginsInputObject_2> | null;
}

export interface sitePluginConnectionPluginOptionsPluginsInputObject_2 {
  resolve: sitePluginConnectionPluginOptionsPluginsResolveQueryString_2 | null;
  id: sitePluginConnectionPluginOptionsPluginsIdQueryString_2 | null;
  name: sitePluginConnectionPluginOptionsPluginsNameQueryString_2 | null;
  version: sitePluginConnectionPluginOptionsPluginsVersionQueryString_2 | null;
  pluginOptions: sitePluginConnectionPluginOptionsPluginsPluginOptionsInputObject_2 | null;
  browserAPIs: sitePluginConnectionPluginOptionsPluginsBrowserApIsQueryList_2 | null;
  ssrAPIs: sitePluginConnectionPluginOptionsPluginsSsrApIsQueryList_2 | null;
  pluginFilepath: sitePluginConnectionPluginOptionsPluginsPluginFilepathQueryString_2 | null;
}

export interface sitePluginConnectionPluginOptionsPluginsResolveQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
}

export interface sitePluginConnectionPluginOptionsPluginsIdQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
}

export interface sitePluginConnectionPluginOptionsPluginsNameQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
}

export interface sitePluginConnectionPluginOptionsPluginsVersionQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
}

export interface sitePluginConnectionPluginOptionsPluginsPluginOptionsInputObject_2 {
  maxWidth: sitePluginConnectionPluginOptionsPluginsPluginOptionsMaxWidthQueryInteger_2 | null;
  backgroundColor: sitePluginConnectionPluginOptionsPluginsPluginOptionsBackgroundColorQueryString_2 | null;
}

export interface sitePluginConnectionPluginOptionsPluginsPluginOptionsMaxWidthQueryInteger_2 {
  eq: number | null;
  ne: number | null;
}

export interface sitePluginConnectionPluginOptionsPluginsPluginOptionsBackgroundColorQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
}

export interface sitePluginConnectionPluginOptionsPluginsBrowserApIsQueryList_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
}

export interface sitePluginConnectionPluginOptionsPluginsSsrApIsQueryList_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
}

export interface sitePluginConnectionPluginOptionsPluginsPluginFilepathQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
}

export interface sitePluginConnectionPluginOptionsTrackingIdQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
}

export interface sitePluginConnectionPluginOptionsHeadQueryBoolean_2 {
  eq: boolean | null;
  ne: boolean | null;
}

export interface sitePluginConnectionPluginOptionsAnonymizeQueryBoolean_2 {
  eq: boolean | null;
  ne: boolean | null;
}

export interface sitePluginConnectionPluginOptionsRespectDntQueryBoolean_2 {
  eq: boolean | null;
  ne: boolean | null;
}

export interface sitePluginConnectionPluginOptionsUserQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
}

export interface sitePluginConnectionPluginOptionsRepositoryQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
}

export interface sitePluginConnectionPluginOptionsTokenQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
}

export interface sitePluginConnectionPluginOptionsRootUrlQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
}

export interface sitePluginConnectionPluginOptionsCwdQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
}

export interface sitePluginConnectionPluginOptionsPatternQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
}

export interface sitePluginConnectionPluginOptionsComponentSrcQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
}

export interface sitePluginConnectionPluginOptionsNameQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
}

export interface sitePluginConnectionPluginOptionsPathQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
}

export interface sitePluginConnectionPluginOptionsMaxWidthQueryInteger_2 {
  eq: number | null;
  ne: number | null;
}

export interface sitePluginConnectionPluginOptionsBackgroundColorQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
}

export interface sitePluginConnectionPluginOptionsIncludePathsQueryList_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
}

export interface sitePluginConnectionPluginOptionsSourceMapsQueryBoolean_2 {
  eq: boolean | null;
  ne: boolean | null;
}

export interface sitePluginConnectionPluginOptionsPostCssPluginsQueryList_2 {
  in: Array<sitePluginConnectionPluginOptionsPostCssPluginsInputObject_2> | null;
}

export interface sitePluginConnectionPluginOptionsPostCssPluginsInputObject_2 {
  postcssPlugin: sitePluginConnectionPluginOptionsPostCssPluginsPostcssPluginQueryString_2 | null;
  postcssVersion: sitePluginConnectionPluginOptionsPostCssPluginsPostcssVersionQueryString_2 | null;
}

export interface sitePluginConnectionPluginOptionsPostCssPluginsPostcssPluginQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
}

export interface sitePluginConnectionPluginOptionsPostCssPluginsPostcssVersionQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
}

export interface sitePluginConnectionNodeApIsQueryList_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
}

export interface sitePluginConnectionBrowserApIsQueryList_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
}

export interface sitePluginConnectionSsrApIsQueryList_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
}

export interface sitePluginConnectionPluginFilepathQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
}

export interface sitePluginConnectionPackageJsonInputObject_2 {
  name: sitePluginConnectionPackageJsonNameQueryString_2 | null;
  description: sitePluginConnectionPackageJsonDescriptionQueryString_2 | null;
  version: sitePluginConnectionPackageJsonVersionQueryString_2 | null;
  main: sitePluginConnectionPackageJsonMainQueryString_2 | null;
  author: sitePluginConnectionPackageJsonAuthorQueryString_2 | null;
  license: sitePluginConnectionPackageJsonLicenseQueryString_2 | null;
  dependencies: sitePluginConnectionPackageJsonDependenciesQueryList_2 | null;
  devDependencies: sitePluginConnectionPackageJsonDevDependenciesQueryList_2 | null;
  peerDependencies: sitePluginConnectionPackageJsonPeerDependenciesQueryList_2 | null;
  keywords: sitePluginConnectionPackageJsonKeywordsQueryList_2 | null;
}

export interface sitePluginConnectionPackageJsonNameQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
}

export interface sitePluginConnectionPackageJsonDescriptionQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
}

export interface sitePluginConnectionPackageJsonVersionQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
}

export interface sitePluginConnectionPackageJsonMainQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
}

export interface sitePluginConnectionPackageJsonAuthorQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
}

export interface sitePluginConnectionPackageJsonLicenseQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
}

export interface sitePluginConnectionPackageJsonDependenciesQueryList_2 {
  in: Array<sitePluginConnectionPackageJsonDependenciesInputObject_2> | null;
}

export interface sitePluginConnectionPackageJsonDependenciesInputObject_2 {
  name: sitePluginConnectionPackageJsonDependenciesNameQueryString_2 | null;
  version: sitePluginConnectionPackageJsonDependenciesVersionQueryString_2 | null;
}

export interface sitePluginConnectionPackageJsonDependenciesNameQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
}

export interface sitePluginConnectionPackageJsonDependenciesVersionQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
}

export interface sitePluginConnectionPackageJsonDevDependenciesQueryList_2 {
  in: Array<sitePluginConnectionPackageJsonDevDependenciesInputObject_2> | null;
}

export interface sitePluginConnectionPackageJsonDevDependenciesInputObject_2 {
  name: sitePluginConnectionPackageJsonDevDependenciesNameQueryString_2 | null;
  version: sitePluginConnectionPackageJsonDevDependenciesVersionQueryString_2 | null;
}

export interface sitePluginConnectionPackageJsonDevDependenciesNameQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
}

export interface sitePluginConnectionPackageJsonDevDependenciesVersionQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
}

export interface sitePluginConnectionPackageJsonPeerDependenciesQueryList_2 {
  in: Array<sitePluginConnectionPackageJsonPeerDependenciesInputObject_2> | null;
}

export interface sitePluginConnectionPackageJsonPeerDependenciesInputObject_2 {
  name: sitePluginConnectionPackageJsonPeerDependenciesNameQueryString_2 | null;
  version: sitePluginConnectionPackageJsonPeerDependenciesVersionQueryString_2 | null;
}

export interface sitePluginConnectionPackageJsonPeerDependenciesNameQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
}

export interface sitePluginConnectionPackageJsonPeerDependenciesVersionQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
}

export interface sitePluginConnectionPackageJsonKeywordsQueryList_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
}

export interface sitePluginConnectionInternalInputObject_2 {
  contentDigest: sitePluginConnectionInternalContentDigestQueryString_2 | null;
  type: sitePluginConnectionInternalTypeQueryString_2 | null;
  owner: sitePluginConnectionInternalOwnerQueryString_2 | null;
}

export interface sitePluginConnectionInternalContentDigestQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
}

export interface sitePluginConnectionInternalTypeQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
}

export interface sitePluginConnectionInternalOwnerQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
}

export interface SitePluginConnection {
  pageInfo: PageInfo;
  edges: Array<SitePluginEdge> | null;
  totalCount: number | null;
  distinct: Array<string> | null;
  group: Array<sitePluginGroupConnectionConnection> | null;
}

export interface DistinctSitePluginConnectionArgs {
  field: sitePluginDistinctEnum | null;
}

export interface GroupSitePluginConnectionArgs {
  skip: number | null;
  limit: number | null;
  field: sitePluginGroupEnum | null;
}

export interface SitePluginEdge {
  node: SitePlugin | null;
  next: SitePlugin | null;
  previous: SitePlugin | null;
}

export type sitePluginDistinctEnum = "resolve" | "id" | "name" | "version" | "pluginOptions___plugins" | "pluginOptions___trackingId" | "pluginOptions___head" | "pluginOptions___anonymize" | "pluginOptions___respectDNT" | "pluginOptions___user" | "pluginOptions___repository" | "pluginOptions___token" | "pluginOptions___rootURL" | "pluginOptions___cwd" | "pluginOptions___pattern" | "pluginOptions___componentSrc" | "pluginOptions___name" | "pluginOptions___path" | "pluginOptions___maxWidth" | "pluginOptions___backgroundColor" | "pluginOptions___includePaths" | "pluginOptions___sourceMaps" | "pluginOptions___postCSSPlugins" | "nodeAPIs" | "browserAPIs" | "ssrAPIs" | "pluginFilepath" | "packageJson___name" | "packageJson___description" | "packageJson___version" | "packageJson___main" | "packageJson___author" | "packageJson___license" | "packageJson___dependencies" | "packageJson___devDependencies" | "packageJson___peerDependencies" | "packageJson___keywords" | "parent" | "internal___contentDigest" | "internal___type" | "internal___owner";

export type sitePluginGroupEnum = "resolve" | "id" | "name" | "version" | "pluginOptions___plugins" | "pluginOptions___trackingId" | "pluginOptions___head" | "pluginOptions___anonymize" | "pluginOptions___respectDNT" | "pluginOptions___user" | "pluginOptions___repository" | "pluginOptions___token" | "pluginOptions___rootURL" | "pluginOptions___cwd" | "pluginOptions___pattern" | "pluginOptions___componentSrc" | "pluginOptions___name" | "pluginOptions___path" | "pluginOptions___maxWidth" | "pluginOptions___backgroundColor" | "pluginOptions___includePaths" | "pluginOptions___sourceMaps" | "pluginOptions___postCSSPlugins" | "nodeAPIs" | "browserAPIs" | "ssrAPIs" | "pluginFilepath" | "packageJson___name" | "packageJson___description" | "packageJson___version" | "packageJson___main" | "packageJson___author" | "packageJson___license" | "packageJson___dependencies" | "packageJson___devDependencies" | "packageJson___peerDependencies" | "packageJson___keywords" | "parent" | "internal___contentDigest" | "internal___type" | "internal___owner";

export interface sitePluginGroupConnectionConnection {
  pageInfo: PageInfo;
  edges: Array<sitePluginGroupConnectionEdge> | null;
  field: string | null;
  fieldValue: string | null;
  totalCount: number | null;
}

export interface sitePluginGroupConnectionEdge {
  node: SitePlugin | null;
  next: SitePlugin | null;
  previous: SitePlugin | null;
}

export interface githubFileConnectionSort {
  fields: Array<GithubFileConnectionSortByFieldsEnum>;
  order: githubFileConnectionSortOrderValues | null;
}

export type GithubFileConnectionSortByFieldsEnum = "items" | "id" | "component" | "parent" | "children" | "internal___type" | "internal___contentDigest" | "internal___owner";

export type githubFileConnectionSortOrderValues = "ASC" | "DESC";

export interface filterGithubFile {
  items: githubFileConnectionItemsQueryList_2 | null;
  id: githubFileConnectionIdQueryString_2 | null;
  component: githubFileConnectionComponentQueryString_2 | null;
  internal: githubFileConnectionInternalInputObject_2 | null;
}

export interface githubFileConnectionItemsQueryList_2 {
  in: Array<githubFileConnectionItemsInputObject_2> | null;
}

export interface githubFileConnectionItemsInputObject_2 {
  sha: githubFileConnectionItemsShaQueryString_2 | null;
  commit: githubFileConnectionItemsCommitInputObject_2 | null;
  url: githubFileConnectionItemsUrlQueryString_2 | null;
  htmlUrl: githubFileConnectionItemsHtmlUrlQueryString_2 | null;
  commentsUrl: githubFileConnectionItemsCommentsUrlQueryString_2 | null;
  author: githubFileConnectionItemsAuthorInputObject_2 | null;
  committer: githubFileConnectionItemsCommitterInputObject_2 | null;
  parents: githubFileConnectionItemsParentsQueryList_2 | null;
}

export interface githubFileConnectionItemsShaQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
}

export interface githubFileConnectionItemsCommitInputObject_2 {
  author: githubFileConnectionItemsCommitAuthorInputObject_2 | null;
  committer: githubFileConnectionItemsCommitCommitterInputObject_2 | null;
  message: githubFileConnectionItemsCommitMessageQueryString_2 | null;
  tree: githubFileConnectionItemsCommitTreeInputObject_2 | null;
  url: githubFileConnectionItemsCommitUrlQueryString_2 | null;
  commentCount: githubFileConnectionItemsCommitCommentCountQueryInteger_2 | null;
  verification: githubFileConnectionItemsCommitVerificationInputObject_2 | null;
}

export interface githubFileConnectionItemsCommitAuthorInputObject_2 {
  name: githubFileConnectionItemsCommitAuthorNameQueryString_2 | null;
  email: githubFileConnectionItemsCommitAuthorEmailQueryString_2 | null;
  date: githubFileConnectionItemsCommitAuthorDateQueryString_2 | null;
}

export interface githubFileConnectionItemsCommitAuthorNameQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
}

export interface githubFileConnectionItemsCommitAuthorEmailQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
}

export interface githubFileConnectionItemsCommitAuthorDateQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
}

export interface githubFileConnectionItemsCommitCommitterInputObject_2 {
  name: githubFileConnectionItemsCommitCommitterNameQueryString_2 | null;
  email: githubFileConnectionItemsCommitCommitterEmailQueryString_2 | null;
  date: githubFileConnectionItemsCommitCommitterDateQueryString_2 | null;
}

export interface githubFileConnectionItemsCommitCommitterNameQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
}

export interface githubFileConnectionItemsCommitCommitterEmailQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
}

export interface githubFileConnectionItemsCommitCommitterDateQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
}

export interface githubFileConnectionItemsCommitMessageQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
}

export interface githubFileConnectionItemsCommitTreeInputObject_2 {
  sha: githubFileConnectionItemsCommitTreeShaQueryString_2 | null;
  url: githubFileConnectionItemsCommitTreeUrlQueryString_2 | null;
}

export interface githubFileConnectionItemsCommitTreeShaQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
}

export interface githubFileConnectionItemsCommitTreeUrlQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
}

export interface githubFileConnectionItemsCommitUrlQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
}

export interface githubFileConnectionItemsCommitCommentCountQueryInteger_2 {
  eq: number | null;
  ne: number | null;
}

export interface githubFileConnectionItemsCommitVerificationInputObject_2 {
  verified: githubFileConnectionItemsCommitVerificationVerifiedQueryBoolean_2 | null;
  reason: githubFileConnectionItemsCommitVerificationReasonQueryString_2 | null;
}

export interface githubFileConnectionItemsCommitVerificationVerifiedQueryBoolean_2 {
  eq: boolean | null;
  ne: boolean | null;
}

export interface githubFileConnectionItemsCommitVerificationReasonQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
}

export interface githubFileConnectionItemsUrlQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
}

export interface githubFileConnectionItemsHtmlUrlQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
}

export interface githubFileConnectionItemsCommentsUrlQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
}

export interface githubFileConnectionItemsAuthorInputObject_2 {
  login: githubFileConnectionItemsAuthorLoginQueryString_2 | null;
  id: githubFileConnectionItemsAuthorIdQueryInteger_2 | null;
  avatarUrl: githubFileConnectionItemsAuthorAvatarUrlQueryString_2 | null;
  gravatarId: githubFileConnectionItemsAuthorGravatarIdQueryString_2 | null;
  url: githubFileConnectionItemsAuthorUrlQueryString_2 | null;
  htmlUrl: githubFileConnectionItemsAuthorHtmlUrlQueryString_2 | null;
  followersUrl: githubFileConnectionItemsAuthorFollowersUrlQueryString_2 | null;
  subscriptionsUrl: githubFileConnectionItemsAuthorSubscriptionsUrlQueryString_2 | null;
  organizationsUrl: githubFileConnectionItemsAuthorOrganizationsUrlQueryString_2 | null;
  reposUrl: githubFileConnectionItemsAuthorReposUrlQueryString_2 | null;
  receivedEventsUrl: githubFileConnectionItemsAuthorReceivedEventsUrlQueryString_2 | null;
  type: githubFileConnectionItemsAuthorTypeQueryString_2 | null;
  siteAdmin: githubFileConnectionItemsAuthorSiteAdminQueryBoolean_2 | null;
  ldapDn: githubFileConnectionItemsAuthorLdapDnQueryString_2 | null;
}

export interface githubFileConnectionItemsAuthorLoginQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
}

export interface githubFileConnectionItemsAuthorIdQueryInteger_2 {
  eq: number | null;
  ne: number | null;
}

export interface githubFileConnectionItemsAuthorAvatarUrlQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
}

export interface githubFileConnectionItemsAuthorGravatarIdQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
}

export interface githubFileConnectionItemsAuthorUrlQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
}

export interface githubFileConnectionItemsAuthorHtmlUrlQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
}

export interface githubFileConnectionItemsAuthorFollowersUrlQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
}

export interface githubFileConnectionItemsAuthorSubscriptionsUrlQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
}

export interface githubFileConnectionItemsAuthorOrganizationsUrlQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
}

export interface githubFileConnectionItemsAuthorReposUrlQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
}

export interface githubFileConnectionItemsAuthorReceivedEventsUrlQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
}

export interface githubFileConnectionItemsAuthorTypeQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
}

export interface githubFileConnectionItemsAuthorSiteAdminQueryBoolean_2 {
  eq: boolean | null;
  ne: boolean | null;
}

export interface githubFileConnectionItemsAuthorLdapDnQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
}

export interface githubFileConnectionItemsCommitterInputObject_2 {
  login: githubFileConnectionItemsCommitterLoginQueryString_2 | null;
  id: githubFileConnectionItemsCommitterIdQueryInteger_2 | null;
  avatarUrl: githubFileConnectionItemsCommitterAvatarUrlQueryString_2 | null;
  gravatarId: githubFileConnectionItemsCommitterGravatarIdQueryString_2 | null;
  url: githubFileConnectionItemsCommitterUrlQueryString_2 | null;
  htmlUrl: githubFileConnectionItemsCommitterHtmlUrlQueryString_2 | null;
  followersUrl: githubFileConnectionItemsCommitterFollowersUrlQueryString_2 | null;
  subscriptionsUrl: githubFileConnectionItemsCommitterSubscriptionsUrlQueryString_2 | null;
  organizationsUrl: githubFileConnectionItemsCommitterOrganizationsUrlQueryString_2 | null;
  reposUrl: githubFileConnectionItemsCommitterReposUrlQueryString_2 | null;
  receivedEventsUrl: githubFileConnectionItemsCommitterReceivedEventsUrlQueryString_2 | null;
  type: githubFileConnectionItemsCommitterTypeQueryString_2 | null;
  siteAdmin: githubFileConnectionItemsCommitterSiteAdminQueryBoolean_2 | null;
  ldapDn: githubFileConnectionItemsCommitterLdapDnQueryString_2 | null;
}

export interface githubFileConnectionItemsCommitterLoginQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
}

export interface githubFileConnectionItemsCommitterIdQueryInteger_2 {
  eq: number | null;
  ne: number | null;
}

export interface githubFileConnectionItemsCommitterAvatarUrlQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
}

export interface githubFileConnectionItemsCommitterGravatarIdQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
}

export interface githubFileConnectionItemsCommitterUrlQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
}

export interface githubFileConnectionItemsCommitterHtmlUrlQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
}

export interface githubFileConnectionItemsCommitterFollowersUrlQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
}

export interface githubFileConnectionItemsCommitterSubscriptionsUrlQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
}

export interface githubFileConnectionItemsCommitterOrganizationsUrlQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
}

export interface githubFileConnectionItemsCommitterReposUrlQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
}

export interface githubFileConnectionItemsCommitterReceivedEventsUrlQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
}

export interface githubFileConnectionItemsCommitterTypeQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
}

export interface githubFileConnectionItemsCommitterSiteAdminQueryBoolean_2 {
  eq: boolean | null;
  ne: boolean | null;
}

export interface githubFileConnectionItemsCommitterLdapDnQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
}

export interface githubFileConnectionItemsParentsQueryList_2 {
  in: Array<githubFileConnectionItemsParentsInputObject_2> | null;
}

export interface githubFileConnectionItemsParentsInputObject_2 {
  sha: githubFileConnectionItemsParentsShaQueryString_2 | null;
  url: githubFileConnectionItemsParentsUrlQueryString_2 | null;
  htmlUrl: githubFileConnectionItemsParentsHtmlUrlQueryString_2 | null;
}

export interface githubFileConnectionItemsParentsShaQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
}

export interface githubFileConnectionItemsParentsUrlQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
}

export interface githubFileConnectionItemsParentsHtmlUrlQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
}

export interface githubFileConnectionIdQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
}

export interface githubFileConnectionComponentQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
}

export interface githubFileConnectionInternalInputObject_2 {
  type: githubFileConnectionInternalTypeQueryString_2 | null;
  contentDigest: githubFileConnectionInternalContentDigestQueryString_2 | null;
  owner: githubFileConnectionInternalOwnerQueryString_2 | null;
}

export interface githubFileConnectionInternalTypeQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
}

export interface githubFileConnectionInternalContentDigestQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
}

export interface githubFileConnectionInternalOwnerQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
}

export interface GithubFileConnection {
  pageInfo: PageInfo;
  edges: Array<GithubFileEdge> | null;
  totalCount: number | null;
  distinct: Array<string> | null;
  group: Array<githubFileGroupConnectionConnection> | null;
}

export interface DistinctGithubFileConnectionArgs {
  field: githubFileDistinctEnum | null;
}

export interface GroupGithubFileConnectionArgs {
  skip: number | null;
  limit: number | null;
  field: githubFileGroupEnum | null;
}

export interface GithubFileEdge {
  node: GithubFile | null;
  next: GithubFile | null;
  previous: GithubFile | null;
}

export interface GithubFile extends Node {
  id: string;
  parent: Node | null;
  children: Array<Node> | null;
  items: Array<items_2> | null;
  component: string | null;
  internal: internal_12 | null;
}

export interface items_2 {
  sha: string | null;
  commit: commit_2 | null;
  url: string | null;
  htmlUrl: string | null;
  commentsUrl: string | null;
  author: author_4 | null;
  committer: committer_4 | null;
  parents: Array<parents_2> | null;
}

export interface commit_2 {
  author: author_3 | null;
  committer: committer_3 | null;
  message: string | null;
  tree: tree_2 | null;
  url: string | null;
  commentCount: number | null;
  verification: verification_2 | null;
}

export interface author_3 {
  name: string | null;
  email: string | null;
  date: Date | null;
}

export interface Dateauthor_3Args {
  formatString: string | null;
  fromNow: boolean | null;
  difference: string | null;
  locale: string | null;
}

export type Date = any;

export interface committer_3 {
  name: string | null;
  email: string | null;
  date: Date | null;
}

export interface Datecommitter_3Args {
  formatString: string | null;
  fromNow: boolean | null;
  difference: string | null;
  locale: string | null;
}

export interface tree_2 {
  sha: string | null;
  url: string | null;
}

export interface verification_2 {
  verified: boolean | null;
  reason: string | null;
}

export interface author_4 {
  login: string | null;
  id: number | null;
  avatarUrl: string | null;
  gravatarId: string | null;
  url: string | null;
  htmlUrl: string | null;
  followersUrl: string | null;
  subscriptionsUrl: string | null;
  organizationsUrl: string | null;
  reposUrl: string | null;
  receivedEventsUrl: string | null;
  type: string | null;
  siteAdmin: boolean | null;
  ldapDn: string | null;
}

export interface committer_4 {
  login: string | null;
  id: number | null;
  avatarUrl: string | null;
  gravatarId: string | null;
  url: string | null;
  htmlUrl: string | null;
  followersUrl: string | null;
  subscriptionsUrl: string | null;
  organizationsUrl: string | null;
  reposUrl: string | null;
  receivedEventsUrl: string | null;
  type: string | null;
  siteAdmin: boolean | null;
  ldapDn: string | null;
}

export interface parents_2 {
  sha: string | null;
  url: string | null;
  htmlUrl: string | null;
}

export interface internal_12 {
  type: string | null;
  contentDigest: string | null;
  owner: string | null;
}

export type githubFileDistinctEnum = "items" | "id" | "component" | "internal___type" | "internal___contentDigest" | "internal___owner";

export type githubFileGroupEnum = "items" | "id" | "component" | "internal___type" | "internal___contentDigest" | "internal___owner";

export interface githubFileGroupConnectionConnection {
  pageInfo: PageInfo;
  edges: Array<githubFileGroupConnectionEdge> | null;
  field: string | null;
  fieldValue: string | null;
  totalCount: number | null;
}

export interface githubFileGroupConnectionEdge {
  node: GithubFile | null;
  next: GithubFile | null;
  previous: GithubFile | null;
}

export interface typeDocFileConnectionSort {
  fields: Array<TypeDocFileConnectionSortByFieldsEnum>;
  order: typeDocFileConnectionSortOrderValues | null;
}

export type TypeDocFileConnectionSortByFieldsEnum = "id" | "component" | "name" | "comment___shortText" | "properties" | "parent" | "children" | "internal___type" | "internal___contentDigest" | "internal___owner";

export type typeDocFileConnectionSortOrderValues = "ASC" | "DESC";

export interface filterTypeDocFile {
  id: typeDocFileConnectionIdQueryString_2 | null;
  component: typeDocFileConnectionComponentQueryString_2 | null;
  name: typeDocFileConnectionNameQueryString_2 | null;
  comment: typeDocFileConnectionCommentInputObject_2 | null;
  properties: typeDocFileConnectionPropertiesQueryList_2 | null;
  internal: typeDocFileConnectionInternalInputObject_2 | null;
}

export interface typeDocFileConnectionIdQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
}

export interface typeDocFileConnectionComponentQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
}

export interface typeDocFileConnectionNameQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
}

export interface typeDocFileConnectionCommentInputObject_2 {
  shortText: typeDocFileConnectionCommentShortTextQueryString_2 | null;
}

export interface typeDocFileConnectionCommentShortTextQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
}

export interface typeDocFileConnectionPropertiesQueryList_2 {
  in: Array<typeDocFileConnectionPropertiesInputObject_2> | null;
}

export interface typeDocFileConnectionPropertiesInputObject_2 {
  name: typeDocFileConnectionPropertiesNameQueryString_2 | null;
  availableValues: typeDocFileConnectionPropertiesAvailableValuesQueryList_2 | null;
  flags: typeDocFileConnectionPropertiesFlagsInputObject_2 | null;
  comment: typeDocFileConnectionPropertiesCommentInputObject_2 | null;
  breakpointCompatible: typeDocFileConnectionPropertiesBreakpointCompatibleQueryBoolean_2 | null;
  type: typeDocFileConnectionPropertiesTypeQueryString_2 | null;
  sourceSrc: typeDocFileConnectionPropertiesSourceSrcQueryString_2 | null;
}

export interface typeDocFileConnectionPropertiesNameQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
}

export interface typeDocFileConnectionPropertiesAvailableValuesQueryList_2 {
  in: Array<typeDocFileConnectionPropertiesAvailableValuesInputObject_2> | null;
}

export interface typeDocFileConnectionPropertiesAvailableValuesInputObject_2 {
  name: typeDocFileConnectionPropertiesAvailableValuesNameQueryString_2 | null;
  sourceSrc: typeDocFileConnectionPropertiesAvailableValuesSourceSrcQueryString_2 | null;
  properties: typeDocFileConnectionPropertiesAvailableValuesPropertiesQueryList_2 | null;
  values: typeDocFileConnectionPropertiesAvailableValuesValuesQueryList_2 | null;
}

export interface typeDocFileConnectionPropertiesAvailableValuesNameQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
}

export interface typeDocFileConnectionPropertiesAvailableValuesSourceSrcQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
}

export interface typeDocFileConnectionPropertiesAvailableValuesPropertiesQueryList_2 {
  in: Array<typeDocFileConnectionPropertiesAvailableValuesPropertiesInputObject_2> | null;
}

export interface typeDocFileConnectionPropertiesAvailableValuesPropertiesInputObject_2 {
  name: typeDocFileConnectionPropertiesAvailableValuesPropertiesNameQueryString_2 | null;
  value: typeDocFileConnectionPropertiesAvailableValuesPropertiesValueQueryString_2 | null;
  isOptional: typeDocFileConnectionPropertiesAvailableValuesPropertiesIsOptionalQueryBoolean_2 | null;
  sourceSrc: typeDocFileConnectionPropertiesAvailableValuesPropertiesSourceSrcQueryString_2 | null;
}

export interface typeDocFileConnectionPropertiesAvailableValuesPropertiesNameQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
}

export interface typeDocFileConnectionPropertiesAvailableValuesPropertiesValueQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
}

export interface typeDocFileConnectionPropertiesAvailableValuesPropertiesIsOptionalQueryBoolean_2 {
  eq: boolean | null;
  ne: boolean | null;
}

export interface typeDocFileConnectionPropertiesAvailableValuesPropertiesSourceSrcQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
}

export interface typeDocFileConnectionPropertiesAvailableValuesValuesQueryList_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
}

export interface typeDocFileConnectionPropertiesFlagsInputObject_2 {
  isExported: typeDocFileConnectionPropertiesFlagsIsExportedQueryBoolean_2 | null;
  isOptional: typeDocFileConnectionPropertiesFlagsIsOptionalQueryBoolean_2 | null;
}

export interface typeDocFileConnectionPropertiesFlagsIsExportedQueryBoolean_2 {
  eq: boolean | null;
  ne: boolean | null;
}

export interface typeDocFileConnectionPropertiesFlagsIsOptionalQueryBoolean_2 {
  eq: boolean | null;
  ne: boolean | null;
}

export interface typeDocFileConnectionPropertiesCommentInputObject_2 {
  tags: typeDocFileConnectionPropertiesCommentTagsQueryList_2 | null;
  shortText: typeDocFileConnectionPropertiesCommentShortTextQueryString_2 | null;
}

export interface typeDocFileConnectionPropertiesCommentTagsQueryList_2 {
  in: Array<typeDocFileConnectionPropertiesCommentTagsInputObject_2> | null;
}

export interface typeDocFileConnectionPropertiesCommentTagsInputObject_2 {
  tag: typeDocFileConnectionPropertiesCommentTagsTagQueryString_2 | null;
  text: typeDocFileConnectionPropertiesCommentTagsTextQueryString_2 | null;
}

export interface typeDocFileConnectionPropertiesCommentTagsTagQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
}

export interface typeDocFileConnectionPropertiesCommentTagsTextQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
}

export interface typeDocFileConnectionPropertiesCommentShortTextQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
}

export interface typeDocFileConnectionPropertiesBreakpointCompatibleQueryBoolean_2 {
  eq: boolean | null;
  ne: boolean | null;
}

export interface typeDocFileConnectionPropertiesTypeQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
}

export interface typeDocFileConnectionPropertiesSourceSrcQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
}

export interface typeDocFileConnectionInternalInputObject_2 {
  type: typeDocFileConnectionInternalTypeQueryString_2 | null;
  contentDigest: typeDocFileConnectionInternalContentDigestQueryString_2 | null;
  owner: typeDocFileConnectionInternalOwnerQueryString_2 | null;
}

export interface typeDocFileConnectionInternalTypeQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
}

export interface typeDocFileConnectionInternalContentDigestQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
}

export interface typeDocFileConnectionInternalOwnerQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
}

export interface TypeDocFileConnection {
  pageInfo: PageInfo;
  edges: Array<TypeDocFileEdge> | null;
  totalCount: number | null;
  distinct: Array<string> | null;
  group: Array<typeDocFileGroupConnectionConnection> | null;
}

export interface DistinctTypeDocFileConnectionArgs {
  field: typeDocFileDistinctEnum | null;
}

export interface GroupTypeDocFileConnectionArgs {
  skip: number | null;
  limit: number | null;
  field: typeDocFileGroupEnum | null;
}

export interface TypeDocFileEdge {
  node: TypeDocFile | null;
  next: TypeDocFile | null;
  previous: TypeDocFile | null;
}

export interface TypeDocFile extends Node {
  id: string;
  parent: Node | null;
  children: Array<Node> | null;
  component: string | null;
  name: string | null;
  comment: comment_3 | null;
  properties: Array<properties_3> | null;
  internal: internal_13 | null;
}

export interface comment_3 {
  shortText: string | null;
}

export interface properties_3 {
  name: string | null;
  availableValues: Array<availableValues_2> | null;
  flags: flags_2 | null;
  comment: comment_4 | null;
  breakpointCompatible: boolean | null;
  type: string | null;
  sourceSrc: string | null;
}

export interface availableValues_2 {
  name: string | null;
  sourceSrc: string | null;
  properties: Array<properties_4> | null;
  values: Array<string> | null;
}

export interface properties_4 {
  name: string | null;
  value: string | null;
  isOptional: boolean | null;
  sourceSrc: string | null;
}

export interface flags_2 {
  isExported: boolean | null;
  isOptional: boolean | null;
}

export interface comment_4 {
  tags: Array<tags_2> | null;
  shortText: string | null;
}

export interface tags_2 {
  tag: string | null;
  text: string | null;
}

export interface internal_13 {
  type: string | null;
  contentDigest: string | null;
  owner: string | null;
}

export type typeDocFileDistinctEnum = "id" | "component" | "name" | "comment___shortText" | "properties" | "internal___type" | "internal___contentDigest" | "internal___owner";

export type typeDocFileGroupEnum = "id" | "component" | "name" | "comment___shortText" | "properties" | "internal___type" | "internal___contentDigest" | "internal___owner";

export interface typeDocFileGroupConnectionConnection {
  pageInfo: PageInfo;
  edges: Array<typeDocFileGroupConnectionEdge> | null;
  field: string | null;
  fieldValue: string | null;
  totalCount: number | null;
}

export interface typeDocFileGroupConnectionEdge {
  node: TypeDocFile | null;
  next: TypeDocFile | null;
  previous: TypeDocFile | null;
}

export interface consumerProjectVersionsFileConnectionSort {
  fields: Array<consumerProjectVersionsFileConnectionSortByFieldsEnum>;
  order: consumerProjectVersionsFileConnectionSortOrderValues | null;
}

export type consumerProjectVersionsFileConnectionSortByFieldsEnum = "id" | "currentProjectVersion" | "parent" | "children" | "internal___type" | "internal___contentDigest" | "internal___owner";

export type consumerProjectVersionsFileConnectionSortOrderValues = "ASC" | "DESC";

export interface filterConsumerProjectVersionsFile {
  id: consumerProjectVersionsFileConnectionIdQueryString_2 | null;
  currentProjectVersion: consumerProjectVersionsFileConnectionCurrentProjectVersionQueryString_2 | null;
  internal: consumerProjectVersionsFileConnectionInternalInputObject_2 | null;
}

export interface consumerProjectVersionsFileConnectionIdQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
}

export interface consumerProjectVersionsFileConnectionCurrentProjectVersionQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
}

export interface consumerProjectVersionsFileConnectionInternalInputObject_2 {
  type: consumerProjectVersionsFileConnectionInternalTypeQueryString_2 | null;
  contentDigest: consumerProjectVersionsFileConnectionInternalContentDigestQueryString_2 | null;
  owner: consumerProjectVersionsFileConnectionInternalOwnerQueryString_2 | null;
}

export interface consumerProjectVersionsFileConnectionInternalTypeQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
}

export interface consumerProjectVersionsFileConnectionInternalContentDigestQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
}

export interface consumerProjectVersionsFileConnectionInternalOwnerQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
}

export interface consumerProjectVersionsFileConnection {
  pageInfo: PageInfo;
  edges: Array<consumerProjectVersionsFileEdge> | null;
  totalCount: number | null;
  distinct: Array<string> | null;
  group: Array<consumerProjectVersionsFileGroupConnectionConnection> | null;
}

export interface DistinctconsumerProjectVersionsFileConnectionArgs {
  field: consumerProjectVersionsFileDistinctEnum | null;
}

export interface GroupconsumerProjectVersionsFileConnectionArgs {
  skip: number | null;
  limit: number | null;
  field: consumerProjectVersionsFileGroupEnum | null;
}

export interface consumerProjectVersionsFileEdge {
  node: consumerProjectVersionsFile | null;
  next: consumerProjectVersionsFile | null;
  previous: consumerProjectVersionsFile | null;
}

export interface consumerProjectVersionsFile extends Node {
  id: string;
  parent: Node | null;
  children: Array<Node> | null;
  currentProjectVersion: string | null;
  internal: internal_14 | null;
}

export interface internal_14 {
  type: string | null;
  contentDigest: string | null;
  owner: string | null;
}

export type consumerProjectVersionsFileDistinctEnum = "id" | "currentProjectVersion" | "internal___type" | "internal___contentDigest" | "internal___owner";

export type consumerProjectVersionsFileGroupEnum = "id" | "currentProjectVersion" | "internal___type" | "internal___contentDigest" | "internal___owner";

export interface consumerProjectVersionsFileGroupConnectionConnection {
  pageInfo: PageInfo;
  edges: Array<consumerProjectVersionsFileGroupConnectionEdge> | null;
  field: string | null;
  fieldValue: string | null;
  totalCount: number | null;
}

export interface consumerProjectVersionsFileGroupConnectionEdge {
  node: consumerProjectVersionsFile | null;
  next: consumerProjectVersionsFile | null;
  previous: consumerProjectVersionsFile | null;
}

export interface directoryConnectionSort {
  fields: Array<DirectoryConnectionSortByFieldsEnum>;
  order: directoryConnectionSortOrderValues | null;
}

export type DirectoryConnectionSortByFieldsEnum = "id" | "children" | "parent" | "internal___contentDigest" | "internal___type" | "internal___owner" | "sourceInstanceName" | "absolutePath" | "relativePath" | "extension" | "size" | "prettySize" | "modifiedTime" | "accessTime" | "changeTime" | "birthTime" | "root" | "dir" | "base" | "ext" | "name" | "relativeDirectory" | "dev" | "mode" | "nlink" | "uid" | "gid" | "rdev" | "blksize" | "ino" | "blocks" | "atimeMs" | "mtimeMs" | "ctimeMs" | "birthtimeMs" | "atime" | "mtime" | "ctime" | "birthtime";

export type directoryConnectionSortOrderValues = "ASC" | "DESC";

export interface filterDirectory {
  id: directoryConnectionIdQueryString_2 | null;
  internal: directoryConnectionInternalInputObject_2 | null;
  sourceInstanceName: directoryConnectionSourceInstanceNameQueryString_2 | null;
  absolutePath: directoryConnectionAbsolutePathQueryString_2 | null;
  relativePath: directoryConnectionRelativePathQueryString_2 | null;
  extension: directoryConnectionExtensionQueryString_2 | null;
  size: directoryConnectionSizeQueryInteger_2 | null;
  prettySize: directoryConnectionPrettySizeQueryString_2 | null;
  modifiedTime: directoryConnectionModifiedTimeQueryString_2 | null;
  accessTime: directoryConnectionAccessTimeQueryString_2 | null;
  changeTime: directoryConnectionChangeTimeQueryString_2 | null;
  birthTime: directoryConnectionBirthTimeQueryString_2 | null;
  root: directoryConnectionRootQueryString_2 | null;
  dir: directoryConnectionDirQueryString_2 | null;
  base: directoryConnectionBaseQueryString_2 | null;
  ext: directoryConnectionExtQueryString_2 | null;
  name: directoryConnectionNameQueryString_2 | null;
  relativeDirectory: directoryConnectionRelativeDirectoryQueryString_2 | null;
  dev: directoryConnectionDevQueryInteger_2 | null;
  mode: directoryConnectionModeQueryInteger_2 | null;
  nlink: directoryConnectionNlinkQueryInteger_2 | null;
  uid: directoryConnectionUidQueryInteger_2 | null;
  gid: directoryConnectionGidQueryInteger_2 | null;
  rdev: directoryConnectionRdevQueryInteger_2 | null;
  blksize: directoryConnectionBlksizeQueryInteger_2 | null;
  ino: directoryConnectionInoQueryInteger_2 | null;
  blocks: directoryConnectionBlocksQueryInteger_2 | null;
  atimeMs: directoryConnectionAtimeMsQueryInteger_2 | null;
  mtimeMs: directoryConnectionMtimeMsQueryInteger_2 | null;
  ctimeMs: directoryConnectionCtimeMsQueryInteger_2 | null;
  birthtimeMs: directoryConnectionBirthtimeMsQueryInteger_2 | null;
  atime: directoryConnectionAtimeQueryString_2 | null;
  mtime: directoryConnectionMtimeQueryString_2 | null;
  ctime: directoryConnectionCtimeQueryString_2 | null;
  birthtime: directoryConnectionBirthtimeQueryString_2 | null;
}

export interface directoryConnectionIdQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
}

export interface directoryConnectionInternalInputObject_2 {
  contentDigest: directoryConnectionInternalContentDigestQueryString_2 | null;
  type: directoryConnectionInternalTypeQueryString_2 | null;
  owner: directoryConnectionInternalOwnerQueryString_2 | null;
}

export interface directoryConnectionInternalContentDigestQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
}

export interface directoryConnectionInternalTypeQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
}

export interface directoryConnectionInternalOwnerQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
}

export interface directoryConnectionSourceInstanceNameQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
}

export interface directoryConnectionAbsolutePathQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
}

export interface directoryConnectionRelativePathQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
}

export interface directoryConnectionExtensionQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
}

export interface directoryConnectionSizeQueryInteger_2 {
  eq: number | null;
  ne: number | null;
}

export interface directoryConnectionPrettySizeQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
}

export interface directoryConnectionModifiedTimeQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
}

export interface directoryConnectionAccessTimeQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
}

export interface directoryConnectionChangeTimeQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
}

export interface directoryConnectionBirthTimeQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
}

export interface directoryConnectionRootQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
}

export interface directoryConnectionDirQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
}

export interface directoryConnectionBaseQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
}

export interface directoryConnectionExtQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
}

export interface directoryConnectionNameQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
}

export interface directoryConnectionRelativeDirectoryQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
}

export interface directoryConnectionDevQueryInteger_2 {
  eq: number | null;
  ne: number | null;
}

export interface directoryConnectionModeQueryInteger_2 {
  eq: number | null;
  ne: number | null;
}

export interface directoryConnectionNlinkQueryInteger_2 {
  eq: number | null;
  ne: number | null;
}

export interface directoryConnectionUidQueryInteger_2 {
  eq: number | null;
  ne: number | null;
}

export interface directoryConnectionGidQueryInteger_2 {
  eq: number | null;
  ne: number | null;
}

export interface directoryConnectionRdevQueryInteger_2 {
  eq: number | null;
  ne: number | null;
}

export interface directoryConnectionBlksizeQueryInteger_2 {
  eq: number | null;
  ne: number | null;
}

export interface directoryConnectionInoQueryInteger_2 {
  eq: number | null;
  ne: number | null;
}

export interface directoryConnectionBlocksQueryInteger_2 {
  eq: number | null;
  ne: number | null;
}

export interface directoryConnectionAtimeMsQueryInteger_2 {
  eq: number | null;
  ne: number | null;
}

export interface directoryConnectionMtimeMsQueryInteger_2 {
  eq: number | null;
  ne: number | null;
}

export interface directoryConnectionCtimeMsQueryInteger_2 {
  eq: number | null;
  ne: number | null;
}

export interface directoryConnectionBirthtimeMsQueryInteger_2 {
  eq: number | null;
  ne: number | null;
}

export interface directoryConnectionAtimeQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
}

export interface directoryConnectionMtimeQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
}

export interface directoryConnectionCtimeQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
}

export interface directoryConnectionBirthtimeQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
}

export interface DirectoryConnection {
  pageInfo: PageInfo;
  edges: Array<DirectoryEdge> | null;
  totalCount: number | null;
  distinct: Array<string> | null;
  group: Array<directoryGroupConnectionConnection> | null;
}

export interface DistinctDirectoryConnectionArgs {
  field: directoryDistinctEnum | null;
}

export interface GroupDirectoryConnectionArgs {
  skip: number | null;
  limit: number | null;
  field: directoryGroupEnum | null;
}

export interface DirectoryEdge {
  node: Directory | null;
  next: Directory | null;
  previous: Directory | null;
}

export interface Directory extends Node {
  id: string;
  parent: Node | null;
  children: Array<Node> | null;
  internal: internal_15 | null;
  sourceInstanceName: string | null;
  absolutePath: string | null;
  relativePath: string | null;
  extension: string | null;
  size: number | null;
  prettySize: string | null;
  modifiedTime: Date | null;
  accessTime: Date | null;
  changeTime: Date | null;
  birthTime: Date | null;
  root: string | null;
  dir: string | null;
  base: string | null;
  ext: string | null;
  name: string | null;
  relativeDirectory: string | null;
  dev: number | null;
  mode: number | null;
  nlink: number | null;
  uid: number | null;
  gid: number | null;
  rdev: number | null;
  blksize: number | null;
  ino: number | null;
  blocks: number | null;
  atimeMs: number | null;
  mtimeMs: number | null;
  ctimeMs: number | null;
  birthtimeMs: number | null;
  atime: Date | null;
  mtime: Date | null;
  ctime: Date | null;
  birthtime: Date | null;
}

export interface ModifiedTimeDirectoryArgs {
  formatString: string | null;
  fromNow: boolean | null;
  difference: string | null;
  locale: string | null;
}

export interface AccessTimeDirectoryArgs {
  formatString: string | null;
  fromNow: boolean | null;
  difference: string | null;
  locale: string | null;
}

export interface ChangeTimeDirectoryArgs {
  formatString: string | null;
  fromNow: boolean | null;
  difference: string | null;
  locale: string | null;
}

export interface BirthTimeDirectoryArgs {
  formatString: string | null;
  fromNow: boolean | null;
  difference: string | null;
  locale: string | null;
}

export interface AtimeDirectoryArgs {
  formatString: string | null;
  fromNow: boolean | null;
  difference: string | null;
  locale: string | null;
}

export interface MtimeDirectoryArgs {
  formatString: string | null;
  fromNow: boolean | null;
  difference: string | null;
  locale: string | null;
}

export interface CtimeDirectoryArgs {
  formatString: string | null;
  fromNow: boolean | null;
  difference: string | null;
  locale: string | null;
}

export interface BirthtimeDirectoryArgs {
  formatString: string | null;
  fromNow: boolean | null;
  difference: string | null;
  locale: string | null;
}

export interface internal_15 {
  contentDigest: string | null;
  type: string | null;
  owner: string | null;
}

export type directoryDistinctEnum = "id" | "parent" | "internal___contentDigest" | "internal___type" | "internal___owner" | "sourceInstanceName" | "absolutePath" | "relativePath" | "extension" | "size" | "prettySize" | "modifiedTime" | "accessTime" | "changeTime" | "birthTime" | "root" | "dir" | "base" | "ext" | "name" | "relativeDirectory" | "dev" | "mode" | "nlink" | "uid" | "gid" | "rdev" | "blksize" | "ino" | "blocks" | "atimeMs" | "mtimeMs" | "ctimeMs" | "birthtimeMs" | "atime" | "mtime" | "ctime" | "birthtime";

export type directoryGroupEnum = "id" | "parent" | "internal___contentDigest" | "internal___type" | "internal___owner" | "sourceInstanceName" | "absolutePath" | "relativePath" | "extension" | "size" | "prettySize" | "modifiedTime" | "accessTime" | "changeTime" | "birthTime" | "root" | "dir" | "base" | "ext" | "name" | "relativeDirectory" | "dev" | "mode" | "nlink" | "uid" | "gid" | "rdev" | "blksize" | "ino" | "blocks" | "atimeMs" | "mtimeMs" | "ctimeMs" | "birthtimeMs" | "atime" | "mtime" | "ctime" | "birthtime";

export interface directoryGroupConnectionConnection {
  pageInfo: PageInfo;
  edges: Array<directoryGroupConnectionEdge> | null;
  field: string | null;
  fieldValue: string | null;
  totalCount: number | null;
}

export interface directoryGroupConnectionEdge {
  node: Directory | null;
  next: Directory | null;
  previous: Directory | null;
}

export interface fileConnectionSort {
  fields: Array<FileConnectionSortByFieldsEnum>;
  order: fileConnectionSortOrderValues | null;
}

export type FileConnectionSortByFieldsEnum = "id" | "children" | "parent" | "internal___contentDigest" | "internal___mediaType" | "internal___type" | "internal___owner" | "internal___fieldOwners___segments" | "internal___fieldOwners___title" | "internal___fieldOwners___slug" | "internal___fieldOwners___path" | "internal___fieldOwners___tab" | "internal___fieldOwners___tabPath" | "sourceInstanceName" | "absolutePath" | "relativePath" | "extension" | "size" | "prettySize" | "modifiedTime" | "accessTime" | "changeTime" | "birthTime" | "root" | "dir" | "base" | "ext" | "name" | "relativeDirectory" | "dev" | "mode" | "nlink" | "uid" | "gid" | "rdev" | "blksize" | "ino" | "blocks" | "atimeMs" | "mtimeMs" | "ctimeMs" | "birthtimeMs" | "atime" | "mtime" | "ctime" | "birthtime" | "fields___segments" | "fields___title" | "fields___slug" | "fields___path" | "fields___tab___slug" | "fields___tab___title" | "fields___tabPath" | "publicURL";

export type fileConnectionSortOrderValues = "ASC" | "DESC";

export interface filterFile {
  id: fileConnectionIdQueryString_2 | null;
  internal: fileConnectionInternalInputObject_2 | null;
  sourceInstanceName: fileConnectionSourceInstanceNameQueryString_2 | null;
  absolutePath: fileConnectionAbsolutePathQueryString_2 | null;
  relativePath: fileConnectionRelativePathQueryString_2 | null;
  extension: fileConnectionExtensionQueryString_2 | null;
  size: fileConnectionSizeQueryInteger_2 | null;
  prettySize: fileConnectionPrettySizeQueryString_2 | null;
  modifiedTime: fileConnectionModifiedTimeQueryString_2 | null;
  accessTime: fileConnectionAccessTimeQueryString_2 | null;
  changeTime: fileConnectionChangeTimeQueryString_2 | null;
  birthTime: fileConnectionBirthTimeQueryString_2 | null;
  root: fileConnectionRootQueryString_2 | null;
  dir: fileConnectionDirQueryString_2 | null;
  base: fileConnectionBaseQueryString_2 | null;
  ext: fileConnectionExtQueryString_2 | null;
  name: fileConnectionNameQueryString_2 | null;
  relativeDirectory: fileConnectionRelativeDirectoryQueryString_2 | null;
  dev: fileConnectionDevQueryInteger_2 | null;
  mode: fileConnectionModeQueryInteger_2 | null;
  nlink: fileConnectionNlinkQueryInteger_2 | null;
  uid: fileConnectionUidQueryInteger_2 | null;
  gid: fileConnectionGidQueryInteger_2 | null;
  rdev: fileConnectionRdevQueryInteger_2 | null;
  blksize: fileConnectionBlksizeQueryInteger_2 | null;
  ino: fileConnectionInoQueryInteger_2 | null;
  blocks: fileConnectionBlocksQueryInteger_2 | null;
  atimeMs: fileConnectionAtimeMsQueryInteger_2 | null;
  mtimeMs: fileConnectionMtimeMsQueryInteger_2 | null;
  ctimeMs: fileConnectionCtimeMsQueryInteger_2 | null;
  birthtimeMs: fileConnectionBirthtimeMsQueryInteger_2 | null;
  atime: fileConnectionAtimeQueryString_2 | null;
  mtime: fileConnectionMtimeQueryString_2 | null;
  ctime: fileConnectionCtimeQueryString_2 | null;
  birthtime: fileConnectionBirthtimeQueryString_2 | null;
  fields: fileConnectionFieldsInputObject_2 | null;
  publicURL: publicUrlQueryString_4 | null;
}

export interface fileConnectionIdQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
}

export interface fileConnectionInternalInputObject_2 {
  contentDigest: fileConnectionInternalContentDigestQueryString_2 | null;
  mediaType: fileConnectionInternalMediaTypeQueryString_2 | null;
  type: fileConnectionInternalTypeQueryString_2 | null;
  owner: fileConnectionInternalOwnerQueryString_2 | null;
  fieldOwners: fileConnectionInternalFieldOwnersInputObject_2 | null;
}

export interface fileConnectionInternalContentDigestQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
}

export interface fileConnectionInternalMediaTypeQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
}

export interface fileConnectionInternalTypeQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
}

export interface fileConnectionInternalOwnerQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
}

export interface fileConnectionInternalFieldOwnersInputObject_2 {
  segments: fileConnectionInternalFieldOwnersSegmentsQueryString_2 | null;
  title: fileConnectionInternalFieldOwnersTitleQueryString_2 | null;
  slug: fileConnectionInternalFieldOwnersSlugQueryString_2 | null;
  path: fileConnectionInternalFieldOwnersPathQueryString_2 | null;
  tab: fileConnectionInternalFieldOwnersTabQueryString_2 | null;
  tabPath: fileConnectionInternalFieldOwnersTabPathQueryString_2 | null;
}

export interface fileConnectionInternalFieldOwnersSegmentsQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
}

export interface fileConnectionInternalFieldOwnersTitleQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
}

export interface fileConnectionInternalFieldOwnersSlugQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
}

export interface fileConnectionInternalFieldOwnersPathQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
}

export interface fileConnectionInternalFieldOwnersTabQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
}

export interface fileConnectionInternalFieldOwnersTabPathQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
}

export interface fileConnectionSourceInstanceNameQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
}

export interface fileConnectionAbsolutePathQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
}

export interface fileConnectionRelativePathQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
}

export interface fileConnectionExtensionQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
}

export interface fileConnectionSizeQueryInteger_2 {
  eq: number | null;
  ne: number | null;
}

export interface fileConnectionPrettySizeQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
}

export interface fileConnectionModifiedTimeQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
}

export interface fileConnectionAccessTimeQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
}

export interface fileConnectionChangeTimeQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
}

export interface fileConnectionBirthTimeQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
}

export interface fileConnectionRootQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
}

export interface fileConnectionDirQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
}

export interface fileConnectionBaseQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
}

export interface fileConnectionExtQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
}

export interface fileConnectionNameQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
}

export interface fileConnectionRelativeDirectoryQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
}

export interface fileConnectionDevQueryInteger_2 {
  eq: number | null;
  ne: number | null;
}

export interface fileConnectionModeQueryInteger_2 {
  eq: number | null;
  ne: number | null;
}

export interface fileConnectionNlinkQueryInteger_2 {
  eq: number | null;
  ne: number | null;
}

export interface fileConnectionUidQueryInteger_2 {
  eq: number | null;
  ne: number | null;
}

export interface fileConnectionGidQueryInteger_2 {
  eq: number | null;
  ne: number | null;
}

export interface fileConnectionRdevQueryInteger_2 {
  eq: number | null;
  ne: number | null;
}

export interface fileConnectionBlksizeQueryInteger_2 {
  eq: number | null;
  ne: number | null;
}

export interface fileConnectionInoQueryInteger_2 {
  eq: number | null;
  ne: number | null;
}

export interface fileConnectionBlocksQueryInteger_2 {
  eq: number | null;
  ne: number | null;
}

export interface fileConnectionAtimeMsQueryInteger_2 {
  eq: number | null;
  ne: number | null;
}

export interface fileConnectionMtimeMsQueryInteger_2 {
  eq: number | null;
  ne: number | null;
}

export interface fileConnectionCtimeMsQueryInteger_2 {
  eq: number | null;
  ne: number | null;
}

export interface fileConnectionBirthtimeMsQueryInteger_2 {
  eq: number | null;
  ne: number | null;
}

export interface fileConnectionAtimeQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
}

export interface fileConnectionMtimeQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
}

export interface fileConnectionCtimeQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
}

export interface fileConnectionBirthtimeQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
}

export interface fileConnectionFieldsInputObject_2 {
  segments: fileConnectionFieldsSegmentsQueryList_2 | null;
  title: fileConnectionFieldsTitleQueryString_2 | null;
  slug: fileConnectionFieldsSlugQueryString_2 | null;
  path: fileConnectionFieldsPathQueryString_2 | null;
  tab: fileConnectionFieldsTabInputObject_2 | null;
  tabPath: fileConnectionFieldsTabPathQueryString_2 | null;
}

export interface fileConnectionFieldsSegmentsQueryList_2 {
  in: Array<fileConnectionFieldsSegmentsInputObject_2> | null;
}

export interface fileConnectionFieldsSegmentsInputObject_2 {
  slug: fileConnectionFieldsSegmentsSlugQueryString_2 | null;
  title: fileConnectionFieldsSegmentsTitleQueryString_2 | null;
}

export interface fileConnectionFieldsSegmentsSlugQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
}

export interface fileConnectionFieldsSegmentsTitleQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
}

export interface fileConnectionFieldsTitleQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
}

export interface fileConnectionFieldsSlugQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
}

export interface fileConnectionFieldsPathQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
}

export interface fileConnectionFieldsTabInputObject_2 {
  slug: fileConnectionFieldsTabSlugQueryString_2 | null;
  title: fileConnectionFieldsTabTitleQueryString_2 | null;
}

export interface fileConnectionFieldsTabSlugQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
}

export interface fileConnectionFieldsTabTitleQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
}

export interface fileConnectionFieldsTabPathQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
}

export interface publicUrlQueryString_4 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
}

export interface FileConnection {
  pageInfo: PageInfo;
  edges: Array<FileEdge> | null;
  totalCount: number | null;
  distinct: Array<string> | null;
  group: Array<fileGroupConnectionConnection> | null;
}

export interface DistinctFileConnectionArgs {
  field: fileDistinctEnum | null;
}

export interface GroupFileConnectionArgs {
  skip: number | null;
  limit: number | null;
  field: fileGroupEnum | null;
}

export interface FileEdge {
  node: File | null;
  next: File | null;
  previous: File | null;
}

export interface File extends Node {
  id: string;
  parent: Node | null;
  children: Array<Node> | null;
  childMarkdownRemark: MarkdownRemark | null;
  internal: internal_16 | null;
  sourceInstanceName: string | null;
  absolutePath: string | null;
  relativePath: string | null;
  extension: string | null;
  size: number | null;
  prettySize: string | null;
  modifiedTime: Date | null;
  accessTime: Date | null;
  changeTime: Date | null;
  birthTime: Date | null;
  root: string | null;
  dir: string | null;
  base: string | null;
  ext: string | null;
  name: string | null;
  relativeDirectory: string | null;
  dev: number | null;
  mode: number | null;
  nlink: number | null;
  uid: number | null;
  gid: number | null;
  rdev: number | null;
  blksize: number | null;
  ino: number | null;
  blocks: number | null;
  atimeMs: number | null;
  mtimeMs: number | null;
  ctimeMs: number | null;
  birthtimeMs: number | null;
  atime: Date | null;
  mtime: Date | null;
  ctime: Date | null;
  birthtime: Date | null;
  fields: fields_2 | null;
  publicURL: string | null;
}

export interface ModifiedTimeFileArgs {
  formatString: string | null;
  fromNow: boolean | null;
  difference: string | null;
  locale: string | null;
}

export interface AccessTimeFileArgs {
  formatString: string | null;
  fromNow: boolean | null;
  difference: string | null;
  locale: string | null;
}

export interface ChangeTimeFileArgs {
  formatString: string | null;
  fromNow: boolean | null;
  difference: string | null;
  locale: string | null;
}

export interface BirthTimeFileArgs {
  formatString: string | null;
  fromNow: boolean | null;
  difference: string | null;
  locale: string | null;
}

export interface AtimeFileArgs {
  formatString: string | null;
  fromNow: boolean | null;
  difference: string | null;
  locale: string | null;
}

export interface MtimeFileArgs {
  formatString: string | null;
  fromNow: boolean | null;
  difference: string | null;
  locale: string | null;
}

export interface CtimeFileArgs {
  formatString: string | null;
  fromNow: boolean | null;
  difference: string | null;
  locale: string | null;
}

export interface BirthtimeFileArgs {
  formatString: string | null;
  fromNow: boolean | null;
  difference: string | null;
  locale: string | null;
}

export interface MarkdownRemark extends Node {
  id: string;
  parent: Node | null;
  children: Array<Node> | null;
  internal: internal_17 | null;
  frontmatter: frontmatter_2 | null;
  excerpt: string | null;
  fileAbsolutePath: string | null;
  html: string | null;
  htmlAst: JSON | null;
  headings: Array<MarkdownHeading> | null;
  timeToRead: number | null;
  tableOfContents: string | null;
  wordCount: wordCount | null;
}

export interface ExcerptMarkdownRemarkArgs {
  pruneLength: number | null;
}

export interface HeadingsMarkdownRemarkArgs {
  depth: HeadingLevels | null;
}

export interface internal_17 {
  content: string | null;
  type: string | null;
  contentDigest: string | null;
  owner: string | null;
}

export interface frontmatter_2 {
  title: string | null;
  redirect: string | null;
  _PARENT: string | null;
  parent: string | null;
  description: string | null;
  component: component_2 | null;
}

export interface component_2 {
  id: string | null;
  disablePlayground: boolean | null;
}

export type JSON = any;

export type HeadingLevels = "h1" | "h2" | "h3" | "h4" | "h5" | "h6";

export interface MarkdownHeading {
  value: string | null;
  depth: number | null;
}

export interface wordCount {
  paragraphs: number | null;
  sentences: number | null;
  words: number | null;
}

export interface internal_16 {
  contentDigest: string | null;
  mediaType: string | null;
  type: string | null;
  owner: string | null;
  fieldOwners: fieldOwners_2 | null;
}

export interface fieldOwners_2 {
  segments: string | null;
  title: string | null;
  slug: string | null;
  path: string | null;
  tab: string | null;
  tabPath: string | null;
}

export interface fields_2 {
  segments: Array<segments_2> | null;
  title: string | null;
  slug: string | null;
  path: string | null;
  tab: tab_2 | null;
  tabPath: string | null;
}

export interface segments_2 {
  slug: string | null;
  title: string | null;
}

export interface tab_2 {
  slug: string | null;
  title: string | null;
}

export type fileDistinctEnum = "id" | "children" | "parent" | "internal___contentDigest" | "internal___mediaType" | "internal___type" | "internal___owner" | "internal___fieldOwners___segments" | "internal___fieldOwners___title" | "internal___fieldOwners___slug" | "internal___fieldOwners___path" | "internal___fieldOwners___tab" | "internal___fieldOwners___tabPath" | "sourceInstanceName" | "absolutePath" | "relativePath" | "extension" | "size" | "prettySize" | "modifiedTime" | "accessTime" | "changeTime" | "birthTime" | "root" | "dir" | "base" | "ext" | "name" | "relativeDirectory" | "dev" | "mode" | "nlink" | "uid" | "gid" | "rdev" | "blksize" | "ino" | "blocks" | "atimeMs" | "mtimeMs" | "ctimeMs" | "birthtimeMs" | "atime" | "mtime" | "ctime" | "birthtime" | "fields___segments" | "fields___title" | "fields___slug" | "fields___path" | "fields___tab___slug" | "fields___tab___title" | "fields___tabPath";

export type fileGroupEnum = "id" | "children" | "parent" | "internal___contentDigest" | "internal___mediaType" | "internal___type" | "internal___owner" | "internal___fieldOwners___segments" | "internal___fieldOwners___title" | "internal___fieldOwners___slug" | "internal___fieldOwners___path" | "internal___fieldOwners___tab" | "internal___fieldOwners___tabPath" | "sourceInstanceName" | "absolutePath" | "relativePath" | "extension" | "size" | "prettySize" | "modifiedTime" | "accessTime" | "changeTime" | "birthTime" | "root" | "dir" | "base" | "ext" | "name" | "relativeDirectory" | "dev" | "mode" | "nlink" | "uid" | "gid" | "rdev" | "blksize" | "ino" | "blocks" | "atimeMs" | "mtimeMs" | "ctimeMs" | "birthtimeMs" | "atime" | "mtime" | "ctime" | "birthtime" | "fields___segments" | "fields___title" | "fields___slug" | "fields___path" | "fields___tab___slug" | "fields___tab___title" | "fields___tabPath";

export interface fileGroupConnectionConnection {
  pageInfo: PageInfo;
  edges: Array<fileGroupConnectionEdge> | null;
  field: string | null;
  fieldValue: string | null;
  totalCount: number | null;
}

export interface fileGroupConnectionEdge {
  node: File | null;
  next: File | null;
  previous: File | null;
}

export interface markdownRemarkConnectionSort {
  fields: Array<MarkdownRemarkConnectionSortByFieldsEnum>;
  order: markdownRemarkConnectionSortOrderValues | null;
}

export type MarkdownRemarkConnectionSortByFieldsEnum = "id" | "children" | "parent" | "internal___content" | "internal___type" | "internal___contentDigest" | "internal___owner" | "frontmatter___title" | "frontmatter___redirect" | "frontmatter____PARENT" | "frontmatter___parent" | "frontmatter___description" | "frontmatter___component___id" | "frontmatter___component___disablePlayground" | "excerpt" | "fileAbsolutePath" | "html" | "headings" | "timeToRead" | "tableOfContents" | "wordCount___paragraphs" | "wordCount___sentences" | "wordCount___words";

export type markdownRemarkConnectionSortOrderValues = "ASC" | "DESC";

export interface filterMarkdownRemark {
  id: markdownRemarkConnectionIdQueryString_2 | null;
  internal: markdownRemarkConnectionInternalInputObject_2 | null;
  frontmatter: markdownRemarkConnectionFrontmatterInputObject_2 | null;
  excerpt: excerptQueryString_4 | null;
  fileAbsolutePath: markdownRemarkConnectionFileAbsolutePathQueryString_2 | null;
  html: htmlQueryString_4 | null;
  headings: headingsQueryList_4 | null;
  timeToRead: timeToReadQueryInt_4 | null;
  tableOfContents: tableOfContentsQueryString_4 | null;
  wordCount: wordCountTypeName_4 | null;
}

export interface markdownRemarkConnectionIdQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
}

export interface markdownRemarkConnectionInternalInputObject_2 {
  content: markdownRemarkConnectionInternalContentQueryString_2 | null;
  type: markdownRemarkConnectionInternalTypeQueryString_2 | null;
  contentDigest: markdownRemarkConnectionInternalContentDigestQueryString_2 | null;
  owner: markdownRemarkConnectionInternalOwnerQueryString_2 | null;
}

export interface markdownRemarkConnectionInternalContentQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
}

export interface markdownRemarkConnectionInternalTypeQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
}

export interface markdownRemarkConnectionInternalContentDigestQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
}

export interface markdownRemarkConnectionInternalOwnerQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
}

export interface markdownRemarkConnectionFrontmatterInputObject_2 {
  title: markdownRemarkConnectionFrontmatterTitleQueryString_2 | null;
  redirect: markdownRemarkConnectionFrontmatterRedirectQueryString_2 | null;
  _PARENT: markdownRemarkConnectionFrontmatterParentQueryString_3 | null;
  parent: markdownRemarkConnectionFrontmatterParentQueryString_4 | null;
  description: markdownRemarkConnectionFrontmatterDescriptionQueryString_2 | null;
  component: markdownRemarkConnectionFrontmatterComponentInputObject_2 | null;
}

export interface markdownRemarkConnectionFrontmatterTitleQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
}

export interface markdownRemarkConnectionFrontmatterRedirectQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
}

export interface markdownRemarkConnectionFrontmatterParentQueryString_3 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
}

export interface markdownRemarkConnectionFrontmatterParentQueryString_4 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
}

export interface markdownRemarkConnectionFrontmatterDescriptionQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
}

export interface markdownRemarkConnectionFrontmatterComponentInputObject_2 {
  id: markdownRemarkConnectionFrontmatterComponentIdQueryString_2 | null;
  disablePlayground: markdownRemarkConnectionFrontmatterComponentDisablePlaygroundQueryBoolean_2 | null;
}

export interface markdownRemarkConnectionFrontmatterComponentIdQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
}

export interface markdownRemarkConnectionFrontmatterComponentDisablePlaygroundQueryBoolean_2 {
  eq: boolean | null;
  ne: boolean | null;
}

export interface excerptQueryString_4 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
}

export interface markdownRemarkConnectionFileAbsolutePathQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
}

export interface htmlQueryString_4 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
}

export interface headingsQueryList_4 {
  value: headingsListElemValueQueryString_4 | null;
  depth: headingsListElemDepthQueryInt_4 | null;
  in: Array<markdownHeadingInputObject_4> | null;
}

export interface headingsListElemValueQueryString_4 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
}

export interface headingsListElemDepthQueryInt_4 {
  eq: number | null;
  ne: number | null;
}

export interface markdownHeadingInputObject_4 {
  value: string | null;
  depth: number | null;
}

export interface timeToReadQueryInt_4 {
  eq: number | null;
  ne: number | null;
}

export interface tableOfContentsQueryString_4 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
}

export interface wordCountTypeName_4 {
  paragraphs: wordCountParagraphsQueryInt_4 | null;
  sentences: wordCountSentencesQueryInt_4 | null;
  words: wordCountWordsQueryInt_4 | null;
}

export interface wordCountParagraphsQueryInt_4 {
  eq: number | null;
  ne: number | null;
}

export interface wordCountSentencesQueryInt_4 {
  eq: number | null;
  ne: number | null;
}

export interface wordCountWordsQueryInt_4 {
  eq: number | null;
  ne: number | null;
}

export interface MarkdownRemarkConnection {
  pageInfo: PageInfo;
  edges: Array<MarkdownRemarkEdge> | null;
  totalCount: number | null;
  distinct: Array<string> | null;
  group: Array<markdownRemarkGroupConnectionConnection> | null;
}

export interface DistinctMarkdownRemarkConnectionArgs {
  field: markdownRemarkDistinctEnum | null;
}

export interface GroupMarkdownRemarkConnectionArgs {
  skip: number | null;
  limit: number | null;
  field: markdownRemarkGroupEnum | null;
}

export interface MarkdownRemarkEdge {
  node: MarkdownRemark | null;
  next: MarkdownRemark | null;
  previous: MarkdownRemark | null;
}

export type markdownRemarkDistinctEnum = "id" | "parent" | "internal___content" | "internal___type" | "internal___contentDigest" | "internal___owner" | "frontmatter___title" | "frontmatter___redirect" | "frontmatter____PARENT" | "frontmatter___parent" | "frontmatter___description" | "frontmatter___component___id" | "frontmatter___component___disablePlayground" | "excerpt" | "fileAbsolutePath";

export type markdownRemarkGroupEnum = "id" | "parent" | "internal___content" | "internal___type" | "internal___contentDigest" | "internal___owner" | "frontmatter___title" | "frontmatter___redirect" | "frontmatter____PARENT" | "frontmatter___parent" | "frontmatter___description" | "frontmatter___component___id" | "frontmatter___component___disablePlayground" | "excerpt" | "fileAbsolutePath";

export interface markdownRemarkGroupConnectionConnection {
  pageInfo: PageInfo;
  edges: Array<markdownRemarkGroupConnectionEdge> | null;
  field: string | null;
  fieldValue: string | null;
  totalCount: number | null;
}

export interface markdownRemarkGroupConnectionEdge {
  node: MarkdownRemark | null;
  next: MarkdownRemark | null;
  previous: MarkdownRemark | null;
}

export interface sitePageLayoutQueryString {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
}

export interface sitePageJsonNameQueryString {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
}

export interface sitePageInternalComponentNameQueryString {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
}

export interface sitePagePathQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
}

export interface sitePageComponentQueryString {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
}

export interface sitePageComponentChunkNameQueryString {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
}

export interface sitePageContextInputObject {
  pagePath: sitePageContextPagePathQueryString | null;
  tab: sitePageContextTabQueryString | null;
  componentId: sitePageContextComponentIdQueryString | null;
  title: sitePageContextTitleQueryString | null;
}

export interface sitePageContextPagePathQueryString {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
}

export interface sitePageContextTabQueryString {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
}

export interface sitePageContextComponentIdQueryString {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
}

export interface sitePageContextTitleQueryString {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
}

export interface sitePagePluginCreatorInputObject {
  resolve: sitePagePluginCreatorResolveQueryString | null;
  id: sitePagePluginCreatorIdQueryString | null;
  name: sitePagePluginCreatorNameQueryString | null;
  version: sitePagePluginCreatorVersionQueryString | null;
  pluginOptions: sitePagePluginCreatorPluginOptionsInputObject | null;
  nodeAPIs: sitePagePluginCreatorNodeApIsQueryList | null;
  browserAPIs: sitePagePluginCreatorBrowserApIsQueryList | null;
  ssrAPIs: sitePagePluginCreatorSsrApIsQueryList | null;
  pluginFilepath: sitePagePluginCreatorPluginFilepathQueryString | null;
  packageJson: sitePagePluginCreatorPackageJsonInputObject | null;
  parent: sitePagePluginCreatorParentQueryString | null;
  internal: sitePagePluginCreatorInternalInputObject | null;
}

export interface sitePagePluginCreatorResolveQueryString {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
}

export interface sitePagePluginCreatorIdQueryString {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
}

export interface sitePagePluginCreatorNameQueryString {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
}

export interface sitePagePluginCreatorVersionQueryString {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
}

export interface sitePagePluginCreatorPluginOptionsInputObject {
  plugins: sitePagePluginCreatorPluginOptionsPluginsQueryList | null;
  trackingId: sitePagePluginCreatorPluginOptionsTrackingIdQueryString | null;
  head: sitePagePluginCreatorPluginOptionsHeadQueryBoolean | null;
  anonymize: sitePagePluginCreatorPluginOptionsAnonymizeQueryBoolean | null;
  respectDNT: sitePagePluginCreatorPluginOptionsRespectDntQueryBoolean | null;
  user: sitePagePluginCreatorPluginOptionsUserQueryString | null;
  repository: sitePagePluginCreatorPluginOptionsRepositoryQueryString | null;
  token: sitePagePluginCreatorPluginOptionsTokenQueryString | null;
  rootURL: sitePagePluginCreatorPluginOptionsRootUrlQueryString | null;
  cwd: sitePagePluginCreatorPluginOptionsCwdQueryString | null;
  pattern: sitePagePluginCreatorPluginOptionsPatternQueryString | null;
  componentSrc: sitePagePluginCreatorPluginOptionsComponentSrcQueryString | null;
  name: sitePagePluginCreatorPluginOptionsNameQueryString | null;
  path: sitePagePluginCreatorPluginOptionsPathQueryString | null;
  maxWidth: sitePagePluginCreatorPluginOptionsMaxWidthQueryInteger | null;
  backgroundColor: sitePagePluginCreatorPluginOptionsBackgroundColorQueryString | null;
  includePaths: sitePagePluginCreatorPluginOptionsIncludePathsQueryList | null;
  sourceMaps: sitePagePluginCreatorPluginOptionsSourceMapsQueryBoolean | null;
  postCSSPlugins: sitePagePluginCreatorPluginOptionsPostCssPluginsQueryList | null;
}

export interface sitePagePluginCreatorPluginOptionsPluginsQueryList {
  in: Array<sitePagePluginCreatorPluginOptionsPluginsInputObject> | null;
}

export interface sitePagePluginCreatorPluginOptionsPluginsInputObject {
  resolve: sitePagePluginCreatorPluginOptionsPluginsResolveQueryString | null;
  id: sitePagePluginCreatorPluginOptionsPluginsIdQueryString | null;
  name: sitePagePluginCreatorPluginOptionsPluginsNameQueryString | null;
  version: sitePagePluginCreatorPluginOptionsPluginsVersionQueryString | null;
  pluginOptions: sitePagePluginCreatorPluginOptionsPluginsPluginOptionsInputObject | null;
  browserAPIs: sitePagePluginCreatorPluginOptionsPluginsBrowserApIsQueryList | null;
  ssrAPIs: sitePagePluginCreatorPluginOptionsPluginsSsrApIsQueryList | null;
  pluginFilepath: sitePagePluginCreatorPluginOptionsPluginsPluginFilepathQueryString | null;
}

export interface sitePagePluginCreatorPluginOptionsPluginsResolveQueryString {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
}

export interface sitePagePluginCreatorPluginOptionsPluginsIdQueryString {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
}

export interface sitePagePluginCreatorPluginOptionsPluginsNameQueryString {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
}

export interface sitePagePluginCreatorPluginOptionsPluginsVersionQueryString {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
}

export interface sitePagePluginCreatorPluginOptionsPluginsPluginOptionsInputObject {
  maxWidth: sitePagePluginCreatorPluginOptionsPluginsPluginOptionsMaxWidthQueryInteger | null;
  backgroundColor: sitePagePluginCreatorPluginOptionsPluginsPluginOptionsBackgroundColorQueryString | null;
}

export interface sitePagePluginCreatorPluginOptionsPluginsPluginOptionsMaxWidthQueryInteger {
  eq: number | null;
  ne: number | null;
}

export interface sitePagePluginCreatorPluginOptionsPluginsPluginOptionsBackgroundColorQueryString {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
}

export interface sitePagePluginCreatorPluginOptionsPluginsBrowserApIsQueryList {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
}

export interface sitePagePluginCreatorPluginOptionsPluginsSsrApIsQueryList {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
}

export interface sitePagePluginCreatorPluginOptionsPluginsPluginFilepathQueryString {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
}

export interface sitePagePluginCreatorPluginOptionsTrackingIdQueryString {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
}

export interface sitePagePluginCreatorPluginOptionsHeadQueryBoolean {
  eq: boolean | null;
  ne: boolean | null;
}

export interface sitePagePluginCreatorPluginOptionsAnonymizeQueryBoolean {
  eq: boolean | null;
  ne: boolean | null;
}

export interface sitePagePluginCreatorPluginOptionsRespectDntQueryBoolean {
  eq: boolean | null;
  ne: boolean | null;
}

export interface sitePagePluginCreatorPluginOptionsUserQueryString {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
}

export interface sitePagePluginCreatorPluginOptionsRepositoryQueryString {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
}

export interface sitePagePluginCreatorPluginOptionsTokenQueryString {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
}

export interface sitePagePluginCreatorPluginOptionsRootUrlQueryString {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
}

export interface sitePagePluginCreatorPluginOptionsCwdQueryString {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
}

export interface sitePagePluginCreatorPluginOptionsPatternQueryString {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
}

export interface sitePagePluginCreatorPluginOptionsComponentSrcQueryString {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
}

export interface sitePagePluginCreatorPluginOptionsNameQueryString {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
}

export interface sitePagePluginCreatorPluginOptionsPathQueryString {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
}

export interface sitePagePluginCreatorPluginOptionsMaxWidthQueryInteger {
  eq: number | null;
  ne: number | null;
}

export interface sitePagePluginCreatorPluginOptionsBackgroundColorQueryString {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
}

export interface sitePagePluginCreatorPluginOptionsIncludePathsQueryList {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
}

export interface sitePagePluginCreatorPluginOptionsSourceMapsQueryBoolean {
  eq: boolean | null;
  ne: boolean | null;
}

export interface sitePagePluginCreatorPluginOptionsPostCssPluginsQueryList {
  in: Array<sitePagePluginCreatorPluginOptionsPostCssPluginsInputObject> | null;
}

export interface sitePagePluginCreatorPluginOptionsPostCssPluginsInputObject {
  postcssPlugin: sitePagePluginCreatorPluginOptionsPostCssPluginsPostcssPluginQueryString | null;
  postcssVersion: sitePagePluginCreatorPluginOptionsPostCssPluginsPostcssVersionQueryString | null;
}

export interface sitePagePluginCreatorPluginOptionsPostCssPluginsPostcssPluginQueryString {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
}

export interface sitePagePluginCreatorPluginOptionsPostCssPluginsPostcssVersionQueryString {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
}

export interface sitePagePluginCreatorNodeApIsQueryList {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
}

export interface sitePagePluginCreatorBrowserApIsQueryList {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
}

export interface sitePagePluginCreatorSsrApIsQueryList {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
}

export interface sitePagePluginCreatorPluginFilepathQueryString {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
}

export interface sitePagePluginCreatorPackageJsonInputObject {
  name: sitePagePluginCreatorPackageJsonNameQueryString | null;
  description: sitePagePluginCreatorPackageJsonDescriptionQueryString | null;
  version: sitePagePluginCreatorPackageJsonVersionQueryString | null;
  main: sitePagePluginCreatorPackageJsonMainQueryString | null;
  author: sitePagePluginCreatorPackageJsonAuthorQueryString | null;
  license: sitePagePluginCreatorPackageJsonLicenseQueryString | null;
  dependencies: sitePagePluginCreatorPackageJsonDependenciesQueryList | null;
  devDependencies: sitePagePluginCreatorPackageJsonDevDependenciesQueryList | null;
  peerDependencies: sitePagePluginCreatorPackageJsonPeerDependenciesQueryList | null;
  keywords: sitePagePluginCreatorPackageJsonKeywordsQueryList | null;
}

export interface sitePagePluginCreatorPackageJsonNameQueryString {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
}

export interface sitePagePluginCreatorPackageJsonDescriptionQueryString {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
}

export interface sitePagePluginCreatorPackageJsonVersionQueryString {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
}

export interface sitePagePluginCreatorPackageJsonMainQueryString {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
}

export interface sitePagePluginCreatorPackageJsonAuthorQueryString {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
}

export interface sitePagePluginCreatorPackageJsonLicenseQueryString {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
}

export interface sitePagePluginCreatorPackageJsonDependenciesQueryList {
  in: Array<sitePagePluginCreatorPackageJsonDependenciesInputObject> | null;
}

export interface sitePagePluginCreatorPackageJsonDependenciesInputObject {
  name: sitePagePluginCreatorPackageJsonDependenciesNameQueryString | null;
  version: sitePagePluginCreatorPackageJsonDependenciesVersionQueryString | null;
}

export interface sitePagePluginCreatorPackageJsonDependenciesNameQueryString {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
}

export interface sitePagePluginCreatorPackageJsonDependenciesVersionQueryString {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
}

export interface sitePagePluginCreatorPackageJsonDevDependenciesQueryList {
  in: Array<sitePagePluginCreatorPackageJsonDevDependenciesInputObject> | null;
}

export interface sitePagePluginCreatorPackageJsonDevDependenciesInputObject {
  name: sitePagePluginCreatorPackageJsonDevDependenciesNameQueryString | null;
  version: sitePagePluginCreatorPackageJsonDevDependenciesVersionQueryString | null;
}

export interface sitePagePluginCreatorPackageJsonDevDependenciesNameQueryString {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
}

export interface sitePagePluginCreatorPackageJsonDevDependenciesVersionQueryString {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
}

export interface sitePagePluginCreatorPackageJsonPeerDependenciesQueryList {
  in: Array<sitePagePluginCreatorPackageJsonPeerDependenciesInputObject> | null;
}

export interface sitePagePluginCreatorPackageJsonPeerDependenciesInputObject {
  name: sitePagePluginCreatorPackageJsonPeerDependenciesNameQueryString | null;
  version: sitePagePluginCreatorPackageJsonPeerDependenciesVersionQueryString | null;
}

export interface sitePagePluginCreatorPackageJsonPeerDependenciesNameQueryString {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
}

export interface sitePagePluginCreatorPackageJsonPeerDependenciesVersionQueryString {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
}

export interface sitePagePluginCreatorPackageJsonKeywordsQueryList {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
}

export interface sitePagePluginCreatorParentQueryString {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
}

export interface sitePagePluginCreatorInternalInputObject {
  contentDigest: sitePagePluginCreatorInternalContentDigestQueryString | null;
  type: sitePagePluginCreatorInternalTypeQueryString | null;
  owner: sitePagePluginCreatorInternalOwnerQueryString | null;
}

export interface sitePagePluginCreatorInternalContentDigestQueryString {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
}

export interface sitePagePluginCreatorInternalTypeQueryString {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
}

export interface sitePagePluginCreatorInternalOwnerQueryString {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
}

export interface sitePagePluginCreatorIdQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
}

export interface sitePageComponentPathQueryString {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
}

export interface sitePageIdQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
}

export interface sitePageInternalInputObject_2 {
  type: sitePageInternalTypeQueryString_2 | null;
  contentDigest: sitePageInternalContentDigestQueryString_2 | null;
  owner: sitePageInternalOwnerQueryString_2 | null;
}

export interface sitePageInternalTypeQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
}

export interface sitePageInternalContentDigestQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
}

export interface sitePageInternalOwnerQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
}

export interface sitePluginResolveQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
}

export interface sitePluginIdQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
}

export interface sitePluginNameQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
}

export interface sitePluginVersionQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
}

export interface sitePluginPluginOptionsInputObject_2 {
  plugins: sitePluginPluginOptionsPluginsQueryList_2 | null;
  trackingId: sitePluginPluginOptionsTrackingIdQueryString_2 | null;
  head: sitePluginPluginOptionsHeadQueryBoolean_2 | null;
  anonymize: sitePluginPluginOptionsAnonymizeQueryBoolean_2 | null;
  respectDNT: sitePluginPluginOptionsRespectDntQueryBoolean_2 | null;
  user: sitePluginPluginOptionsUserQueryString_2 | null;
  repository: sitePluginPluginOptionsRepositoryQueryString_2 | null;
  token: sitePluginPluginOptionsTokenQueryString_2 | null;
  rootURL: sitePluginPluginOptionsRootUrlQueryString_2 | null;
  cwd: sitePluginPluginOptionsCwdQueryString_2 | null;
  pattern: sitePluginPluginOptionsPatternQueryString_2 | null;
  componentSrc: sitePluginPluginOptionsComponentSrcQueryString_2 | null;
  name: sitePluginPluginOptionsNameQueryString_2 | null;
  path: sitePluginPluginOptionsPathQueryString_2 | null;
  maxWidth: sitePluginPluginOptionsMaxWidthQueryInteger_2 | null;
  backgroundColor: sitePluginPluginOptionsBackgroundColorQueryString_2 | null;
  includePaths: sitePluginPluginOptionsIncludePathsQueryList_2 | null;
  sourceMaps: sitePluginPluginOptionsSourceMapsQueryBoolean_2 | null;
  postCSSPlugins: sitePluginPluginOptionsPostCssPluginsQueryList_2 | null;
}

export interface sitePluginPluginOptionsPluginsQueryList_2 {
  in: Array<sitePluginPluginOptionsPluginsInputObject_2> | null;
}

export interface sitePluginPluginOptionsPluginsInputObject_2 {
  resolve: sitePluginPluginOptionsPluginsResolveQueryString_2 | null;
  id: sitePluginPluginOptionsPluginsIdQueryString_2 | null;
  name: sitePluginPluginOptionsPluginsNameQueryString_2 | null;
  version: sitePluginPluginOptionsPluginsVersionQueryString_2 | null;
  pluginOptions: sitePluginPluginOptionsPluginsPluginOptionsInputObject_2 | null;
  browserAPIs: sitePluginPluginOptionsPluginsBrowserApIsQueryList_2 | null;
  ssrAPIs: sitePluginPluginOptionsPluginsSsrApIsQueryList_2 | null;
  pluginFilepath: sitePluginPluginOptionsPluginsPluginFilepathQueryString_2 | null;
}

export interface sitePluginPluginOptionsPluginsResolveQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
}

export interface sitePluginPluginOptionsPluginsIdQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
}

export interface sitePluginPluginOptionsPluginsNameQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
}

export interface sitePluginPluginOptionsPluginsVersionQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
}

export interface sitePluginPluginOptionsPluginsPluginOptionsInputObject_2 {
  maxWidth: sitePluginPluginOptionsPluginsPluginOptionsMaxWidthQueryInteger_2 | null;
  backgroundColor: sitePluginPluginOptionsPluginsPluginOptionsBackgroundColorQueryString_2 | null;
}

export interface sitePluginPluginOptionsPluginsPluginOptionsMaxWidthQueryInteger_2 {
  eq: number | null;
  ne: number | null;
}

export interface sitePluginPluginOptionsPluginsPluginOptionsBackgroundColorQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
}

export interface sitePluginPluginOptionsPluginsBrowserApIsQueryList_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
}

export interface sitePluginPluginOptionsPluginsSsrApIsQueryList_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
}

export interface sitePluginPluginOptionsPluginsPluginFilepathQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
}

export interface sitePluginPluginOptionsTrackingIdQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
}

export interface sitePluginPluginOptionsHeadQueryBoolean_2 {
  eq: boolean | null;
  ne: boolean | null;
}

export interface sitePluginPluginOptionsAnonymizeQueryBoolean_2 {
  eq: boolean | null;
  ne: boolean | null;
}

export interface sitePluginPluginOptionsRespectDntQueryBoolean_2 {
  eq: boolean | null;
  ne: boolean | null;
}

export interface sitePluginPluginOptionsUserQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
}

export interface sitePluginPluginOptionsRepositoryQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
}

export interface sitePluginPluginOptionsTokenQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
}

export interface sitePluginPluginOptionsRootUrlQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
}

export interface sitePluginPluginOptionsCwdQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
}

export interface sitePluginPluginOptionsPatternQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
}

export interface sitePluginPluginOptionsComponentSrcQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
}

export interface sitePluginPluginOptionsNameQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
}

export interface sitePluginPluginOptionsPathQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
}

export interface sitePluginPluginOptionsMaxWidthQueryInteger_2 {
  eq: number | null;
  ne: number | null;
}

export interface sitePluginPluginOptionsBackgroundColorQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
}

export interface sitePluginPluginOptionsIncludePathsQueryList_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
}

export interface sitePluginPluginOptionsSourceMapsQueryBoolean_2 {
  eq: boolean | null;
  ne: boolean | null;
}

export interface sitePluginPluginOptionsPostCssPluginsQueryList_2 {
  in: Array<sitePluginPluginOptionsPostCssPluginsInputObject_2> | null;
}

export interface sitePluginPluginOptionsPostCssPluginsInputObject_2 {
  postcssPlugin: sitePluginPluginOptionsPostCssPluginsPostcssPluginQueryString_2 | null;
  postcssVersion: sitePluginPluginOptionsPostCssPluginsPostcssVersionQueryString_2 | null;
}

export interface sitePluginPluginOptionsPostCssPluginsPostcssPluginQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
}

export interface sitePluginPluginOptionsPostCssPluginsPostcssVersionQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
}

export interface sitePluginNodeApIsQueryList_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
}

export interface sitePluginBrowserApIsQueryList_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
}

export interface sitePluginSsrApIsQueryList_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
}

export interface sitePluginPluginFilepathQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
}

export interface sitePluginPackageJsonInputObject_2 {
  name: sitePluginPackageJsonNameQueryString_2 | null;
  description: sitePluginPackageJsonDescriptionQueryString_2 | null;
  version: sitePluginPackageJsonVersionQueryString_2 | null;
  main: sitePluginPackageJsonMainQueryString_2 | null;
  author: sitePluginPackageJsonAuthorQueryString_2 | null;
  license: sitePluginPackageJsonLicenseQueryString_2 | null;
  dependencies: sitePluginPackageJsonDependenciesQueryList_2 | null;
  devDependencies: sitePluginPackageJsonDevDependenciesQueryList_2 | null;
  peerDependencies: sitePluginPackageJsonPeerDependenciesQueryList_2 | null;
  keywords: sitePluginPackageJsonKeywordsQueryList_2 | null;
}

export interface sitePluginPackageJsonNameQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
}

export interface sitePluginPackageJsonDescriptionQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
}

export interface sitePluginPackageJsonVersionQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
}

export interface sitePluginPackageJsonMainQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
}

export interface sitePluginPackageJsonAuthorQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
}

export interface sitePluginPackageJsonLicenseQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
}

export interface sitePluginPackageJsonDependenciesQueryList_2 {
  in: Array<sitePluginPackageJsonDependenciesInputObject_2> | null;
}

export interface sitePluginPackageJsonDependenciesInputObject_2 {
  name: sitePluginPackageJsonDependenciesNameQueryString_2 | null;
  version: sitePluginPackageJsonDependenciesVersionQueryString_2 | null;
}

export interface sitePluginPackageJsonDependenciesNameQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
}

export interface sitePluginPackageJsonDependenciesVersionQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
}

export interface sitePluginPackageJsonDevDependenciesQueryList_2 {
  in: Array<sitePluginPackageJsonDevDependenciesInputObject_2> | null;
}

export interface sitePluginPackageJsonDevDependenciesInputObject_2 {
  name: sitePluginPackageJsonDevDependenciesNameQueryString_2 | null;
  version: sitePluginPackageJsonDevDependenciesVersionQueryString_2 | null;
}

export interface sitePluginPackageJsonDevDependenciesNameQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
}

export interface sitePluginPackageJsonDevDependenciesVersionQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
}

export interface sitePluginPackageJsonPeerDependenciesQueryList_2 {
  in: Array<sitePluginPackageJsonPeerDependenciesInputObject_2> | null;
}

export interface sitePluginPackageJsonPeerDependenciesInputObject_2 {
  name: sitePluginPackageJsonPeerDependenciesNameQueryString_2 | null;
  version: sitePluginPackageJsonPeerDependenciesVersionQueryString_2 | null;
}

export interface sitePluginPackageJsonPeerDependenciesNameQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
}

export interface sitePluginPackageJsonPeerDependenciesVersionQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
}

export interface sitePluginPackageJsonKeywordsQueryList_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
}

export interface sitePluginInternalInputObject_2 {
  contentDigest: sitePluginInternalContentDigestQueryString_2 | null;
  type: sitePluginInternalTypeQueryString_2 | null;
  owner: sitePluginInternalOwnerQueryString_2 | null;
}

export interface sitePluginInternalContentDigestQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
}

export interface sitePluginInternalTypeQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
}

export interface sitePluginInternalOwnerQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
}

export interface siteSiteMetadataInputObject_2 {
  title: siteSiteMetadataTitleQueryString_2 | null;
}

export interface siteSiteMetadataTitleQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
}

export interface sitePortQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
}

export interface siteHostQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
}

export interface sitePolyfillQueryBoolean_2 {
  eq: boolean | null;
  ne: boolean | null;
}

export interface siteBuildTimeQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
}

export interface siteIdQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
}

export interface siteInternalInputObject_2 {
  contentDigest: siteInternalContentDigestQueryString_2 | null;
  type: siteInternalTypeQueryString_2 | null;
  owner: siteInternalOwnerQueryString_2 | null;
}

export interface siteInternalContentDigestQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
}

export interface siteInternalTypeQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
}

export interface siteInternalOwnerQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
}

export interface Site extends Node {
  id: string;
  parent: Node | null;
  children: Array<Node> | null;
  siteMetadata: siteMetadata_2 | null;
  port: Date | null;
  host: string | null;
  polyfill: boolean | null;
  buildTime: Date | null;
  internal: internal_18 | null;
}

export interface PortSiteArgs {
  formatString: string | null;
  fromNow: boolean | null;
  difference: string | null;
  locale: string | null;
}

export interface BuildTimeSiteArgs {
  formatString: string | null;
  fromNow: boolean | null;
  difference: string | null;
  locale: string | null;
}

export interface siteMetadata_2 {
  title: string | null;
}

export interface internal_18 {
  contentDigest: string | null;
  type: string | null;
  owner: string | null;
}

export interface githubFileItemsQueryList_2 {
  in: Array<githubFileItemsInputObject_2> | null;
}

export interface githubFileItemsInputObject_2 {
  sha: githubFileItemsShaQueryString_2 | null;
  commit: githubFileItemsCommitInputObject_2 | null;
  url: githubFileItemsUrlQueryString_2 | null;
  htmlUrl: githubFileItemsHtmlUrlQueryString_2 | null;
  commentsUrl: githubFileItemsCommentsUrlQueryString_2 | null;
  author: githubFileItemsAuthorInputObject_2 | null;
  committer: githubFileItemsCommitterInputObject_2 | null;
  parents: githubFileItemsParentsQueryList_2 | null;
}

export interface githubFileItemsShaQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
}

export interface githubFileItemsCommitInputObject_2 {
  author: githubFileItemsCommitAuthorInputObject_2 | null;
  committer: githubFileItemsCommitCommitterInputObject_2 | null;
  message: githubFileItemsCommitMessageQueryString_2 | null;
  tree: githubFileItemsCommitTreeInputObject_2 | null;
  url: githubFileItemsCommitUrlQueryString_2 | null;
  commentCount: githubFileItemsCommitCommentCountQueryInteger_2 | null;
  verification: githubFileItemsCommitVerificationInputObject_2 | null;
}

export interface githubFileItemsCommitAuthorInputObject_2 {
  name: githubFileItemsCommitAuthorNameQueryString_2 | null;
  email: githubFileItemsCommitAuthorEmailQueryString_2 | null;
  date: githubFileItemsCommitAuthorDateQueryString_2 | null;
}

export interface githubFileItemsCommitAuthorNameQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
}

export interface githubFileItemsCommitAuthorEmailQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
}

export interface githubFileItemsCommitAuthorDateQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
}

export interface githubFileItemsCommitCommitterInputObject_2 {
  name: githubFileItemsCommitCommitterNameQueryString_2 | null;
  email: githubFileItemsCommitCommitterEmailQueryString_2 | null;
  date: githubFileItemsCommitCommitterDateQueryString_2 | null;
}

export interface githubFileItemsCommitCommitterNameQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
}

export interface githubFileItemsCommitCommitterEmailQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
}

export interface githubFileItemsCommitCommitterDateQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
}

export interface githubFileItemsCommitMessageQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
}

export interface githubFileItemsCommitTreeInputObject_2 {
  sha: githubFileItemsCommitTreeShaQueryString_2 | null;
  url: githubFileItemsCommitTreeUrlQueryString_2 | null;
}

export interface githubFileItemsCommitTreeShaQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
}

export interface githubFileItemsCommitTreeUrlQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
}

export interface githubFileItemsCommitUrlQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
}

export interface githubFileItemsCommitCommentCountQueryInteger_2 {
  eq: number | null;
  ne: number | null;
}

export interface githubFileItemsCommitVerificationInputObject_2 {
  verified: githubFileItemsCommitVerificationVerifiedQueryBoolean_2 | null;
  reason: githubFileItemsCommitVerificationReasonQueryString_2 | null;
}

export interface githubFileItemsCommitVerificationVerifiedQueryBoolean_2 {
  eq: boolean | null;
  ne: boolean | null;
}

export interface githubFileItemsCommitVerificationReasonQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
}

export interface githubFileItemsUrlQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
}

export interface githubFileItemsHtmlUrlQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
}

export interface githubFileItemsCommentsUrlQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
}

export interface githubFileItemsAuthorInputObject_2 {
  login: githubFileItemsAuthorLoginQueryString_2 | null;
  id: githubFileItemsAuthorIdQueryInteger_2 | null;
  avatarUrl: githubFileItemsAuthorAvatarUrlQueryString_2 | null;
  gravatarId: githubFileItemsAuthorGravatarIdQueryString_2 | null;
  url: githubFileItemsAuthorUrlQueryString_2 | null;
  htmlUrl: githubFileItemsAuthorHtmlUrlQueryString_2 | null;
  followersUrl: githubFileItemsAuthorFollowersUrlQueryString_2 | null;
  subscriptionsUrl: githubFileItemsAuthorSubscriptionsUrlQueryString_2 | null;
  organizationsUrl: githubFileItemsAuthorOrganizationsUrlQueryString_2 | null;
  reposUrl: githubFileItemsAuthorReposUrlQueryString_2 | null;
  receivedEventsUrl: githubFileItemsAuthorReceivedEventsUrlQueryString_2 | null;
  type: githubFileItemsAuthorTypeQueryString_2 | null;
  siteAdmin: githubFileItemsAuthorSiteAdminQueryBoolean_2 | null;
  ldapDn: githubFileItemsAuthorLdapDnQueryString_2 | null;
}

export interface githubFileItemsAuthorLoginQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
}

export interface githubFileItemsAuthorIdQueryInteger_2 {
  eq: number | null;
  ne: number | null;
}

export interface githubFileItemsAuthorAvatarUrlQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
}

export interface githubFileItemsAuthorGravatarIdQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
}

export interface githubFileItemsAuthorUrlQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
}

export interface githubFileItemsAuthorHtmlUrlQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
}

export interface githubFileItemsAuthorFollowersUrlQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
}

export interface githubFileItemsAuthorSubscriptionsUrlQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
}

export interface githubFileItemsAuthorOrganizationsUrlQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
}

export interface githubFileItemsAuthorReposUrlQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
}

export interface githubFileItemsAuthorReceivedEventsUrlQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
}

export interface githubFileItemsAuthorTypeQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
}

export interface githubFileItemsAuthorSiteAdminQueryBoolean_2 {
  eq: boolean | null;
  ne: boolean | null;
}

export interface githubFileItemsAuthorLdapDnQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
}

export interface githubFileItemsCommitterInputObject_2 {
  login: githubFileItemsCommitterLoginQueryString_2 | null;
  id: githubFileItemsCommitterIdQueryInteger_2 | null;
  avatarUrl: githubFileItemsCommitterAvatarUrlQueryString_2 | null;
  gravatarId: githubFileItemsCommitterGravatarIdQueryString_2 | null;
  url: githubFileItemsCommitterUrlQueryString_2 | null;
  htmlUrl: githubFileItemsCommitterHtmlUrlQueryString_2 | null;
  followersUrl: githubFileItemsCommitterFollowersUrlQueryString_2 | null;
  subscriptionsUrl: githubFileItemsCommitterSubscriptionsUrlQueryString_2 | null;
  organizationsUrl: githubFileItemsCommitterOrganizationsUrlQueryString_2 | null;
  reposUrl: githubFileItemsCommitterReposUrlQueryString_2 | null;
  receivedEventsUrl: githubFileItemsCommitterReceivedEventsUrlQueryString_2 | null;
  type: githubFileItemsCommitterTypeQueryString_2 | null;
  siteAdmin: githubFileItemsCommitterSiteAdminQueryBoolean_2 | null;
  ldapDn: githubFileItemsCommitterLdapDnQueryString_2 | null;
}

export interface githubFileItemsCommitterLoginQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
}

export interface githubFileItemsCommitterIdQueryInteger_2 {
  eq: number | null;
  ne: number | null;
}

export interface githubFileItemsCommitterAvatarUrlQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
}

export interface githubFileItemsCommitterGravatarIdQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
}

export interface githubFileItemsCommitterUrlQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
}

export interface githubFileItemsCommitterHtmlUrlQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
}

export interface githubFileItemsCommitterFollowersUrlQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
}

export interface githubFileItemsCommitterSubscriptionsUrlQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
}

export interface githubFileItemsCommitterOrganizationsUrlQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
}

export interface githubFileItemsCommitterReposUrlQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
}

export interface githubFileItemsCommitterReceivedEventsUrlQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
}

export interface githubFileItemsCommitterTypeQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
}

export interface githubFileItemsCommitterSiteAdminQueryBoolean_2 {
  eq: boolean | null;
  ne: boolean | null;
}

export interface githubFileItemsCommitterLdapDnQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
}

export interface githubFileItemsParentsQueryList_2 {
  in: Array<githubFileItemsParentsInputObject_2> | null;
}

export interface githubFileItemsParentsInputObject_2 {
  sha: githubFileItemsParentsShaQueryString_2 | null;
  url: githubFileItemsParentsUrlQueryString_2 | null;
  htmlUrl: githubFileItemsParentsHtmlUrlQueryString_2 | null;
}

export interface githubFileItemsParentsShaQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
}

export interface githubFileItemsParentsUrlQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
}

export interface githubFileItemsParentsHtmlUrlQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
}

export interface githubFileIdQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
}

export interface githubFileComponentQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
}

export interface githubFileInternalInputObject_2 {
  type: githubFileInternalTypeQueryString_2 | null;
  contentDigest: githubFileInternalContentDigestQueryString_2 | null;
  owner: githubFileInternalOwnerQueryString_2 | null;
}

export interface githubFileInternalTypeQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
}

export interface githubFileInternalContentDigestQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
}

export interface githubFileInternalOwnerQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
}

export interface typeDocFileIdQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
}

export interface typeDocFileComponentQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
}

export interface typeDocFileNameQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
}

export interface typeDocFileCommentInputObject_2 {
  shortText: typeDocFileCommentShortTextQueryString_2 | null;
}

export interface typeDocFileCommentShortTextQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
}

export interface typeDocFilePropertiesQueryList_2 {
  in: Array<typeDocFilePropertiesInputObject_2> | null;
}

export interface typeDocFilePropertiesInputObject_2 {
  name: typeDocFilePropertiesNameQueryString_2 | null;
  availableValues: typeDocFilePropertiesAvailableValuesQueryList_2 | null;
  flags: typeDocFilePropertiesFlagsInputObject_2 | null;
  comment: typeDocFilePropertiesCommentInputObject_2 | null;
  breakpointCompatible: typeDocFilePropertiesBreakpointCompatibleQueryBoolean_2 | null;
  type: typeDocFilePropertiesTypeQueryString_2 | null;
  sourceSrc: typeDocFilePropertiesSourceSrcQueryString_2 | null;
}

export interface typeDocFilePropertiesNameQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
}

export interface typeDocFilePropertiesAvailableValuesQueryList_2 {
  in: Array<typeDocFilePropertiesAvailableValuesInputObject_2> | null;
}

export interface typeDocFilePropertiesAvailableValuesInputObject_2 {
  name: typeDocFilePropertiesAvailableValuesNameQueryString_2 | null;
  sourceSrc: typeDocFilePropertiesAvailableValuesSourceSrcQueryString_2 | null;
  properties: typeDocFilePropertiesAvailableValuesPropertiesQueryList_2 | null;
  values: typeDocFilePropertiesAvailableValuesValuesQueryList_2 | null;
}

export interface typeDocFilePropertiesAvailableValuesNameQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
}

export interface typeDocFilePropertiesAvailableValuesSourceSrcQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
}

export interface typeDocFilePropertiesAvailableValuesPropertiesQueryList_2 {
  in: Array<typeDocFilePropertiesAvailableValuesPropertiesInputObject_2> | null;
}

export interface typeDocFilePropertiesAvailableValuesPropertiesInputObject_2 {
  name: typeDocFilePropertiesAvailableValuesPropertiesNameQueryString_2 | null;
  value: typeDocFilePropertiesAvailableValuesPropertiesValueQueryString_2 | null;
  isOptional: typeDocFilePropertiesAvailableValuesPropertiesIsOptionalQueryBoolean_2 | null;
  sourceSrc: typeDocFilePropertiesAvailableValuesPropertiesSourceSrcQueryString_2 | null;
}

export interface typeDocFilePropertiesAvailableValuesPropertiesNameQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
}

export interface typeDocFilePropertiesAvailableValuesPropertiesValueQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
}

export interface typeDocFilePropertiesAvailableValuesPropertiesIsOptionalQueryBoolean_2 {
  eq: boolean | null;
  ne: boolean | null;
}

export interface typeDocFilePropertiesAvailableValuesPropertiesSourceSrcQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
}

export interface typeDocFilePropertiesAvailableValuesValuesQueryList_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
}

export interface typeDocFilePropertiesFlagsInputObject_2 {
  isExported: typeDocFilePropertiesFlagsIsExportedQueryBoolean_2 | null;
  isOptional: typeDocFilePropertiesFlagsIsOptionalQueryBoolean_2 | null;
}

export interface typeDocFilePropertiesFlagsIsExportedQueryBoolean_2 {
  eq: boolean | null;
  ne: boolean | null;
}

export interface typeDocFilePropertiesFlagsIsOptionalQueryBoolean_2 {
  eq: boolean | null;
  ne: boolean | null;
}

export interface typeDocFilePropertiesCommentInputObject_2 {
  tags: typeDocFilePropertiesCommentTagsQueryList_2 | null;
  shortText: typeDocFilePropertiesCommentShortTextQueryString_2 | null;
}

export interface typeDocFilePropertiesCommentTagsQueryList_2 {
  in: Array<typeDocFilePropertiesCommentTagsInputObject_2> | null;
}

export interface typeDocFilePropertiesCommentTagsInputObject_2 {
  tag: typeDocFilePropertiesCommentTagsTagQueryString_2 | null;
  text: typeDocFilePropertiesCommentTagsTextQueryString_2 | null;
}

export interface typeDocFilePropertiesCommentTagsTagQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
}

export interface typeDocFilePropertiesCommentTagsTextQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
}

export interface typeDocFilePropertiesCommentShortTextQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
}

export interface typeDocFilePropertiesBreakpointCompatibleQueryBoolean_2 {
  eq: boolean | null;
  ne: boolean | null;
}

export interface typeDocFilePropertiesTypeQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
}

export interface typeDocFilePropertiesSourceSrcQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
}

export interface typeDocFileInternalInputObject_2 {
  type: typeDocFileInternalTypeQueryString_2 | null;
  contentDigest: typeDocFileInternalContentDigestQueryString_2 | null;
  owner: typeDocFileInternalOwnerQueryString_2 | null;
}

export interface typeDocFileInternalTypeQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
}

export interface typeDocFileInternalContentDigestQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
}

export interface typeDocFileInternalOwnerQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
}

export interface consumerProjectVersionsFileIdQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
}

export interface consumerProjectVersionsFileCurrentProjectVersionQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
}

export interface consumerProjectVersionsFileInternalInputObject_2 {
  type: consumerProjectVersionsFileInternalTypeQueryString_2 | null;
  contentDigest: consumerProjectVersionsFileInternalContentDigestQueryString_2 | null;
  owner: consumerProjectVersionsFileInternalOwnerQueryString_2 | null;
}

export interface consumerProjectVersionsFileInternalTypeQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
}

export interface consumerProjectVersionsFileInternalContentDigestQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
}

export interface consumerProjectVersionsFileInternalOwnerQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
}

export interface directoryIdQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
}

export interface directoryInternalInputObject_2 {
  contentDigest: directoryInternalContentDigestQueryString_2 | null;
  type: directoryInternalTypeQueryString_2 | null;
  owner: directoryInternalOwnerQueryString_2 | null;
}

export interface directoryInternalContentDigestQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
}

export interface directoryInternalTypeQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
}

export interface directoryInternalOwnerQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
}

export interface directorySourceInstanceNameQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
}

export interface directoryAbsolutePathQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
}

export interface directoryRelativePathQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
}

export interface directoryExtensionQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
}

export interface directorySizeQueryInteger_2 {
  eq: number | null;
  ne: number | null;
}

export interface directoryPrettySizeQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
}

export interface directoryModifiedTimeQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
}

export interface directoryAccessTimeQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
}

export interface directoryChangeTimeQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
}

export interface directoryBirthTimeQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
}

export interface directoryRootQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
}

export interface directoryDirQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
}

export interface directoryBaseQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
}

export interface directoryExtQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
}

export interface directoryNameQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
}

export interface directoryRelativeDirectoryQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
}

export interface directoryDevQueryInteger_2 {
  eq: number | null;
  ne: number | null;
}

export interface directoryModeQueryInteger_2 {
  eq: number | null;
  ne: number | null;
}

export interface directoryNlinkQueryInteger_2 {
  eq: number | null;
  ne: number | null;
}

export interface directoryUidQueryInteger_2 {
  eq: number | null;
  ne: number | null;
}

export interface directoryGidQueryInteger_2 {
  eq: number | null;
  ne: number | null;
}

export interface directoryRdevQueryInteger_2 {
  eq: number | null;
  ne: number | null;
}

export interface directoryBlksizeQueryInteger_2 {
  eq: number | null;
  ne: number | null;
}

export interface directoryInoQueryInteger_2 {
  eq: number | null;
  ne: number | null;
}

export interface directoryBlocksQueryInteger_2 {
  eq: number | null;
  ne: number | null;
}

export interface directoryAtimeMsQueryInteger_2 {
  eq: number | null;
  ne: number | null;
}

export interface directoryMtimeMsQueryInteger_2 {
  eq: number | null;
  ne: number | null;
}

export interface directoryCtimeMsQueryInteger_2 {
  eq: number | null;
  ne: number | null;
}

export interface directoryBirthtimeMsQueryInteger_2 {
  eq: number | null;
  ne: number | null;
}

export interface directoryAtimeQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
}

export interface directoryMtimeQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
}

export interface directoryCtimeQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
}

export interface directoryBirthtimeQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
}

export interface fileIdQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
}

export interface fileInternalInputObject_2 {
  contentDigest: fileInternalContentDigestQueryString_2 | null;
  mediaType: fileInternalMediaTypeQueryString_2 | null;
  type: fileInternalTypeQueryString_2 | null;
  owner: fileInternalOwnerQueryString_2 | null;
  fieldOwners: fileInternalFieldOwnersInputObject_2 | null;
}

export interface fileInternalContentDigestQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
}

export interface fileInternalMediaTypeQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
}

export interface fileInternalTypeQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
}

export interface fileInternalOwnerQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
}

export interface fileInternalFieldOwnersInputObject_2 {
  segments: fileInternalFieldOwnersSegmentsQueryString_2 | null;
  title: fileInternalFieldOwnersTitleQueryString_2 | null;
  slug: fileInternalFieldOwnersSlugQueryString_2 | null;
  path: fileInternalFieldOwnersPathQueryString_2 | null;
  tab: fileInternalFieldOwnersTabQueryString_2 | null;
  tabPath: fileInternalFieldOwnersTabPathQueryString_2 | null;
}

export interface fileInternalFieldOwnersSegmentsQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
}

export interface fileInternalFieldOwnersTitleQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
}

export interface fileInternalFieldOwnersSlugQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
}

export interface fileInternalFieldOwnersPathQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
}

export interface fileInternalFieldOwnersTabQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
}

export interface fileInternalFieldOwnersTabPathQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
}

export interface fileSourceInstanceNameQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
}

export interface fileAbsolutePathQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
}

export interface fileRelativePathQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
}

export interface fileExtensionQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
}

export interface fileSizeQueryInteger_2 {
  eq: number | null;
  ne: number | null;
}

export interface filePrettySizeQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
}

export interface fileModifiedTimeQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
}

export interface fileAccessTimeQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
}

export interface fileChangeTimeQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
}

export interface fileBirthTimeQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
}

export interface fileRootQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
}

export interface fileDirQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
}

export interface fileBaseQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
}

export interface fileExtQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
}

export interface fileNameQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
}

export interface fileRelativeDirectoryQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
}

export interface fileDevQueryInteger_2 {
  eq: number | null;
  ne: number | null;
}

export interface fileModeQueryInteger_2 {
  eq: number | null;
  ne: number | null;
}

export interface fileNlinkQueryInteger_2 {
  eq: number | null;
  ne: number | null;
}

export interface fileUidQueryInteger_2 {
  eq: number | null;
  ne: number | null;
}

export interface fileGidQueryInteger_2 {
  eq: number | null;
  ne: number | null;
}

export interface fileRdevQueryInteger_2 {
  eq: number | null;
  ne: number | null;
}

export interface fileBlksizeQueryInteger_2 {
  eq: number | null;
  ne: number | null;
}

export interface fileInoQueryInteger_2 {
  eq: number | null;
  ne: number | null;
}

export interface fileBlocksQueryInteger_2 {
  eq: number | null;
  ne: number | null;
}

export interface fileAtimeMsQueryInteger_2 {
  eq: number | null;
  ne: number | null;
}

export interface fileMtimeMsQueryInteger_2 {
  eq: number | null;
  ne: number | null;
}

export interface fileCtimeMsQueryInteger_2 {
  eq: number | null;
  ne: number | null;
}

export interface fileBirthtimeMsQueryInteger_2 {
  eq: number | null;
  ne: number | null;
}

export interface fileAtimeQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
}

export interface fileMtimeQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
}

export interface fileCtimeQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
}

export interface fileBirthtimeQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
}

export interface fileFieldsInputObject_2 {
  segments: fileFieldsSegmentsQueryList_2 | null;
  title: fileFieldsTitleQueryString_2 | null;
  slug: fileFieldsSlugQueryString_2 | null;
  path: fileFieldsPathQueryString_2 | null;
  tab: fileFieldsTabInputObject_2 | null;
  tabPath: fileFieldsTabPathQueryString_2 | null;
}

export interface fileFieldsSegmentsQueryList_2 {
  in: Array<fileFieldsSegmentsInputObject_2> | null;
}

export interface fileFieldsSegmentsInputObject_2 {
  slug: fileFieldsSegmentsSlugQueryString_2 | null;
  title: fileFieldsSegmentsTitleQueryString_2 | null;
}

export interface fileFieldsSegmentsSlugQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
}

export interface fileFieldsSegmentsTitleQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
}

export interface fileFieldsTitleQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
}

export interface fileFieldsSlugQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
}

export interface fileFieldsPathQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
}

export interface fileFieldsTabInputObject_2 {
  slug: fileFieldsTabSlugQueryString_2 | null;
  title: fileFieldsTabTitleQueryString_2 | null;
}

export interface fileFieldsTabSlugQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
}

export interface fileFieldsTabTitleQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
}

export interface fileFieldsTabPathQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
}

export interface publicUrlQueryString_3 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
}

export interface markdownRemarkIdQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
}

export interface markdownRemarkInternalInputObject_2 {
  content: markdownRemarkInternalContentQueryString_2 | null;
  type: markdownRemarkInternalTypeQueryString_2 | null;
  contentDigest: markdownRemarkInternalContentDigestQueryString_2 | null;
  owner: markdownRemarkInternalOwnerQueryString_2 | null;
}

export interface markdownRemarkInternalContentQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
}

export interface markdownRemarkInternalTypeQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
}

export interface markdownRemarkInternalContentDigestQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
}

export interface markdownRemarkInternalOwnerQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
}

export interface markdownRemarkFrontmatterInputObject_2 {
  title: markdownRemarkFrontmatterTitleQueryString_2 | null;
  redirect: markdownRemarkFrontmatterRedirectQueryString_2 | null;
  _PARENT: markdownRemarkFrontmatterParentQueryString_3 | null;
  parent: markdownRemarkFrontmatterParentQueryString_4 | null;
  description: markdownRemarkFrontmatterDescriptionQueryString_2 | null;
  component: markdownRemarkFrontmatterComponentInputObject_2 | null;
}

export interface markdownRemarkFrontmatterTitleQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
}

export interface markdownRemarkFrontmatterRedirectQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
}

export interface markdownRemarkFrontmatterParentQueryString_3 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
}

export interface markdownRemarkFrontmatterParentQueryString_4 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
}

export interface markdownRemarkFrontmatterDescriptionQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
}

export interface markdownRemarkFrontmatterComponentInputObject_2 {
  id: markdownRemarkFrontmatterComponentIdQueryString_2 | null;
  disablePlayground: markdownRemarkFrontmatterComponentDisablePlaygroundQueryBoolean_2 | null;
}

export interface markdownRemarkFrontmatterComponentIdQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
}

export interface markdownRemarkFrontmatterComponentDisablePlaygroundQueryBoolean_2 {
  eq: boolean | null;
  ne: boolean | null;
}

export interface excerptQueryString_3 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
}

export interface markdownRemarkFileAbsolutePathQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
}

export interface htmlQueryString_3 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
}

export interface headingsQueryList_3 {
  value: headingsListElemValueQueryString_3 | null;
  depth: headingsListElemDepthQueryInt_3 | null;
  in: Array<markdownHeadingInputObject_3> | null;
}

export interface headingsListElemValueQueryString_3 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
}

export interface headingsListElemDepthQueryInt_3 {
  eq: number | null;
  ne: number | null;
}

export interface markdownHeadingInputObject_3 {
  value: string | null;
  depth: number | null;
}

export interface timeToReadQueryInt_3 {
  eq: number | null;
  ne: number | null;
}

export interface tableOfContentsQueryString_3 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
}

export interface wordCountTypeName_3 {
  paragraphs: wordCountParagraphsQueryInt_3 | null;
  sentences: wordCountSentencesQueryInt_3 | null;
  words: wordCountWordsQueryInt_3 | null;
}

export interface wordCountParagraphsQueryInt_3 {
  eq: number | null;
  ne: number | null;
}

export interface wordCountSentencesQueryInt_3 {
  eq: number | null;
  ne: number | null;
}

export interface wordCountWordsQueryInt_3 {
  eq: number | null;
  ne: number | null;
}
