/* tslint:disable no-var-requires */
/* tslint:disable no-console */

import * as React from 'react';
import Helmet from 'react-helmet';
import { siteMetadata } from '../gatsby-config';

// Load production style
let styles: string;
if (process.env.NODE_ENV === `production`) {
  try {
    // tslint:disable-next-line:no-require-imports
    styles = require('!raw-loader!../public/styles.css');
  } catch (err) {
    console.log(err);
  }
}

interface HtmlProps {
  body: string;
  postBodyComponents: {};
  headComponents: {};
}

// Use `module.exports` to be compliante with `webpack-require` import method
module.exports = (props: HtmlProps) => {
  const head = Helmet.rewind();

  return (
    <html className="tw-root tw-root--hover">
      <head>
        {props.headComponents}
        <title>{siteMetadata.title}</title>
        <link rel="icon" href="//s3-us-west-2.amazonaws.com/web-design-int-production/assets/images/favicon-16.png" sizes="16x16"/>
        <link rel="icon" href="//s3-us-west-2.amazonaws.com/web-design-int-production/assets/images/favicon-32.png" sizes="32x32"/>
        <meta charSet="utf-8" />
        <meta httpEquiv="X-UA-Compatible" content="IE=edge" />
        <meta
          name="viewport"
          content="width=device-width, initial-scale=1.0, maximum-scale=1.0"
        />
        {head.title.toComponent()}
        {head.meta.toComponent()}
        {head.link.toComponent()}
        {process.env.NODE_ENV === 'production' && (
          <style
            id="gatsby-inlined-css"
            dangerouslySetInnerHTML={{ __html: styles }}
          />
        )}
      </head>
      <body>
        <div
          key="body"
          id="___gatsby"
          dangerouslySetInnerHTML={{ __html: props.body }}
        />
        {props.postBodyComponents}
      </body>
    </html>
  );
};
