import 'babel-polyfill';
import {
  Display,
  Layout,
  Position,
} from 'carbon-components-prototype';
import * as classnames from 'classnames';
import * as React from 'react';
import { RouteComponentProps, withRouter } from 'react-router-dom';
import { Sidebar } from '../components/sidebar';
import { SidebarMenu } from '../components/sidebar-menu';
import { FileConnection } from '../graphql-types';
import '../scss/main.scss';
import { withoutPrefix } from '../utils/path-helpers';
import './styles.scss';

interface ConsumerProjectVersionsFile {
  currentProjectVersion: string;
}

interface PublicProps {
  data: {
    pages: FileConnection;
    projectVersions: ConsumerProjectVersionsFile;
  };
  children: any; // tslint:disable-line:no-any
}

type Props = PublicProps & RouteComponentProps<{}>;

/**
 * Layout Component
 *
 * Note: Gatsby only renders the layout component once. This allows us to
 *       keep other components mounted when the route changes.
 */
class MainPageLayoutComponent extends React.Component<Props, {}> {
  public render () {
    const isHomepage = !withoutPrefix(this.props.history.location.pathname);
    const classes: ClassValue = {
      'layout': true,
      'layout--no-menu': isHomepage,
    };

    return (
      <Layout fullHeight className={classnames(classes)}>
        <Layout
          className="layout__sidebar"
          display={Display.Flex}
          position={Position.Fixed}
          attachTop
          attachLeft
        >
          <Sidebar currentProjectVersion={this.props.data.projectVersions.currentProjectVersion} />
          {!isHomepage && <SidebarMenu pages={this.props.data.pages.edges} />}
        </Layout>
        <Layout
          className="layout__body"
          position={Position.Relative}
          fullHeight
        >
          {this.props.children()}
        </Layout>
      </Layout>
    );
  }
}

// Gatsby requires a default export for template and layout files.
// tslint:disable-next-line:no-default-export
export default withRouter(MainPageLayoutComponent);

export const pageQuery = graphql`
  query LayoutData {
    projectVersions: consumerProjectVersionsFile {
      id,
      currentProjectVersion
    }
    pages: allFile (
      sort: {
        fields: [relativePath],
        order: ASC
      }
      filter: {
        absolutePath: { regex: "/data/" }
        extension: { regex: "/md/" }
        fields: {
          tab: {
            slug: {
              eq: "index"
            }
          }
        }
      }
    ) {
      edges {
        node {
          relativePath
          childMarkdownRemark {
            frontmatter {
              title
              component {
                id
              }
            }
          }
          fields {
            title
            path
            slug
            segments {
              slug
            }
          }
        }
      }
    }
  }
`;
