import { escape } from 'lodash';
import * as visit from 'unist-util-visit';

function gatsbyRemarkCodeClassnames ({ markdownAST }: any, {}) {

  visit(markdownAST, 'code', (node: any) => {
    const language = node.lang;

    node.type = 'html';
    node.value = `<div>
      <pre data-language="${language}"><code data-language="${language}">${escape(node.value)}</code></pre>
    </div>`;
  });

}

module.exports = gatsbyRemarkCodeClassnames;
