import * as crypto from 'crypto';

// tslint:disable-next-line
const currentCorePackage = require('carbon-components-prototype/package.json');

exports.sourceNodes = (
  { boundActionCreators }: any, // tslint:disable-line no-any
) => {
  const { createNode } = boundActionCreators;

  createNode({
    id: `consumerProjectVersions`,
    currentProjectVersion: currentCorePackage.version,
    parent: null,
    children: [],
    internal: {
      type: 'consumerProjectVersionsFile',
      contentDigest: crypto
        .createHash('md5')
        .update(JSON.stringify(currentCorePackage.version))
        .digest('hex'),
    },
  });

  return;
};
