import {
  Column,
  Grid,
} from 'carbon-components-prototype';
import * as React from 'react';
import { RouteComponentProps } from 'react-router-dom';
import { Changelog } from '../components/changelog';
import { PageWrapper } from '../components/page-wrapper';
import { File, FileConnection, GithubFile, SitePage, TypeDocFile } from '../graphql-types';
import './styles.scss';

interface PublicProps {
  data: {
    indexPage: SitePage;
    indexFile: File;
    tabs: FileConnection;
    component: TypeDocFile;
    github: GithubFile;
  };
}

type Props = PublicProps & RouteComponentProps<{}>;

// Gatsby requires a default export for template and layout files.
// tslint:disable-next-line:no-default-export
export default class ChangelogPageTemplate extends React.Component<Props, {}> {

  public render () {
    return (
      <PageWrapper
        page={this.props.data.indexPage}
        file={this.props.data.indexFile}
        tabs={this.props.data.tabs}
        component={this.props.data.component}
      >
        <Grid>
          <Column cols={{ default: 12, lg: 8 }}>
            <Changelog file={this.props.data.github} />
          </Column>
        </Grid>
      </PageWrapper>
    );
  }
}

export const pageQuery = graphql`
  query ChangelogPageContent(
    $pagePath: String!,
    $componentId: String
    $path: String
  ) {
    ...defaultPage
    github: githubFile(
      component: { eq: $componentId }
    ) {
      items{
        sha
        htmlUrl
        commit {
          message
          committer {
            date(locale: "en")
          }
        }
        author {
          login
          avatarUrl
          htmlUrl
        }
      }
    }
  }
`;
