import { navigateTo } from 'gatsby-link';
import * as React from 'react';
import { RouteComponentProps } from 'react-router-dom';
import { PageWrapper } from '../components/page-wrapper';
import { Playground } from '../components/playground';
import { File, FileConnection, SitePage, TypeDocFile } from '../graphql-types';
import './styles.scss';

interface PublicProps {
  data: {
    indexPage: SitePage;
    indexFile: File;
    tabs: FileConnection;
    component: TypeDocFile;
  };
}

type Props = PublicProps & RouteComponentProps<{}>;

// Gatsby requires a default export for template and layout files.
// tslint:disable-next-line:no-default-export
export default class PlaygroundPageTemplate extends React.Component<Props, {}> {

  public render () {
    return (
      <PageWrapper
        page={this.props.data.indexPage}
        file={this.props.data.indexFile}
        tabs={this.props.data.tabs}
        component={this.props.data.component}
      >
        <Playground file={this.props.data.component} onClickClose={this.closePlayground} />
      </PageWrapper>
    );
  }

  private closePlayground = () => {
    if (this.props.data.indexFile.fields && this.props.data.indexFile.fields.path) {
      navigateTo(this.props.data.indexFile.fields.path);
    }
  }

}

export const pageQuery = graphql`
  query PlaygroundPageContent(
    $pagePath: String!,
    $componentId: String
    $path: String
  ) {
    ...defaultPage
  }
`;
