import {
  Column,
  Grid,
} from 'carbon-components-prototype';
import * as React from 'react';
import { RouteComponentProps } from 'react-router-dom';
import { PageWrapper } from '../components/page-wrapper';
import { PropertiesList } from '../components/properties-list';
import { File, FileConnection, SitePage, TypeDocFile } from '../graphql-types';
import './styles.scss';

interface PublicProps {
  data: {
    indexPage: SitePage;
    indexFile: File;
    tabs: FileConnection;
    component: TypeDocFile;
  };
}

type Props = PublicProps & RouteComponentProps<{}>;

// Gatsby requires a default export for template and layout files.
// tslint:disable-next-line:no-default-export
export default class PropertiesPageTemplate extends React.Component<Props, {}> {

  public render () {
    return (
      <PageWrapper
        page={this.props.data.indexPage}
        file={this.props.data.indexFile}
        tabs={this.props.data.tabs}
        component={this.props.data.component}
      >
        <Grid>
          <Column cols={{ default: 12, lg: 8 }}>
            <PropertiesList file={this.props.data.component} />
          </Column>
        </Grid>
      </PageWrapper>
    );
  }

}

export const pageQuery = graphql`
  query PropertiesPageContent(
    $pagePath: String!,
    $componentId: String
    $path: String
  ) {
    ...defaultPage
  }
`;
