import { TypeDocFile } from '../../graphql-types';

export const buttonData: TypeDocFile = {
  id: 'TypeDoc  components/button/button',
  component: 'components/button/button',
  name: 'Button',
  parent: null,
  internal: {
    type: 'TypeDocFile',
    contentDigest: '1c4296a0950d2ea8d3bbc461bc08f208',
    owner: 'gatsby-source-component-properties',
  },
  children: [],
  comment: {
    shortText: ' Buttons communicate that an action will happen when clicked. Best used as\n primary actions inside of another component such as a Modals, Cards, and/or\n forms. **Buttons should never be used for generic links.**',
  },
  properties: [
    {
      name: 'ariaLabel',
      flags: {
        isExported: true,
        isOptional: true,
      },
      type: 'string',
      comment: {
        shortText: 'Sets the `aria-label` HTML attribute. This is label will be available\nto screen readers.',
        tags: null,
      },
      availableValues: [],
      breakpointCompatible: false,
      sourceSrc: null,
    },
    {
      name: 'autoFocus',
      flags: {
        isExported: true,
        isOptional: true,
      },
      type: 'boolean',
      comment: {
        shortText: 'If the element is a button, autofocus it when it is first rendered.',
        tags: null,
      },
      availableValues: [],
      breakpointCompatible: false,
      sourceSrc: null,
    },
    {
      name: 'blurAfterClick',
      flags: {
        isExported: true,
        isOptional: true,
      },
      type: 'boolean',
      comment: {
        shortText: 'Ensures the element loses focus after interaction.',
        tags: null,
      },
      availableValues: [],
      breakpointCompatible: false,
      sourceSrc: null,
    },
    {
      name: 'children',
      flags: {
        isExported: true,
        isOptional: true,
      },
      type: 'React.ReactNode',
      comment: {
        shortText: 'The content rendered within the button. This includes the button text.',
        tags: [
          {
            tag: 'example',
            text: 'Chat\n',
          },
        ],
      },
      availableValues: [],
      breakpointCompatible: false,
      sourceSrc: null,
    },
    {
      name: 'disabled',
      flags: {
        isExported: true,
        isOptional: true,
      },
      type: 'boolean',
      comment: {
        shortText: 'Sets the element as disabled, always renders as a button.',
        tags: null,
      },
      availableValues: [],
      breakpointCompatible: false,
      sourceSrc: null,
    },
    {
      name: 'download',
      flags: {
        isExported: true,
        isOptional: true,
      },
      type: 'string',
      comment: {
        shortText: 'Sets the `download` attribute on the element. If the `linkTo` prop is set,\nthe resource will be downloaded instead of being navigated to.',
        tags: null,
      },
      availableValues: [],
      breakpointCompatible: false,
      sourceSrc: null,
    },
    {
      name: 'dropdown',
      flags: {
        isExported: true,
        isOptional: true,
      },
      type: 'boolean',
      comment: {
        shortText: 'Indicates the button will open a dropdown.',
        tags: null,
      },
      availableValues: [],
      breakpointCompatible: false,
      sourceSrc: null,
    },
    {
      name: 'fullWidth',
      flags: {
        isExported: true,
        isOptional: true,
      },
      type: 'boolean',
      comment: {
        shortText: 'Sets the button to stretch across the width of its container.',
        tags: null,
      },
      availableValues: [],
      breakpointCompatible: false,
      sourceSrc: null,
    },
    {
      name: 'icon',
      flags: {
        isExported: true,
        isOptional: true,
      },
      type: 'SVGAsset',
      comment: {
        shortText: 'Displays an icon in the button.',
        tags: null,
      },
      availableValues: [
        {
          name: 'SVGAsset',
          values: [
            'AddFriend',
            'AddReaction',
            'AddUser',
            'Amazon',
            'Android',
            'AngleDown',
            'AngleLeft',
            'AngleRight',
            'AngleUp',
            'ArrowDown',
            'ArrowLeft',
            'ArrowRight',
            'ArrowUp',
            'Automod',
            'Ban',
            'Battlenet',
            'Bits',
            'CC',
            'CCOff',
            'Camera',
            'Carat',
            'ChatRiskFlag',
            'ChatSettingsBack',
            'Check',
            'Clip',
            'Close',
            'Collections',
            'Comments',
            'Communities',
            'Conversations',
            'Copy',
            'Crate',
            'Crown',
            'DeadGlitch',
            'Desktop',
            'Document',
            'Download',
            'DragHandle',
            'Drops',
            'Edit',
            'Email',
            'Emoticons',
            'Events',
            'EventsReminderAdd',
            'EventsReminderAdded',
            'EventsReminderRemove',
            'Experiment',
            'Extensions',
            'Facebook',
            'Featured',
            'Filter',
            'FollowCheck',
            'FollowHollow',
            'FollowX',
            'Friends',
            'FriendsSC',
            'Fullscreen',
            'FullscreenExit',
            'Gear',
            'Gift',
            'Github',
            'Global',
            'GlyphArrDown',
            'GlyphArrLeft',
            'GlyphArrRight',
            'GlyphArrUp',
            'GlyphArrUpDown',
            'GlyphFollowers',
            'GlyphLength',
            'GlyphLive',
            'GlyphLiveSmall',
            'GlyphViews',
            'GridLayout',
            'HGCNexus',
            'HTCVibe',
            'Halt',
            'Hash',
            'Heart',
            'Hide',
            'HourGlass',
            'IOS',
            'Ignore',
            'LeagueOfLegends',
            'Like',
            'Liked',
            'Link',
            'Lock',
            'LogoGlitch',
            'LogoTwitch',
            'LogoTwitchDevelopers',
            'LogoTwitchPrime',
            'LogoTwitchPrimeHorizontal',
            'MacOs',
            'Maximize',
            'MessagesSC',
            'MiniPlayerExpand',
            'MiniPlayerPause',
            'MiniPlayerPlay',
            'Minimize',
            'More',
            'Muted',
            'NavBackpack',
            'NavBug',
            'NavChannels',
            'NavCreative',
            'NavDashboard',
            'NavDiscover',
            'NavFollowing',
            'NavGames',
            'NavLogout',
            'NavManager',
            'NavMessages',
            'NavMore',
            'NavMyChannel',
            'NavProfile',
            'NavSearch',
            'NavSettings',
            'NavVideos',
            'Neck',
            'NintendoSwitch',
            'NotificationBell',
            'NotificationBellOff',
            'NotificationError',
            'NotificationInfo',
            'NotificationSuccess',
            'NotificationWarning',
            'OP',
            'OculusVR',
            'PermissionsAdd',
            'PermissionsAdded',
            'PermissionsRemove',
            'Pin',
            'Pinned',
            'Play',
            'PlayStation',
            'Playlist',
            'Plus',
            'Popout',
            'QuestionMark',
            'Reddit',
            'Refresh',
            'RemoveTag',
            'RequestsSC',
            'Reshare',
            'Roman1',
            'Roman2',
            'Roman3',
            'Roman4',
            'Roman5',
            'RoomList',
            'RoomListOpen',
            'Scissors',
            'SearchNoResults',
            'Share',
            'Shirt',
            'Star',
            'StarHollow',
            'Steam',
            'Streaming',
            'Sword',
            'Team',
            'Theater',
            'TheaterExit',
            'Timeout',
            'Timer',
            'ToBottom',
            'ToTop',
            'Trash',
            'Trophy',
            'Twitter',
            'Unheart',
            'Unignore',
            'Unlock',
            'Upload',
            'VKontakte',
            'Verified',
            'VideoPremiere',
            'VideoRerun',
            'ViewerList',
            'VisibilityHidden',
            'VisibilityShown',
            'VolumeMax',
            'VolumeMid',
            'VolumeMuted',
            'Warning',
            'Whisper',
            'WhisperMuted',
            'Windows',
            'XboxOne',
            'YouTube',
          ],
          sourceSrc: 'https://git-aws.internal.justin.tv/core-ui/core-ui/blob/v4.6.1/src/components/svg/component.tsx#L20',
          properties: null,
        },
      ],
      breakpointCompatible: false,
      sourceSrc: 'https://git-aws.internal.justin.tv/core-ui/core-ui/blob/v4.6.1/src/components/svg/component.tsx#L20',
    },
    {
      name: 'linkTo',
      flags: {
        isExported: true,
        isOptional: true,
      },
      type: 'history.LocationDescriptor',
      comment: {
        shortText: 'Indicates the element is a link and will navigate to the passed URL.',
        tags: null,
      },
      availableValues: [],
      breakpointCompatible: false,
      sourceSrc: null,
    },
    {
      name: 'onClick',
      flags: {
        isExported: true,
        isOptional: true,
      },
      type: 'React.MouseEventHandler',
      comment: {
        shortText: 'Event called when the element is clicked.',
        tags: null,
      },
      availableValues: [],
      breakpointCompatible: false,
      sourceSrc: null,
    },
    {
      name: 'overlay',
      flags: {
        isExported: true,
        isOptional: true,
      },
      type: 'boolean',
      comment: {
        shortText: 'Indicates that this button overlays on a darker background.',
        tags: null,
      },
      availableValues: [],
      breakpointCompatible: false,
      sourceSrc: null,
    },
    {
      name: 'purchase',
      flags: {
        isExported: true,
        isOptional: true,
      },
      type: 'string',
      comment: {
        shortText: 'Displays a price associated with the button action.',
        tags: null,
      },
      availableValues: [],
      breakpointCompatible: false,
      sourceSrc: null,
    },
    {
      name: 'renderLink',
      flags: {
        isExported: true,
        isOptional: true,
      },
      type: null,
      comment: {
        shortText: 'Render prop to allow for using react-router alternatives @experimental',
        tags: null,
      },
      availableValues: [],
      breakpointCompatible: false,
      sourceSrc: null,
    },
    {
      name: 'size',
      flags: {
        isExported: true,
        isOptional: true,
      },
      type: 'ButtonSize',
      comment: {
        shortText: 'Size of the button.',
        tags: null,
      },
      availableValues: [
        {
          name: 'ButtonSize',
          values: [
            'Default',
            'Large',
            'Small',
          ],
          sourceSrc: 'https://git-aws.internal.justin.tv/core-ui/core-ui/blob/v4.6.1/src/components/button/button/component.tsx#L18',
          properties: null,
        },
      ],
      breakpointCompatible: false,
      sourceSrc: 'https://git-aws.internal.justin.tv/core-ui/core-ui/blob/v4.6.1/src/components/button/button/component.tsx#L18',
    },
    {
      name: 'state',
      flags: {
        isExported: true,
        isOptional: true,
      },
      type: 'ButtonState',
      comment: null,
      availableValues: [
        {
          name: 'ButtonState',
          values: [
            'Default',
            'Loading',
            'Success',
          ],
          sourceSrc: 'https://git-aws.internal.justin.tv/core-ui/core-ui/blob/v4.6.1/src/components/button/button/component.tsx#L24',
          properties: null,
        },
      ],
      breakpointCompatible: false,
      sourceSrc: 'https://git-aws.internal.justin.tv/core-ui/core-ui/blob/v4.6.1/src/components/button/button/component.tsx#L24',
    },
    {
      name: 'statusAlertIcon',
      flags: {
        isExported: true,
        isOptional: true,
      },
      type: 'SVGAsset',
      comment: {
        shortText: 'Icon to display when the status button is hovered.',
        tags: null,
      },
      availableValues: [
        {
          name: 'SVGAsset',
          values: [
            'AddFriend',
            'AddReaction',
            'AddUser',
            'Amazon',
            'Android',
            'AngleDown',
            'AngleLeft',
            'AngleRight',
            'AngleUp',
            'ArrowDown',
            'ArrowLeft',
            'ArrowRight',
            'ArrowUp',
            'Automod',
            'Ban',
            'Battlenet',
            'Bits',
            'CC',
            'CCOff',
            'Camera',
            'Carat',
            'ChatRiskFlag',
            'ChatSettingsBack',
            'Check',
            'Clip',
            'Close',
            'Collections',
            'Comments',
            'Communities',
            'Conversations',
            'Copy',
            'Crate',
            'Crown',
            'DeadGlitch',
            'Desktop',
            'Document',
            'Download',
            'DragHandle',
            'Drops',
            'Edit',
            'Email',
            'Emoticons',
            'Events',
            'EventsReminderAdd',
            'EventsReminderAdded',
            'EventsReminderRemove',
            'Experiment',
            'Extensions',
            'Facebook',
            'Featured',
            'Filter',
            'FollowCheck',
            'FollowHollow',
            'FollowX',
            'Friends',
            'FriendsSC',
            'Fullscreen',
            'FullscreenExit',
            'Gear',
            'Gift',
            'Github',
            'Global',
            'GlyphArrDown',
            'GlyphArrLeft',
            'GlyphArrRight',
            'GlyphArrUp',
            'GlyphArrUpDown',
            'GlyphFollowers',
            'GlyphLength',
            'GlyphLive',
            'GlyphLiveSmall',
            'GlyphViews',
            'GridLayout',
            'HGCNexus',
            'HTCVibe',
            'Halt',
            'Hash',
            'Heart',
            'Hide',
            'HourGlass',
            'IOS',
            'Ignore',
            'LeagueOfLegends',
            'Like',
            'Liked',
            'Link',
            'Lock',
            'LogoGlitch',
            'LogoTwitch',
            'LogoTwitchDevelopers',
            'LogoTwitchPrime',
            'LogoTwitchPrimeHorizontal',
            'MacOs',
            'Maximize',
            'MessagesSC',
            'MiniPlayerExpand',
            'MiniPlayerPause',
            'MiniPlayerPlay',
            'Minimize',
            'More',
            'Muted',
            'NavBackpack',
            'NavBug',
            'NavChannels',
            'NavCreative',
            'NavDashboard',
            'NavDiscover',
            'NavFollowing',
            'NavGames',
            'NavLogout',
            'NavManager',
            'NavMessages',
            'NavMore',
            'NavMyChannel',
            'NavProfile',
            'NavSearch',
            'NavSettings',
            'NavVideos',
            'Neck',
            'NintendoSwitch',
            'NotificationBell',
            'NotificationBellOff',
            'NotificationError',
            'NotificationInfo',
            'NotificationSuccess',
            'NotificationWarning',
            'OP',
            'OculusVR',
            'PermissionsAdd',
            'PermissionsAdded',
            'PermissionsRemove',
            'Pin',
            'Pinned',
            'Play',
            'PlayStation',
            'Playlist',
            'Plus',
            'Popout',
            'QuestionMark',
            'Reddit',
            'Refresh',
            'RemoveTag',
            'RequestsSC',
            'Reshare',
            'Roman1',
            'Roman2',
            'Roman3',
            'Roman4',
            'Roman5',
            'RoomList',
            'RoomListOpen',
            'Scissors',
            'SearchNoResults',
            'Share',
            'Shirt',
            'Star',
            'StarHollow',
            'Steam',
            'Streaming',
            'Sword',
            'Team',
            'Theater',
            'TheaterExit',
            'Timeout',
            'Timer',
            'ToBottom',
            'ToTop',
            'Trash',
            'Trophy',
            'Twitter',
            'Unheart',
            'Unignore',
            'Unlock',
            'Upload',
            'VKontakte',
            'Verified',
            'VideoPremiere',
            'VideoRerun',
            'ViewerList',
            'VisibilityHidden',
            'VisibilityShown',
            'VolumeMax',
            'VolumeMid',
            'VolumeMuted',
            'Warning',
            'Whisper',
            'WhisperMuted',
            'Windows',
            'XboxOne',
            'YouTube',
          ],
          sourceSrc: 'https://git-aws.internal.justin.tv/core-ui/core-ui/blob/v4.6.1/src/components/svg/component.tsx#L20',
          properties: null,
        },
      ],
      breakpointCompatible: false,
      sourceSrc: 'https://git-aws.internal.justin.tv/core-ui/core-ui/blob/v4.6.1/src/components/svg/component.tsx#L20',
    },
    {
      name: 'statusAlertText',
      flags: {
        isExported: true,
        isOptional: true,
      },
      type: 'string',
      comment: {
        shortText: 'Text to display when the status button is hovered. Setting this property\nturns the button into a "status" button.',
        tags: null,
      },
      availableValues: [],
      breakpointCompatible: false,
      sourceSrc: null,
    },
    {
      name: 'tabIndex',
      flags: {
        isExported: true,
        isOptional: true,
      },
      type: 'number',
      comment: {
        shortText: 'Manually set the `tabIndex` of this element.',
        tags: null,
      },
      availableValues: [],
      breakpointCompatible: false,
      sourceSrc: null,
    },
    {
      name: 'targetBlank',
      flags: {
        isExported: true,
        isOptional: true,
      },
      type: 'boolean',
      comment: {
        shortText: 'If the element is a link, open it in a new tab.',
        tags: null,
      },
      availableValues: [],
      breakpointCompatible: false,
      sourceSrc: null,
    },
    {
      name: 'type',
      flags: {
        isExported: true,
        isOptional: true,
      },
      type: 'ButtonType',
      comment: {
        shortText: 'The type of button to display.',
        tags: null,
      },
      availableValues: [
        {
          name: 'ButtonType',
          values: [
            'Alert',
            'Default',
            'Hollow',
            'Success',
            'Text',
          ],
          sourceSrc: 'https://git-aws.internal.justin.tv/core-ui/core-ui/blob/v4.6.1/src/components/button/button/component.tsx#L10',
          properties: null,
        },
      ],
      breakpointCompatible: false,
      sourceSrc: 'https://git-aws.internal.justin.tv/core-ui/core-ui/blob/v4.6.1/src/components/button/button/component.tsx#L10',
    },
  ],
};
