
interface TrackedEventFields {
  eventCategory: string; // Typically the object that was interacted with (e.g. 'Video')
  eventAction: string; // The type of interaction (e.g. 'play')
  eventLabel?: string; // Useful for categorizing events (e.g. 'Fall Campaign')
  eventValue?: number; // A numeric value associated with the event (e.g. 42)
}

export function trackContributeCalloutEdit(event: React.MouseEvent<HTMLButtonElement>) {
  trackEvent({
    eventCategory: 'Contribute Callout',
    eventAction: 'Edit Button',
    eventLabel: '' + event.currentTarget.getAttribute('href'),
  });
}

export function trackContributeCalloutGuidelines() {
  trackEvent({
    eventCategory: 'Contribute Callout',
    eventAction: 'Guidelines Button',
  });
}

export function trackContributeCalloutFilePath(event: React.FormEvent<HTMLInputElement>) {
  trackEvent({
    eventCategory: 'Contribute Callout',
    eventAction: 'File Path Input',
    eventLabel: event.currentTarget.value,
  });
}

export function trackCopyCodeButton() {
  trackEvent({
    eventCategory: 'Code Example Interaction',
    eventAction: 'Copy Code Button',
  });
}

export function trackPreviewThemeToggle(theme: string) {
  trackEvent({
    eventCategory: 'Live Preview Interaction',
    eventAction: `Change theme to: ${theme}`,
  });
}

export function trackSiteThemeToggle(theme: string) {
  trackEvent({
    eventCategory: 'Sidebar Interaction',
    eventAction: `Change theme to: ${theme}`,
  });
}

export function trackCodeClickInteraction() {
  trackEvent({
    eventCategory: 'Code Example Interaction',
    eventAction: 'Click or highlight code example',
  });
}

export function trackTableOfContentsClick(event: React.MouseEvent<HTMLLinkElement>) {
  trackEvent({
    eventCategory: 'Table of Contents',
    eventAction: 'Click on Link',
    eventLabel: '' + event.currentTarget.getAttribute('href'),
  });
}

export function trackSearchResultPosition(searchTerm: string, selectedPath: string, listPosition: number) {
  trackEvent({
    eventCategory: 'Site Search Navigation',
    eventAction: `Navigate to: ${selectedPath}`,
    eventLabel: `Search term: ${searchTerm}`,
    eventValue: listPosition,
  });
}

function trackEvent(fieldsObject: TrackedEventFields) {
  if (typeof (window as any).ga === 'undefined') {
    return;
  }

  (window as any).ga('send', 'event', fieldsObject);
}
