import { File } from '../graphql-types';

export const getDisplayTitle = (file: File): string => {
  if (
    file.childMarkdownRemark &&
    file.childMarkdownRemark.frontmatter &&
    file.childMarkdownRemark.frontmatter.title
  ) {
    return file.childMarkdownRemark.frontmatter.title;
  }

  if (
    file.childMarkdownRemark &&
    file.childMarkdownRemark.frontmatter &&
    file.childMarkdownRemark.frontmatter.component &&
    file.childMarkdownRemark.frontmatter.component.id &&
    file.fields &&
    file.fields.title
  ) {
    return file.fields.title.replace(/\s/g, '');
  }

  if (
    file.fields &&
    file.fields.title
  ) {
    return file.fields.title;
  }

  return '';
};
