import * as Remark from 'remark';
import * as RemarkHtml from 'remark-html';

export const parseMarkdownFromString = (source: string) => {
  let markdown = '';

  Remark()
    .data('settings', {
      commonmark: true,
      pedantic: true,
    })
    .use(RemarkHtml)
    .process(source, (err: any, file: any) => {
      if (err) {
        console.error(err);
      }

      markdown = file.contents;
    });

  return markdown;
};
