
// Values follow the WAI-ARIA 1.1 specification, for all global states and
// properties not marked as deprecated.
// See https://www.w3.org/TR/wai-aria-1.1/#global_states
// TODO: Support and enforce role-based properties? For example, role="dialog"
// or "alertdialog" support the properties aria-expanded and aria-modal, while
// no other roles do.

export enum AriaCurrent {
  False = 'false',
  True = 'true',
  Page = 'page',
  Step = 'step',
  Location = 'location',
  Date = 'date',
  Time = 'time',
}

export enum AriaHasPopup {
  False = 'false',
  True = 'true',
  Menu = 'menu',
  ListBox = 'listbox',
  Tree = 'tree',
  Grid = 'grid',
  Dialog = 'dialog',
}

export enum AriaInvalid {
  False = 'false',
  True = 'true',
  Spelling = 'spelling',
  Grammar = 'grammar',
}

export enum AriaLive {
  Off = 'off',
  Assertive = 'assertive',
  Polite = 'polite',
}

export enum AriaRelevant {
  All = 'all',
  Additions = 'additions',
  AdditionsText = 'additions text',
  Removals = 'removals',
  Text = 'text',
}

export enum AriaRole {
  Alert = 'alert',
  AlertDialog = 'alertdialog',
  Application = 'application',
  Article = 'article',
  Banner = 'banner',
  Button = 'button',
  Cell = 'cell',
  CheckBox = 'checkbox',
  ColumnHeader = 'columnheader',
  ComboBox = 'combobox',
  Complementary = 'complementary',
  Contentinfo = 'contentinfo',
  Definition = 'definition',
  Dialog = 'dialog',
  Directory = 'directory',
  Document = 'document',
  Feed = 'feed',
  Figure = 'figure',
  Form = 'form',
  Grid = 'grid',
  GridCell = 'gridcell',
  Group = 'group',
  Heading = 'heading',
  Img = 'img',
  Link = 'link',
  List = 'list',
  ListBox = 'listbox',
  ListItem = 'listitem',
  Log = 'log',
  Main = 'main',
  Marquee = 'marquee',
  Math = 'math',
  Menu = 'menu',
  Menubar = 'menubar',
  MenuItem = 'menuitem',
  MenuItemCheckBox = 'menuitemcheckbox',
  MenuItemRadio = 'menuitemradio',
  Navigation = 'navigation',
  None = 'none',
  Note = 'note',
  Option = 'option',
  Presentation = 'presentation',
  ProgressBar = 'progressbar',
  Radio = 'radio',
  RadioGroup = 'radiogroup',
  Region = 'region',
  Row = 'row',
  RowGroup = 'rowgroup',
  RowHeader = 'rowheader',
  ScrollBar = 'scrollbar',
  Search = 'search',
  SearchBox = 'searchbox',
  Separator = 'separator',
  Slider = 'slider',
  SpinButton = 'spinbutton',
  Status = 'status',
  Switch = 'switch',
  Tab = 'tab',
  Table = 'table',
  TabList = 'tablist',
  TabPanel = 'tabpanel',
  Term = 'term',
  TextBox = 'textbox',
  Timer = 'timer',
  ToolBar = 'toolbar',
  Tooltip = 'tooltip',
  Tree = 'tree',
  TreeGrid = 'treegrid',
  TreeItem = 'treeitem',
}

// React native HTMLElements support aria properties without the React standard
// of camelCasing them, so let's use aria-* for this component as well.
export interface AriaProps {
  role?: AriaRole;
  ariaAtomic?: boolean;
  ariaBusy?: boolean;
  ariaControls?: string | string[];
  ariaCurrent?: AriaCurrent;
  ariaDescribedby?: string | string[];
  ariaDetails?: string;
  ariaDisabled?: boolean;
  ariaErrormessage?: string;
  ariaFlowto?: string | string[];
  ariaHaspopup?: AriaHasPopup;
  ariaHidden?: boolean;
  ariaInvalid?: AriaInvalid;
  ariaKeyshortcuts?: string;
  ariaLabel?: string;
  ariaLabelledby?: string | string[];
  ariaLive?: AriaLive;
  ariaOwns?: string | string[];
  ariaRelevant?: AriaRelevant | AriaRelevant[];
  ariaRoledescription?: string;
}
